/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base;

import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.hr.base.EntityMapping;
import com.kingdee.eas.hr.base.FieldMapping;
import com.kingdee.eas.hr.base.MetaInfo;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;

public class EntityTreeMapping
implements Serializable {
    private static final long serialVersionUID = 7953727224016082933L;
    private EntityMapping entityMapping = new EntityMapping();
    private MetaInfo parentLink = null;
    private EntityTreeMapping parent = null;
    private HashMap children = null;

    public EntityTreeMapping(MetaInfo entity) {
        this.entityMapping.setEntity(entity);
    }

    public EntityMapping getEntityMapping() {
        return this.entityMapping;
    }

    public EntityTreeMapping getParent() {
        return this.parent;
    }

    public void setParent(EntityTreeMapping parent) {
        this.parent = parent;
    }

    public MetaInfo getParentLink() {
        return this.parentLink;
    }

    public void setParentLink(MetaInfo parentLink) {
        this.parentLink = parentLink;
    }

    public void addChild(PropertyInfo property, EntityTreeMapping child) {
        if (child != null && property != null) {
            if (this.children == null) {
                this.children = new HashMap();
            }
            child.setParent(this);
            MetaInfo linkProp = new MetaInfo();
            linkProp.setName(property.getName());
            linkProp.setValue(property.getAlias());
            child.setParentLink(linkProp);
            this.children.put(property.getName(), child);
        }
    }

    public HashMap getChildren() {
        return this.children;
    }

    public EntityTreeMapping getChild(String propertyName) {
        if (this.children != null && !StringUtils.isEmpty((String)propertyName)) {
            return (EntityTreeMapping)this.children.get(propertyName);
        }
        return null;
    }

    public FieldMapping getFieldMapping(String property) {
        if (StringUtils.isEmpty((String)property)) {
            return null;
        }
        String[] sub = StringUtils.split((String)property, (String)".");
        if (sub.length == 1) {
            return this.entityMapping.getFieldMapping(property);
        }
        if (this.getChild(sub[0]) != null) {
            return this.getChild(sub[0]).getFieldMapping(property.substring(sub[0].length() + 1));
        }
        return null;
    }
}

