/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.ISHRCheckRule;
import com.kingdee.eas.hr.base.SHRCheckRuleCollection;
import com.kingdee.eas.hr.base.SHRCheckRuleFactory;
import com.kingdee.eas.hr.base.SHRCheckRuleInfo;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.check.CheckParamInfo;
import com.kingdee.eas.hr.base.check.CheckResultInfo;
import com.kingdee.eas.hr.base.check.ICheckAction;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.util.HashSet;

public class SHRAffairActionCheckTool {
    public static SHRCheckRuleCollection getSHRCheckRuleCollection(Context ctx, int hrBizDefineType) throws BOSException {
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> ruleTypeSet = new HashSet<Integer>();
        if (1 == hrBizDefineType) {
            ruleTypeSet.add(2);
            ruleTypeSet.add(1);
            filter.getFilterItems().add(new FilterItemInfo("type", ruleTypeSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("hrBizDefineType", (Object)hrBizDefineType, CompareType.EQUALS));
        } else if (4 == hrBizDefineType) {
            filter.getFilterItems().add(new FilterItemInfo("hrBizDefineType", (Object)hrBizDefineType, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrBizDefineType", (Object)hrBizDefineType, CompareType.EQUALS));
        }
        return SHRAffairActionCheckTool.getEnableSHRCheckRuleCollection(ctx, filter);
    }

    private static SHRCheckRuleCollection getEnableSHRCheckRuleCollection(Context ctx, FilterInfo filter) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorterInfo = new SorterItemInfo("type");
        sorterColl.add(sorterInfo);
        sorterInfo = new SorterItemInfo("index");
        sorterColl.add(sorterInfo);
        viewInfo.setSorter(sorterColl);
        viewInfo.setFilter(filter);
        ISHRCheckRule iSHRCheckRule = SHRCheckRuleFactory.getLocalInstance(ctx);
        SHRCheckRuleCollection checkRuleColl = iSHRCheckRule.getSHRCheckRuleCollection(viewInfo);
        return checkRuleColl;
    }

    public static CheckResultInfo checkCompulsoryRule(Context ctx, HRBizData hrBizData) throws BOSException, EASBizException {
        CheckParamInfo paramInfo = new CheckParamInfo();
        paramInfo.setPersonInfo(hrBizData.getNewPosition().getPersonInfo());
        paramInfo.setActionReasonInfo(hrBizData.getActionType());
        return SHRAffairActionCheckTool.check(ctx, paramInfo, true);
    }

    public static CheckResultInfo checkCompulsoryRule(Context ctx, HRBizData hrBizData, int hrBizDefineType) throws BOSException, EASBizException {
        CheckParamInfo paramInfo = new CheckParamInfo();
        paramInfo.setPersonInfo(hrBizData.getNewPosition().getPersonInfo());
        paramInfo.setActionReasonInfo(hrBizData.getActionType());
        return SHRAffairActionCheckTool.check(ctx, paramInfo, true, hrBizDefineType);
    }

    public static CheckResultInfo checkCompulsoryRule(Context ctx, PersonInfo persoInfo, int hrBizDefineType) throws BOSException, EASBizException {
        CheckParamInfo paramInfo = new CheckParamInfo();
        paramInfo.setPersonInfo(persoInfo);
        return SHRAffairActionCheckTool.check(ctx, paramInfo, true, hrBizDefineType);
    }

    public static CheckResultInfo checkWarnningRule(Context ctx, PersonInfo persoInfo, int hrBizDefineType) throws BOSException, EASBizException {
        CheckParamInfo paramInfo = new CheckParamInfo();
        paramInfo.setPersonInfo(persoInfo);
        return SHRAffairActionCheckTool.check(ctx, paramInfo, false, hrBizDefineType);
    }

    private static CheckResultInfo check(Context ctx, CheckParamInfo paramInfo, boolean isCompulsory) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isCompulsory", (Object)true));
        SHRCheckRuleCollection checkRuleColl = SHRAffairActionCheckTool.getEnableSHRCheckRuleCollection(ctx, filter);
        int size = checkRuleColl.size();
        for (int i = 0; i < size; ++i) {
            SHRCheckRuleInfo ruleInfo = checkRuleColl.get(i);
            if (ruleInfo.isIsCompulsory() != isCompulsory || StringUtils.isEmpty((String)ruleInfo.getClassName())) continue;
            try {
                Class clazz = MsfClassLoaderFactory.forName((String)ruleInfo.getClassName());
                Object obj = clazz.newInstance();
                paramInfo.setCheckRuleInfo(ruleInfo);
                if (!(obj instanceof ICheckAction)) continue;
                ICheckAction checkAction = (ICheckAction)obj;
                checkAction.check(ctx, paramInfo);
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return paramInfo.getResultInfo();
    }

    private static CheckResultInfo check(Context ctx, CheckParamInfo paramInfo, boolean isCompulsory, int hrBizDefineType) throws BOSException, EASBizException {
        SHRCheckRuleCollection checkRuleColl = SHRAffairActionCheckTool.getSHRCheckRuleCollection(ctx, hrBizDefineType);
        int size = checkRuleColl.size();
        for (int i = 0; i < size; ++i) {
            SHRCheckRuleInfo ruleInfo = checkRuleColl.get(i);
            if (ruleInfo.isIsCompulsory() != isCompulsory || StringUtils.isEmpty((String)ruleInfo.getClassName())) continue;
            try {
                Class clazz = MsfClassLoaderFactory.forName((String)ruleInfo.getClassName());
                Object obj = clazz.newInstance();
                paramInfo.setCheckRuleInfo(ruleInfo);
                if (!(obj instanceof ICheckAction)) continue;
                ICheckAction checkAction = (ICheckAction)obj;
                checkAction.check(ctx, paramInfo);
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return paramInfo.getResultInfo();
    }

    public static EmpPosOrgRelationCollection getEmpPosOrgRelaCollByBizDefineType(Context ctx, HRBizDefineTypeEnum bizDefineType, String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("action.bizDefineType", (Object)bizDefineType.getValue()));
        view.setFilter(filter);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("EFFDT");
        sorter.setSortType(SortType.DESCEND);
        sortColl.add(sorter);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        view.setSorter(sortColl);
        EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
        return collection;
    }

    public static void appendCheckRuleInfo(CheckParamInfo paramInfo) {
        if (paramInfo.getCheckRuleInfo().isIsCompulsory()) {
            paramInfo.getResultInfo().appendErrorCheckRule(paramInfo.getCheckRuleInfo());
        } else {
            paramInfo.getResultInfo().appendWarnningCheckRule(paramInfo.getCheckRuleInfo());
        }
    }

    public static PersonInfo getPersonInfoByIdCardNo(Context ctx, PersonInfo personInfo) throws BOSException {
        if (personInfo.getId() != null) {
            return personInfo;
        }
        PersonInfo pInfo = null;
        if (personInfo.getIdCardNO() != null || personInfo.getPassportNO() != null) {
            String iDCardNO18To15;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (!StringUtils.isEmpty((String)personInfo.getIdCardNO()) && !StringUtils.isEmpty((String)personInfo.getPassportNO())) {
                filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)personInfo.getIdCardNO().toUpperCase()));
                iDCardNO18To15 = "";
                if (personInfo.getIdCardNO().length() == 18) {
                    try {
                        iDCardNO18To15 = IDCardCommonUtil.IDCardNO18To15(personInfo.getIdCardNO());
                    }
                    catch (BaseException e) {
                        e.printStackTrace();
                    }
                }
                if (!StringUtils.isEmpty((String)iDCardNO18To15)) {
                    filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)iDCardNO18To15));
                    filter.getFilterItems().add(new FilterItemInfo("passportNO", (Object)personInfo.getPassportNO()));
                    filter.setMaskString("(#0 or #1) or #2");
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("passportNO", (Object)personInfo.getPassportNO()));
                    filter.setMaskString("#0 or #1");
                }
            }
            if (!StringUtils.isEmpty((String)personInfo.getIdCardNO()) && StringUtils.isEmpty((String)personInfo.getPassportNO())) {
                iDCardNO18To15 = "";
                if (personInfo.getIdCardNO().length() == 18) {
                    try {
                        iDCardNO18To15 = IDCardCommonUtil.IDCardNO18To15(personInfo.getIdCardNO());
                    }
                    catch (BaseException e) {
                        e.printStackTrace();
                    }
                }
                filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)personInfo.getIdCardNO().toUpperCase()));
                if (!StringUtils.isEmpty((String)iDCardNO18To15)) {
                    filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)iDCardNO18To15));
                    filter.setMaskString("#0 or #1");
                }
            }
            if (StringUtils.isEmpty((String)personInfo.getIdCardNO()) && !StringUtils.isEmpty((String)personInfo.getPassportNO())) {
                filter.getFilterItems().add(new FilterItemInfo("passportNO", (Object)personInfo.getPassportNO()));
            }
            view.setFilter(filter);
            PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
            if (personColl.size() > 0) {
                pInfo = personColl.get(0);
            }
        }
        return pInfo;
    }
}

