/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.HRBaseDataUtils;
import com.kingdee.eas.hr.base.client.AbstractEmpDynamicTimePointUI;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class EmpDynamicTimePointUI
extends AbstractEmpDynamicTimePointUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpDynamicTimePointUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("adminOrg.displayName").getStyleAttributes().setHided(true);
        String uititle = (String)this.getUIContext().get("UItitle");
        this.setUITitle(uititle);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    protected String getEditUIName() {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        Set reasonLongNumberSet;
        Date effectTime = (Date)this.getUIContext().get("effectTime");
        String adminLongNumber = (String)this.getUIContext().get("adminLongNumber");
        FilterInfo filterInfo = new FilterInfo();
        String isStart = (String)this.getUIContext().get("isStart");
        if (isStart == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("effectStartDate", (Object)effectTime, CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("effectEndDate", (Object)effectTime, CompareType.GREATER));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("effectStartDate", (Object)effectTime, CompareType.LESS));
            filterInfo.getFilterItems().add(new FilterItemInfo("effectEndDate", (Object)effectTime, CompareType.GREATER_EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(adminLongNumber + "%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isPartTime", (Object)0));
        if (this.getUIContext().get("commonFilterInfo") != null) {
            HRBaseDataUtils.MergCommFilterTimePoint((FilterInfo)this.getUIContext().get("commonFilterInfo"), filterInfo, effectTime);
        }
        if ((reasonLongNumberSet = (Set)this.getUIContext().get("reasonLongNumberSet")) != null) {
            try {
                filterInfo.mergeFilter(HRUtil.getReasonLongNumberFilter(reasonLongNumberSet), "AND");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        HRBaseDataUtils.MergeFilter(filterInfo, null);
        return filterInfo;
    }
}

