/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EmpPosOrgRelationConstraints;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFacadeFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.PositionStatuEnum;
import com.kingdee.eas.hr.base.client.AbstractEmpPosOrgActiveRelationListUI;
import com.kingdee.eas.hr.base.client.IEmployeeUI;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EmpPosOrgActiveRelationListUI
extends AbstractEmpPosOrgActiveRelationListUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpPosOrgActiveRelationListUI.class);
    private int buttonshowType = 1;
    private FilterInfo defaultFlterInfo = null;

    protected void initWorkButton() {
        super.initWorkButton();
        if (HRClientUtil.fromNewEmployeeUI((CoreUIObject)this)) {
            HRClientUtil.processSpecialWorkButton(this.btnShowPersonLifeCyCle);
            HRClientUtil.processSpecialWorkButton(this.btnShowPositionLifeCycle);
            HRClientUtil.processSpecialWorkButton(this.btnFluctuation);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        HRUtilExtend.setMaxDateTimeNull(rowSet);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    protected void setDefaultFilter() throws Exception {
        if (this.buttonshowType == 1) {
            this.showPersonCurPosOrgRelation();
        } else {
            this.showPersonLifeCyCle();
        }
    }

    protected FilterInfo getDefaultFilter() throws Exception {
        this.setDefaultFilter();
        return this.defaultFlterInfo;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void initKeyStroke() {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmpPosOrgRelationFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        EmpPosOrgRelationInfo objectValue = new EmpPosOrgRelationInfo();
        return objectValue;
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.hr.base.client.EmpPosOrgActiveRelationEditUI";
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)EmpPosOrgRelationConstraints.EMPPOSORGRELATIONID, (Object)this.getSelectedKeyValue());
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionFluctuation_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.getSelectedKeyValue())) {
            return;
        }
        this.actionEdit_actionPerformed(e);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        String selectedKeyValue = this.getSelectedKeyValue();
        if (StringUtils.isEmpty((String)selectedKeyValue)) {
            return;
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnFluctuation.setEnabled(false);
            return;
        }
        try {
            EmpPosOrgRelationInfo currentRelation = EmpPosOrgRelationFacadeFactory.getRemoteInstance().getEmpPosOrgRelationValue(selectedKeyValue);
            if (DateTimeUtils.dayEquals((Date)currentRelation.getLEFFDT(), (Date)HRUtil.getMaxEndDate())) {
                if (PositionStatuEnum.InActive.equals((Object)currentRelation.getPositionstatus())) {
                    this.btnFluctuation.setEnabled(false);
                } else {
                    this.btnFluctuation.setEnabled(true);
                }
            } else {
                this.btnFluctuation.setEnabled(false);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getCause());
            this.btnFluctuation.setEnabled(false);
        }
    }

    @Override
    public void actionShowPositionLifeCycle_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        int curSelectRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (curSelectRow >= 0) {
            IEmployeeUI treeEditUI = (IEmployeeUI)this.getUIContext().get("GroupListEditUI");
            String personId = treeEditUI.getEmployeeID();
            String positionId = (String)this.tblMain.getRow(curSelectRow).getCell("position.id").getValue();
            uiContext.put((Object)"PersonID", (Object)personId);
            uiContext.put((Object)"PositionID", (Object)positionId);
            String closeAccountUI = "com.kingdee.eas.hr.base.client.EmpPosRelationListUI";
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(closeAccountUI, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    @Override
    public void actionShowPersonLifeCyCle_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        if (this.buttonshowType == 1) {
            this.showPersonLifeCyCle();
            this.buttonshowType = 2;
        } else {
            this.showPersonCurPosOrgRelation();
            this.buttonshowType = 1;
        }
        this.actionRefresh_actionPerformed(null);
    }

    private void showPersonLifeCyCle() {
        IEmployeeUI treeEditUI = (IEmployeeUI)this.getUIContext().get("GroupListEditUI");
        String personId = treeEditUI.getEmployeeID();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        this.mainQuery.setFilter(filter);
        this.defaultFlterInfo = filter;
        this.btnShowPersonLifeCyCle.setText(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.PersonCurPosOrgRelation"));
        this.btnShowPersonLifeCyCle.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.PersonCurPosOrgRelation"));
    }

    private void showPersonCurPosOrgRelation() {
        IEmployeeUI treeEditUI = (IEmployeeUI)this.getUIContext().get("GroupListEditUI");
        String personId = treeEditUI.getEmployeeID();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        filter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)curDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)curDate, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)1, CompareType.EQUALS));
        this.defaultFlterInfo = filter;
        this.mainQuery.setFilter(filter);
        SorterItemCollection coll = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("EFFDT");
        sortItem.setSortType(SortType.DESCEND);
        coll.add(sortItem);
        this.mainQuery.setSorter(coll);
        this.btnShowPersonLifeCyCle.setText(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.PersonLifeCyCle"));
        this.btnShowPersonLifeCyCle.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.PersonLifeCyCle"));
    }

    @Override
    public void actionShowAllPosition_actionPerformed(ActionEvent e) throws Exception {
    }
}

