/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.client.AbstractEmpPosOrgRelationListUI;
import com.kingdee.eas.hr.emp.EmpInnerWorkExpCollection;
import com.kingdee.eas.hr.emp.EmpInnerWorkExpFactory;
import com.kingdee.eas.hr.emp.EmpInnerWorkExpInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EmpPosOrgRelationListUI
extends AbstractEmpPosOrgRelationListUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpPosOrgRelationListUI.class);

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        this.loadEmpCheckHire();
    }

    private void loadEmpCheckHire() {
        HashSet<String> idSet = new HashSet<String>();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            idSet.add(this.tblMain.getRow(i).getCell("id").getValue().toString());
        }
        if (idSet.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("personRZType.name"));
            selectors.add(new SelectorItemInfo("checkLen"));
            selectors.add(new SelectorItemInfo("checkOverTime"));
            selectors.add(new SelectorItemInfo("checkState"));
            selectors.add(new SelectorItemInfo("personnelNumber"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("empPosRela.id", idSet, CompareType.INCLUDE));
            viewInfo.setSelector(selectors);
            viewInfo.setFilter(filterInfo);
            try {
                EmpInnerWorkExpCollection coll = EmpInnerWorkExpFactory.getRemoteInstance().getEmpInnerWorkExpCollection(viewInfo);
                if (coll.size() > 0) {
                    IRow row = null;
                    EmpInnerWorkExpInfo curInfo = null;
                    int size2 = this.tblMain.getRowCount();
                    for (int i = 0; i < size2; ++i) {
                        row = this.tblMain.getRow(i);
                        String empPosOrgRelaId = row.getCell("id").getValue().toString();
                        int num = coll.size();
                        for (int j = 0; j < num; ++j) {
                            curInfo = coll.get(j);
                            if (curInfo.getEmpPosRela() == null || !empPosOrgRelaId.equals(curInfo.getEmpPosRela().getId().toString())) continue;
                            if (curInfo.getPersonRZType() != null) {
                                row.getCell("personRZType.name").setValue((Object)curInfo.getPersonRZType().getName());
                            }
                            row.getCell("checkLen").setValue((Object)curInfo.getCheckLen());
                            row.getCell("checkOverTime").setValue((Object)curInfo.getCheckOverTime());
                            row.getCell("checkState").setValue((Object)curInfo.getCheckState());
                            row.getCell("personnelNumber").setValue((Object)curInfo.getPersonnelNumber());
                        }
                    }
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EmpPosOrgRelationFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        EmpPosOrgRelationInfo objectValue = new EmpPosOrgRelationInfo();
        return objectValue;
    }
}

