/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairUpgradeFacadeFactory;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.BaseInnerFacadeFactory;
import com.kingdee.eas.hr.base.HRInitCollection;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRInitInfo;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.base.SHRSystemUpdateFacadeFactory;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.client.AbstractHRInitUI;
import com.kingdee.eas.hr.base.client.EditUIUtil;
import com.kingdee.eas.hr.base.client.TableCopyUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.org.HRJobSystemFacadeFactory;
import com.kingdee.eas.hr.org.IHRJobSystemFacade;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class HRInitUI
extends AbstractHRInitUI {
    private static final Logger logger = CoreUIObject.getLogger(HRInitUI.class);
    private IHRInit iHR = null;

    protected void initWorkButton() {
        super.initWorkButton();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            throw new BaseException(BaseException.HRINIT_NOT_HRUNIT);
        }
        this.iHR = HRInitFactory.getRemoteInstance();
        String isNewsql = "select id from where  id='wf8iTD7NNkyUgXsXKqaRSkxvIAU='";
        if (this.iHR.exists(isNewsql)) {
            this.kDLabel2.setVisible(false);
            this.affairBizBillUpdate.setVisible(false);
            this.btnExportNotUpdate.setVisible(false);
            this.btnSystemUpdate.setText(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label71"));
            this.txtDescription.setText(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label73"));
        } else {
            this.btnSystemUpdate.setText(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label71"));
            this.txtDescription.setText(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label65"));
        }
        if (this.iHR.isFinishInit()) {
            this.btnFinishInit.setEnabled(false);
            this.menuItemFinishInit.setEnabled(false);
        }
        this.loadShrSystemUpdateInfo();
        this.loadSPSchema();
        this.loadJXCurrency();
        this.loadInitYear();
        this.loadApplyK3KaoQingParam();
        this.loadBenefit();
        this.loadCmpItemAccount();
        this.loadUseNewBill();
        if (this.iHR.exists("where key='NO_USED_OLD_AFFAIR'")) {
            this.pnlAffair2New.setVisible(false);
        }
    }

    private void loadShrSystemUpdateInfo() {
        try {
            HRInitInfo hrInitInfo = this.iHR.getShrSytemUpdateInfo();
            if (hrInitInfo.isIsFinish()) {
                if (hrInitInfo.getValue() != null) {
                    this.dtSystemUpdateDate.setValue((Object)DateTimeUtils.parseDate((String)hrInitInfo.getValue()));
                    this.btnSystemUpdate.setEnabled(false);
                    this.dtSystemUpdateDate.setEnabled(false);
                    this.btnExportNotUpdate.setEnabled(true);
                }
            } else {
                this.dtSystemUpdateDate.setValue(null);
                this.btnSystemUpdate.setEnabled(true);
                this.btnExportNotUpdate.setEnabled(false);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionFinishInit_actionPerformed(ActionEvent e) throws Exception {
        super.actionFinishInit_actionPerformed(e);
        if (!this.iHR.isFinishInit()) {
            this.iHR.finishInit();
            this.btnFinishInit.setEnabled(false);
            this.menuItemFinishInit.setEnabled(false);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.HRINIT_FINISH_SUCCESS"));
        }
    }

    @Override
    public void enable1Action_actionPerformed(ActionEvent e) throws Exception {
        super.enable1Action_actionPerformed(e);
        HRInitInfo info = new HRInitInfo();
        info.setKey("JOB_SYSTEM_SCHEMA");
        if (this.rboGroup.isSelected()) {
            info.setValue("0");
        } else {
            info.setValue("1");
        }
        CtrlUnitInfo cuInfo = new CtrlUnitInfo();
        cuInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        info.put("IS_CU_FILTER", Boolean.FALSE);
        info.setCU(cuInfo);
        this.iHR.addnew((CoreBaseInfo)info);
        this.btnEnable.setEnabled(false);
        this.rboGroup.setEnabled(false);
        this.rboSeperate.setEnabled(false);
    }

    @Override
    public void enable2Action_actionPerformed(ActionEvent e) throws Exception {
        super.enable2Action_actionPerformed(e);
        HRInitInfo info = new HRInitInfo();
        info.setKey("SALARAIATPOINT_SCHEMA");
        if (this.chkCmp.isSelected()) {
            info.setValue("1");
        } else {
            info.setValue("0");
        }
        info.put("IS_CU_FILTER", Boolean.TRUE);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        this.iHR.addnew((CoreBaseInfo)info);
        this.chkCmp.setEnabled(false);
        this.btnEnable2.setEnabled(false);
    }

    @Override
    public void enable3Action_actionPerformed(ActionEvent e) throws Exception {
        super.enable3Action_actionPerformed(e);
        HRInitInfo info = new HRInitInfo();
        info.setKey("JX_CURRENCY");
        if (this.bizCurrency.getData() == null) {
            throw new BaseException(BaseException.HRINIT_NOT_SET_CURRENCY);
        }
        info.put("IS_CU_FILTER", Boolean.TRUE);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setValue(((CurrencyInfo)this.bizCurrency.getData()).getId().toString());
        this.iHR.addnew((CoreBaseInfo)info);
        this.bizCurrency.setEnabled(false);
        this.btnEnable3.setEnabled(false);
    }

    @Override
    public void enable4Action_actionPerformed(ActionEvent e) throws Exception {
        super.enable4Action_actionPerformed(e);
        HRInitInfo info = new HRInitInfo();
        info.setKey("INIT_YEAR");
        if (Integer.parseInt(this.txtInitYear.getText()) > 3000 || Integer.parseInt(this.txtInitYear.getText()) < 1980) {
            throw new BaseException(BaseException.HRINIT_INIT_YEAR_ERROR);
        }
        info.put("IS_CU_FILTER", Boolean.TRUE);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setValue(this.txtInitYear.getText());
        this.iHR.addnew((CoreBaseInfo)info);
        this.txtInitYear.setEnabled(false);
        this.btnEnable4.setEnabled(false);
    }

    @Override
    public void enable5Action_actionPerformed(ActionEvent e) throws Exception {
        super.enable5Action_actionPerformed(e);
        BenefitUtils.initBenefit();
        HRInitInfo info = new HRInitInfo();
        info.setKey("INIT_BENEFIT");
        info.put("IS_CU_FILTER", Boolean.TRUE);
        info.setValue("1");
        this.iHR.addnew((CoreBaseInfo)info);
        this.btnEnable5.setEnabled(false);
    }

    private void loadJobSystemSchema() throws Exception {
        int value = this.iHR.getJobSystemScheme();
        if (value == -1) {
            this.rboGroup.setSelected(true);
            this.btnEnable.setEnabled(true);
            this.rboGroup.setEnabled(true);
            this.rboSeperate.setEnabled(true);
        } else if (value == 0) {
            this.rboGroup.setSelected(true);
            this.btnEnable.setEnabled(false);
            this.rboGroup.setEnabled(false);
            this.rboSeperate.setEnabled(false);
        } else {
            this.rboSeperate.setSelected(true);
            this.btnEnable.setEnabled(false);
            this.rboGroup.setEnabled(false);
            this.rboSeperate.setEnabled(false);
        }
    }

    private void loadSPSchema() throws Exception {
        int value = this.iHR.getSPSchema();
        if (value == -1) {
            this.chkCmp.setEnabled(true);
            this.chkCmp.setSelected(true);
            this.btnEnable2.setEnabled(true);
        } else if (value == 1) {
            this.chkCmp.setSelected(true);
            this.chkCmp.setEnabled(false);
            this.btnEnable2.setEnabled(false);
        } else {
            this.chkCmp.setSelected(false);
            this.chkCmp.setEnabled(false);
            this.btnEnable2.setEnabled(false);
        }
    }

    private void loadCmpItemAccount() throws Exception {
        int value = this.iHR.getInitCmpItemAccount(true);
        if (value == -1) {
            this.cbIsUseCmpItemAccount.setEnabled(true);
            this.btnEnableCmpItemAccount.setEnabled(true);
        } else if (value == 1) {
            this.cbIsUseCmpItemAccount.setSelected(true);
            this.cbIsUseCmpItemAccount.setEnabled(false);
            this.btnEnableCmpItemAccount.setEnabled(false);
        } else {
            this.cbIsUseCmpItemAccount.setSelected(false);
            this.cbIsUseCmpItemAccount.setEnabled(false);
            this.btnEnableCmpItemAccount.setEnabled(false);
        }
    }

    private void loadInitYear() throws Exception {
        int value = this.iHR.getInitYear();
        this.txtInitYear.setHorizontalAlignment(4);
        this.txtInitYear.setGroupingUsed(false);
        if (value == -1) {
            Calendar now = Calendar.getInstance(SysContext.getSysContext().getLocale());
            this.txtInitYear.setText(Integer.toString(now.get(1)));
            this.txtInitYear.setEnabled(true);
            this.btnEnable4.setEnabled(true);
        } else {
            this.txtInitYear.setEnabled(false);
            this.btnEnable4.setEnabled(false);
            this.txtInitYear.setText(Integer.toString(value));
        }
    }

    private void loadJXCurrency() throws Exception {
        this.bizCurrency.setEditable(false);
        this.bizCurrency.setEditFormat("$number$");
        this.bizCurrency.setDisplayFormat("$name$");
        this.bizCurrency.setCommitFormat("$number$");
        this.bizCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CurrencyDefaultF7Query");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        this.bizCurrency.setSelectorCollection(sic);
        String currencyId = this.iHR.getJXCurrency();
        if (currencyId == null) {
            this.bizCurrency.setEnabled(true);
            this.btnEnable3.setEnabled(true);
        } else {
            ICurrency iCurr = CurrencyFactory.getRemoteInstance();
            this.bizCurrency.setData((Object)iCurr.getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)currencyId))));
            this.bizCurrency.setEnabled(false);
            this.btnEnable3.setEnabled(false);
        }
    }

    private void loadBenefit() throws Exception {
        int value = this.iHR.getInitBenefit();
        if (value < 1) {
            this.btnEnable5.setEnabled(true);
        } else {
            this.btnEnable5.setEnabled(false);
        }
    }

    private void loadUseNewBill() throws Exception {
        boolean upgrade = AffairUpgradeFacadeFactory.getRemoteInstance().isUpgrade();
        this.btnUseNewBill.setEnabled(!upgrade);
        this.btnCheckBill.setEnabled(true);
        if (upgrade) {
            this.affairBizBillUpdate.setEnabled(true);
        } else {
            this.affairBizBillUpdate.setEnabled(false);
        }
    }

    @Override
    protected void CoreUI_keyReleased(KeyEvent e) throws Exception {
        super.CoreUI_keyReleased(e);
        if (e.getKeyChar() + '\u0000' == 8) {
            IHRInit iHRinit = HRInitFactory.getRemoteInstance();
            if (!iHRinit.exists("where key='JOB_Level_Grade_INIT'") && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"56_HRInitUI")) == 0) {
                IHRJobSystemFacade facade = HRJobSystemFacadeFactory.getRemoteInstance();
                facade.upgradeJobLevelAndGrade();
                HRInitInfo info = new HRInitInfo();
                info.setKey("JOB_Level_Grade_INIT");
                info.setValue("OK");
                info.put("IS_CU_FILTER", Boolean.TRUE);
                iHRinit.addnew((CoreBaseInfo)info);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"57_HRInitUI"));
            }
        } else if (e.getKeyCode() == 119) {
            IUIFactory uiFactory = null;
            UIContext hash = new UIContext(this.getUIContext().get("OwnerWindow"));
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.fm.common.client.FMIsqlUI", (Map)hash);
            uiWindow.show();
        } else if (e.getKeyCode() == 120) {
            IUIFactory uiFactory = null;
            UIContext hash = new UIContext(this.getUIContext().get("OwnerWindow"));
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
            IUIWindow uiWindow = uiFactory.create(TableCopyUI.class.getName(), (Map)hash);
            uiWindow.show();
        } else if (512 == e.getModifiersEx() && e.getKeyCode() == 85) {
            this.updatePersonNamePingYin();
        } else if (512 == e.getModifiersEx() && e.getKeyCode() == 73) {
            this.initComplexPingYin();
        }
    }

    private void updatePersonNamePingYin() {
        GetDataDialog dlg = this.getDataDialog();
        dlg.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"58_HRInitUI"));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                BaseInnerFacadeFactory.getRemoteInstance().updatePersonNamePingYin();
                MsgBox.showInfo((Component)((Object)HRInitUI.this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"59_HRInitUI"));
                return null;
            }
        });
        dlg.show();
    }

    private void initComplexPingYin() {
        GetDataDialog dlg = this.getDataDialog();
        dlg.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"60_HRInitUI"));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                BaseInnerFacadeFactory.getRemoteInstance().initComplexPingYin();
                MsgBox.showInfo((Component)((Object)HRInitUI.this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"61_HRInitUI"));
                return null;
            }
        });
        dlg.show();
    }

    private GetDataDialog getDataDialog() {
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        return dlg;
    }

    @Override
    public void actionEnableCmpItemAccount_actionPerformed(ActionEvent e) throws Exception {
        HRInitInfo info = new HRInitInfo();
        info.setKey("IS_USE_CMPITEMACCOUNT");
        if (this.chkCmp.isSelected()) {
            info.setValue("1");
        } else {
            info.setValue("0");
        }
        info.put("IS_CU_FILTER", Boolean.TRUE);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        this.iHR.addnew((CoreBaseInfo)info);
        this.cbIsUseCmpItemAccount.setEnabled(false);
        this.btnEnableCmpItemAccount.setEnabled(false);
    }

    @Override
    public void actionUseNewBill_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"140_HRInitUI")) == 0) {
            BatchProcessedResult result = AffairUpgradeFacadeFactory.getRemoteInstance().bizUpgrade();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"62_HRInitUI"));
            this.loadUseNewBill();
        }
    }

    @Override
    public void actionCheckBill_actionPerformed(ActionEvent e) throws Exception {
        BatchProcessedResult result = AffairUpgradeFacadeFactory.getRemoteInstance().bizCheck();
        if (result != null && result.isHasValidInfo()) {
            EditUIUtil.showBatchProcessResult(result, (Object)this);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"63_HRInitUI"));
        }
    }

    private void loadApplyK3KaoQingParam() throws Exception {
        int value = this.iHR.getApplyK3SysParam();
        if (value == 1) {
            this.kDCheckBox_appK3KQ.setSelected(true);
        } else {
            this.kDCheckBox_appK3KQ.setSelected(false);
        }
    }

    @Override
    public void actionApplyK3KaoQing_actionPerformed(ActionEvent e) throws Exception {
        super.enable2Action_actionPerformed(e);
        HRInitInfo info = new HRInitInfo();
        info.setKey("applyK3KaoQingSystem");
        if (this.kDCheckBox_appK3KQ.isSelected()) {
            info.setValue("1");
        } else {
            info.setValue("0");
        }
        info.put("IS_CU_FILTER", Boolean.FALSE);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        if (this.iHR.exists("where key = 'applyK3KaoQingSystem'")) {
            HRInitInfo hrInitInfo = this.iHR.getHRInitInfo("where key = 'applyK3KaoQingSystem'");
            hrInitInfo.setValue(info.getValue());
            HRInitCollection col = new HRInitCollection();
            col.add(hrInitInfo);
            this.iHR.update((IObjectPK)new ObjectUuidPK(hrInitInfo.getId()), (CoreBaseInfo)hrInitInfo);
        } else {
            this.iHR.addnew((CoreBaseInfo)info);
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label2"));
    }

    @Override
    public void actionSHRSystemUpdateAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.dtSystemUpdateDate.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label64"));
            this.dtSystemUpdateDate.requestFocusInWindow();
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"Confirm_Execute_UpdateEAS_TO_SHR")) == 0) {
            GetDataDialog dlg = GetDataDialog.getInstance((GetDataTaskAdapter)new GetDataTaskAdapter(){

                public Object exec() throws Exception {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("SHRSystemUpdateTime", HRInitUI.this.dtSystemUpdateDate.getValue());
                    SHRSystemUpdateFacadeFactory.getRemoteInstance().startUpdate(param);
                    HRInitUI.this.btnSystemUpdate.setEnabled(false);
                    HRInitUI.this.dtSystemUpdateDate.setEnabled(false);
                    HRInitUI.this.btnExportNotUpdate.setEnabled(true);
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label76"));
                    return null;
                }
            });
            dlg.show();
        }
    }

    @Override
    public void actionExportNotUpdate_actionPerformed(ActionEvent e) throws Exception {
        PersonCollection pcll = SHRSystemUpdateFacadeFactory.getRemoteInstance().getNotUpdatePersonCollection();
        StringBuffer infoString = new StringBuffer();
        if (pcll.size() > 0) {
            int size = pcll.size();
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    infoString.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label153")).append("\r\n");
                    infoString.append(pcll.get(i).getNumber()).append(",");
                    infoString.append(pcll.get(i).getName()).append("\r\n");
                    continue;
                }
                infoString.append(pcll.get(i).getNumber()).append(",");
                infoString.append(pcll.get(i).getName()).append("\r\n");
            }
        }
        StringBuffer infoBuf = new StringBuffer();
        infoBuf.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label154") + " \r\n");
        infoBuf.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label155") + " \r\n");
        infoBuf.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label156") + " \r\n");
        infoBuf.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label157") + " \r\n");
        infoBuf.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label158") + " \r\n");
        MsgBox.showDetailAndOK((Component)((Object)this), (String)infoBuf.toString(), (String)infoString.toString(), (int)1);
    }

    @Override
    public void actionAffairBizBillUpdate_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label77")) == 0) {
            SHRSystemUpdateFacadeFactory.getRemoteInstance().affairBizBillUpdate();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label78"));
        }
    }

    @Override
    public void actionInitSortCode_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label141")) == 0) {
            GetDataDialog dlg = GetDataDialog.getInstance((GetDataTaskAdapter)new GetDataTaskAdapter(){

                public Object exec() throws Exception {
                    SHRSystemUpdateFacadeFactory.getRemoteInstance().initSortCode();
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label79"));
                    return null;
                }
            });
            dlg.show();
        }
    }
}

