/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.BaseInnerFacadeFactory;
import com.kingdee.eas.hr.base.IBaseInnerFacade;
import com.kingdee.eas.hr.base.client.Edge;
import com.kingdee.eas.hr.base.client.Node;
import com.kingdee.eas.hr.base.client.OrgChartPersonPhotoBuilder;
import com.kingdee.eas.hr.base.client.OrgChartTreeBaseBuilder;
import com.kingdee.eas.hr.base.util.OrgChartUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class OrgChartPersonPlanBuilder
extends OrgChartTreeBaseBuilder {
    private Map personPlanMap = new HashMap();
    private Map realNumberMap = new HashMap();
    private Map allPersonPlanMap = new HashMap();
    private Map allRealNumberMap = new HashMap();

    @Override
    public int getNodeHeight() {
        return 120;
    }

    @Override
    public int getNodeWidth() {
        return 100;
    }

    @Override
    public void paintDemo(Graphics g, Dimension size) {
        int cnOffSet = 0;
        if (OrgChartPersonPhotoBuilder.isChinaLocale()) {
            cnOffSet = 10;
        }
        g.setColor(new Color(192, 192, 192));
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(Color.BLACK);
        OrgChartPersonPhotoBuilder.Paint4("drawRect", g, 150, 5, 130, 80, 17, 35);
        g.setColor(Color.WHITE);
        OrgChartPersonPhotoBuilder.Paint4("fillRect", g, 151, 6, 129, 79, 18, 36);
        g.setColor(Color.BLACK);
        int fontHeight = g.getFontMetrics().getHeight();
        OrgChartPersonPhotoBuilder.Paint4Line("drawLine", g, 150, 5 + fontHeight, 280, 5 + fontHeight, 147, 115);
        OrgChartPersonPhotoBuilder.Paint4Line("drawLine", g, 150, 5 + fontHeight * 2, 280, 5 + fontHeight * 2, 147, 115);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"104_OrgChartPersonPhotoBuilder"), 195, 19);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"PERSON_PLAN") + "--(--)", 180 + cnOffSet, 37);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"REAL_NUMBER") + "--(--)", 155 + cnOffSet * 2, 67);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"106_OrgChartPersonPhotoBuilder"), 40, 134);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"PERSON_PLAN") + "--(--)", 25 + cnOffSet, 152);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"REAL_NUMBER") + "--(--)", 10 + cnOffSet * 2, 182);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"107_OrgChartPersonPhotoBuilder"), 195, 134);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"PERSON_PLAN") + "--(--)", 180 + cnOffSet, 152);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"REAL_NUMBER") + "--(--)", 155 + cnOffSet * 2, 182);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"108_OrgChartPersonPhotoBuilder"), 340, 134);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"PERSON_PLAN") + "--(--)", 325 + cnOffSet, 152);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"REAL_NUMBER") + "--(--)", 300 + cnOffSet * 2, 182);
        g.drawLine(215, 85, 215, 120);
        g.drawLine(62, 100, 362, 100);
        g.drawLine(62, 100, 62, 120);
        g.drawLine(362, 100, 362, 120);
    }

    @Override
    public boolean renderNode(Graphics g, Node node, HashMap renderMap) {
        Integer count;
        Rectangle rect = node.getRect();
        String name = node.getName();
        Color fontColor = node.getFontColor();
        Color splitLineColor = new Color(210, 208, 160);
        if (StringUtils.isEmpty((String)name)) {
            return true;
        }
        List nameList = OrgChartUtil.getPrintScreenStr(name, node, g.getFontMetrics());
        name = nameList.get(0).toString();
        int fontHeight = g.getFontMetrics().getHeight();
        Color oldColor = g.getColor();
        g.setColor(fontColor);
        g.drawString(name, 6 + (rect.width - 12 - g.getFontMetrics().stringWidth(name)) / 2, fontHeight);
        g.setColor(oldColor);
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        oldColor = g2d.getColor();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(splitLineColor);
        g2d.drawLine(5, fontHeight + 6, node.getWidth() - 5, fontHeight + 6);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
        name = EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"PERSON_PLAN");
        String nodeID = node.getId();
        if (this.personPlanMap != null && !StringUtils.isEmpty((String)nodeID) && this.personPlanMap.containsKey(nodeID)) {
            count = (Integer)this.personPlanMap.get(nodeID);
            name = name + count;
        } else {
            name = name + "--";
        }
        if (this.allPersonPlanMap != null && !StringUtils.isEmpty((String)nodeID) && this.allPersonPlanMap.containsKey(nodeID)) {
            count = (Integer)this.allPersonPlanMap.get(nodeID);
            name = name + "(" + count + ")";
        } else {
            name = name + "(--)";
        }
        oldColor = g.getColor();
        g.setColor(fontColor);
        g.drawString(name, 6 + (rect.width - 12 - g.getFontMetrics().stringWidth(name)) / 2, fontHeight * 2 + 6);
        g.setColor(oldColor);
        oldColor = g2d.getColor();
        oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(splitLineColor);
        g.drawLine(5, fontHeight * 2 + 12, node.getWidth() - 5, fontHeight * 2 + 12);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
        name = EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"REAL_NUMBER");
        if (this.realNumberMap != null && !StringUtils.isEmpty((String)nodeID) && this.realNumberMap.containsKey(nodeID)) {
            count = (Integer)this.realNumberMap.get(nodeID);
            name = name + count;
        } else {
            name = name + "--";
        }
        if (this.allRealNumberMap != null && !StringUtils.isEmpty((String)nodeID) && this.allRealNumberMap.containsKey(nodeID)) {
            count = (Integer)this.allRealNumberMap.get(nodeID);
            name = name + "(" + count + ")";
        } else {
            name = name + "(--)";
        }
        oldColor = g2d.getColor();
        g2d.setColor(fontColor);
        g.drawString(name, 6 + (rect.width - 12 - g.getFontMetrics().stringWidth(name)) / 2, fontHeight * 3 + 12);
        g2d.setColor(oldColor);
        return true;
    }

    @Override
    public Element saveNodesAndEdgesAndBgToXML(List nodes, List edges, Color bg) {
        if (nodes == null) {
            return null;
        }
        Element nodeAndEdgeElement = new Element("NodeAndEdge");
        Element nodeElement = null;
        Element edgeElement = null;
        Element nodeListElement = null;
        Element edgeListElement = null;
        Element bgElement = null;
        Element personPlanElement = null;
        Element realNumberElement = null;
        Node node = null;
        Edge edge = null;
        KDFont font = null;
        nodeListElement = new Element("NodeList");
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            node = (Node)nodes.get(i);
            nodeElement = new Element("Node");
            nodeElement.addContent((Content)new Element("X").setText(Integer.toString(node.getX())));
            nodeElement.addContent((Content)new Element("Y").setText(Integer.toString(node.getY())));
            nodeElement.addContent((Content)new Element("Width").setText(Integer.toString(node.getWidth())));
            nodeElement.addContent((Content)new Element("Height").setText(Integer.toString(node.getHeight())));
            nodeElement.addContent((Content)new Element("BgColor").setText(Integer.toString(node.getBackground().getRGB())));
            nodeElement.addContent((Content)new Element("BorderColor").setText(Integer.toString(node.getBorderColor().getRGB())));
            nodeElement.addContent((Content)new Element("fontColor").setText(Integer.toString(node.getFontColor().getRGB())));
            nodeElement.addContent((Content)new Element("ObjID").setText(node.getId()));
            nodeElement.addContent((Content)new Element("Name").setText(node.getName()));
            nodeElement.addContent((Content)new Element("IsLeaf").setText(Boolean.toString(node.isLeaf())));
            if (node.getClientProperty().get("personPlan") != null) {
                personPlanElement = new Element("personPlan");
                personPlanElement.addContent((Content)new Element("Name").setText(node.getClientProperty().get("personPlan").toString()));
                nodeElement.addContent((Content)personPlanElement);
            }
            if (node.getClientProperty().get("realNumber") != null) {
                realNumberElement = new Element("realNumber");
                personPlanElement.addContent((Content)new Element("Name").setText(node.getClientProperty().get("realNumber").toString()));
                nodeElement.addContent((Content)realNumberElement);
            }
            if ((font = (KDFont)node.getFont()) != null) {
                nodeElement.addContent((Content)new Element("FontName").setText(font.getName().toString()));
                nodeElement.addContent((Content)new Element("FontStyle").setText(Integer.toString(font.getStyle())));
                nodeElement.addContent((Content)new Element("FontSize").setText(Integer.toString(new Float(font.getSize()).intValue())));
            }
            nodeListElement.addContent((Content)nodeElement);
        }
        nodeAndEdgeElement.addContent((Content)nodeListElement);
        edgeListElement = new Element("EdgeList");
        Element pointListElement = null;
        Element pointElement = null;
        Point point = null;
        int size2 = edges.size();
        for (int i = 0; i < size2; ++i) {
            edge = (Edge)edges.get(i);
            edgeElement = new Element("Edge");
            edgeElement.addContent((Content)new Element("Color").setText(Integer.toString(edge.getColor().getRGB())));
            edgeElement.addContent((Content)new Element("SNodeID").setText(edge.getSourceNode().getId()));
            edgeElement.addContent((Content)new Element("TNodeID").setText(edge.getTargetNode().getId()));
            pointListElement = new Element("PointList");
            int length = edge.getPoints().size();
            for (int t = 1; t < length - 1; ++t) {
                point = (Point)edge.getPoints().get(t);
                pointElement = new Element("Point");
                pointElement.addContent((Content)new Element("X").setText(Integer.toString(point.x)));
                pointElement.addContent((Content)new Element("Y").setText(Integer.toString(point.y)));
                pointListElement.addContent((Content)pointElement);
            }
            edgeElement.addContent((Content)pointListElement);
            edgeListElement.addContent((Content)edgeElement);
        }
        nodeAndEdgeElement.addContent((Content)edgeListElement);
        bgElement = new Element("Background");
        bgElement.setText(Integer.toString(bg.getRGB()));
        nodeAndEdgeElement.addContent((Content)bgElement);
        return nodeAndEdgeElement;
    }

    @Override
    public List getNodesAndEdgesAndBgFromXML(String xmlData) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlData));
        Element root = doc.getRootElement();
        Element nodeAndEdgeElement = root.getChild("NodeAndEdge");
        Element nodeListElement = nodeAndEdgeElement.getChild("NodeList");
        Element bg = nodeAndEdgeElement.getChild("Background");
        Element nodeElement = null;
        Object fontName = null;
        Object fontStyle = null;
        Object fontSize = null;
        Object displayTextType = null;
        KDFont font = null;
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Node node = null;
        String x = null;
        String y = null;
        String width = null;
        String height = null;
        String bgColor = null;
        String borderColor = null;
        String fontColor = null;
        String mainBackgroundColor = null;
        String name = null;
        String objId = null;
        String isLeaf = null;
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        Element personPlanElement = null;
        Element realNumberElement = null;
        HashSet<String> adminSet = new HashSet<String>();
        int size = nodeListElement.getChildren().size();
        for (int i = 0; i < size; ++i) {
            nodeElement = (Element)nodeListElement.getChildren().get(i);
            x = nodeElement.getChild("X").getText();
            y = nodeElement.getChild("Y").getText();
            width = nodeElement.getChild("Width").getText();
            height = nodeElement.getChild("Height").getText();
            bgColor = nodeElement.getChild("BgColor").getText();
            borderColor = nodeElement.getChild("BorderColor").getText();
            fontColor = nodeElement.getChild("fontColor").getText();
            name = nodeElement.getChild("Name").getText();
            objId = nodeElement.getChild("ObjID").getText();
            isLeaf = nodeElement.getChild("IsLeaf").getText();
            node = new Node(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(width), Integer.parseInt(height), objId, name, Boolean.valueOf(isLeaf));
            node.setBackground(new Color(Integer.parseInt(bgColor)));
            node.setBorderColor(new Color(Integer.parseInt(borderColor)));
            node.setFontColor(new Color(Integer.parseInt(fontColor)));
            if (nodeElement.getChild("personPlan") != null) {
                personPlanElement = nodeElement.getChild("personPlan");
                node.getClientProperty().put("personPlan", personPlanElement.getChild("Name").getText());
            }
            if (nodeElement.getChild("realNumber") != null) {
                realNumberElement = nodeElement.getChild("realNumber");
                node.getClientProperty().put("personPlan", realNumberElement.getChild("Name").getText());
            }
            if (fontName != null && fontStyle != null && fontSize != null) {
                font = new KDFont(fontName.getText(), new Integer(fontStyle.getText()).intValue(), new Integer(fontSize.getText()).intValue());
                node.setFont((Font)font);
            }
            adminSet.add(objId);
            nodeMap.put(objId, node);
            nodeList.add(node);
        }
        Element edgeListElement = nodeAndEdgeElement.getChild("EdgeList");
        Element edgeElement = null;
        Element pointListElement = null;
        String color = null;
        String sNodeId = null;
        String tNodeId = null;
        Edge edge = null;
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        ArrayList<Point> pointList = null;
        int size2 = edgeListElement.getChildren().size();
        for (int i = 0; i < size2; ++i) {
            edgeElement = (Element)edgeListElement.getChildren().get(i);
            color = edgeElement.getChild("Color").getText();
            sNodeId = edgeElement.getChild("SNodeID").getText();
            tNodeId = edgeElement.getChild("TNodeID").getText();
            edge = new Edge();
            edge.setSourceNode((Node)nodeMap.get(sNodeId));
            edge.setTargetNode((Node)nodeMap.get(tNodeId));
            edge.setColor(new Color(Integer.parseInt(color)));
            pointListElement = edgeElement.getChild("PointList");
            pointList = new ArrayList<Point>();
            pointList.add(new Point(0, 0));
            int length = pointListElement.getChildren().size();
            for (int t = 0; t < length; ++t) {
                Element pointElement = (Element)pointListElement.getChildren().get(t);
                x = pointElement.getChild("X").getText();
                y = pointElement.getChild("Y").getText();
                pointList.add(new Point(Integer.parseInt(x), Integer.parseInt(y)));
            }
            pointList.add(new Point(0, 0));
            edge.setPoints(pointList);
            edgeList.add(edge);
        }
        ArrayList<Object> nodeAndEdgeList = new ArrayList<Object>();
        nodeAndEdgeList.add(nodeList);
        nodeAndEdgeList.add(edgeList);
        if (bg != null) {
            mainBackgroundColor = bg.getText();
            nodeAndEdgeList.add(mainBackgroundColor);
        }
        this.loadPersonNumberMap(adminSet);
        return nodeAndEdgeList;
    }

    @Override
    public IRowSet getOrgChartDataRowSet() throws Exception {
        IRowSet rs = super.getOrgChartDataRowSet();
        HashSet<String> adminSet = new HashSet<String>();
        while (rs.next()) {
            adminSet.add(rs.getString("FID"));
        }
        IBaseInnerFacade iBaseInner = BaseInnerFacadeFactory.getRemoteInstance();
        List list = iBaseInner.getPersonPlanNumber(adminSet);
        if (null == list || list.size() != 4) {
            return null;
        }
        this.personPlanMap = (Map)list.get(0);
        this.allPersonPlanMap = (Map)list.get(1);
        this.realNumberMap = (Map)list.get(2);
        this.allRealNumberMap = (Map)list.get(3);
        rs.beforeFirst();
        return rs;
    }

    private void loadPersonNumberMap(Set adminSet) throws EASBizException, BOSException {
        IBaseInnerFacade iBaseInner = BaseInnerFacadeFactory.getRemoteInstance();
        List list = iBaseInner.getPersonPlanNumber(adminSet);
        if (null == list || list.size() != 4) {
            return;
        }
        this.personPlanMap = (Map)list.get(0);
        this.allPersonPlanMap = (Map)list.get(1);
        this.realNumberMap = (Map)list.get(2);
        this.allRealNumberMap = (Map)list.get(3);
    }
}

