/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.base.client.ListenerManager;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RowEditor
implements PropertyChangeListener {
    private PropertyChangeSupport changeSupport;
    private KDTable tblMain;
    private String oprtState;
    private Map editors;
    private int selectedRow = -1;
    private boolean open = false;
    private ListenerManager listenerManager = new ListenerManager();
    private boolean isLayout = false;

    public RowEditor(KDTable table) {
        this.changeSupport = new PropertyChangeSupport(this);
        this.changeSupport.addPropertyChangeListener(this);
        this.editors = new LinkedHashMap();
        this.setKDTable(table);
        this.setOprtState(null);
    }

    private void setKDTable(KDTable table) {
        this.tblMain = table;
        if (this.tblMain == null) {
            return;
        }
        this.initTableListener();
        this.initRowEditor();
        this.initComponentListener();
    }

    public KDTable getKDTable() {
        return this.tblMain;
    }

    public void setOprtState(String oprtState) {
        String oldValue = this.oprtState;
        this.oprtState = oprtState;
        this.changeSupport.firePropertyChange("oprtState", oldValue, this.oprtState);
    }

    public String getOprtState() {
        return this.oprtState;
    }

    public JComponent getComponent(String columnKey) {
        JComponent comp = null;
        Object obj = this.editors.get(columnKey);
        if (obj instanceof KDLabelContainer) {
            comp = ((KDLabelContainer)obj).getBoundEditor();
        }
        return comp;
    }

    public void setEnabled(String columnKey, boolean isEnabled) {
        JComponent comp = this.getComponent(columnKey);
        if (comp != null) {
            comp.setEnabled(isEnabled);
        }
    }

    public void setEditable(String columnKey, boolean isEditable) {
        JComponent comp = this.getComponent(columnKey);
        if (comp instanceof IKDTextComponent) {
            ((IKDTextComponent)comp).setEditable(isEditable);
            ((IKDTextComponent)comp).setEnabled(isEditable);
        }
    }

    public void setRequired(String columnKey, boolean isRequired) {
        JComponent comp = this.getComponent(columnKey);
        if (comp instanceof IKDTextComponent) {
            ((IKDTextComponent)comp).setRequired(isRequired);
        }
    }

    public void setAccessAuthority(String columnKey, int authority) {
        JComponent comp = this.getComponent(columnKey);
        if (comp instanceof IKDTextComponent) {
            ((IKDTextComponent)comp).setAccessAuthority(authority);
        }
    }

    public void setBackground(String columnKey, Color color) {
        JComponent comp = this.getComponent(columnKey);
        this.setBackground(comp, color);
    }

    public void changeEditor(String columnKey, JComponent newEditor) {
        if (columnKey == null || newEditor == null) {
            return;
        }
        Object obj = this.editors.get(columnKey);
        if (!(obj instanceof KDLabelContainer)) {
            return;
        }
        newEditor.setName(columnKey);
        KDLabelContainer container = (KDLabelContainer)obj;
        JComponent oldEditor = container.getBoundEditor();
        this.setBackground(newEditor, oldEditor.getBackground());
        this.initComponentListener(columnKey, newEditor);
        container.setBoundEditor(newEditor);
    }

    private void setBackground(JComponent comp, Color color) {
        Color newColor;
        if (comp == null) {
            return;
        }
        Color color2 = newColor = color == null ? null : new Color(color.getRGB());
        if (comp instanceof KDTextField) {
            ((KDTextField)comp).setCustomBackgroundColor(newColor);
        } else if (comp instanceof BasicFormattedTextField) {
            ((BasicFormattedTextField)comp).setCustomBackgroundColor(newColor);
        } else if (comp instanceof KDDatePicker) {
            BasicFormattedTextField txtField = (BasicFormattedTextField)((KDDatePicker)comp).getEditor().getEditorComponent();
            txtField.setCustomBackgroundColor(newColor);
        } else if (comp instanceof KDPromptBox) {
            this.setBackground(((KDPromptBox)comp).getEditor(), color);
        } else {
            comp.setBackground(newColor);
        }
    }

    private void initRowEditor() {
        this.editors.clear();
        IRow headRow = this.tblMain.getHeadRow(0);
        int size = this.tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            IColumn curColumn = this.tblMain.getColumn(i);
            if (curColumn.getStyleAttributes().isHided()) continue;
            JComponent comp = curColumn.getEditor() != null ? (JComponent)curColumn.getEditor().getComponent() : null;
            JComponent newComp = null;
            if (comp != null) {
                try {
                    newComp = (JComponent)comp.getClass().newInstance();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                KDTextField txtField = new KDTextField();
                txtField.setName(curColumn.getKey());
                newComp = txtField;
            }
            if (newComp == null) {
                return;
            }
            newComp.setEnabled(!curColumn.getStyleAttributes().isLocked());
            if (comp instanceof KDFormattedTextField) {
                ((KDFormattedTextField)newComp).setDataType(((KDFormattedTextField)comp).getDataType());
                ((KDFormattedTextField)newComp).setPrecision(((KDFormattedTextField)comp).getPrecision());
            } else if (comp instanceof KDTextField) {
                ((KDTextField)newComp).setMaxLength(((KDTextField)comp).getMaxLength());
                ((KDTextField)newComp).setMinLength(((KDTextField)comp).getMinLength());
            } else if (comp instanceof KDComboBox) {
                int itemCount = ((KDComboBox)comp).getItemCount();
                for (int j = 0; j < itemCount; ++j) {
                    ((KDComboBox)newComp).addItem(((KDComboBox)comp).getItemAt(j));
                }
            } else if (comp instanceof KDBizPromptBox) {
                KDBizPromptBox prmtComp = (KDBizPromptBox)comp;
                KDBizPromptBox prmtNewComp = (KDBizPromptBox)newComp;
                String queryInfo = prmtComp.getQueryInfo();
                if (!StringUtils.isEmpty((String)queryInfo)) {
                    queryInfo = queryInfo.replace(File.separatorChar, '.');
                    prmtNewComp.setQueryInfo(queryInfo);
                }
                prmtNewComp.setSelector(prmtComp.getSelector());
                prmtNewComp.setEntityViewInfo(prmtComp.getEntityViewInfo());
                prmtNewComp.setEnabledMultiSelection(prmtComp.isEnabledMultiSelection());
                prmtNewComp.setEditable(false);
            }
            if (!(headRow.getCell(i).getValue() instanceof String)) continue;
            KDLabelContainer labelContainer = new KDLabelContainer((String)headRow.getCell(i).getValue());
            labelContainer.setSize(new Dimension(210, 19));
            labelContainer.setBoundLabelUnderline(true);
            labelContainer.setBoundLabelLength(90);
            labelContainer.setBoundEditor(newComp);
            newComp.setName(curColumn.getKey());
            this.editors.put(curColumn.getKey(), labelContainer);
        }
    }

    private void loadData() {
        for (Map.Entry entry : this.editors.entrySet()) {
            String columnKey = (String)entry.getKey();
            JComponent comp = ((KDLabelContainer)entry.getValue()).getBoundEditor();
            this.updateComponentValue(comp, this.tblMain.getCell(this.selectedRow, columnKey));
        }
    }

    private void initTableListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int[] rows = KDTableUtil.getSelectedRows((KDTable)RowEditor.this.tblMain);
                if (rows.length > 0) {
                    RowEditor.this.setSelectedRowIndex(rows[0]);
                }
            }
        });
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1 && e.getModifiersEx() == 128 && KDTableUtil.getSelectedRowCount((KDTable)RowEditor.this.tblMain) > 0) {
                    RowEditor.this.setOpen(!RowEditor.this.open);
                }
            }
        });
        this.tblMain.addAfterActionListener(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                if (e.getType() == 1 || e.getType() == 0) {
                    RowEditor.this.setOpen(false);
                }
            }
        });
        this.tblMain.setBeforeRemoveRowsAction((Action)new AbstractAction(){
            private static final long serialVersionUID = 4341242987212841483L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RowEditor.this.setOpen(false);
            }
        });
        this.tblMain.addKDTPropertyChangeListener((KDTPropertyChangeListener)this.listenerManager.createListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                String columnKey = RowEditor.this.tblMain.getColumn(evt.getColIndex()).getKey();
                Object obj = RowEditor.this.editors.get(columnKey);
                if (obj instanceof KDLabelContainer) {
                    JComponent comp = ((KDLabelContainer)obj).getBoundEditor();
                    RowEditor.this.updateComponentValue(comp, RowEditor.this.tblMain.getCell(evt.getRowIndex(), evt.getColIndex()));
                }
            }
        }.getClass(), new Class[]{RowEditor.class}, new Object[]{this}));
    }

    private void initComponentListener() {
        for (Map.Entry entry : this.editors.entrySet()) {
            String columnKey = (String)entry.getKey();
            JComponent comp = ((KDLabelContainer)entry.getValue()).getBoundEditor();
            this.initComponentListener(columnKey, comp);
        }
    }

    private void initComponentListener(final String columnKey, JComponent comp) {
        if (comp instanceof IKDEditor) {
            ((IKDEditor)comp).addDataChangeListener((DataChangeListener)this.listenerManager.createListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    RowEditor.this.tblMain.getCell(RowEditor.this.selectedRow, columnKey).setValue(eventObj.getNewValue());
                }
            }.getClass(), new Class[]{RowEditor.class, String.class}, new Object[]{this, columnKey}));
        } else if (comp instanceof KDFormattedTextField) {
            ((KDFormattedTextField)comp).addDataChangeListener((DataChangeListener)this.listenerManager.createListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    RowEditor.this.tblMain.getCell(RowEditor.this.selectedRow, columnKey).setValue(eventObj.getNewValue());
                }
            }.getClass(), new Class[]{RowEditor.class, String.class}, new Object[]{this, columnKey}));
        } else if (comp instanceof KDTextField) {
            final KDTextField textField = (KDTextField)comp;
            textField.getDocument().addDocumentListener((DocumentListener)this.listenerManager.createListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.txtChanged(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.txtChanged(e);
                }

                public void txtChanged(DocumentEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RowEditor.this.tblMain.getCell(RowEditor.this.selectedRow, columnKey).setValue((Object)textField.getText());
                        }
                    });
                }
            }.getClass(), new Class[]{RowEditor.class, String.class, textField.getClass()}, new Object[]{this, columnKey, textField}));
        } else if (comp instanceof KDCheckBox) {
            final KDCheckBox checkBox = (KDCheckBox)comp;
            checkBox.addItemListener((ItemListener)this.listenerManager.createListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    RowEditor.this.tblMain.getCell(RowEditor.this.selectedRow, columnKey).setValue((Object)checkBox.isSelected());
                }
            }.getClass(), new Class[]{RowEditor.class, String.class, checkBox.getClass()}, new Object[]{this, columnKey, checkBox}));
        } else if (comp instanceof KDComboBox) {
            final KDComboBox comboBox = (KDComboBox)comp;
            comboBox.addItemListener((ItemListener)this.listenerManager.createListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    RowEditor.this.tblMain.getCell(RowEditor.this.selectedRow, columnKey).setValue(comboBox.getSelectedItem());
                }
            }.getClass(), new Class[]{RowEditor.class, String.class, comboBox.getClass()}, new Object[]{this, columnKey, comboBox}));
        }
    }

    private void updateComponentValue(JComponent comp, ICell cell) {
        boolean isEditable;
        if (cell == null) {
            return;
        }
        Object newValue = cell.getValue();
        Color color = cell.getStyleAttributes().getBackground();
        boolean bl = isEditable = !cell.getStyleAttributes().isLocked();
        if (comp instanceof IKDEditor) {
            ((IKDEditor)comp).setValue(newValue);
        } else if (comp instanceof KDFormattedTextField) {
            ((KDFormattedTextField)comp).setNumberValue((Number)newValue);
        } else if (comp instanceof KDTextField) {
            String oldValue = ((KDTextField)comp).getText();
            if (newValue != null && !newValue.equals(oldValue) || oldValue != null && !oldValue.equals(newValue)) {
                Class<?> classType = null;
                try {
                    classType = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (newValue != null && newValue.getClass().equals(classType)) {
                    ((KDTextField)comp).setText((String)newValue);
                } else {
                    ((KDTextField)comp).setText(" ");
                }
            }
        } else if (comp instanceof KDComboBox) {
            ((KDComboBox)comp).setSelectedItem(newValue);
        } else if (comp instanceof KDCheckBox && newValue instanceof Boolean) {
            ((KDCheckBox)comp).setSelected(((Boolean)newValue).booleanValue());
        }
        if (comp instanceof IKDTextComponent) {
            ((IKDTextComponent)comp).setEditable(isEditable);
            ((IKDTextComponent)comp).setEnabled(isEditable);
        }
        this.setBackground(comp, color);
        if (comp instanceof KDBizPromptBox) {
            ((KDBizPromptBox)comp).setEditable(false);
        }
    }

    private void openLayout() {
        if (this.isLayout) {
            KDSplitPane splitPane = (KDSplitPane)this.tblMain.getParent();
            SplitPaneListener.remove(splitPane);
            splitPane.addComponentListener((ComponentListener)SplitPaneListener.THIRD);
            splitPane.setDividerLocation(0.3333333333333333);
            splitPane.revalidate();
            return;
        }
        Container container = this.tblMain.getParent();
        KDPanel pnl = new KDPanel();
        KDScrollPane scrollPane = new KDScrollPane();
        scrollPane.getViewport().add((Component)pnl);
        KDSplitPane splitPane = new KDSplitPane(0);
        splitPane.add((Component)this.tblMain, (Object)"top");
        splitPane.add((Component)scrollPane, (Object)"bottom");
        container.setLayout(new BorderLayout());
        container.add((Component)splitPane, "Center");
        pnl.setLayout((LayoutManager)new KDLayout());
        int initX = 10;
        int initY = 10;
        int initialWidth = 730;
        int componentWidth = 210;
        int componentHeigth = 19;
        int componentSpace = (initialWidth - initX * 2 - componentWidth * 3) / 2;
        ArrayList<JComponent> compList = new ArrayList<JComponent>();
        Iterator iterator = this.editors.values().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            KDLabelContainer labelContainer = (KDLabelContainer)iterator.next();
            JComponent comp = labelContainer.getBoundEditor();
            if (comp.isEnabled()) {
                labelContainer.getBoundEditor().setFocusable(true);
                compList.add(labelContainer.getBoundEditor());
            }
            int imod3 = i % 3;
            int x = initX + imod3 * (componentWidth + componentSpace);
            int y = initY + 30 * (i / 3);
            Rectangle rect = new Rectangle(x, y, componentWidth, componentHeigth);
            if (i % 3 == 1) {
                labelContainer.setBounds(rect);
                pnl.add((Component)labelContainer, (Object)new KDLayout.Constraints(401, rect));
            } else if (i % 3 == 2) {
                labelContainer.setBounds(rect);
                pnl.add((Component)labelContainer, (Object)new KDLayout.Constraints(137, rect));
            } else {
                labelContainer.setBounds(rect);
                pnl.add((Component)labelContainer, (Object)new KDLayout.Constraints(261, rect));
            }
            ++i;
        }
        int initialHeight = 10 + 30 * (this.editors.values().size() / 3) + 19;
        Rectangle rect = new Rectangle();
        rect.setSize(initialWidth, initialHeight);
        pnl.putClientProperty((Object)"OriginalBounds", (Object)rect);
        pnl.setPreferredSize(new Dimension(initialWidth, initialHeight));
        ((JComponent)container).revalidate();
        SplitPaneListener.remove(splitPane);
        splitPane.addComponentListener((ComponentListener)SplitPaneListener.THIRD);
        splitPane.setDividerLocation(0.3333333333333333);
        int size = compList.size();
        pnl.setFocusCycleRoot(true);
        Component[] comps = new Component[size];
        for (int k = 0; k < size; ++k) {
            comps[k] = (Component)compList.get(k);
        }
        pnl.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(comps));
        this.isLayout = true;
    }

    private void closeLayout() {
        KDSplitPane splitPane = (KDSplitPane)this.tblMain.getParent();
        SplitPaneListener.remove(splitPane);
        splitPane.addComponentListener((ComponentListener)SplitPaneListener.FULL);
        splitPane.setDividerLocation(1.0);
    }

    public int getSelectedRowIndex() {
        return this.selectedRow;
    }

    public void setSelectedRowIndex(int rowIndex) {
        int oldValue = this.selectedRow;
        this.selectedRow = rowIndex;
        boolean oldListening = this.listenerManager.isListening();
        this.listenerManager.setListening(false);
        this.changeSupport.firePropertyChange("selectedRow", oldValue, this.selectedRow);
        this.listenerManager.setListening(oldListening);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        boolean oldValue = this.open;
        this.open = open;
        this.changeSupport.firePropertyChange("open", oldValue, this.open);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("open".equals(propertyName)) {
            boolean isOpen = (Boolean)evt.getNewValue();
            this.open(isOpen);
            if (isOpen) {
                this.loadData();
            }
            this.listenerManager.setListening(isOpen);
        } else if ("selectedRow".equals(propertyName) && this.open) {
            this.loadData();
        } else if ("oprtState".equals(propertyName)) {
            boolean editable = false;
            if (OprtState.ADDNEW.equals(this.oprtState) || OprtState.EDIT.equals(this.oprtState)) {
                editable = true;
            }
            this.changeEditable(editable);
            this.listenerManager.setListening(this.open);
        }
    }

    private void changeEditable(boolean editable) {
        for (Map.Entry entry : this.editors.entrySet()) {
            String columnKey = (String)entry.getKey();
            IColumn curColumn = this.tblMain.getColumn(columnKey);
            boolean isLocked = curColumn.getStyleAttributes().isLocked();
            JComponent comp = ((KDLabelContainer)entry.getValue()).getBoundEditor();
            if (comp instanceof IKDTextComponent) {
                if (isLocked) {
                    comp.setEnabled(!isLocked);
                    continue;
                }
                ((IKDTextComponent)comp).setEditable(editable);
                if (editable) {
                    ((IKDTextComponent)comp).setAccessAuthority(0);
                } else {
                    ((IKDTextComponent)comp).setAccessAuthority(1);
                }
                ((IKDTextComponent)comp).setRequired(curColumn.isRequired());
            }
            if (!(comp instanceof KDBizPromptBox)) continue;
            ((KDBizPromptBox)comp).setEditable(false);
        }
    }

    private void open(boolean isOpened) {
        if (isOpened) {
            this.openLayout();
        } else {
            this.closeLayout();
        }
    }

    private static class SplitPaneListener
    extends ComponentAdapter {
        public static final double FULL_VALUE = 1.0;
        public static final double THIRD_VALUE = 0.3333333333333333;
        public static final SplitPaneListener FULL = new SplitPaneListener(1.0);
        public static final SplitPaneListener THIRD = new SplitPaneListener(0.3333333333333333);
        private double location;

        private SplitPaneListener(double location) {
            this.location = location;
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            if (evt.getComponent() instanceof KDSplitPane) {
                ((KDSplitPane)evt.getComponent()).setDividerLocation(this.location);
            }
        }

        public static void remove(KDSplitPane splitPane) {
            if (splitPane == null) {
                return;
            }
            ComponentListener[] listeners = splitPane.getComponentListeners();
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof SplitPaneListener)) continue;
                splitPane.removeComponentListener(listeners[i]);
            }
        }
    }
}

