/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.hr.base.BaseBizException;
import com.kingdee.eas.hr.base.EmpInfoSinglePageInfo;
import com.kingdee.eas.hr.base.EntityFieldMappingCollection;
import com.kingdee.eas.hr.base.EntityFieldMappingFactory;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.MappingSolutionCollection;
import com.kingdee.eas.hr.base.MappingSolutionFactory;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.IPersonOtherInfo;
import com.kingdee.eas.hr.emp.IPersonPositionExtend;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionExtendFactory;
import com.kingdee.eas.hr.emp.PersonPositionExtendHISCollection;
import com.kingdee.eas.hr.emp.PersonPositionExtendHISFactory;
import com.kingdee.eas.hr.emp.PersonPositionExtendInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import java.util.Date;

public class AffairBizExtendCustomerTool {
    public static void deleteCustomerExtendData(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billID.getType());
        HRBillBaseInfo model = (HRBillBaseInfo)iCoreBillBase.getValue((IObjectPK)new ObjectUuidPK(billID));
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        HRBillBaseEntryInfo entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            AffairBizExtendCustomerTool.deletePersonPositionExtendDate(ctx, entry);
        }
    }

    private static void deletePersonPositionExtendDate(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        String personId = (PersonInfo)entry.get("person") != null ? ((PersonInfo)entry.get("person")).getId().toString() : null;
        Date effdt = (Date)entry.get("bizDate");
        if (personId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo(HistoryConstant.ID));
            sic.add(new SelectorItemInfo(HistoryConstant.historyRelateID));
            sic.add(new SelectorItemInfo(HistoryConstant.EFFDT));
            sic.add(new SelectorItemInfo(HistoryConstant.LEFFDT));
            view.setSelector(sic);
            SorterItemInfo sorter = new SorterItemInfo(HistoryConstant.LEFFDT);
            sorter.setSortType(SortType.DESCEND);
            view.getSorter().add(sorter);
            PersonPositionExtendHISCollection ppeHiscoll = PersonPositionExtendHISFactory.getLocalInstance((Context)ctx).getPersonPositionExtendHISCollection(view);
            if (ppeHiscoll == null || ppeHiscoll.size() < 1) {
                return;
            }
            if (!entry.getId().getType().toString().equals(ppeHiscoll.get(0).getEntryType())) {
                return;
            }
            if (ppeHiscoll.get(0).getEFFDT().compareTo(effdt) != 0) {
                throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.EMP_AFTER_OPTION, new Object[]{DateUtils.getCustomDateString((Date)effdt, (String)"yyyy-MM-dd")})));
            }
            if (ppeHiscoll.size() == 1) {
                PersonPositionExtendFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(ppeHiscoll.get(0).getHistoryRelateID()));
            } else {
                PersonPositionExtendHISFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(ppeHiscoll.get(0).getId().toString()));
                PersonPositionExtendInfo ppeInfo = new PersonPositionExtendInfo();
                HistoryUtil.cloneInfo((IObjectValue)ppeHiscoll.get(1), (IObjectValue)ppeInfo);
                ppeInfo.setId(BOSUuid.read((String)ppeHiscoll.get(1).getHistoryRelateID().toString()));
                ppeInfo.setLEFFDT(HistoryUtil.getMaxDate());
                PersonPositionExtendFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(ppeHiscoll.get(0).getHistoryRelateID()), (EmpInfoSinglePageInfo)ppeInfo);
            }
        }
    }

    private static void deleteCustomerExtendDate(Context ctx, HRBillBaseInfo model, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("enable", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entity"));
        view.setSelector(sic);
        MappingSolutionCollection mappingColl = MappingSolutionFactory.getLocalInstance(ctx).getMappingSolutionCollection(view);
        if (mappingColl != null && mappingColl.size() > 0) {
            boolean flag = false;
            String mappingSolutionId = null;
            for (int i = 0; i < mappingColl.size(); ++i) {
                EntityObjectInfo entitobj;
                String modelName;
                String entityName = mappingColl.get(i).getEntity();
                if (!entityName.equals(modelName = (entitobj = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(model.getId().getType())).getFullName())) continue;
                flag = true;
                mappingSolutionId = mappingColl.get(i).getId().toString();
                break;
            }
            if (flag) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("solution.id", mappingSolutionId, CompareType.EQUALS));
                view.setFilter(filter);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("sourceFieldPath"));
                sic.add(new SelectorItemInfo("targetEntity"));
                sic.add(new SelectorItemInfo("targetFieldPath"));
                view.setSelector(sic);
                EntityFieldMappingCollection entityFieldMappingCollection = EntityFieldMappingFactory.getLocalInstance(ctx).getEntityFieldMappingCollection(view);
            }
        }
    }

    public static boolean isNeedWritePersonPositionExtend(Context ctx, BOSUuid billId) {
        boolean flag = false;
        try {
            EntityObjectInfo entitobj = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(billId.getType());
            String modelName = entitobj.getFullName();
            String tarEntity = "com.kingdee.eas.hr.emp.app.PersonPositionExtend";
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT es.FID ,es.FENTITY  FROM T_HR_EntitySetting es left join T_HR_MappingSolution ms ");
            sql.append(" ON ES.FSOLUTIONID = MS.FID where es.FENTITY = ? ");
            sql.append(" and ms.FENTITY = ? and ms.FENABLE =1");
            Object[] paraObj = new Object[]{tarEntity, modelName};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paraObj);
            if (rowSet.size() > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static void recordPersonPositionExtendMapping(Context ctx, PersonPositionExtendInfo info) throws BOSException, EASBizException {
        String ppePk;
        IPersonPositionExtend personPositionExtend = PersonPositionExtendFactory.getLocalInstance((Context)ctx);
        PersonPositionExtendInfo ppeInfo = HRUtilExtend.getPersonPositionExtendInfoByPersonInfo(ctx, info.getPerson());
        String string = ppePk = ppeInfo == null ? null : ppeInfo.getId().toString();
        if (ppeInfo == null) {
            ppeInfo = new PersonPositionExtendInfo();
        }
        ObjectUuidPK ppk = null;
        if (ppePk == null) {
            HistoryUtil.cloneInfo((IObjectValue)info, (IObjectValue)ppeInfo);
            ppeInfo.setLEFFDT(HistoryUtil.getMaxDate());
            ppk = personPositionExtend.addnew((EmpInfoSinglePageInfo)ppeInfo);
            ppeInfo.setId(BOSUuid.read((String)ppk.toString()));
        } else {
            ppk = new ObjectUuidPK(ppePk);
            ppeInfo.setId(BOSUuid.read((String)ppePk));
            info.setId(BOSUuid.read((String)ppePk));
            if (info.getEFFDT() == null) {
                info.setEFFDT(ppeInfo.getEFFDT());
            }
            if (info.getLEFFDT() == null) {
                info.setLEFFDT(ppeInfo.getLEFFDT());
            }
            personPositionExtend.update((IObjectPK)ppk, (EmpInfoSinglePageInfo)info);
        }
    }

    public static void recordPersonOtherInfoMapping(Context ctx, PersonOtherInfoInfo info) throws BOSException, EASBizException {
        String ppePk;
        IPersonOtherInfo personOtherInfo = PersonOtherInfoFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getPerson().getId().toString()));
        viewInfo.setFilter(filterInfo);
        PersonOtherInfoCollection personOtherInfoCollection = personOtherInfo.getPersonOtherInfoCollection(viewInfo);
        PersonOtherInfoInfo ppeInfo = personOtherInfoCollection.get(0);
        String string = ppePk = ppeInfo == null ? null : ppeInfo.getId().toString();
        if (ppeInfo == null) {
            ppeInfo = new PersonOtherInfoInfo();
        }
        ObjectUuidPK ppk = null;
        if (ppePk == null) {
            HistoryUtil.cloneInfo((IObjectValue)info, (IObjectValue)ppeInfo);
            ppeInfo.setLEFFDT(HistoryUtil.getMaxDate());
            ppk = personOtherInfo.addnew((CoreBaseInfo)ppeInfo);
            ppeInfo.setId(BOSUuid.read((String)ppk.toString()));
        } else {
            ppk = new ObjectUuidPK(ppePk);
            ppeInfo.setId(BOSUuid.read((String)ppePk));
            info.setId(BOSUuid.read((String)ppePk));
            if (info.getEFFDT() == null) {
                info.setEFFDT(ppeInfo.getEFFDT());
            }
            if (info.getLEFFDT() == null) {
                info.setLEFFDT(ppeInfo.getLEFFDT());
            }
            personOtherInfo.update((IObjectPK)ppk, (CoreBaseInfo)info);
        }
    }
}

