/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.hr.base.BaseBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public final class HRDBHelper {
    public static final DateFormat FORMAT_DAY = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat FORMAT_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String gen_InsertScript(Context ctx, String string) throws BOSException {
        String rstValue = "";
        IRowSet rs = null;
        try {
            String from = "from";
            String[] sqls = string.split(";");
            for (int i = 0; i < sqls.length; ++i) {
                int e;
                String lc = sqls[i].toLowerCase();
                int s = lc.indexOf(from);
                String tableName = null;
                if (s > 0 && (e = lc.indexOf(" ", s = from.length() + s + 1)) > 0 && tableName == null) {
                    tableName = lc.substring(s, e).trim();
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sqls[i]);
                rstValue = rstValue + HRDBHelper.genInsertSql(tableName, (ResultSet)rs);
            }
        }
        catch (SQLException exp) {
            throw new BOSException((Throwable)exp);
        }
        return rstValue;
    }

    private static String genInsertSql(String tableName, ResultSet rs) throws SQLException {
        if (rs == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer headSb = new StringBuffer();
        ResultSetMetaData mddata = rs.getMetaData();
        if (StringUtils.isEmpty((String)tableName)) {
            throw new SQLException((Throwable)((Object)new BaseBizException(BaseBizException.TABLE_NAME_IS_NULL)));
        }
        headSb = HRDBHelper.getHeadSql(tableName, mddata);
        int k = 0;
        while (rs.next()) {
            sb.append("\n");
            headSb = HRDBHelper.fillHeadSQL(tableName, rs, sb, headSb, mddata);
            for (int i = 1; i <= mddata.getColumnCount(); ++i) {
                Object value;
                if (i > 1) {
                    sb.append(", ");
                }
                if ((value = HRDBHelper.getRowValue(rs, i, mddata.getColumnType(i), mddata.getColumnTypeName(i))) != null && value instanceof String) {
                    value = ((String)value).replaceAll("\r|\n", "");
                }
                sb.append(value);
            }
            ++k;
            sb.append(")");
            sb.append(";\n");
        }
        return sb.toString();
    }

    private static StringBuffer getHeadSql(String tableName, ResultSetMetaData mddata) throws SQLException {
        StringBuffer headSb = new StringBuffer();
        headSb.append("insert into ");
        headSb.append(tableName);
        headSb.append("(");
        for (int i = 1; i <= mddata.getColumnCount(); ++i) {
            if (i > 1) {
                headSb.append(", ");
            }
            headSb.append(mddata.getColumnName(i));
        }
        headSb.append(")");
        headSb.append("\n");
        headSb.append(" values\n");
        headSb.append("(");
        return headSb;
    }

    private static StringBuffer fillHeadSQL(String tableName, ResultSet rs, StringBuffer sb, StringBuffer headSb, ResultSetMetaData mddata) throws SQLException {
        String idKey = "fid";
        String entityNameKey = "FENTITYNAME";
        String uiNameKey = "FUINAME";
        String idValue = null;
        String entityNameValue = null;
        String uiNameValue = null;
        try {
            idValue = rs.getString(idKey);
            entityNameValue = rs.getString(entityNameKey);
            uiNameValue = rs.getString(uiNameKey);
            headSb = HRDBHelper.fillHeadSQL(tableName, sb, headSb, mddata, idKey, entityNameKey, uiNameKey, idValue, entityNameValue, uiNameValue);
        }
        catch (SQLException e) {
            headSb = HRDBHelper.fillHeadSQL(tableName, sb, headSb, mddata, idKey, entityNameKey, uiNameKey, idValue, entityNameValue, uiNameValue);
        }
        return headSb;
    }

    private static StringBuffer fillHeadSQL(String tableName, StringBuffer sb, StringBuffer headSb, ResultSetMetaData mddata, String idKey, String entityNameKey, String uiNameKey, String idValue, String entityNameValue, String uiNameValue) throws SQLException {
        if (idValue != null && idValue.length() > 25) {
            headSb = new StringBuffer();
            headSb = HRDBHelper.getHeadSql(tableName, mddata);
            headSb.insert(0, "If not exists (select * from " + tableName + " where " + idKey + "='" + idValue + "')\n");
        } else if (entityNameValue != null && entityNameValue.trim().length() > 0) {
            headSb = new StringBuffer();
            headSb = HRDBHelper.getHeadSql(tableName, mddata);
            headSb.insert(0, "If not exists (select * from " + tableName + " where " + entityNameKey + "='" + entityNameValue + "')\n");
        } else if (uiNameValue != null && uiNameValue.trim().length() > 0) {
            headSb = new StringBuffer();
            headSb = HRDBHelper.getHeadSql(tableName, mddata);
            headSb.insert(0, "If not exists (select * from " + tableName + " where " + uiNameKey + "='" + uiNameValue + "')\n");
        } else if (idValue != null && idValue.trim().length() > 0) {
            headSb = new StringBuffer();
            headSb = HRDBHelper.getHeadSql(tableName, mddata);
            headSb.insert(0, "If not exists (select * from " + tableName + " where " + idKey + "='" + idValue + "')\n");
        }
        sb.append(headSb.toString());
        return headSb;
    }

    private static Object getRowValue(ResultSet rs, int i, int type, String dispTypeName) throws SQLException {
        Object o = rs.getObject(i);
        if (o == null) {
            return "null";
        }
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return o.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                if (o.toString().trim().length() == 44 || o.toString().trim().length() == 28) {
                    return "'" + rs.getString(i) + "'";
                }
                return "N'" + rs.getString(i) + "'";
            }
            case 16: {
                return o.toString();
            }
            case 91: {
                return "{d'" + FORMAT_DAY.format(o) + "'}";
            }
            case 92: 
            case 93: {
                return "{ts'" + FORMAT_TIME.format(o) + "'}";
            }
            case 0: {
                return null;
            }
            case 1111: {
                return "'" + rs.getString(i) + "'";
            }
        }
        return "'" + rs.getString(i) + "'";
    }
}

