/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class IDCardCommonUtil {
    private static final String verify18PatternStr = "(\\d{6})(\\d{8})(\\d{3})([\\d[xX]]{1})";
    private static final Pattern verify18Pattern = Pattern.compile("(\\d{6})(\\d{8})(\\d{3})([\\d[xX]]{1})");
    private static final String verify15PatternStr = "(\\d{6})(\\d{6})(\\d{3})";
    private static final Pattern verify15Pattern = Pattern.compile("(\\d{6})(\\d{6})(\\d{3})");
    private static final int[] verify18Rights = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
    private static final String[] verify18CheckDigit = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private int[] a = new int[18];
    private String areaNum;
    private String birthdayNum;
    private String seqNum;
    private String check_digit;
    private int length;
    private static Logger logger = Logger.getLogger(IDCardCommonUtil.class);

    public boolean isMan() {
        int num = Integer.parseInt(this.seqNum);
        return num % 2 != 0;
    }

    public Genders getGenders() {
        if (this.seqNum == null) {
            return null;
        }
        int num = Integer.parseInt(this.seqNum);
        if (num % 2 != 0) {
            return Genders.getEnum((int)1);
        }
        return Genders.getEnum((int)2);
    }

    public String getBirthday() {
        String FullBirthdayNum = null;
        FullBirthdayNum = this.length == 15 && this.birthdayNum != null ? "19" + this.birthdayNum : this.birthdayNum;
        if (FullBirthdayNum == null) {
            return "";
        }
        String year = FullBirthdayNum.substring(0, 4);
        String month = FullBirthdayNum.substring(4, 6);
        String date = FullBirthdayNum.substring(6, 8);
        return year + "-" + month + "-" + date;
    }

    public IDCardCommonUtil(String IDCardNO) throws BaseException {
        if (IDCardNO == null) {
            throw new BaseException(BaseException.IDCARD_NOTNULL);
        }
        IDCardNO = IDCardCommonUtil.upperIdCardNo(IDCardNO);
        this.length = IDCardNO.length();
        switch (this.length) {
            case 15: {
                this.Verifier15(IDCardNO);
                break;
            }
            case 18: {
                this.Verifier18(IDCardNO);
                break;
            }
            default: {
                throw new BaseException(BaseException.IDCARD_NUMERROR);
            }
        }
    }

    public IDCardCommonUtil(String IDCardNO, boolean isVerify) throws BaseException {
        if (IDCardNO == null) {
            throw new BaseException(BaseException.IDCARD_NOTNULL);
        }
        IDCardNO = IDCardCommonUtil.upperIdCardNo(IDCardNO);
        this.length = IDCardNO.length();
        if (this.length == 15 && isVerify) {
            throw new BaseException(BaseException.IDCARD_NUMERROR18);
        }
        switch (this.length) {
            case 15: {
                this.Verifier15(IDCardNO, isVerify);
                break;
            }
            case 18: {
                this.Verifier18(IDCardNO, isVerify);
                break;
            }
            default: {
                if (!isVerify) break;
                throw new BaseException(BaseException.IDCARD_NUMERROR);
            }
        }
    }

    private void Verifier15(String IDCardNO) throws BaseException {
        Matcher m = verify15Pattern.matcher(IDCardNO);
        if (!m.matches()) {
            throw new BaseException(BaseException.IDCARD_INVALID);
        }
        String strMonth = IDCardNO.substring(8, 10);
        String strDay = IDCardNO.substring(10, 12);
        if (Integer.parseInt(strMonth) > 12 || Integer.parseInt(strMonth) < 1) {
            throw new BaseException(BaseException.IDCARD_INVALID);
        }
        if (Integer.parseInt(strDay) > 31 || Integer.parseInt(strDay) < 1) {
            throw new BaseException(BaseException.IDCARD_INVALID);
        }
        this.areaNum = m.group(1);
        this.birthdayNum = m.group(2);
        this.seqNum = m.group(3);
    }

    private void Verifier18(String IDCardNO) throws BaseException {
        Matcher m = verify18Pattern.matcher(IDCardNO);
        if (!m.matches()) {
            throw new BaseException(BaseException.IDCARD_INVALID);
        }
        this.areaNum = m.group(1);
        this.birthdayNum = m.group(2);
        this.seqNum = m.group(3);
        this.check_digit = m.group(4);
        String expect_check_digit = IDCardCommonUtil.getCheck_digit18(IDCardNO);
        if (!expect_check_digit.equalsIgnoreCase(this.check_digit)) {
            throw new BaseException(BaseException.IDCARD_INVALID);
        }
    }

    private void Verifier18(String IDCardNO, boolean isVerify) throws BaseException {
        block6: {
            try {
                Matcher m = verify18Pattern.matcher(IDCardNO);
                if (!m.matches()) {
                    throw new BaseException(BaseException.IDCARD_INVALID);
                }
                this.areaNum = m.group(1);
                this.birthdayNum = m.group(2);
                this.seqNum = m.group(3);
                this.check_digit = m.group(4);
                String expect_check_digit = IDCardCommonUtil.getCheck_digit18(IDCardNO);
                if (!expect_check_digit.equalsIgnoreCase(this.check_digit)) {
                    throw new BaseException(BaseException.IDCARD_INVALID);
                }
            }
            catch (BaseException e) {
                if (isVerify) {
                    throw e;
                }
            }
            catch (Exception e) {
                if (!isVerify) break block6;
                throw new BaseException(BaseException.IDCARD_INVALID);
            }
        }
    }

    private void Verifier15(String IDCardNO, boolean isVerify) throws BaseException {
        block7: {
            try {
                Matcher m = verify15Pattern.matcher(IDCardNO);
                if (!m.matches()) {
                    throw new BaseException(BaseException.IDCARD_INVALID);
                }
                String strMonth = IDCardNO.substring(8, 10);
                String strDay = IDCardNO.substring(10, 12);
                if (Integer.parseInt(strMonth) > 12 || Integer.parseInt(strMonth) < 1) {
                    throw new BaseException(BaseException.IDCARD_INVALID);
                }
                if (Integer.parseInt(strDay) > 31 || Integer.parseInt(strDay) < 1) {
                    throw new BaseException(BaseException.IDCARD_INVALID);
                }
                this.areaNum = m.group(1);
                this.birthdayNum = m.group(2);
                this.seqNum = m.group(3);
            }
            catch (BaseException e) {
                if (isVerify) {
                    throw e;
                }
            }
            catch (NumberFormatException e) {
                if (!isVerify) break block7;
                throw new BaseException(BaseException.IDCARD_INVALID);
            }
        }
    }

    public static String getCheck_digit18(String IDCardNO) {
        int sum = 0;
        for (int i = 0; i <= 16; ++i) {
            int num = Integer.parseInt(IDCardNO.substring(i, i + 1));
            int right = verify18Rights[i];
            sum += num * right;
        }
        int y = sum % 11;
        return verify18CheckDigit[y];
    }

    public static String IDCardNO15To18(String IDCardNO15) throws BaseException {
        Matcher m = verify15Pattern.matcher(IDCardNO15);
        if (!m.matches()) {
            return "none";
        }
        String NO17 = IDCardNO15.substring(0, 6) + "19" + IDCardNO15.substring(6, 15);
        return NO17 + IDCardCommonUtil.getCheck_digit18(NO17);
    }

    public static String IDCardNO18To15(String IDCardNO18) throws BaseException {
        Matcher m = verify18Pattern.matcher(IDCardNO18);
        if (!m.matches()) {
            return "none";
        }
        return IDCardNO18.substring(0, 6) + IDCardNO18.substring(8, 17);
    }

    public String getAreaNum() {
        return this.areaNum;
    }

    public String getBirthdayNum() {
        return this.birthdayNum;
    }

    public String getCheck_digitNum18() {
        return this.check_digit;
    }

    public int getLength() {
        return this.length;
    }

    public String getSeqNum() {
        return this.seqNum;
    }

    public String getVerify(String eightcardid) {
        int remaining = 0;
        if (eightcardid.length() == 18) {
            eightcardid = eightcardid.substring(0, 17);
        }
        if (eightcardid.length() == 17) {
            int i;
            int sum = 0;
            for (i = 0; i < 17; ++i) {
                String k = eightcardid.substring(i, i + 1);
                this.a[i] = Integer.parseInt(k);
            }
            for (i = 0; i < 17; ++i) {
                sum += verify18Rights[i] * this.a[i];
            }
            remaining = sum % 11;
        }
        return remaining == 2 ? "X" : String.valueOf(verify18CheckDigit[remaining]);
    }

    public String uptoeighteen(String fifteencardid) {
        String eightcardid = fifteencardid.substring(0, 6);
        eightcardid = eightcardid + "19";
        eightcardid = eightcardid + fifteencardid.substring(6, 15);
        eightcardid = eightcardid + this.getVerify(eightcardid);
        return eightcardid;
    }

    public static void main(String[] args) {
        try {
            IDCardCommonUtil iDCardValidUtil = new IDCardCommonUtil("610528198205024510");
            iDCardValidUtil.Verifier18("61052819820502451x");
            logger.info((Object)iDCardValidUtil.getBirthday());
            logger.info((Object)iDCardValidUtil.isMan());
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public boolean checkIdCard(String IDCardNO) {
        if (IDCardNO == null) {
            return false;
        }
        this.length = IDCardNO.length();
        switch (this.length) {
            case 15: {
                try {
                    this.Verifier15(IDCardNO);
                    break;
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                    return false;
                }
            }
            case 18: {
                try {
                    this.Verifier18(IDCardNO);
                    break;
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                    return false;
                }
            }
            default: {
                try {
                    throw new BaseException(BaseException.IDCARD_NUMERROR);
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                    return false;
                }
            }
        }
        return true;
    }

    public static String upperIdCardNo(String IdCardNo) {
        Matcher m;
        String regex = ".*[a-zA-Z]+.*";
        Pattern p = Pattern.compile(regex);
        if (!StringUtils.isEmpty((String)IdCardNo) && (m = p.matcher(IdCardNo)).matches()) {
            IdCardNo = IdCardNo.toUpperCase();
        }
        return IdCardNo;
    }
}

