/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;

public class ShrEmpNaturalMonthUtil {
    private static final int[] monthModelAvg = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] monthModelLeap = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static boolean isLeapYear(Date date) {
        int year = DateTimeUtils.getYear((Date)date);
        return ShrEmpNaturalMonthUtil.isLeapYear(year);
    }

    public static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
    }

    public static int getDateCountOfMonth(int month, boolean isLeap) {
        if (month > 12 || month < 1) {
            return -1;
        }
        if (isLeap) {
            return monthModelLeap[month - 1];
        }
        return monthModelAvg[month - 1];
    }

    public static int getDateCountOfMonth(int month, int year) {
        if (month > 12 || month < 1) {
            return -1;
        }
        return ShrEmpNaturalMonthUtil.getDateCountOfMonth(month, ShrEmpNaturalMonthUtil.isLeapYear(year));
    }

    public static int getDateCountOfMonth(Date date) {
        int month = DateTimeUtils.getMonth((Date)date);
        int year = DateTimeUtils.getYear((Date)date);
        return ShrEmpNaturalMonthUtil.getDateCountOfMonth(month, year);
    }

    public static Date addNaturalMonths(Date beginDate, int month) {
        if (month == 0) {
            return beginDate;
        }
        int year1 = DateTimeUtils.getYear((Date)beginDate);
        int month1 = DateTimeUtils.getMonth((Date)beginDate);
        int date1 = DateTimeUtils.getDay((Date)beginDate);
        int year2 = year1;
        int month2 = month1 + month;
        int date2 = date1;
        if (month2 > 12) {
            year2 += month2 / 12;
            if ((month2 %= 12) == 0) {
                month2 = 12;
                --year2;
            }
        } else if (month2 < 0) {
            year2 = year2 - 1 + month2 / 12;
            month2 = 12 + month2 % 12;
        }
        boolean isLeap1 = ShrEmpNaturalMonthUtil.isLeapYear(year1);
        boolean isLeap2 = ShrEmpNaturalMonthUtil.isLeapYear(year2);
        int beginDateCount = ShrEmpNaturalMonthUtil.getDateCountOfMonth(month1, isLeap1);
        int endDateCount = ShrEmpNaturalMonthUtil.getDateCountOfMonth(month2, isLeap2);
        if (date1 == beginDateCount || date2 > endDateCount) {
            date2 = endDateCount;
        }
        return ShrEmpNaturalMonthUtil.getDate(year2, month2, date2);
    }

    public static Date getLastDateInNaturalMonths(Date beginDate, int month) {
        Date date = ShrEmpNaturalMonthUtil.addNaturalMonths(beginDate, month);
        return DateUtil.getBeforeDay((Date)date);
    }

    public static Date getDate(int year, int month, int date) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, date, 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Date getDate(int year, int month, int date, int hour, int min, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, date, hour, min, second);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Integer getProbation(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        endDate = DateUtil.getAfterDay((Date)endDate);
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int startDay = DateTimeUtils.getDay((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int endDay = DateTimeUtils.getDay((Date)endDate);
        int dateAdjustValue = endDay < startDay ? 1 : 0;
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        int maxDay = cal.getActualMaximum(5);
        if (endDay == maxDay) {
            dateAdjustValue = 0;
        }
        int probation = (endYear - startYear) * 12 + (endMonth - startMonth) - dateAdjustValue;
        return probation;
    }
}

