/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.ListUIController;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.base.EmployeeFenLeiInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountDetailInfo;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.EmpAccountManagerException;
import com.kingdee.eas.hr.benefit.EmpManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IEmpManagerFacade;
import com.kingdee.eas.hr.benefit.PayTypeEnum;
import com.kingdee.eas.hr.benefit.client.AbstractAccountManagerListUI;
import com.kingdee.eas.hr.benefit.client.AccountManagerQueryPanelUI;
import com.kingdee.eas.hr.benefit.client.EmpAccountManagerEditUI;
import com.kingdee.eas.hr.benefit.client.EmptyAccountSettleUI;
import com.kingdee.eas.hr.benefit.client.FluctuationPersonListUI;
import com.kingdee.eas.hr.benefit.client.NoBenefitPersonListUI;
import com.kingdee.eas.hr.benefit.client.UpdateAccountCurPeriodUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AccountManagerListUI
extends AbstractAccountManagerListUI {
    private static final long serialVersionUID = 1L;
    protected static final TextRender render = new TextRender();
    FilterInfo filterInfo3 = new FilterInfo();
    private EntityViewInfo entityViewInfo = null;
    private EntityViewInfo userPanelEvi = null;
    private boolean isFirstDefaultQuery = true;
    private WindowListener listenerForEditWindow1 = null;
    private CommonQueryDialog dialog = null;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (!BenefitUtils.hasInitPeriod()) {
            throw new BenefitException(BenefitException.NO_BENEFIT_PERIOD);
        }
        super.onLoad();
        this.setRenderForPayState();
        this.setUpdataButtonState();
        this.tblItem.checkParsed();
        this.tblItem.getSelectManager().setSelectMode(1);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tHelper.getDisabledTables().add(this.tblItem);
    }

    private void setRenderForPayState() throws Exception {
        this.tblItem.getColumn("payState").setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object == null) {
                    return;
                }
                int enumValue = Integer.parseInt(object.toString());
                PayTypeEnum enum0 = PayTypeEnum.getEnum(enumValue);
                render.draw(graphics, clip, enum0.toString(), cellStyle);
            }
        });
    }

    private void setUpdataButtonState() throws BOSException, EASBizException {
        IEmpManagerFacade iemf = EmpManagerFacadeFactory.getRemoteInstance();
        if (iemf.hasUpdatePeriodData()) {
            this.menuUpdate.setEnabled(false);
        } else {
            this.menuUpdate.setEnabled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnNormal.setIcon(EASResource.getIcon((String)"imgTbtn_turnin"));
        this.btnStop.setIcon(EASResource.getIcon((String)"imgTbtn_stopturnin"));
        this.btnSeal.setIcon(EASResource.getIcon((String)"imgTbtn_sealup"));
        this.menuItemNormal.setIcon(EASResource.getIcon((String)"imgTbtn_turnin"));
        this.menuItemStop.setIcon(EASResource.getIcon((String)"imgTbtn_stopturnin"));
        this.menuItemSeal.setIcon(EASResource.getIcon((String)"imgTbtn_sealup"));
        this.menuItemNoBenefit.setIcon(EASResource.getIcon((String)"imgTbtn_creat"));
        this.menuItemFlucPerson.setIcon(EASResource.getIcon((String)"imgTbtn_listfile"));
        this.btnNoBenefit.setEnabled(true);
        this.btnFlucPerson.setEnabled(true);
        this.btnNoBenefit.setIcon(EASResource.getIcon((String)"imgTbtn_creat"));
        this.btnFlucPerson.setIcon(EASResource.getIcon((String)"imgTbtn_listfile"));
        this.menuUpdate.setIcon(EASResource.getIcon((String)"tbtn_resultemend.gif"));
        this.btnNormal.setEnabled(false);
        this.btnStop.setEnabled(false);
        this.btnSeal.setEnabled(false);
        this.menuItemNoBenefit.setEnabled(true);
        this.menuItemFlucPerson.setEnabled(true);
        this.emptyAccountSettle.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.btnEmptySettle.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int topIndex = e.getSelectBlock().getTop();
        IRow iRow = this.tblMain.getRow(topIndex);
        if (iRow.getCell("id") == null) {
            return;
        }
        String accountID = iRow.getCell("id").getValue().toString();
        try {
            this.actionNormal.setEnabled(false);
            this.actionStop.setEnabled(false);
            this.actionSeal.setEnabled(false);
            this.loadTblItem(accountID);
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    protected void tblItem_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int topIndex = e.getSelectBlock().getTop();
        IRow iRow = this.tblItem.getRow(topIndex);
        if (iRow != null) {
            int payState = Integer.valueOf(iRow.getCell("payState").getValue().toString());
            this.initPayStateBtlEnable(payState);
        }
    }

    protected void initPayStateBtlEnable(int payState) {
        if (payState == 10) {
            this.actionStop.setEnabled(true);
            this.actionSeal.setEnabled(false);
            this.actionNormal.setEnabled(false);
        }
        if (payState == 20) {
            this.actionStop.setEnabled(false);
            this.actionSeal.setEnabled(true);
            this.actionNormal.setEnabled(true);
        }
        if (payState == 30) {
            this.actionStop.setEnabled(false);
            this.actionSeal.setEnabled(false);
            this.actionNormal.setEnabled(true);
        }
    }

    protected void loadTblItem(String accountID) throws BOSException, EASBizException {
        HashSet accSet = BenefitUtils.getAccountType();
        if (accSet != null && accSet.size() <= 0) {
            return;
        }
        EntityViewInfo view1 = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)accountID));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)accSet, CompareType.INCLUDE));
        filter.setMaskString("#0 and #1 and #2");
        view1.setFilter(filter);
        this.accountDetailQuery = view1;
        this.tblItem.removeRows();
        if (this.tblItem.getRowCount() > 0) {
            this.actionAddNew.setEnabled(false);
            this.tblItem.getSelectManager().select(0, 0);
        } else {
            this.actionAddNew.setEnabled(true);
        }
    }

    protected void initTree() throws Exception {
        DefaultKingdeeTreeNode root = HRTreeUtil.createEmployeeFenLeiTreeNode((boolean)true);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.treeMain.setModel((TreeModel)model);
        this.treeMain.setSelectionNode(root);
    }

    public void loadFilterUI() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = AccountManagerListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        this.isPerformDefaultQuery(iQuery, queryName);
        AccountManagerQueryPanelUI filterUI = new AccountManagerQueryPanelUI();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName);
            CustomerParams cp = null;
            if (solution.getQueryPanelInfo().get(0) != null) {
                cp = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
            }
            if (solution.getQueryPanelInfo().get(1) != null && cp == null) {
                cp = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(1).getCustomerParams());
            }
            if (cp != null) {
                filterUI.setCustomerParams(cp);
                this.filterInfo3 = filterUI.getFilter();
                this.userPanelEvi = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                this.setEntityViewInfo();
                boolean cpNull = cp.getBoolean("null");
                if (cpNull) {
                    this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.benefit.app", "NoAccountPersonQuery");
                }
                this.mainQuery = this.entityViewInfo;
                this.tblMain.removeRows();
                if (cpNull) {
                    this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.benefit.app", "AccountPersonQuery");
                }
            } else {
                this.showQueryDialog();
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showQueryDialog();
        }
    }

    public void showQueryDialog() throws Exception {
        AccountManagerQueryPanelUI filterUI = new AccountManagerQueryPanelUI();
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setWidth(400);
            this.dialog.setHeight(350);
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(false);
            this.dialog.setQueryObjectPK(this.mainQueryPK);
            this.dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.ACCMANAGER_FILTER_TITLE"));
            this.dialog.addUserPanel((KDPanel)filterUI);
        }
        if (this.dialog.show()) {
            this.filterInfo3 = ((AccountManagerQueryPanelUI)this.dialog.getUserPanel(0)).getFilter();
            this.userPanelEvi = this.dialog.getEntityViewInfoResult();
            this.setEntityViewInfo();
            this.mainQuery = this.entityViewInfo;
            this.doQuery(this.dialog);
            this.tblMain.removeRows();
            this.refreshList();
            this.tHelper.setDialog(this.dialog);
        } else {
            this.tHelper.setDialog(this.dialog);
            SysUtil.abort();
        }
    }

    private void setEntityViewInfo() throws BOSException {
        this.entityViewInfo = new EntityViewInfo();
        FilterInfo filter = this.filterInfo3;
        filter.mergeFilter(this.getHRAndUserAdminFilter(), "AND");
        if (this.userPanelEvi != null && FilterUtility.hasFilterItem((FilterInfo)this.userPanelEvi.getFilter())) {
            filter.mergeFilter(this.userPanelEvi.getFilter(), "and");
        }
        this.entityViewInfo.setFilter(filter);
    }

    protected FilterInfo getHRAndUserAdminFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("adminToUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminUser.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        return filterInfo;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.entityViewInfo == null) {
            return;
        }
        EntityViewInfo view1 = (EntityViewInfo)this.entityViewInfo.clone();
        if (view1 != null && FilterUtility.hasFilterItem((FilterInfo)view1.getFilter())) {
            view1.getFilter().mergeFilter(this.setPerTypeAllFilter(), "AND");
        }
        this.mainQuery = view1;
        this.tblMain.removeRows();
        this.accountDetailQuery = null;
        this.tblItem.removeRows();
        if (this.tblMain.getRowCount3() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        } else {
            int size = this.tblItem.getRowCount3();
            for (int i = 0; i < size; ++i) {
                this.tblItem.removeRow(i);
            }
        }
    }

    private FilterInfo setPerTypeAllFilter() throws BOSException {
        FilterInfo filter = new FilterInfo();
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (selectNode.getUserObject() instanceof EmployeeTypeInfo) {
                EmployeeTypeInfo selectInfo = (EmployeeTypeInfo)selectNode.getUserObject();
                filter.getFilterItems().add(new FilterItemInfo("et.id", (Object)selectInfo.getId().toString()));
                filter.setMaskString("#0");
            } else if (selectNode.getUserObject() instanceof EmployeeFenLeiInfo) {
                EmployeeFenLeiInfo etFenLeiInfo = (EmployeeFenLeiInfo)selectNode.getUserObject();
                String longNumber = etFenLeiInfo.getLongNumber();
                filter.getFilterItems().add(new FilterItemInfo("etFenLei.longNumber", (Object)longNumber));
                filter.getFilterItems().add(new FilterItemInfo("etFenLei.longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                filter.setMaskString("(#0 or #1)");
            }
        }
        return filter;
    }

    public void actionNormal_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new AccountDetailInfo().getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.ACCOUNTDATA"), (String)"AccountManager_normal");
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblItem);
        if (index != -1) {
            IRow row = this.tblItem.getRow(index);
            String aID = row.getCell("id").getValue().toString();
            ((IAccountDetail)this.getBizInterface()).makeNormal(aID);
        }
        this.tblItem.refresh();
        this.tblItem.getSelectManager().select(0, 0);
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    public void actionSeal_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new AccountDetailInfo().getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.ACCOUNTDATA"), (String)"AccountManager_seal");
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblItem);
        if (index != -1) {
            IRow row = this.tblItem.getRow(index);
            String aID = row.getCell("id").getValue().toString();
            ((IAccountDetail)this.getBizInterface()).makeSeal(aID);
        }
        this.tblItem.refresh();
        this.tblItem.getSelectManager().select(0, 0);
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    public void actionStop_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new AccountDetailInfo().getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.ACCOUNTDATA"), (String)"AccountManager_stop");
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblItem);
        if (index != -1 && BenefitUtils.confirmStopBiz()) {
            IRow row = this.tblItem.getRow(index);
            String aID = row.getCell("id").getValue().toString();
            ((IAccountDetail)this.getBizInterface()).makeStop(aID);
            BenefitUtils.cleanBenefitData(null, aID);
        }
        this.tblItem.refresh();
        this.tblItem.getSelectManager().select(0, 0);
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        IEmpManagerFacade iemf = EmpManagerFacadeFactory.getRemoteInstance();
        if (!iemf.hasUpdatePeriodData()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.PersonInBenefitResource.PLEASE_UPDATE_DATA"));
            return;
        }
        if (StringUtils.isEmpty((String)this.getSelectedKeyValue())) {
            throw new EmpAccountManagerException(EmpAccountManagerException.PERSON_NOT_NULL);
        }
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        this.getUIContext().putAll(uiContext);
        IUIWindow uiWindow = null;
        ((ListUIController)super.getUIController()).actionAddNew();
        uiWindow = ((ListUIController)super.getUIController()).getNavigator().getUIWindow();
        this.isDoRefresh1(uiWindow);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        IEmpManagerFacade iemf = EmpManagerFacadeFactory.getRemoteInstance();
        if (!iemf.hasUpdatePeriodData()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.PersonInBenefitResource.PLEASE_UPDATE_DATA"));
            return;
        }
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"parent", (Object)this);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.isDoRefresh1(uiWindow);
    }

    protected void isDoRefresh1(IUIWindow uiWindow) {
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        this.listenerForEditWindow1 = new WindowAdapter(){

            public void windowClosed(WindowEvent event) {
                try {
                    if (SysContext.getSysContext().getSessionID() != null) {
                        ActionEvent actionEvent1 = new ActionEvent(AccountManagerListUI.this.btnRefresh, 1001, AccountManagerListUI.this.btnRefresh.getActionCommand());
                        AccountManagerListUI.this.refresh(actionEvent1);
                    }
                }
                catch (Exception e) {
                    AccountManagerListUI.this.handleException(e);
                }
            }
        };
        window.addWindowListener(this.listenerForEditWindow1);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.mainQuery = this.entityViewInfo;
        this.tblMain.removeRows();
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
        if (this.tblMain.getRowCount3() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        } else {
            int size = this.tblItem.getRowCount3();
            for (int i = 0; i < size; ++i) {
                this.tblItem.removeRow(i);
            }
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.chkDisplayName.setSelected(false);
        this.loadFilterUI();
        if (this.tblMain.getRowCount3() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        } else {
            int size = this.tblItem.getRowCount3();
            for (int i = size - 1; i >= 0; --i) {
                this.tblItem.removeRow(i);
            }
        }
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountDetailFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return EmpAccountManagerEditUI.class.getName();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
    }

    public void actionNoBenefit_actionPerformed(ActionEvent e) throws Exception {
        super.actionNoBenefit_actionPerformed(e);
        UIContext uiCtx = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(NoBenefitPersonListUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionDisplayName_actionPerformed(ActionEvent e) throws Exception {
        this.displayAllName();
    }

    private void displayAllName() {
        boolean isSelected = this.chkDisplayName.isSelected();
        if (isSelected) {
            IRow row = null;
            int size = this.tblMain.getRowCount3();
            for (int i = 0; i < size; ++i) {
                row = this.tblMain.getRow(i);
                if (row == null) continue;
                row.getCell("adminOrgUnit").setValue(row.getCell("admin.displayName").getValue());
            }
        } else {
            IRow row = null;
            int size = this.tblMain.getRowCount3();
            for (int i = 0; i < size; ++i) {
                row = this.tblMain.getRow(i);
                if (row == null) continue;
                row.getCell("adminOrgUnit").setValue(row.getCell("admin.name").getValue());
            }
        }
    }

    public void actionFlucPerson_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curUI = uiFactory.create(FluctuationPersonListUI.class.getName(), (Map)uiContext);
            curUI.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
    }

    public void actionUpdateCurPeriod_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UpdateAccountCurPeriodUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        String hasUpdate = (String)uiWindow.getUIObject().getUIContext().get("hasUpdate");
        if (hasUpdate != null && hasUpdate.equals("yes")) {
            this.menuUpdate.setEnabled(false);
        }
    }

    public void actionEmptyAccountSettle_actionPerformed(ActionEvent e) throws Exception {
        int index;
        this.checkSelected();
        if (this.tblItem.getRowCount() == 0 || this.tblItem.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.EmptyAccountSettle"));
            SysUtil.abort();
        }
        if ((index = KDTableUtil.getSelectedRow((KDTable)this.tblItem)) != -1) {
            IRow row = this.tblItem.getRow(index);
            String aID = row.getCell("id").getValue().toString();
            AccountDetailInfo detailInfo = AccountDetailFactory.getRemoteInstance().getAccountDetailInfo((IObjectPK)new ObjectUuidPK(aID));
            if (10 != detailInfo.getPayState().getValue()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.CANNOTSETTLE"));
                SysUtil.abort();
            }
            CmpPeriodInfo periodInfo = CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(detailInfo.getCurPeriod().getId().toString()));
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"id", (Object)this.getSelectedKeyValue());
            uiContext.put((Object)"accountDetailID", (Object)aID);
            uiContext.put((Object)"accountID", (Object)detailInfo.getAccount().getId().toString());
            uiContext.put((Object)"accountTypeID", (Object)detailInfo.getAccountType().getId().toString());
            CmpPeriodInfo nextPeriodInfo = AccountManagerListUI.getCmpPeriodInfoForConstant(periodInfo, 1);
            CmpPeriodInfo beforePeriodInfo = AccountManagerListUI.getCmpPeriodInfoForConstant(periodInfo, -1);
            uiContext.put((Object)"curPeriodInfo", (Object)periodInfo);
            uiContext.put((Object)"nextPeriodInfo", (Object)nextPeriodInfo);
            uiContext.put((Object)"beforePeriodInfo", (Object)beforePeriodInfo);
            IUIWindow personUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.benefit.client.EmptyAccountSettleUI", (Map)uiContext, null, OprtState.VIEW);
            personUI.show();
            if (((EmptyAccountSettleUI)personUI.getUIObject()).getRefresh()) {
                this.refresh(e);
            }
        }
    }

    private static CmpPeriodInfo getCmpPeriodInfoForConstant(CmpPeriodInfo currCmpPeriod, int constant) throws BOSException {
        if (constant == 0) {
            return currCmpPeriod;
        }
        ICmpPeriod iCmpPeriod = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String hrOrgUnitID = null;
        iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
        hrOrgUnitID = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
        if (currCmpPeriod.getHrOrgUnit() != null) {
            hrOrgUnitID = currCmpPeriod.getHrOrgUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitID));
        entityViewInfo.setFilter(filter);
        SorterItemInfo sortInfo = new SorterItemInfo("begindate");
        sortInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sortInfo);
        CmpPeriodCollection cmpPeriodColl = iCmpPeriod.getCmpPeriodCollection(entityViewInfo);
        if (cmpPeriodColl == null || cmpPeriodColl.size() <= 1) {
            return null;
        }
        String id = currCmpPeriod.getId().toString();
        String temp = null;
        int size = cmpPeriodColl.size();
        for (int i = 0; i < size; ++i) {
            temp = cmpPeriodColl.get(i).getId().toString();
            if (!temp.equals(id)) continue;
            if (constant > 0) {
                if (size > constant + i) {
                    return cmpPeriodColl.get(constant + i);
                }
                return null;
            }
            if (constant < 0) {
                if (i >= -constant) {
                    return cmpPeriodColl.get(i + constant);
                }
                return null;
            }
            return cmpPeriodColl.get(i);
        }
        return null;
    }

    public static class EmpInServiceType {
        private String _name;
        private int _type;

        public EmpInServiceType(String name, int type) {
            this._name = name;
            this._type = type;
        }

        public String getName() {
            return this._name;
        }

        public int getType() {
            return this._type;
        }

        public String toString() {
            return this.getName();
        }
    }

    static class IDLock {
        boolean b = false;

        IDLock(boolean b) {
            this.b = b;
        }

        public synchronized void setLock(boolean b) {
            this.b = b;
        }

        public synchronized boolean isLock() {
            return this.b;
        }
    }
}

