/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitCollection;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.BenefitPropEnum;
import com.kingdee.eas.hr.benefit.BenefitRuleFacadeFactory;
import com.kingdee.eas.hr.benefit.IAccountType;
import com.kingdee.eas.hr.benefit.IBenefitRuleFacade;
import com.kingdee.eas.hr.benefit.client.AbstractAccountTypeListUI;
import com.kingdee.eas.hr.benefit.client.AccountTypeEditUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AccountTypeListUI
extends AbstractAccountTypeListUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountTypeListUI.class);

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionQuery.setVisible(false);
        this.menuItemQuery.setVisible(false);
        this.menuItemImportData.setVisible(false);
    }

    public void onLoad() throws Exception {
        this.handlePermissionForItemAction((ItemAction)this.actionOnLoad);
        if (!BenefitUtils.hasInitPeriod()) {
            throw new BenefitException(BenefitException.NO_BENEFIT_PERIOD);
        }
        this.addHROrgUtil();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.initWorkButton();
        this.enableExportExcel(this.tblMain);
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        super.onLoad();
        this.refresh(null);
    }

    private void addHROrgUtil() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filterInfo);
        this.mainQuery = viewInfo;
    }

    private void loadDataForTable() throws BOSException, SQLException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        iQe.setObjectView(viewInfo);
        IRowSet iRowSet = iQe.executeQuery();
        iQe.option().isAutoTranslateEnum = true;
        IRow iRow = null;
        while (iRowSet.next()) {
            iRow = this.tblMain.addRow();
            iRow.getCell("id").setValue((Object)iRowSet.getString("id"));
            iRow.getCell("number").setValue((Object)iRowSet.getString("number"));
            iRow.getCell("name").setValue((Object)iRowSet.getString("name"));
            iRow.getCell("isInner").setValue(iRowSet.getObject("isInner"));
        }
    }

    private void loadBenefitColl() throws EASBizException, BOSException {
        IRow iRow = null;
        ArrayList<String> list = new ArrayList<String>();
        IBenefitRuleFacade iBenefitRuleFacade = BenefitRuleFacadeFactory.getRemoteInstance();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblMain.getRow(i);
            list.add(iRow.getCell("id").getValue().toString());
        }
        HashMap map = (HashMap)iBenefitRuleFacade.getBenefitCollFromColl(list);
        String atID = null;
        BenefitCollection coll = null;
        BenefitInfo info = null;
        StringBuffer bName = null;
        int size2 = this.tblMain.getRowCount();
        for (int i = 0; i < size2; ++i) {
            bName = new StringBuffer();
            iRow = this.tblMain.getRow(i);
            atID = iRow.getCell("id").getValue().toString();
            coll = (BenefitCollection)((Object)map.get(atID));
            int count = coll.size();
            for (int j = 0; j < count; ++j) {
                info = coll.get(j);
                bName.append(info.getName() + " ");
            }
            iRow.getCell("containBene").setValue((Object)bName.toString());
        }
    }

    private void initTblMainColWidth() {
        int size = this.tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            this.tblMain.getColumn(i).setWidth(200);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        IRow iRow = null;
        int selectIndex = e.getSelectBlock().getTop();
        iRow = this.tblMain.getRow(selectIndex);
        IAccountType iat = AccountTypeFactory.getRemoteInstance();
        boolean hasUsed = iat.accountTypehasUsed(iRow.getCell("id").getValue().toString());
        if (iRow.getCell("isInner").getValue() instanceof String) {
            if (!BenefitPropEnum.UNINNER.getAlias().equals(iRow.getCell("isInner").getValue().toString()) || hasUsed) {
                this.actionRemove.setEnabled(false);
            } else {
                this.actionRemove.setEnabled(true);
            }
        }
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            return;
        }
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionAddNew);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionEdit);
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionRemove);
        super.actionRemove_actionPerformed(e);
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        this.initTblMainColWidth();
        this.loadBenefitColl();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }

    protected String getEditUIName() {
        return AccountTypeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountTypeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        AccountTypeInfo objectValue = new AccountTypeInfo();
        return objectValue;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.WELFARE;
    }
}

