/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.client.AbstractAvgPayCalResultUI;
import com.kingdee.eas.hr.compensation.CmpCommonFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpCommonFacade;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AvgPayCalResultUI
extends AbstractAvgPayCalResultUI {
    private static final Logger logger = CoreUIObject.getLogger(AvgPayCalResultUI.class);
    public HashMap resultMap = new HashMap();

    public void onLoad() throws Exception {
        this.initUI();
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    private void initUI() throws EASBizException, BOSException, SQLException {
        CmpPeriodInfo start = (CmpPeriodInfo)this.getUIContext().get("startCmpPeriod");
        CmpPeriodInfo end = (CmpPeriodInfo)this.getUIContext().get("endCmpPeriod");
        this.txtStartCmpPeriod.setText(start.getNumber());
        this.txtEndCmpPeriod.setText(end.getNumber());
        CmpItemCollection cmpItemColl = (CmpItemCollection)this.getUIContext().get("cmpItemColl");
        StringBuffer collNameArr = new StringBuffer();
        int size = cmpItemColl.size();
        for (int i = 0; i < size; ++i) {
            collNameArr.append(cmpItemColl.get(i).getName()).append(" ");
        }
        this.txtCmpName.setText(collNameArr.toString());
        ICmpCommonFacade iCmpCommonFacade = CmpCommonFacadeFactory.getRemoteInstance();
        CmpPeriodCollection coll = iCmpCommonFacade.getCmpPeriodColl(start.getBeginDate(), end.getEndDate());
        this.txtCmpPeriods.setText(String.valueOf(coll.size()));
        this.addCol(coll);
        this.addColName(coll);
        if (this.getUIContext().get("resultRows") instanceof IRowSet) {
            this.loadResultData(cmpItemColl);
        } else if (this.getUIContext().get("resultRows") instanceof List) {
            this.loadResultDataForCol(cmpItemColl);
        }
    }

    private void addCol(CmpPeriodCollection coll) {
        this.tblMain.checkParsed();
        this.tblMain.setEnabled(false);
        IColumn col = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            col = this.tblMain.addColumn();
            col.setKey(coll.get(i).getId().toString());
            col.getStyleAttributes().setNumberFormat("0.00");
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        col = this.tblMain.addColumn();
        col.setKey("total");
        col.getStyleAttributes().setNumberFormat("0.00");
        col = this.tblMain.addColumn();
        col.setKey("avg");
        col.getStyleAttributes().setNumberFormat("0.00");
    }

    private void addColName(CmpPeriodCollection coll) {
        this.tblMain.checkParsed();
        IRow iRow = this.tblMain.getHeadRow(0);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            iRow.getCell(coll.get(i).getId().toString()).setValue((Object)coll.get(i).getName());
        }
        iRow.getCell("total").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.TOTAL"));
        iRow.getCell("avg").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.AVG"));
    }

    private void loadResultDataForCol(CmpItemCollection cmpItemColl) throws SQLException, EASBizException, BOSException {
        List list = (List)this.getUIContext().get("resultRows");
        IRow iRow = null;
        IRowSet rows = null;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal total = new BigDecimal(0);
        int kk = list.size();
        for (int k = 0; k < kk; ++k) {
            rows = (IRowSet)list.get(k);
            if (rows == null) continue;
            while (rows.next()) {
                BigDecimal scattered = null;
                for (int i = 1; i <= cmpItemColl.size(); ++i) {
                    scattered = rows.getBigDecimal(i);
                    total = total.add(scattered);
                }
                map.put(rows.getString("fpersonid") + "&&" + rows.getString("fperiod"), total);
            }
        }
        String key = null;
        String[] strArr = null;
        PersonInfo perInfo = null;
        Iterator iter = map.entrySet().iterator();
        Map.Entry entry = null;
        while (iter.hasNext()) {
            entry = iter.next();
            key = (String)entry.getKey();
            strArr = StringUtils.split((String)key, (String)"&&");
            if (this.tblMain.getRowCount() == 0) {
                iRow = this.tblMain.addRow();
            } else {
                int i = this.tblMain.getRowCount();
                IRow iRow1 = this.tblMain.getRow(i - 1);
                if (!iRow1.getCell("id").getValue().toString().equals(strArr[0])) {
                    iRow = this.tblMain.addRow();
                }
            }
            perInfo = CompUtils.getPersonInfo((String)strArr[0]);
            if (perInfo != null) {
                iRow.getCell("number").setValue((Object)perInfo.getNumber());
                iRow.getCell("name").setValue((Object)perInfo.getName());
            }
            iRow.getCell("id").setValue((Object)strArr[0]);
            iRow.getCell(strArr[1]).setValue(entry.getValue());
        }
        IRow iRow2 = null;
        int sum = this.tblMain.getRowCount();
        for (int j = 0; j < sum; ++j) {
            iRow2 = this.tblMain.getRow(j);
            BigDecimal tempTotal = new BigDecimal(0);
            int ss = this.tblMain.getColumnCount();
            for (int k = 3; k < ss; ++k) {
                if (this.tblMain.getCell(j, k).getValue() == null) continue;
                tempTotal = tempTotal.add((BigDecimal)this.tblMain.getCell(j, k).getValue());
            }
            iRow2.getCell("total").setValue((Object)tempTotal);
            iRow2.getCell("avg").setValue((Object)tempTotal.divide(new BigDecimal(this.txtCmpPeriods.getText()), 2));
            this.resultMap.put(iRow2.getCell("id").getValue().toString(), iRow2.getCell("avg").getValue().toString());
        }
    }

    private void loadResultData(CmpItemCollection cmpItemColl) throws SQLException, EASBizException, BOSException {
        IRowSet rows = (IRowSet)this.getUIContext().get("resultRows");
        IRow iRow = null;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal total = new BigDecimal(0);
        while (rows.next()) {
            BigDecimal scattered = null;
            for (int i = 1; i <= cmpItemColl.size(); ++i) {
                scattered = rows.getBigDecimal(i);
                if (scattered == null) continue;
                total = total.add(scattered);
            }
            map.put(rows.getString("fpersonid") + "&&" + rows.getString("fperiod"), total);
            total = new BigDecimal(0);
        }
        HashMap<String, String> perTempMap = new HashMap<String, String>();
        String key2 = null;
        String[] strArr = null;
        PersonInfo perInfo = null;
        for (String key2 : map.keySet()) {
            strArr = StringUtils.split((String)key2, (String)"&&");
            if (this.tblMain.getRowCount() == 0) {
                iRow = this.tblMain.addRow();
                iRow.getCell("id").setValue((Object)strArr[0]);
                perInfo = CompUtils.getPersonInfo((String)strArr[0]);
                if (perInfo != null) {
                    iRow.getCell("number").setValue((Object)perInfo.getNumber());
                    iRow.getCell("name").setValue((Object)perInfo.getName());
                }
            } else if (perTempMap.get(strArr[0]) == null) {
                iRow = this.tblMain.addRow();
                iRow.getCell("id").setValue((Object)strArr[0]);
                perInfo = CompUtils.getPersonInfo((String)strArr[0]);
                if (perInfo != null) {
                    iRow.getCell("number").setValue((Object)perInfo.getNumber());
                    iRow.getCell("name").setValue((Object)perInfo.getName());
                }
            }
            perTempMap.put(strArr[0], "person");
        }
        IRow iRow3 = null;
        IColumn iCol = null;
        int sum = this.tblMain.getRowCount();
        for (int j = 0; j < sum; ++j) {
            iRow3 = this.tblMain.getRow(j);
            int ss = this.tblMain.getColumnCount();
            for (int k = 3; k < ss; ++k) {
                iCol = this.tblMain.getColumn(k);
                iRow3.getCell(iCol.getKey()).setValue(map.get(iRow3.getCell("id").getValue().toString() + "&&" + iCol.getKey()));
            }
        }
        IRow iRow2 = null;
        int sum2 = this.tblMain.getRowCount();
        for (int j = 0; j < sum2; ++j) {
            iRow2 = this.tblMain.getRow(j);
            BigDecimal tempTotal = new BigDecimal(0);
            int ss = this.tblMain.getColumnCount();
            for (int k = 3; k < ss; ++k) {
                if (this.tblMain.getCell(j, k).getValue() == null) continue;
                tempTotal = tempTotal.add((BigDecimal)this.tblMain.getCell(j, k).getValue());
            }
            iRow2.getCell("total").setValue((Object)tempTotal);
            iRow2.getCell("avg").setValue((Object)tempTotal.divide(new BigDecimal(this.txtCmpPeriods.getText()), 2));
            this.resultMap.put(iRow2.getCell("id").getValue().toString(), iRow2.getCell("avg").getValue().toString());
        }
    }
}

