/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitCollection;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.OperateTypeEnum;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitAdjustDataFilterUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;

public class BenefitAdjustDataFilterUI
extends AbstractBenefitAdjustDataFilterUI {
    private static final long serialVersionUID = 1L;
    private BenefitCollection coll = null;

    public BenefitAdjustDataFilterUI() throws Exception {
        this.loadOprtState();
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtBegin.setEnabled(false);
        this.prmtEnd.setEnabled(false);
        this.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.SEARCH"));
    }

    private void loadOprtState() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        Iterator iter = OperateTypeEnum.iterator();
        while (iter.hasNext()) {
            model.addElement(iter.next());
        }
        this.comboOperateType.setModel(model);
    }

    protected void promptOrg_stateChanged(ChangeEvent e) throws Exception {
        super.promptOrg_stateChanged(e);
    }

    protected void chkIncludeSubOrg_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIncludeSubOrg_itemStateChanged(e);
    }

    protected void prmtCurPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.prmtBegin.setData(null);
        this.prmtEnd.setData(null);
        if (this.prmtCurPeriod.getData() == null) {
            this.prmtBegin.setEnabled(false);
            this.prmtEnd.setEnabled(false);
        } else {
            CmpPeriodInfo curPeriodInfo = (CmpPeriodInfo)this.prmtCurPeriod.getData();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)curPeriodInfo.getBeginDate(), CompareType.LESS));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            this.setSelector(evi, this.prmtBegin);
            this.setSelector(evi, this.prmtEnd);
            this.prmtBegin.setEnabled(true);
            this.prmtEnd.setEnabled(true);
        }
    }

    private void setSelector(EntityViewInfo evi, KDBizPromptBox prmt) {
        prmt.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        prmt.setDisplayFormat("$number$");
        prmt.setEditFormat("$number$");
        prmt.setCommitFormat("$number$");
        prmt.setEntityViewInfo(evi);
        prmt.setEditable(true);
    }

    protected void comboAccountType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboAccountType_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            AccountTypeInfo info = (AccountTypeInfo)e.getItem();
            this.repaintBenefitItems(info);
        }
    }

    private void repaintBenefitItems(AccountTypeInfo info) throws Exception {
        String id = info.getId().toString();
        this.coll = BenefitUtils.getBenefitColl(id);
        this.initPanelBenefitItem(this.coll);
        this.panelBenefitItem2.repaint();
        this.updateUI();
    }

    private void initPanelBenefitItem(BenefitCollection coll) {
        String name = null;
        KDCheckBox cb = null;
        this.panelBenefitItem2.removeAll();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            name = coll.get(i).getName().toString();
            cb = new KDCheckBox();
            cb.setBounds(new Rectangle(13, 14 + i * 22, 140, 19));
            cb.setText(name);
            cb.setUserObject((Object)coll.get(i));
            this.panelBenefitItem2.add((Component)cb);
        }
        this.panelBenefitItem2.setPreferredSize(new Dimension(120, 28 * coll.size()));
    }

    private ArrayList getBenefitList() {
        ArrayList<BenefitInfo> list = new ArrayList<BenefitInfo>();
        int count = this.panelBenefitItem2.getComponentCount();
        Component c = null;
        KDCheckBox cb = null;
        BenefitInfo info = null;
        for (int i = 0; i < count; ++i) {
            c = this.panelBenefitItem2.getComponent(i);
            if (!(c instanceof KDCheckBox) || !(cb = (KDCheckBox)c).isSelected()) continue;
            info = (BenefitInfo)cb.getUserObject();
            list.add(info);
        }
        return list;
    }

    private void setBenefitByList(ArrayList list) {
        int listCount = list.size();
        int itemCount = this.panelBenefitItem2.getComponentCount();
        Component c = null;
        KDCheckBox cb = null;
        if (super.isFirstAccType()) {
            AccountTypeInfo info = (AccountTypeInfo)this.comboAccountType.getSelectedItem();
            try {
                this.repaintBenefitItems(info);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        block2: for (int i = 0; i < listCount; ++i) {
            BenefitInfo listInfo = (BenefitInfo)list.get(i);
            for (int j = 0; j < itemCount; ++j) {
                BenefitInfo itemInfo;
                c = this.panelBenefitItem2.getComponent(j);
                if (!(c instanceof KDCheckBox) || !(itemInfo = (BenefitInfo)(cb = (KDCheckBox)c).getUserObject()).getId().toString().equals(listInfo.getId().toString())) continue;
                cb.setSelected(true);
                continue block2;
            }
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        String benefitList = CommonQueryUtil.getStringFromList(this.getBenefitList());
        cp.addCustomerParam("benefitList", benefitList);
        cp.putInt("operateType", ((OperateTypeEnum)((Object)this.comboOperateType.getSelectedItem())).getValue());
        if (this.prmtBegin.getData() != null && this.prmtEnd.getData() != null) {
            CommonQueryUtil.getCmpFromQueryPanel("begin", cp, this.prmtBegin);
            CommonQueryUtil.getCmpFromQueryPanel("end", cp, this.prmtEnd);
        } else if (this.prmtBegin.getData() != null) {
            CommonQueryUtil.getCmpFromQueryPanel("begin", cp, this.prmtBegin);
            CommonQueryUtil.getCmpFromQueryPanel("end", cp, this.prmtBegin);
        } else if (this.prmtEnd.getData() != null) {
            CommonQueryUtil.getCmpFromQueryPanel("begin", cp, this.prmtEnd);
            CommonQueryUtil.getCmpFromQueryPanel("end", cp, this.prmtEnd);
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        try {
            this.repaintBenefitItems((AccountTypeInfo)this.comboAccountType.getSelectedItem());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        ArrayList list = this.getSelBenefits(cp);
        this.setBenefitByList(list);
        int type = cp.getInt("operateType");
        OperateTypeEnum oprtEnum = OperateTypeEnum.getEnum(type);
        int count = this.comboOperateType.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (((OperateTypeEnum)((Object)this.comboOperateType.getItemAt(i))).getValue() != oprtEnum.getValue()) continue;
            this.comboOperateType.setSelectedIndex(i);
            break;
        }
        CommonQueryUtil.setCmpFromQueryPanel("begin", "end", cp, this.prmtBegin, this.prmtEnd);
    }

    private ArrayList getSelBenefits(CustomerParams cp) {
        String selBenefitListStr = cp.getCustomerParam("benefitList");
        ArrayList<BenefitInfo> list = new ArrayList<BenefitInfo>();
        if (null != selBenefitListStr && null != this.coll) {
            String[] selBenefitListArr = selBenefitListStr.split(",");
            for (int i = 0; i < selBenefitListArr.length; ++i) {
                int size = this.coll.size();
                for (int j = 0; j < size; ++j) {
                    if (null == this.coll.get(j) || !selBenefitListArr[i].equals(this.coll.get(j).getId().toString())) continue;
                    list.add(this.coll.get(j));
                }
            }
        }
        return list;
    }

    public void clear() {
        super.clear();
        if (this.comboAccountType.getSelectedItem() != null) {
            try {
                this.repaintBenefitItems((AccountTypeInfo)this.comboAccountType.getSelectedItem());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.comboOperateType.getItemCount() > 0) {
            this.comboAccountType.setSelectedIndex(0);
        }
        this.prmtBegin.setData(null);
        this.prmtEnd.setData(null);
    }

    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        if (this.getBenefitList().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFITITEM_NOTNULL"));
            return false;
        }
        if (this.prmtBegin.getData() != null && this.prmtEnd.getData() != null) {
            Date dtBegin = ((CmpPeriodInfo)this.prmtBegin.getData()).getEndDate();
            Date dtEnd = ((CmpPeriodInfo)this.prmtEnd.getData()).getEndDate();
            if (DateTimeUtils.dayBefore((Date)dtEnd, (Date)dtBegin)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"35_BenefitAdjustDataFilterUI"));
                return false;
            }
        }
        return true;
    }
}

