/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitInvokeFacadeFactory;
import com.kingdee.eas.hr.benefit.IAccountType;
import com.kingdee.eas.hr.benefit.IBenefitInvokeFacade;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitCaculateUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;

public class BenefitCaculateUI
extends AbstractBenefitCaculateUI {
    private static final long serialVersionUID = 1L;
    private static final String ZERO_STR = "0";
    private List personList = null;
    private int calCount = 0;
    private String accountType = null;
    private String curPeriod = null;
    private String adminOrg = null;
    private boolean includeSubOrg = false;
    private boolean isCancel = false;
    private boolean isSubmit = false;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected String getMessageText() {
        return EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.MESSAGE_BENEFIT_CALCU") + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.MESSAGE_SUCCESS");
    }

    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.btnSubmit_actionPerformed(e);
        this.getUIWindow().close();
        this.isSubmit = true;
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
        this.isCancel = true;
    }

    public boolean getIsCancel() {
        return this.isCancel;
    }

    public boolean getIsSubmit() {
        return this.isSubmit;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (!BenefitUtils.hasInitPeriod()) {
            throw new BenefitException(BenefitException.NO_BENEFIT_PERIOD);
        }
        this.accountType = (String)this.getUIContext().get("accountType");
        this.curPeriod = (String)this.getUIContext().get("curPeriod");
        this.adminOrg = (String)this.getUIContext().get("adminOrg");
        this.includeSubOrg = (Boolean)this.getUIContext().get("includeSubOrg");
        this.personList = (List)this.getUIContext().get("personList");
        IBenefitInvokeFacade ibnf = BenefitInvokeFacadeFactory.getRemoteInstance();
        this.setCurCalCount(ibnf);
        this.setAccountInfo(ibnf);
        this.setTxtValue();
    }

    private void setTxtValue() throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)this.accountType)) {
            IAccountType iat = AccountTypeFactory.getRemoteInstance();
            AccountTypeInfo atInfo = iat.getAccountTypeInfo((IObjectPK)new ObjectStringPK(this.accountType));
            this.txtAccountType.setText(atInfo.getName());
            this.txtAccountType.setEnabled(false);
        }
        if (!StringUtils.isEmpty((String)this.curPeriod)) {
            ICmpPeriod icp = CmpPeriodFactory.getRemoteInstance();
            CmpPeriodInfo cpInfo = icp.getCmpPeriodInfo((IObjectPK)new ObjectStringPK(this.curPeriod));
            this.txtPeriod.setText(cpInfo.getNumber());
        }
    }

    private void setCurCalCount(IBenefitInvokeFacade ibnf) {
        try {
            this.calCount = ibnf.getCurCalAccountCount(this.personList, this.accountType);
            this.txtSelected.setText(String.valueOf(this.calCount));
        }
        catch (Exception e) {
            if (e.getCause() instanceof BenefitException) {
                MsgBox.showError((Component)((Object)this), (String)e.getCause().getMessage());
                SysUtil.abort();
            }
            this.handleException(e);
        }
    }

    private void setAccountInfo(IBenefitInvokeFacade ibnf) {
        try {
            HashMap map = ibnf.getAccountInfos(this.accountType, this.curPeriod, this.adminOrg, this.includeSubOrg);
            if (map.get("COUNT_ACCOUNT_TOTAL") != null) {
                this.txtAccTotal.setText(((Integer)map.get("COUNT_ACCOUNT_TOTAL")).toString());
            } else {
                this.txtAccTotal.setText(ZERO_STR);
            }
            if (map.get("COUNT_ACCOUNT_STOP") != null) {
                this.txtAccStop.setText(((Integer)map.get("COUNT_ACCOUNT_STOP")).toString());
            } else {
                this.txtAccStop.setText(ZERO_STR);
            }
            if (map.get("COUNT_ACCOUNT_NORMAL") != null) {
                this.txtAccNormal.setText(((Integer)map.get("COUNT_ACCOUNT_NORMAL")).toString());
            } else {
                this.txtAccNormal.setText(ZERO_STR);
            }
            if (map.get("COUNT_ACCOUNT_FREEZE") != null) {
                this.txtAccFreeze.setText(((Integer)map.get("COUNT_ACCOUNT_FREEZE")).toString());
            } else {
                this.txtAccFreeze.setText(ZERO_STR);
            }
            if (map.get("COUNT_ACCOUNT_CURRENT_CHK") != null) {
                this.txtAudit.setText(((Integer)map.get("COUNT_ACCOUNT_CURRENT_CHK")).toString());
            } else {
                this.txtAudit.setText(ZERO_STR);
            }
            if (map.get("COUNT_ACCOUNT_CURRENT_UNCHK") != null) {
                this.txtNoAudit.setText(((Integer)map.get("COUNT_ACCOUNT_CURRENT_UNCHK")).toString());
            } else {
                this.txtNoAudit.setText(ZERO_STR);
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof BenefitException) {
                MsgBox.showError((Component)((Object)this), (String)e.getCause().getMessage());
                SysUtil.abort();
            }
            this.handleException(e);
        }
    }
}

