/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitCalFormFilterUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class BenefitCalFormFilterUI
extends AbstractBenefitCalFormFilterUI {
    private static final long serialVersionUID = 1L;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.SEARCH"));
        this.initAllEditor();
        this.perTotal.setBounds(new Rectangle(this.perTotal.getX(), this.perTotal.getY(), 155, 19));
        this.kDPanel1.setBorder((Border)new TitledBorder(BorderFactory.createLineBorder(new Color(192, 192, 192), 0), ""));
    }

    private void initAllEditor() throws Exception {
        BenefitUtils.setAdminOrgF7(this.prmtAdminOrg);
        this.prmtPeriod.setEnabled(true);
        this.prmtEndPeriod.setEnabled(true);
        BenefitUtils.initPeriodEditor(this.prmtPeriod);
        BenefitUtils.initPeriodEditor(this.prmtEndPeriod);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.addCustomerParam("perTotal", new Boolean(this.perTotal.isSelected()).toString());
        CommonQueryUtil.getAdminFromQueryPanel(cp, this.prmtAdminOrg);
        cp.addCustomerParam("chkIncludeSubOrgUnit", Boolean.valueOf(this.chkIncludeSubOrgUnit.isSelected()).toString());
        CommonQueryUtil.getCmpFromQueryPanel("period.id", cp, this.prmtPeriod);
        CommonQueryUtil.getCmpFromQueryPanel("endPeriod", cp, this.prmtEndPeriod);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            if (cp == null) {
                return;
            }
            if (cp.getCustomerParam("chkOnPosition") != null) {
                // empty if block
            }
            if (cp.getCustomerParam("chkOutPosition") != null) {
                // empty if block
            }
            if (cp.getCustomerParam("chkRetire") != null) {
                // empty if block
            }
            if (cp.getCustomerParam("chkResignation") != null) {
                // empty if block
            }
            if (cp.getCustomerParam("chkReretain") != null) {
                // empty if block
            }
            CommonQueryUtil.setAdminFromQueryPanel(cp, this.prmtAdminOrg);
            if (cp.getCustomerParam("chkIncludeSubOrgUnit") != null) {
                this.chkIncludeSubOrgUnit.setSelected(Boolean.valueOf(cp.getCustomerParam("chkIncludeSubOrgUnit")).booleanValue());
            }
            if (cp.getCustomerParam("perTotal") != null) {
                this.perTotal.setSelected(new Boolean(cp.getCustomerParam("perTotal")).booleanValue());
            }
            CommonQueryUtil.setCmpFromQueryPanel("period.id", cp, this.prmtPeriod);
            CommonQueryUtil.setCmpFromQueryPanel("endPeriod", cp, this.prmtEndPeriod);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean verify() {
        boolean flagOfDate;
        if (this.prmtAdminOrg.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.ADMINORG_NOT_NULL"));
            this.prmtAdminOrg.requestFocusInWindow();
            return false;
        }
        if (this.prmtPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.client.FormDetailResource.MUST_BEGINPERIOD"));
            this.prmtPeriod.requestFocusInWindow();
            return false;
        }
        if (this.prmtEndPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.client.FormDetailResource.MUST_ENDPERIOD"));
            this.prmtEndPeriod.requestFocusInWindow();
            return false;
        }
        CmpPeriodInfo cmpPeriodInfoBegin = (CmpPeriodInfo)this.prmtPeriod.getData();
        CmpPeriodInfo cmpPeriodInfoEnd = (CmpPeriodInfo)this.prmtEndPeriod.getData();
        if (!cmpPeriodInfoBegin.getId().toString().equals(cmpPeriodInfoEnd.getId().toString()) && !(flagOfDate = DateTimeUtils.dayAfter((Date)cmpPeriodInfoEnd.getBeginDate(), (Date)cmpPeriodInfoBegin.getEndDate()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.BEGINDATE_AFTER_ENDDATE"));
            this.prmtPeriod.requestFocusInWindow();
            return false;
        }
        return true;
    }

    protected void getPanelSql(HashMap paramMap) throws EASBizException, BOSException {
        HashSet adminSet = new HashSet();
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtAdminOrg.getData();
        String adminID = adminOrgUnitInfo.getId().toString();
        if (this.chkIncludeSubOrgUnit.isSelected()) {
            adminSet = BenefitUtils.getUserRangeAdminOrg(null, adminID, true);
        } else {
            adminSet.add(adminID);
        }
        paramMap.put("adminOrgUnit", adminSet);
        CmpPeriodInfo periodInfo = (CmpPeriodInfo)this.prmtPeriod.getData();
        CmpPeriodInfo endPeriodInfo = (CmpPeriodInfo)this.prmtEndPeriod.getData();
        HashSet periodSet = BenefitUtils.getCmpPeridSet(periodInfo, endPeriodInfo);
        paramMap.put("period", periodSet);
        paramMap.put("total", new Boolean(this.perTotal.isSelected()));
    }

    public void clear() {
        super.clear();
        this.prmtAdminOrg.setEnabled(true);
        this.prmtAdminOrg.setData(null);
        this.chkIncludeSubOrgUnit.setSelected(false);
        this.prmtPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
        this.perTotal.setSelected(false);
    }
}

