/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitCollection;
import com.kingdee.eas.hr.benefit.BenefitCommonFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitFactory;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.IBenefit;
import com.kingdee.eas.hr.benefit.IBenefitCommonFacade;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitCalReportFilterUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.BenefitVerifyUtils;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

public class BenefitCalReportFilterUI
extends AbstractBenefitCalReportFilterUI {
    private static final long serialVersionUID = 1L;
    private boolean isUseAdminFlag = true;

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        this.loadComboAccountType();
        this.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.SEARCH"));
        this.kDPanel1.setBorder((Border)new TitledBorder(BorderFactory.createLineBorder(new Color(192, 192, 192), 0), ""));
    }

    private void initAllEditor() throws Exception {
        BenefitUtils.setAdminOrgF7(this.prmtAdminOrg);
        this.prmtPeriod.setEnabled(true);
        this.prmtEndPeriod.setEnabled(true);
        BenefitUtils.initPeriodEditor(this.prmtPeriod);
        BenefitUtils.initPeriodEditor(this.prmtEndPeriod);
        this.prmtBenefit.setDisplayFormat("$name$");
        this.prmtBenefit.setEditFormat("$number$");
        this.prmtBenefit.setCommitFormat("$number$");
        this.prmtBenefit.setEnabledMultiSelection(true);
        this.prmtBenefit.setQueryInfo("com.kingdee.eas.hr.benefit.app.BenefitReportQuery");
    }

    private void loadComboAccountType() throws BOSException {
        DefaultComboBoxModel<AccountTypeInfo> model = new DefaultComboBoxModel<AccountTypeInfo>();
        AccountTypeCollection accountTypeInfos = BenefitUtils.getAccountTypeColl();
        for (int i = 0; i < accountTypeInfos.size(); ++i) {
            model.addElement(accountTypeInfos.get(i));
        }
        if (accountTypeInfos.size() != 0) {
            AccountTypeInfo atInfo = accountTypeInfos.get(0);
            model.setSelectedItem(atInfo);
            this.setBenefitFilterInfo(atInfo);
        } else {
            this.prmtBenefit.setEnabled(false);
        }
        this.comboAccountType.setModel(model);
    }

    protected void prmtAdminOrg_stateChanged(ChangeEvent e) throws Exception {
        this.dealWithSubOrgCheckBox();
    }

    protected void comboAccountType_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtBenefit.setData(null);
        if (this.comboAccountType.getSelectedItem() == null) {
            this.prmtBenefit.setEnabled(false);
        } else {
            this.prmtBenefit.setEnabled(true);
            AccountTypeInfo atInfo = (AccountTypeInfo)this.comboAccountType.getSelectedItem();
            this.setBenefitFilterInfo(atInfo);
        }
    }

    private void setBenefitFilterInfo(AccountTypeInfo atInfo) {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filtInfo = new FilterInfo();
        filtInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filtInfo.getFilterItems().add(new FilterItemInfo("accounttype.id", (Object)atInfo.getId().toString()));
        filtInfo.setMaskString("#0 and #1");
        env.setFilter(filtInfo);
        this.prmtBenefit.setEntityViewInfo(env);
    }

    private void dealWithSubOrgCheckBox() throws Exception {
        this.levelSubOrg.removeAllItems();
        this.levelSum.removeAllItems();
        if (this.prmtAdminOrg.getData() == null) {
            return;
        }
        IBenefitCommonFacade iBenefitCommon = BenefitCommonFacadeFactory.getRemoteInstance();
        int level = iBenefitCommon.getAdminLevel(((AdminOrgUnitInfo)this.prmtAdminOrg.getData()).getLongNumber());
        if (level > 0) {
            this.chkIncludeSubOrgUnit.setSelected(false);
            this.chkIncludeSubOrgUnit.setEnabled(true);
            this.levelSubOrg.setEnabled(true);
            this.chkSumLevel.setSelected(false);
            this.chkSumLevel.setEnabled(true);
            this.levelSum.setEnabled(true);
        } else {
            this.chkIncludeSubOrgUnit.setSelected(false);
            this.chkIncludeSubOrgUnit.setEnabled(false);
            this.levelSubOrg.setEnabled(false);
            this.chkSumLevel.setSelected(false);
            this.chkSumLevel.setEnabled(false);
            this.levelSum.setEnabled(false);
        }
        this.initComBox(level, this.levelSubOrg);
        this.initComBox(level, this.levelSum);
    }

    private void initComBox(int level, KDComboBox cmbControl) {
        for (int i = 1; i <= level; ++i) {
            cmbControl.addItem((Object)i);
        }
        if (level >= 1) {
            cmbControl.setSelectedIndex(0);
        }
    }

    public int getAdminOrgLevelCount(AdminOrgUnitInfo info) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber()));
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!%"), CompareType.LIKE));
        fi.setMaskString("(#0 or #1)");
        viewInfo.setFilter(fi);
        SorterItemInfo sortInfo = new SorterItemInfo("level");
        sortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortInfo);
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
        AdminOrgUnitCollection coll = iAdmin.getAdminOrgUnitCollection(viewInfo);
        if (coll != null) {
            int size = coll.size();
            if (size <= 1) {
                return 0;
            }
            if (size > 1) {
                return coll.get(size - 1).getLevel() - coll.get(0).getLevel();
            }
        }
        return 0;
    }

    public void getPanelSql(HashMap paramMap) throws BOSException {
        HashSet adminSet = new HashSet();
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtAdminOrg.getData();
        if (adminOrgUnitInfo != null) {
            if (this.chkIncludeSubOrgUnit.isSelected()) {
                int levelSubOrg = 0;
                if (this.levelSubOrg.getSelectedItem() != null) {
                    levelSubOrg = Integer.parseInt(this.levelSubOrg.getSelectedItem().toString());
                }
                adminSet = BenefitUtils.getUserRangeSubAdminOrg(null, adminOrgUnitInfo, levelSubOrg);
            } else {
                adminSet.add(adminOrgUnitInfo.getId().toString());
            }
        }
        paramMap.put("adminOrgUnit", adminSet);
        HashSet<String> periodSet = null;
        CmpPeriodInfo periodInfo = (CmpPeriodInfo)this.prmtPeriod.getData();
        CmpPeriodInfo endPeriodInfo = (CmpPeriodInfo)this.prmtEndPeriod.getData();
        if (endPeriodInfo != null) {
            periodSet = BenefitUtils.getCmpPeridSet(periodInfo, endPeriodInfo);
        } else {
            periodSet = new HashSet<String>();
            periodSet.add(periodInfo.getId().toString());
        }
        paramMap.put("period", periodSet);
    }

    public boolean verify() {
        if (this.prmtAdminOrg.getData() == null && this.isUseAdminFlag) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.ADMINORG_NOT_NULL"));
            this.prmtAdminOrg.requestFocusInWindow();
            return false;
        }
        if (this.chkIncludeSubOrgUnit.isSelected() && this.chkSumLevel.isSelected() && this.levelSubOrg.getSelectedItem() != null && this.levelSum.getSelectedItem() != null) {
            int levelSubOrg = Integer.parseInt(this.levelSubOrg.getSelectedItem().toString());
            int levelSum = Integer.parseInt(this.levelSum.getSelectedItem().toString());
            if (levelSum > levelSubOrg) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"51_BenefitCalReportFilterUI"));
                return false;
            }
        }
        if (this.prmtPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.client.FormDetailResource.MUST_BEGINPERIOD"));
            this.prmtPeriod.requestFocusInWindow();
            return false;
        }
        if (!this.chkSumLevel.isSelected()) {
            boolean flagOfDate;
            if (this.prmtEndPeriod.getData() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.client.FormDetailResource.MUST_ENDPERIOD"));
                this.prmtEndPeriod.requestFocusInWindow();
                return false;
            }
            CmpPeriodInfo cmpPeriodInfoBegin = (CmpPeriodInfo)this.prmtPeriod.getData();
            CmpPeriodInfo cmpPeriodInfoEnd = (CmpPeriodInfo)this.prmtEndPeriod.getData();
            if (!cmpPeriodInfoBegin.getId().toString().equals(cmpPeriodInfoEnd.getId().toString()) && !(flagOfDate = DateTimeUtils.dayAfter((Date)cmpPeriodInfoEnd.getBeginDate(), (Date)cmpPeriodInfoBegin.getEndDate()))) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.BEGINDATE_AFTER_ENDDATE"));
                this.prmtPeriod.requestFocusInWindow();
                return false;
            }
        }
        if (!BenefitVerifyUtils.accountTypeNotNullVerify(this.comboAccountType)) {
            return false;
        }
        Object[] object = (Object[])this.prmtBenefit.getData();
        if (object != null && object.length > 0) {
            HashSet<String> set = new HashSet<String>();
            int size = object.length;
            for (int i = 0; i < size; ++i) {
                if (object[i] == null) continue;
                set.add(((BenefitInfo)object[i]).getId().toString());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("state", (Object)Boolean.valueOf("0")));
            viewInfo.setFilter(fi);
            try {
                IBenefit benefit = BenefitFactory.getRemoteInstance();
                BenefitCollection collection = benefit.getBenefitCollection(viewInfo);
                if (collection.size() > 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.BENEFIT_JINYONG"));
                    return false;
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.prmtAdminOrg.setEnabled(true);
        this.prmtAdminOrg.setData(null);
        this.chkIncludeSubOrgUnit.setSelected(false);
        this.chkSumLevel.setSelected(false);
        this.prmtPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
        if (this.comboAccountType.getItemCount() > 0) {
            this.comboAccountType.setSelectedIndex(0);
        } else {
            this.comboAccountType.setSelectedItem(null);
        }
        this.prmtBenefit.setData(null);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CommonQueryUtil.getAdminFromQueryPanel(cp, this.prmtAdminOrg);
        cp.addCustomerParam("chkIncludeSubOrgUnit", Boolean.valueOf(this.chkIncludeSubOrgUnit.isSelected()).toString());
        cp.addCustomerParam("chkSumLevel", Boolean.valueOf(this.chkSumLevel.isSelected()).toString());
        if (this.levelSubOrg.getSelectedItem() != null) {
            cp.addCustomerParam("levelSubOrg", this.levelSubOrg.getSelectedItem().toString());
        }
        if (this.levelSum.getSelectedItem() != null) {
            cp.addCustomerParam("levelSum", this.levelSum.getSelectedItem().toString());
        }
        AccountTypeInfo atInfo = (AccountTypeInfo)this.comboAccountType.getSelectedItem();
        cp.addCustomerParam("accountTypeID", atInfo.getId().toString());
        if (this.prmtBenefit.getData() != null) {
            Object data = this.prmtBenefit.getData();
            Object[] datas = (Object[])data;
            BenefitInfo beneInfo = null;
            StringBuffer beneIDStr = new StringBuffer();
            int size = datas.length;
            for (int i = 0; i < size; ++i) {
                beneInfo = (BenefitInfo)datas[i];
                if (beneInfo == null) continue;
                beneIDStr.append(beneInfo.getId().toString()).append("@");
            }
            cp.addCustomerParam("benefitIDS", beneIDStr.toString());
        }
        CommonQueryUtil.getCmpFromQueryPanel("cmpPeriod.id", cp, this.prmtPeriod);
        CommonQueryUtil.getCmpFromQueryPanel("endPeriod", cp, this.prmtEndPeriod);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            if (cp == null) {
                return;
            }
            CommonQueryUtil.setAdminFromQueryPanel(cp, this.prmtAdminOrg);
            if (cp.getCustomerParam("chkIncludeSubOrgUnit") != null) {
                this.chkIncludeSubOrgUnit.setSelected(Boolean.valueOf(cp.getCustomerParam("chkIncludeSubOrgUnit")).booleanValue());
            }
            if (cp.getCustomerParam("chkSumLevel") != null) {
                this.chkSumLevel.setSelected(Boolean.valueOf(cp.getCustomerParam("chkSumLevel")).booleanValue());
            }
            if (cp.getCustomerParam("levelSubOrg") != null) {
                this.levelSubOrg.setSelectedItem((Object)Integer.parseInt(cp.getCustomerParam("levelSubOrg")));
            }
            if (cp.getCustomerParam("levelSum") != null) {
                this.levelSum.setSelectedItem((Object)Integer.parseInt(cp.getCustomerParam("levelSum")));
            }
            AccountTypeInfo atInfo = null;
            if (cp.getCustomerParam("accountTypeID") != null) {
                atInfo = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo((IObjectPK)new ObjectStringPK(cp.getCustomerParam("accountTypeID")));
            }
            if (atInfo != null) {
                this.comboAccountType.setSelectedItem(atInfo);
            } else {
                this.comboAccountType.setSelectedItem(null);
            }
            String beneIDStr = cp.getCustomerParam("benefitIDS");
            if (!StringUtils.isEmpty((String)beneIDStr)) {
                String IDStr = null;
                IBenefit ib = BenefitFactory.getRemoteInstance();
                BenefitInfo beneInfo = null;
                String[] str = beneIDStr.split("@");
                int size = str.length;
                Object[] datas = new Object[size];
                for (int i = 0; i < size; ++i) {
                    IDStr = str[i];
                    beneInfo = ib.getBenefitInfo((IObjectPK)new ObjectStringPK(IDStr));
                    datas[i] = beneInfo;
                }
                this.prmtBenefit.setData((Object)datas);
            }
            CommonQueryUtil.setCmpFromQueryPanel("cmpPeriod.id", cp, this.prmtPeriod);
            CommonQueryUtil.setCmpFromQueryPanel("endPeriod", cp, this.prmtEndPeriod);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void chkSumLevel_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkSumLevel.isSelected()) {
            this.prmtEndPeriod.setData(null);
            this.prmtEndPeriod.setEnabled(false);
        } else {
            this.prmtEndPeriod.setEnabled(true);
        }
    }
}

