/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitCalcuOtherHRFilterUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;

public class BenefitCalcuOtherHRFilterUI
extends AbstractBenefitCalcuOtherHRFilterUI {
    private static final long serialVersionUID = 1L;
    private boolean isAdjustDataUI = false;
    private AccountTypeCollection accountTypeInfos;

    private void loadComboAccountType() throws BOSException {
        DefaultComboBoxModel<AccountTypeInfo> model = new DefaultComboBoxModel<AccountTypeInfo>();
        this.accountTypeInfos = BenefitUtils.getAccountTypeColl();
        for (int i = 0; i < this.accountTypeInfos.size(); ++i) {
            model.addElement(this.accountTypeInfos.get(i));
        }
        if (this.accountTypeInfos.size() != 0) {
            model.setSelectedItem(this.accountTypeInfos.get(0));
        }
        this.comboAccountType.setModel(model);
    }

    protected boolean isFirstAccType() {
        if (this.accountTypeInfos.size() == 0) {
            return false;
        }
        return this.accountTypeInfos.get(0).equals(this.comboAccountType.getSelectedItem());
    }

    public BenefitCalcuOtherHRFilterUI() throws Exception {
        this.loadComboAccountType();
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void chkNoEnrolltIn_itemStateChanged(ItemEvent e) throws Exception {
    }

    protected void chkOffOff_itemStateChanged(ItemEvent e) throws Exception {
    }

    protected void comboAccountType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboAccountType_itemStateChanged(e);
    }

    public CustomerParams getQueryFilter() {
        CustomerParams cp = new CustomerParams();
        cp.putBoolean("chkEnroll", this.chkEnroll.isSelected());
        cp.putBoolean("chkNoEnroll", this.chkNoEnroll.isSelected());
        cp.putBoolean("chkResign", this.chkResign.isSelected());
        cp.putBoolean("chkRetire", this.chkRetire.isSelected());
        cp.putBoolean("chkReretain", this.chkReretain.isSelected());
        cp.addCustomerParam("AccountType", ((AccountTypeInfo)this.comboAccountType.getSelectedItem()).getId().toString());
        return cp;
    }

    public CustomerParams getCustomerParams() {
        return this.getQueryFilter();
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.chkEnroll.setSelected(cp.getBoolean("chkEnroll"));
        this.chkNoEnroll.setSelected(cp.getBoolean("chkNoEnroll"));
        this.chkResign.setSelected(cp.getBoolean("chkResign"));
        this.chkRetire.setSelected(cp.getBoolean("chkRetire"));
        this.chkReretain.setSelected(cp.getBoolean("chkReretain"));
        String acc = cp.getCustomerParam("AccountType");
        int size = this.comboAccountType.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (!acc.equals(((AccountTypeInfo)this.comboAccountType.getItemAt(i)).getId().toString())) continue;
            this.comboAccountType.setSelectedIndex(i);
            break;
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void clear() {
        super.clear();
        this.chkEnroll.setSelected(false);
        this.chkNoEnroll.setSelected(false);
        this.chkResign.setSelected(false);
        this.chkRetire.setSelected(false);
        this.chkReretain.setSelected(false);
        this.comboAccountType.setSelectedIndex(0);
    }

    public AccountTypeCollection getAccountTypeInfos() {
        return this.accountTypeInfos;
    }

    protected void comboPayState_itemStateChanged(ItemEvent e) throws Exception {
        super.comboAccountType_itemStateChanged(e);
    }

    public void setAdjustUI(boolean isAdjustDataUI) {
        this.isAdjustDataUI = isAdjustDataUI;
    }

    public FilterInfo getFilterInfo() {
        int fSize;
        CustomerParams cp = this.getCustomerParams();
        ArrayList<Integer> list = new ArrayList<Integer>();
        FilterInfo info = new FilterInfo();
        if (cp.getBoolean("chkEnroll")) {
            list.add(1);
        }
        if (cp.getBoolean("chkNoEnroll")) {
            list.add(0);
        }
        if (cp.getBoolean("chkResign")) {
            list.add(2);
        }
        if (cp.getBoolean("chkRetire")) {
            list.add(3);
        }
        if (cp.getBoolean("chkReretain")) {
            list.add(4);
        }
        HashSet set = null;
        if (list.size() > 0) {
            set = new HashSet();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                set.add(list.get(i));
            }
            info.getFilterItems().add(new FilterItemInfo("et.inService", set, CompareType.INCLUDE));
        }
        String type = cp.getCustomerParam("AccountType");
        info.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)type));
        String curHROId = null;
        if (SysContext.getSysContext().getCurrentHRUnit() != null) {
            curHROId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        } else {
            try {
                throw new BenefitException(BenefitException.NO_HRO);
            }
            catch (BenefitException e) {
                ExceptionHandler.handle((Throwable)((Object)e));
            }
        }
        info.getFilterItems().add(new FilterItemInfo("adminToUnit.id", (Object)curHROId));
        if (!this.isAdjustDataUI) {
            info.getFilterItems().add(new FilterItemInfo("user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        }
        if ((fSize = info.getFilterItems().size()) > 1) {
            StringBuffer mStr = new StringBuffer();
            for (int i = 0; i < fSize; ++i) {
                if (i == 0) {
                    mStr.append("#");
                    mStr.append(i);
                    continue;
                }
                mStr.append(" and #");
                mStr.append(i);
            }
            info.setMaskString(mStr.toString());
        }
        return info;
    }
}

