/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenifitFormFacadeFactory;
import com.kingdee.eas.hr.benefit.IBenifitFormFacade;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitPersonalInfoListUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.ActionEvent;

public class BenefitPersonalInfoListUI
extends AbstractBenefitPersonalInfoListUI {
    private static final long serialVersionUID = 1L;
    public static final int PERSON_ID = 0;
    public static final int CELL_ACCOUNT_NUM = 1;
    public static final int CELL_ACCOUNT_TYPE = 2;
    public static final int CELL_ACCOUNT = 3;
    public static final int CELL_BENEFIT_TYPE = 4;
    public static final int CELL_BENEFIT_ITEM = 5;
    public static final int CELL_ACCOUNT_MONEY = 6;
    private String thisPersonalID = null;
    private IBenifitFormFacade iBenFac = null;
    private EmployeeTreeEditUI treeEditUI = null;

    public void storeFields() {
        super.storeFields();
    }

    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        if (!BenefitUtils.hasInitPeriod(this.getCurrentHRO().getId().toString())) {
            throw new BenefitException(BenefitException.NO_BENEFIT_PERIOD);
        }
        this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
        if (this.getUIContext().get("ID") == null) {
            return;
        }
        this.thisPersonalID = (String)this.getUIContext().get("ID");
        this.initAllEditor();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo();
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    private IBenifitFormFacade getBenFacInterface() throws BOSException {
        if (this.iBenFac == null) {
            this.iBenFac = BenifitFormFacadeFactory.getRemoteInstance();
        }
        return this.iBenFac;
    }

    private void fillAllPersonData() throws BOSException, EASBizException {
        if (this.prmtBenefitPeriod.getValue() == null) {
            this.mainQuery = null;
            this.tblMain.removeRows();
            SysUtil.abort();
        }
        CmpPeriodInfo selectedInfo = (CmpPeriodInfo)this.prmtBenefitPeriod.getValue();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.thisPersonalID));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getCurrentHRO().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)selectedInfo.getId().toString()));
        ev.setFilter(filterInfo);
        SorterItemInfo typeSort = new SorterItemInfo("accountType.name");
        typeSort.setSortType(SortType.ASCEND);
        ev.getSorter().add(typeSort);
        SorterItemInfo benefitSort = new SorterItemInfo("benefit.id");
        benefitSort.setSortType(SortType.ASCEND);
        ev.getSorter().add(benefitSort);
        SorterItemInfo itemSort = new SorterItemInfo("benefitItem.name");
        itemSort.setSortType(SortType.ASCEND);
        ev.getSorter().add(itemSort);
        this.mainQuery = ev;
        this.tblMain.removeRows();
        KDTMergeManager mm = this.tblMain.getMergeManager();
        int sumSize = this.tblMain.getRowCount() - 1;
        for (int i = 0; i < 5; ++i) {
            mm.mergeBlock(0, i, sumSize, i, 3);
        }
    }

    private void initAllEditor() throws Exception {
        CmpPeriodInfo initPeriod = BenefitUtils.getInitPeriod();
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getCurrentHRO().getId().toString()));
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("beginDate", (Object)initPeriod.getBeginDate().toString(), CompareType.GREATER_EQUALS));
        filterInfoCmpPeriod.setMaskString("#0 AND #1");
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtBenefitPeriod.setEntityViewInfo(eviCmpPeriod);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(6).getStyleAttributes().setNumberFormat("0.00");
        this.tblMain.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.prmtBenefitPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    BenefitPersonalInfoListUI.this.fillAllPersonData();
                }
                catch (Exception e) {
                    BenefitPersonalInfoListUI.this.handleException(e);
                }
            }
        });
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void refresh(ActionEvent e) throws Exception {
    }

    public void refreshList() throws Exception {
        if (this.getUIContext().get("ID") == null) {
            return;
        }
        this.thisPersonalID = (String)this.getUIContext().get("ID");
        this.fillAllPersonData();
    }
}

