/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.base.EmployeeFenLeiInfo;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.IEmployeeType;
import com.kingdee.eas.hr.benefit.BenefitCommonFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.IBenefitCommonFacade;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitQueryListUI;
import com.kingdee.eas.hr.benefit.client.AccountAdjustQueryUI;
import com.kingdee.eas.hr.benefit.client.BenefitQueryQueryPanelUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BenefitQueryListUI
extends AbstractBenefitQueryListUI {
    private static final long serialVersionUID = 1L;
    protected static final TextRender render = new TextRender();
    private EntityViewInfo entityViewInfo = null;
    private boolean isFirstDefaultQuery = true;
    private ArrayList periodList;
    private HashMap accItemInputIdRowMap;
    private int initColSize;
    private static final String ACCOUNT_ITEM_INPUT_ID = "accountItemInput.id";
    private Color comColor = Color.ORANGE;
    private CommonQueryDialog dialog = null;
    private CmpPeriodInfo beginPeriod = null;
    private CmpPeriodInfo endPeriod = null;
    private Map ruleInfoMap = new HashMap();
    private FilterInfo personInfo = new FilterInfo();
    private Map ruleMap = new HashMap();

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (!BenefitUtils.hasInitPeriod()) {
            throw new BenefitException(BenefitException.NO_BENEFIT_PERIOD);
        }
        super.onLoad();
        this.initPerTypeTree();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(1);
        this.tblItem.checkParsed();
        this.tblItem.setEnabled(false);
        this.tblItem.getSelectManager().setSelectMode(1);
        this.tHelper.getDisabledTables().add(this.tblItem);
    }

    protected void initPerTypeTree() throws Exception {
        DefaultKingdeeTreeNode root = HRTreeUtil.createEmployeeFenLeiTreeNode((boolean)true);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.treeMain.setModel((TreeModel)model);
        this.treeMain.setSelectionNode(root);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionView.setVisible(false);
        this.actionView.setEnabled(false);
        this.tblItem.checkParsed();
        this.tblItem.getColumn("benefitItem.name").setWidth(150);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int topIndex = e.getSelectBlock().getTop();
        IRow iRow = this.tblMain.getRow(topIndex);
        String accountID = iRow.getCell("account.id").getValue().toString();
        this.loadTblItem(accountID);
    }

    protected void loadTblItem(String accountID) throws Exception {
        int count = this.tblItem.getColumnCount() - 13;
        for (int i = 0; i < count; ++i) {
            this.tblItem.removeColumn(this.tblItem.getColumnCount() - 1);
        }
        this.loadTableData(accountID, this.beginPeriod, this.endPeriod);
    }

    private void loadTableData(String accountId, CmpPeriodInfo beginPeriod, CmpPeriodInfo endPeriod) throws Exception {
        this.tblItem.getMergeManager().setMergeMode(3);
        this.setPeriodListBy(beginPeriod, endPeriod);
        FilterInfo filter = new FilterInfo();
        FilterInfo commFilter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("benefitItem.state", (Object)1, CompareType.EQUALS));
        HashSet atSet = BenefitUtils.getAccountType();
        if (atSet != null && atSet.isEmpty()) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)atSet, CompareType.INCLUDE));
        filter.setMaskString("#0 and #1 and #2 and #3");
        this.accountInfoQuery = new EntityViewInfo();
        this.accountInfoQuery.setFilter(filter);
        this.tblItem.refresh();
        this.initColSize = this.tblItem.getColumnCount();
        this.setAccItemInputIdRowMap();
        this.initPeriodColumn();
        commFilter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        this.loadDatas(this.getDataRow(commFilter));
    }

    protected void tblItem_tableClicked(KDTMouseEvent e) throws Exception {
        int colIndex;
        int rowIndex;
        ICell cell;
        if (e.getClickCount() == 2 && e.getType() == 1 && (cell = this.tblItem.getCell(rowIndex = this.tblItem.getSelectManager().get().getTop(), colIndex = this.tblItem.getSelectManager().get().getLeft())).getUserObject() != null) {
            String accountTypeName = (String)this.tblItem.getRow(rowIndex).getCell("accountType.name").getValue();
            String periodId = this.tblItem.getColumnKey(colIndex);
            String accountItemInputId = (String)this.tblItem.getRow(rowIndex).getCell(ACCOUNT_ITEM_INPUT_ID).getValue();
            this.showAdjustDataDialog(accountTypeName, periodId, accountItemInputId);
        }
    }

    private void showAdjustDataDialog(String accountTypeName, String periodId, String accountItemInputId) throws Exception {
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"accountTypeName", (Object)accountTypeName);
        ctx.put((Object)"periodId", (Object)periodId);
        ctx.put((Object)"accountItemInputId", (Object)accountItemInputId);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccountAdjustQueryUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void setAccItemInputIdRowMap() {
        int count = this.tblItem.getRowCount();
        this.accItemInputIdRowMap = new HashMap();
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            row = this.tblItem.getRow(i);
            this.accItemInputIdRowMap.put(row.getCell(ACCOUNT_ITEM_INPUT_ID).getValue(), i);
        }
    }

    private void setPeriodListBy(CmpPeriodInfo beginPeriod, CmpPeriodInfo endPeriod) throws Exception {
        this.periodList = new ArrayList();
        if (beginPeriod != null && endPeriod != null && !endPeriod.getId().toString().equals(beginPeriod.getId().toString())) {
            CmpPeriodInfo nextPeriod = beginPeriod;
            CmpPeriodInfo tmp = null;
            while (!nextPeriod.getId().toString().equals(endPeriod.getId().toString())) {
                this.periodList.add(nextPeriod);
                tmp = HRUtils.getNextCmpPeriodInfoClient((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)nextPeriod.getId().toString())));
                if (tmp == null) break;
                nextPeriod = tmp;
            }
        }
        this.periodList.add(endPeriod);
    }

    private void initPeriodColumn() {
        IColumn col = null;
        CmpPeriodInfo info = null;
        int size = this.periodList.size();
        for (int i = 0; i < size; ++i) {
            info = (CmpPeriodInfo)this.periodList.get(i);
            col = this.tblItem.addColumn();
            col.getStyleAttributes().setNumberFormat("#,##0.00");
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            col.setKey(info.getId().toString());
            col.setUserObject((Object)info.getName());
        }
        int colCount = this.tblItem.getColumnCount();
        if (colCount > this.initColSize) {
            IRow row = this.tblItem.getHeadRow(0);
            for (int i = this.initColSize; i < colCount; ++i) {
                row.getCell(i).setValue(this.tblItem.getColumn(i).getUserObject());
            }
        }
    }

    private void loadDatas(IRowSet rows) throws Exception {
        boolean extCom = false;
        String cmpPeriodId = null;
        BigDecimal value = null;
        String accountItemInputId = null;
        String benefitID = null;
        String itemNumber = null;
        IRow row = null;
        ICell cell = null;
        int index = -1;
        String accountID = null;
        String accountTypeID = null;
        while (rows.next()) {
            extCom = rows.getBoolean("existsComplementary");
            value = rows.getBigDecimal("fvalue");
            accountItemInputId = rows.getString(ACCOUNT_ITEM_INPUT_ID);
            cmpPeriodId = rows.getString("cmpPeriod.id");
            if (this.accItemInputIdRowMap.get(accountItemInputId) == null) continue;
            index = (Integer)this.accItemInputIdRowMap.get(accountItemInputId);
            row = this.tblItem.getRow(index);
            cell = row.getCell(cmpPeriodId);
            cell.setValue((Object)value);
            benefitID = (String)row.getCell("benefit.id").getValue();
            itemNumber = (String)row.getCell("benefitItem.number").getValue();
            accountID = (String)row.getCell("account.id").getValue();
            accountTypeID = (String)row.getCell("accountType.id").getValue();
            BenefitUtils.setCellStyle(this.ruleMap, this.ruleInfoMap, accountID + "@@" + accountTypeID, benefitID, itemNumber, cell, null, null, false);
            if (!extCom) continue;
            cell.setUserObject((Object)Boolean.TRUE);
            cell.getStyleAttributes().setBackground(this.comColor);
        }
    }

    private IRowSet getDataRow(FilterInfo commFilter) throws Exception {
        IQueryExecutor iq = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.benefit.app.AccountDataQuery"));
        FilterInfo filter = new FilterInfo();
        CmpPeriodInfo info = null;
        int size = this.periodList.size();
        for (int i = 0; i < size; ++i) {
            info = (CmpPeriodInfo)this.periodList.get(i);
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)info.getId().toString()));
        }
        int count = filter.getFilterItems().size();
        if (count >= 2) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                if (i == 0) {
                    sb.append("#");
                } else {
                    sb.append(" or #");
                }
                sb.append(i);
            }
            filter.setMaskString(sb.toString());
        }
        if (FilterUtility.hasFilterItem((FilterInfo)commFilter)) {
            filter.mergeFilter(commFilter, "and");
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iq.setObjectView(evi);
        return iq.executeQuery();
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "account.id", "benefitItem.number", "benefit.number", ACCOUNT_ITEM_INPUT_ID, "accountType.id", "benefitItem.id", "benefit.id", "accountType.number", "accountType.name", "accounts", "benefit.name", "benefitItem.name"};
    }

    protected void initTree() throws Exception {
        KDTreeNode root = new KDTreeNode((Object)new EmpInServiceType(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE"), -1));
        KDTreeNode isNode = new KDTreeNode((Object)new EmpInServiceType(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_INSERVICE"), 1));
        KDTreeNode noNode = new KDTreeNode((Object)new EmpInServiceType(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_NOTINSERVICE"), 0));
        KDTreeNode leaveNode = new KDTreeNode((Object)new EmpInServiceType(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_LEAVEINSERVICE"), 2));
        KDTreeNode retireNode = new KDTreeNode((Object)new EmpInServiceType(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_RETIRESERVICE"), 3));
        KDTreeNode reretainNode = new KDTreeNode((Object)new EmpInServiceType(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_RERETAIN"), 4));
        root.add((MutableTreeNode)isNode);
        root.add((MutableTreeNode)noNode);
        root.add((MutableTreeNode)leaveNode);
        root.add((MutableTreeNode)retireNode);
        root.add((MutableTreeNode)reretainNode);
        IEmployeeType iEmp = EmployeeTypeFactory.getRemoteInstance();
        EmployeeTypeCollection empInfos = iEmp.getEmployeeTypeCollection();
        block7: for (int i = 0; i < empInfos.size(); ++i) {
            KDTreeNode newNode = new KDTreeNode((Object)empInfos.get(i));
            switch (empInfos.get(i).getInService().getValue()) {
                case 0: {
                    noNode.add((MutableTreeNode)newNode);
                    continue block7;
                }
                case 1: {
                    isNode.add((MutableTreeNode)newNode);
                    continue block7;
                }
                case 2: {
                    leaveNode.add((MutableTreeNode)newNode);
                    continue block7;
                }
                case 3: {
                    retireNode.add((MutableTreeNode)newNode);
                    continue block7;
                }
                case 4: {
                    reretainNode.add((MutableTreeNode)newNode);
                    continue block7;
                }
            }
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.treeMain.setModel((TreeModel)model);
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)root);
    }

    public void loadFilterUI(boolean loaded) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = BenefitQueryListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        this.isPerformDefaultQuery(iQuery, queryName);
        BenefitQueryQueryPanelUI filterUI = new BenefitQueryQueryPanelUI();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName);
            CustomerParams cp = null;
            if (solution.getQueryPanelInfo().get(0) != null) {
                cp = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
            }
            if (solution.getQueryPanelInfo().get(1) != null && cp == null) {
                cp = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(1).getCustomerParams());
            }
            if (cp != null && !"".equals(solution.getQueryPanelInfo().get(0).getCustomerParams())) {
                if (!BenefitUtils.hasCurPeriodParams(cp) || !BenefitUtils.hasAdminParams(cp)) {
                    this.showQueryDialog();
                } else {
                    filterUI.setCustomerParams(cp);
                    this.beginPeriod = (CmpPeriodInfo)filterUI.prmtFromPeriod.getData();
                    this.endPeriod = (CmpPeriodInfo)filterUI.prmtToPeriod.getData();
                    FilterInfo info = filterUI.getCustomerFilterInfo(cp);
                    this.entityViewInfo = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                    if (this.entityViewInfo == null) {
                        this.entityViewInfo = new EntityViewInfo();
                    }
                    if (this.entityViewInfo.getFilter() == null) {
                        this.entityViewInfo.setFilter(info);
                    } else {
                        this.entityViewInfo.getFilter().mergeFilter(info, "and");
                    }
                    this.personInfo = info;
                    this.mainQuery = this.entityViewInfo;
                }
            } else {
                this.showQueryDialog();
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showQueryDialog();
        }
    }

    public void showQueryDialog() throws Exception {
        BenefitQueryQueryPanelUI filterUI = new BenefitQueryQueryPanelUI();
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setWidth(420);
            this.dialog.setHeight(350);
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(false);
            this.dialog.setQueryObjectPK(this.mainQueryPK);
            this.dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.BENEFITQUERY_FILTER_TITLE"));
            this.dialog.addUserPanel((KDPanel)filterUI);
        }
        if (this.dialog.show()) {
            CustomerParams cp = ((BenefitQueryQueryPanelUI)this.dialog.getUserPanel(0)).getCustomerParams();
            filterUI.setCustomerParams(cp);
            this.beginPeriod = (CmpPeriodInfo)filterUI.prmtFromPeriod.getData();
            this.endPeriod = (CmpPeriodInfo)filterUI.prmtToPeriod.getData();
            FilterInfo info = filterUI.getCustomerFilterInfo(cp);
            this.entityViewInfo = this.dialog.getEntityViewInfoResult();
            if (this.entityViewInfo == null) {
                this.entityViewInfo = new EntityViewInfo();
            }
            if (this.entityViewInfo.getFilter() == null) {
                this.entityViewInfo.setFilter(info);
            } else {
                this.entityViewInfo.getFilter().mergeFilter(info, "and");
            }
            this.personInfo = info;
            this.mainQuery = this.entityViewInfo;
            this.tblMain.removeRows();
            this.tHelper.setDialog(this.dialog);
        } else {
            this.tHelper.setDialog(this.dialog);
            SysUtil.abort();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    protected FilterInfo getDefaultFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("adminToUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminUser.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        return filterInfo;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        DefaultKingdeeTreeNode selectNode = null;
        EmployeeTypeInfo etInfo = null;
        EmployeeFenLeiInfo selectInfo = null;
        TreePath path = this.treeMain.getSelectionPath();
        EntityViewInfo view1 = new EntityViewInfo();
        FilterInfo filter = this.getDefaultFilter();
        if (path != null) {
            selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (selectNode.getUserObject() instanceof EmployeeTypeInfo) {
                etInfo = (EmployeeTypeInfo)selectNode.getUserObject();
                filter.getFilterItems().add(new FilterItemInfo("et.id", (Object)etInfo.getId().toString()));
                filter.setMaskString("#0 and #1 and #2 and #3");
            } else if (selectNode.getUserObject() instanceof EmployeeFenLeiInfo) {
                selectInfo = (EmployeeFenLeiInfo)selectNode.getUserObject();
                String longNumber = selectInfo.getLongNumber();
                filter.getFilterItems().add(new FilterItemInfo("etFenLei.longNumber", (Object)longNumber));
                filter.getFilterItems().add(new FilterItemInfo("etFenLei.longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
            }
        }
        if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
            if (this.entityViewInfo != null) {
                filter.mergeFilter(this.entityViewInfo.getFilter(), "and");
            }
        } else if (this.entityViewInfo != null) {
            filter = this.entityViewInfo.getFilter();
        }
        view1.setFilter(filter);
        this.mainQuery = view1;
        this.tblMain.removeRows();
        this.accountInfoQuery = null;
        this.tblItem.removeRows();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initPerTypeTree();
        this.tblItem.getSelectManager().setSelectMode(1);
        this.loadTblItem(null);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.loadFilterUI(true);
        IBenefitCommonFacade benefitCommonFacade = BenefitCommonFacadeFactory.getRemoteInstance();
        HashSet<String> set = new HashSet<String>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            set.add(this.tblMain.getRow(i).getCell("id").getValue().toString());
        }
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
        map.put("set", set);
        this.ruleInfoMap = benefitCommonFacade.getAccountRuleItemByKey(map);
        this.ruleMap = BenefitUtils.getBenefitRuleItem(null, null);
        if (this.tblMain.getRowCount3() <= 0) {
            this.loadTblItem(null);
        } else {
            IRow iRow = this.tblMain.getRow(0);
            String accountID = iRow.getCell("account.id").getValue().toString();
            this.loadTblItem(accountID);
        }
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.mainQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
                exec.option().isAutoTranslateEnum = true;
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    public static class EmpInServiceType {
        private String _name;
        private int _type;

        public EmpInServiceType(String name, int type) {
            this._name = name;
            this._type = type;
        }

        public String getName() {
            return this._name;
        }

        public int getType() {
            return this._type;
        }

        public String toString() {
            return this.getName();
        }
    }
}

