/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitCollection;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.EmpManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.IEmpManagerFacade;
import com.kingdee.eas.hr.benefit.client.AbstractRadixInputQueryPanelUI;
import com.kingdee.eas.hr.benefit.client.RadixInputFilterInfo;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.BenefitVerifyUtils;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;

public class RadixInputQueryPanelUI
extends AbstractRadixInputQueryPanelUI {
    private static final long serialVersionUID = 1L;
    private BenefitCollection benefitColl = null;

    public RadixInputQueryPanelUI() throws Exception {
        this.loadComboAccountType();
        this.loadBenefitCol();
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        BenefitUtils.initF7Selector(this, this.prmtAdminOrgUnit);
        this.prmtAdminOrgUnit.setEditable(true);
        this.prmtCurPeriod.setEnabled(false);
        super.onLoad();
    }

    private void loadComboAccountType() throws BOSException {
        DefaultComboBoxModel<AccountTypeInfo> model = new DefaultComboBoxModel<AccountTypeInfo>();
        AccountTypeCollection accountTypeInfos = BenefitUtils.getAccountTypeColl();
        for (int i = 0; i < accountTypeInfos.size(); ++i) {
            model.addElement(accountTypeInfos.get(i));
        }
        if (accountTypeInfos.size() != 0) {
            model.setSelectedItem(accountTypeInfos.get(0));
        }
        this.comboAccountType.setModel(model);
    }

    private void loadBenefitCol() throws EASBizException, BOSException {
        AccountTypeInfo atInfo = (AccountTypeInfo)this.comboAccountType.getSelectedItem();
        String id = atInfo.getId().toString();
        this.benefitColl = BenefitUtils.getBenefitColl(id);
    }

    protected void prmtAdminOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        this.setCurPeriodPrompt();
    }

    protected void chkIsLowLevel_itemStateChanged(ItemEvent e) throws Exception {
        this.setCurPeriodPrompt();
    }

    protected void comboAccountType_itemStateChanged(ItemEvent e) throws Exception {
        this.setCurPeriodPrompt();
        this.repaintBenefitItems();
    }

    private void setCurPeriodPrompt() throws EASBizException, BOSException {
        if (this.prmtAdminOrgUnit.getData() == null) {
            this.prmtCurPeriod.setData(null);
            this.prmtCurPeriod.setEnabled(false);
        } else {
            this.prmtCurPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
            this.prmtCurPeriod.setDisplayFormat("$number$");
            this.prmtCurPeriod.setEditFormat("$number$");
            this.prmtCurPeriod.setCommitFormat("$number$");
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            AdminOrgUnitInfo admin = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData();
            String accTypeID = null;
            if (this.comboAccountType.getSelectedItem() != null) {
                accTypeID = ((AccountTypeInfo)this.comboAccountType.getSelectedItem()).getId().toString();
            }
            IEmpManagerFacade iemf = EmpManagerFacadeFactory.getRemoteInstance();
            Map map = iemf.getPeriodCollection(admin.getId().toString(), this.chkIsLowLevel.isSelected(), accTypeID);
            Set set = (Set)map.get("periodset");
            CmpPeriodInfo beginInfo = (CmpPeriodInfo)map.get("CmpPeriodInfo");
            if (set != null && set.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1");
                this.prmtCurPeriod.setData((Object)beginInfo);
                this.prmtCurPeriod.setEnabled(true);
            } else {
                this.prmtCurPeriod.setData(null);
                this.prmtCurPeriod.setEnabled(false);
            }
            evi.setFilter(filter);
            this.prmtCurPeriod.setEntityViewInfo(evi);
        }
    }

    private void repaintBenefitItems() throws BOSException, EASBizException {
        if (this.comboAccountType.getSelectedItem() != null) {
            AccountTypeInfo info = (AccountTypeInfo)this.comboAccountType.getSelectedItem();
            String id = info.getId().toString();
            BenefitCollection coll = BenefitUtils.getBenefitColl(id);
            this.initPanelBenefitItem(coll);
            this.panelBenefitItem2.repaint();
            this.updateUI();
        }
    }

    private void initPanelBenefitItem(BenefitCollection coll) {
        String name = null;
        KDCheckBox cb = null;
        this.panelBenefitItem2.removeAll();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            name = coll.get(i).getName().toString();
            cb = new KDCheckBox();
            cb.setBounds(new Rectangle(13, 14 + i * 22, 140, 19));
            cb.setText(name);
            cb.setUserObject((Object)coll.get(i));
            this.panelBenefitItem2.add((Component)cb);
        }
        this.panelBenefitItem2.setPreferredSize(new Dimension(120, 28 * coll.size()));
    }

    public void clear() {
        super.clear();
        this.chkIn.setSelected(false);
        this.chkNotIn.setSelected(false);
        this.chkOff.setSelected(false);
        this.chkOffOld.setSelected(false);
        this.chkReretain.setSelected(false);
        this.prmtAdminOrgUnit.setValue(null);
        if (this.comboAccountType.getItemCount() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"38_BenefitCalcuFilterUI"));
            SysUtil.abort();
        }
        this.comboAccountType.setSelectedIndex(0);
        this.chkIsLowLevel.setSelected(false);
        if (this.comboAccountType.getSelectedItem() != null) {
            try {
                this.repaintBenefitItems();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putBoolean("chkIn", this.chkIn.isSelected());
        cp.putBoolean("chkNotIn", this.chkNotIn.isSelected());
        cp.putBoolean("chkOff", this.chkOff.isSelected());
        cp.putBoolean("chkOffOld", this.chkOffOld.isSelected());
        cp.putBoolean("chkReretain", this.chkReretain.isSelected());
        CommonQueryUtil.getAdminFromQueryPanel(cp, this.prmtAdminOrgUnit);
        cp.putBoolean("isSelect", this.chkIsLowLevel.isSelected());
        CommonQueryUtil.getCmpFromQueryPanel("curPeriod", cp, this.prmtCurPeriod);
        cp.addCustomerParam("accTypeInfo", ((AccountTypeInfo)this.comboAccountType.getSelectedItem()).getId().toString());
        String coll = CommonQueryUtil.getStringFromColl((IObjectCollection)this.benefitColl);
        cp.addCustomerParam("benefitColl", coll);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.chkIn.setSelected(cp.getBoolean("chkIn"));
        this.chkNotIn.setSelected(cp.getBoolean("chkNotIn"));
        this.chkOff.setSelected(cp.getBoolean("chkOff"));
        this.chkOffOld.setSelected(cp.getBoolean("chkOffOld"));
        this.chkReretain.setSelected(cp.getBoolean("chkReretain"));
        CommonQueryUtil.setAdminFromQueryPanel(cp, this.prmtAdminOrgUnit);
        this.chkIsLowLevel.setSelected(cp.getBoolean("isSelect"));
        String infoId = cp.getCustomerParam("accTypeInfo");
        int size = this.comboAccountType.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (!infoId.equals(((AccountTypeInfo)this.comboAccountType.getItemAt(i)).getId().toString())) continue;
            this.comboAccountType.setSelectedIndex(i);
            break;
        }
        CommonQueryUtil.setCmpFromQueryPanel("curPeriod", cp, this.prmtCurPeriod);
        try {
            this.benefitColl = CommonQueryUtil.getBenefitColl(cp.getCustomerParam("benefitColl"));
            try {
                this.repaintBenefitItems();
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            this.setBenefitByList(this.benefitColl);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void setBenefitByList(BenefitCollection coll) {
        int listCount = coll.size();
        int itemCount = this.panelBenefitItem2.getComponentCount();
        Component c = null;
        KDCheckBox cb = null;
        block0: for (int i = 0; i < listCount; ++i) {
            BenefitInfo listInfo = coll.get(i);
            for (int j = 0; j < itemCount; ++j) {
                BenefitInfo itemInfo;
                c = this.panelBenefitItem2.getComponent(j);
                if (!(c instanceof KDCheckBox) || !(itemInfo = (BenefitInfo)(cb = (KDCheckBox)c).getUserObject()).getId().toString().equals(listInfo.getId().toString())) continue;
                cb.setSelected(true);
                continue block0;
            }
        }
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        Vector<Integer> v = new Vector<Integer>();
        if (this.chkIn.isSelected()) {
            v.add(1);
        }
        if (this.chkNotIn.isSelected()) {
            v.add(0);
        }
        if (this.chkOff.isSelected()) {
            v.add(2);
        }
        if (this.chkOffOld.isSelected()) {
            v.add(3);
        }
        if (this.chkReretain.isSelected()) {
            v.add(4);
        }
        FilterInfo filterChoose = null;
        if (v.size() > 0) {
            filterChoose = new FilterInfo();
            StringBuffer maskString = new StringBuffer("(");
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                filterChoose.getFilterItems().add(new FilterItemInfo("et.inService", v.get(i)));
                if (i != v.size() - 1) {
                    maskString.append("#");
                    maskString.append(i);
                    maskString.append(" or ");
                    continue;
                }
                maskString.append("#");
                maskString.append(i);
            }
            maskString.append(")");
            filterChoose.setMaskString(maskString.toString());
        }
        AdminOrgUnitInfo org = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData();
        try {
            FilterInfo filter1;
            if (org != null) {
                if (this.chkIsLowLevel.isSelected()) {
                    filter.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)org.getLongNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString("(#0 or #1)");
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)org.getLongNumber(), CompareType.EQUALS));
                }
            }
            if (v.size() == 1 && v.contains(1) && (filter1 = HRUtil.buildHROFilter((String)"admin.id")).getFilterItems().size() > 0) {
                filter.mergeFilter(filter1, "and");
            }
            if (filterChoose != null) {
                filter.mergeFilter(filterChoose, "and");
            }
            FilterInfo fInfo = new FilterInfo();
            CmpPeriodInfo cmpInfo = (CmpPeriodInfo)this.prmtCurPeriod.getData();
            fInfo.getFilterItems().add(new FilterItemInfo("curPeriod.id", (Object)cmpInfo.getId().toString(), CompareType.EQUALS));
            AccountTypeInfo atInfo = (AccountTypeInfo)this.comboAccountType.getSelectedItem();
            fInfo.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)atInfo.getId().toString(), CompareType.EQUALS));
            HROrgUnitInfo hrOrgUnit = SysContext.getSysContext().getCurrentHRUnit();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            fInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnit.getId().toString(), CompareType.EQUALS));
            HashSet<String> hroSet = new HashSet<String>();
            String hrOrgId = null;
            HROrgUnitInfo hrOrgInfo = SysContext.getSysContext().getCurrentHRUnit();
            if (hrOrgInfo != null) {
                hrOrgId = hrOrgInfo.getId().toString();
                hroSet.add(hrOrgId);
            }
            fInfo.getFilterItems().add(EmployeeClientUtils.getAdminRangeAndClientageFilterItemInfo((String)"admin.id", hroSet));
            fInfo.setMaskString("#0 and #1 and #2 and #3 ");
            filter.mergeFilter(fInfo, "and");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return filter;
    }

    public RadixInputFilterInfo getQryFilter() throws BenefitException {
        RadixInputFilterInfo qryFilter = new RadixInputFilterInfo();
        qryFilter.empState = new Vector();
        if (this.chkIn.isSelected()) {
            qryFilter.empState.add(1);
        }
        if (this.chkNotIn.isSelected()) {
            qryFilter.empState.add(0);
        }
        if (this.chkOff.isSelected()) {
            qryFilter.empState.add(2);
        }
        if (this.chkOffOld.isSelected()) {
            qryFilter.empState.add(3);
        }
        if (this.chkReretain.isSelected()) {
            qryFilter.empState.add(4);
        }
        qryFilter.adminOrgUnit = this.prmtAdminOrgUnit.getData() != null ? ((AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData()).getLongNumber().toString() : SysContext.getSysContext().getCurrentAdminUnit().getLongNumber().toString();
        qryFilter.isLowLevel = this.chkIsLowLevel.isSelected();
        qryFilter.bColl = this.benefitColl;
        qryFilter.atInfo = (AccountTypeInfo)this.comboAccountType.getSelectedItem();
        return qryFilter;
    }

    public boolean verify() {
        if (!BenefitVerifyUtils.adminOrgNotNullVerify(this.prmtAdminOrgUnit)) {
            return false;
        }
        if (!BenefitVerifyUtils.curPeriodNotNullVerify(this.prmtCurPeriod)) {
            return false;
        }
        if (!BenefitVerifyUtils.accountTypeNotNullVerify(this.comboAccountType)) {
            return false;
        }
        this.benefitColl = new BenefitCollection();
        int count = this.panelBenefitItem2.getComponentCount();
        KDCheckBox cb = null;
        for (int i = 0; i < count; ++i) {
            cb = (KDCheckBox)this.panelBenefitItem2.getComponent(i);
            if (!cb.isSelected()) continue;
            this.benefitColl.add((BenefitInfo)cb.getUserObject());
        }
        if (this.benefitColl.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFITITEM_NOTNULL"));
            return false;
        }
        return super.verify();
    }

    protected void chkNotIn_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.chkNotIn.isSelected() && !this.chkOff.isSelected()) {
            this.prmtAdminOrgUnit.setEnabled(true);
            this.chkIsLowLevel.setEnabled(true);
        }
    }

    protected void chkOff_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.chkNotIn.isSelected() && !this.chkOff.isSelected()) {
            this.prmtAdminOrgUnit.setEnabled(true);
            this.chkIsLowLevel.setEnabled(true);
        }
    }
}

