/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.util;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.ObjectUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtil {
    public static void addNodes(KDTree tree, KDTreeNode[] treeNodes, Set extendedNodes) throws CloneNotSupportedException {
        assert (tree != null && treeNodes != null);
        KDTreeNode root = (KDTreeNode)tree.getModel().getRoot();
        extendedNodes.addAll(TreeUtil.getExpendedNodes(tree));
        int length = treeNodes.length;
        for (int i = 0; i < length; ++i) {
            KDTreeNode node = (KDTreeNode)ObjectUtils.createCopy((Object)treeNodes[i]);
            root = TreeUtil.createRootForAdd(root, node);
        }
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)root);
    }

    private static KDTreeNode createRootForAdd(KDTreeNode root, KDTreeNode addNode) {
        DataBaseInfo pIAdd;
        Map mapRoot = TreeUtil.getNodeMap(root);
        if (mapRoot.containsKey((pIAdd = TreeUtil.getTreeNodeObject(addNode)).getId())) {
            if (pIAdd instanceof TechnicalPostInfo) {
                return root;
            }
            KDTreeNode node = (KDTreeNode)mapRoot.get(pIAdd.getId());
            TreeUtil.mergeNode(addNode, mapRoot);
            root = (KDTreeNode)node.getRoot();
        } else {
            KDTreeNode parent = (KDTreeNode)addNode.getParent();
            if (parent == null) {
                root = addNode;
            } else {
                KDTreeNode parentInRoot = null;
                while (parent != null) {
                    TreeUtil.removeExcludeChilds(parent, addNode);
                    DataBaseInfo piParent = TreeUtil.getTreeNodeObject(parent);
                    if (piParent != null) {
                        if (mapRoot.containsKey(piParent.getId())) {
                            parentInRoot = (KDTreeNode)mapRoot.get(piParent.getId());
                            parentInRoot.add((MutableTreeNode)addNode);
                            break;
                        }
                        addNode = parent;
                    } else if (EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.TECHNICALPOST_TYPE").equals(parent.getUserObject().toString())) {
                        if (root != null) {
                            root.add((MutableTreeNode)addNode);
                            break;
                        }
                        addNode = parent;
                    } else {
                        addNode = parent;
                    }
                    parent = (KDTreeNode)addNode.getParent();
                }
                root = (KDTreeNode)addNode.getRoot();
            }
        }
        return root;
    }

    private static Map getNodeMap(KDTreeNode node) {
        if (node == null) {
            return new HashMap();
        }
        HashMap<BOSUuid, KDTreeNode> mapTarget = new HashMap<BOSUuid, KDTreeNode>(4000);
        Enumeration enumTarget = node.breadthFirstEnumeration();
        while (enumTarget.hasMoreElements()) {
            KDTreeNode nodeTarget = (KDTreeNode)enumTarget.nextElement();
            DataBaseInfo piTarget = TreeUtil.getTreeNodeObject(nodeTarget);
            if (piTarget == null) continue;
            mapTarget.put(piTarget.getId(), nodeTarget);
        }
        return mapTarget;
    }

    private static void mergeNode(KDTreeNode addNode, Map mapRoot) {
        DataBaseInfo piAdd = TreeUtil.getTreeNodeObject(addNode);
        KDTreeNode nodeInRoot = (KDTreeNode)mapRoot.get(piAdd.getId());
        for (int i = addNode.getChildCount() - 1; i >= 0; --i) {
            KDTreeNode childAdd = (KDTreeNode)addNode.getChildAt(i);
            DataBaseInfo piChildAdd = TreeUtil.getTreeNodeObject(childAdd);
            if (mapRoot.containsKey(piChildAdd.getId())) continue;
            nodeInRoot.add((MutableTreeNode)childAdd);
        }
    }

    private static void removeExcludeChilds(KDTreeNode parent, KDTreeNode leftChild) {
        assert (leftChild != null);
        DataBaseInfo piLeftChild = TreeUtil.getTreeNodeObject(leftChild);
        if (parent != null) {
            Enumeration childs = parent.children();
            HashSet<KDTreeNode> setRemove = new HashSet<KDTreeNode>();
            while (childs.hasMoreElements()) {
                KDTreeNode child = (KDTreeNode)childs.nextElement();
                DataBaseInfo piChild = TreeUtil.getTreeNodeObject(child);
                if (piLeftChild.getId().equals((Object)piChild.getId())) continue;
                setRemove.add(child);
            }
            for (KDTreeNode nodeRemove : setRemove) {
                parent.remove((MutableTreeNode)nodeRemove);
            }
        }
    }

    public static Set getExpendedNodes(KDTree tree) {
        HashSet<KDTreeNode> setNode = new HashSet<KDTreeNode>();
        if (tree == null || tree.getModel() == null || tree.getModel().getRoot() == null) {
            return setNode;
        }
        Enumeration enumeration = ((KDTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            KDTreeNode node = (KDTreeNode)enumeration.nextElement();
            TreePath nodePath = new TreePath(node.getPath());
            if (!tree.isExpanded(nodePath)) continue;
            setNode.add(node);
        }
        return setNode;
    }

    public static void removeNodes(KDTree tree, KDTreeNode[] treeNodes) {
        assert (treeNodes != null);
        KingdeeTreeModel model = (KingdeeTreeModel)tree.getModel();
        TreePath path = null;
        int startRow = 0;
        String prefix = null;
        int length = treeNodes.length;
        for (int i = 0; i < length; ++i) {
            prefix = treeNodes[i].getUserObject().toString();
            path = tree.getNextMatch(prefix, startRow, Position.Bias.Forward);
            KDTreeNode node = (KDTreeNode)path.getLastPathComponent();
            model.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    private static DataBaseInfo getTreeNodeObject(KDTreeNode treeNode) {
        if (!(treeNode.getUserObject() instanceof String)) {
            return (DataBaseInfo)treeNode.getUserObject();
        }
        return null;
    }
}

