/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.cadre.client;

import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.cadre.CadreException;
import com.kingdee.eas.hr.cadre.InSupportPageFactory;
import com.kingdee.eas.hr.cadre.InSupportPageInfo;
import com.kingdee.eas.hr.cadre.client.AbstractInSupportPageEditUI;
import com.kingdee.eas.hr.cadre.client.TrainMeasureTypePrompt;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class InSupportPageEditUI
extends AbstractInSupportPageEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InSupportPageEditUI.class);
    private HROrgUnitInfo hroInfo = null;

    public void loadFields() {
        super.loadFields();
    }

    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        super.beforeStoreFields(arg0);
        this.validateData(this.pkInSupportDate, this.pkinSupportEndDate);
    }

    private void validateData(KDDatePicker startDatePicker, KDDatePicker endDatePicker) throws CadreException {
        if (startDatePicker.getValue() != null && endDatePicker.getValue() != null) {
            Date startDate = (Date)startDatePicker.getValue();
            Date endDate = (Date)endDatePicker.getValue();
            if (DateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) {
                throw new CadreException(CadreException.DATE_WRONG);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtTrainMeasureType.setSelector((KDPromptSelector)new TrainMeasureTypePrompt());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InSupportPageFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        InSupportPageInfo objectValue = new InSupportPageInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        PersonInfo pInfo = new PersonInfo();
        String personID = (String)this.getUIContext().get("PersonID");
        pInfo.setId(personID == null ? null : BOSUuid.read((String)personID));
        objectValue.setPerson(pInfo);
        if (personID != null) {
            AdminOrgUnitInfo adminInfo = null;
            PositionInfo postInfo = null;
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
                view.setFilter(filter);
                SelectorItemCollection selectItemColl = new SelectorItemCollection();
                selectItemColl.add("personDep.*");
                selectItemColl.add("primaryPosition.*");
                view.setSelector(selectItemColl);
                PersonPositionCollection coll = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(view);
                PersonPositionInfo personPostInfo = coll.get(0);
                adminInfo = personPostInfo.getPersonDep();
                postInfo = personPostInfo.getPrimaryPosition();
                objectValue.setPersonDep(adminInfo);
                objectValue.setPosition(postInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return objectValue;
    }

    public void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setCU(this.getCurrentCU());
        return super.runSubmit();
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.hroInfo != null) {
            return this.hroInfo.getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.hroInfo != null) {
            return this.hroInfo;
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectValue getValueByPK(IObjectPK pk) throws Exception {
        String recordId = null;
        if (this.getUIContext().get("CUR_OBJ_ID") != null) {
            recordId = this.getUIContext().get("CUR_OBJ_ID").toString();
        }
        if (recordId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)recordId));
            view.put("selector", (Object)this.getMergedSelector());
            view.setFilter(filter);
            CoreBaseCollection pcmCol = this.getBizInterface().getCollection(view);
            if (pcmCol.size() <= 0) {
                this.editData = (InSupportPageInfo)this.createNewData();
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)recordId));
                this.editData.setPerson(person);
            } else {
                this.editData = (InSupportPageInfo)pcmCol.get(0);
            }
            this.setDataObject((IObjectValue)this.editData);
        }
        return this.editData;
    }
}

