/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.CmpAdjExecutorFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.ICmpAdjExecutor;
import com.kingdee.eas.hr.compensation.ICmpAdjustScheme;
import com.kingdee.eas.hr.compensation.client.AbstractAdjustSchemeListUI;
import com.kingdee.eas.hr.compensation.client.AdjustCheckUnAuditMsgUI;
import com.kingdee.eas.hr.compensation.client.AdjustSchemeEditUI;
import com.kingdee.eas.hr.compensation.util.CmpDateUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.IUserPermission;
import com.kingdee.eas.hr.emp.UserPermissionCollection;
import com.kingdee.eas.hr.emp.UserPermissionFactory;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdjustSchemeListUI
extends AbstractAdjustSchemeListUI {
    private static Logger logger = Logger.getLogger(AdjustSchemeListUI.class);
    private static final String COL_STATE = "adjSchemeState";
    private static final String COL_LASTUPDDATE = "lastUpdDate";
    private final String RESC = "com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.";
    private CommonQueryDialog commonQuerydialog = null;
    private boolean isCmp009 = false;

    public AdjustSchemeListUI() throws Exception {
        HRSchemeUtils.checkInit();
        this.intiCtl();
    }

    private void intiCtl() {
        HRUtils.setFocusDir(this.tblMain, 0);
        this.tblMain.getMergeManager().setMergeMode(1);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                AdjustSchemeListUI.this.doSelectChanged(e);
            }
        });
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        filter.setMaskString("#0 and #1");
        try {
            if (this.isCmp009) {
                this.setF7Filter(filter);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return filter;
    }

    private void doSelectChanged(KDTSelectEvent e) {
        IRow row;
        Object obj;
        int rowInd;
        KDTSelectBlock blk = e.getSelectBlock();
        if (blk != null && (rowInd = blk.getBeginRow()) >= 0 && (obj = (row = this.tblMain.getRow(rowInd)).getCell(COL_STATE).getValue()) != null && obj instanceof BizEnumValueInfo) {
            BizEnumValueInfo info = (BizEnumValueInfo)obj;
            String state = (String)info.getValue();
            if (state.equals("10") || state.equals("70")) {
                this.wbtnAudit.setEnabled(true);
                this.menuItemApprove.setEnabled(true);
                this.btnEdit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.menuItemEdit.setEnabled(true);
                this.menuItemRemove.setEnabled(true);
            } else {
                this.wbtnAudit.setEnabled(false);
                this.menuItemApprove.setEnabled(false);
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.menuItemEdit.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            }
            if ("30".equals(state)) {
                this.menuItemCancelAudit.setEnabled(true);
            } else {
                this.menuItemCancelAudit.setEnabled(false);
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.wbtnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.wbtnAudit.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.AUDIT"));
        this.wbtnAudit.setEnabled(true);
        this.menuItemApprove.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.toolBar.add((Component)this.wbtnAudit);
        this.toolBar.remove((Component)this.btnAuditResult);
        this.toolBar.add((Component)this.btnAuditResult);
        this.toolBar.remove((Component)this.btnAdjNameList);
        this.toolBar.add((Component)this.btnAdjNameList);
        this.btnImportData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.toolBar.remove((Component)this.btnImportData);
        this.toolBar.add((Component)this.btnImportData);
        this.MenuItemAttachment.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.tblMain.setColumnMoveable(true);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected String getEditUIName() {
        return AdjustSchemeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CmpAdjustSchemeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        if (HRParamUtil.getParamOfHR(null, (String)"hr_cmp_009", (String)HRO_ID)) {
            this.isCmp009 = true;
        }
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(15);
        this.btnAttachment.setVisible(false);
        CmpDateUtils.setColumnDateTimeFormat(this.tblMain, new String[]{"effectDate", COL_LASTUPDDATE});
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getOnloadPermItemName() {
        return super.getOnloadPermItemName();
    }

    @Override
    public void actionAdjNameList_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> lstAdjSchNumList = new ArrayList<String>();
        KDTSelectBlock sb = null;
        String adjSchNum = null;
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int j = 0;
            int bottom = 0;
            if (sb.getMode() == 8 || sb.getMode() == 4) {
                j = 0;
                bottom = this.tblMain.getRowCount();
            } else {
                j = sb.getTop();
                bottom = sb.getBottom() + 1;
            }
            while (j < bottom) {
                adjSchNum = this.tblMain.getRow(j).getCell("adjSchNum").getValue().toString();
                lstAdjSchNumList.add(adjSchNum);
                ++j;
            }
        }
        if (lstAdjSchNumList.size() <= 0) {
            return;
        }
        Map ctx = this.getUIContext();
        ctx.put("adjSchNum", lstAdjSchNumList);
        IUIWindow adjEditUI = UIFactory.createUIFactory((String)this.getEditUIModal()).create("com.kingdee.eas.hr.compensation.client.AdjNameListReportUI", ctx, null, OprtState.VIEW);
        adjEditUI.show();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() != 1 || this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.SELECT_ONE_ADJSCHEME"));
            return;
        }
        KDTBlock block = (KDTBlock)blocks.get(0);
        IRow row = this.tblMain.getRow(block.getTop());
        if (row != null && row.getCell("id") != null && row.getCell("id").getValue() != null) {
            HashMap errorMap = FixedCmpSchemeFacadeFactory.getRemoteInstance().checkAdjDateByAdjSch(row.getCell("id").getValue().toString());
            String errorMessage = null;
            if (errorMap != null) {
                List invalidList = (List)errorMap.get("invalidList");
                Map adjPerIndexMap = (Map)errorMap.get("adjPerIndexMap");
                errorMessage = this.makeErrorMessage(invalidList, adjPerIndexMap);
            }
            if (errorMessage != null && !errorMessage.equals("")) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.ADJ_EFFECTDATE_INVALID"), (String)errorMessage, (int)8188);
                SysUtil.abort();
            }
        }
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.CONFIRM_AUDIT")) == 2) {
            return;
        }
        if (row != null && row.getCell("id") != null && row.getCell("id").getValue() != null) {
            Object obj = row.getCell("id").getValue();
            String adjSchID = (String)obj;
            ICmpAdjustScheme adjSch = CmpAdjustSchemeFactory.getRemoteInstance();
            adjSch.audit(BOSUuid.read((String)adjSchID));
        }
        this.actionRefresh_actionPerformed(e);
    }

    private void adjustFixTable() throws Exception {
        ICmpAdjExecutor iae = CmpAdjExecutorFactory.getRemoteInstance();
        iae.updCmpSchDataBySch("753b5d57-0108-1000-e000-05fbc0a81248E73377F8");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.HRO;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQuerydialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQuerydialog = super.initCommonQueryDialog();
        }
        return this.commonQuerydialog;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK orgPK = null;
        if (SysContext.getSysContext().getCurrentHRUnit() != null) {
            orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentHRUnit().getId());
        }
        return orgPK;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    @Override
    public void actionCancelAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() != 1 || this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.SELECT_ONE_ADJSCHEME"));
            return;
        }
        KDTBlock block = (KDTBlock)blocks.get(0);
        IRow row = this.tblMain.getRow(block.getTop());
        Object obj = null;
        String strNumber = null;
        if (row != null && row.getCell("id") != null && row.getCell("id").getValue() != null) {
            obj = row.getCell("id").getValue();
            strNumber = row.getCell("adjSchNum").getValue().toString();
        }
        String adjSchID = null;
        BizEnumValueInfo enable = (BizEnumValueInfo)HRTableTools.getTableSelectCellValue(this.tblMain, COL_STATE);
        if (obj == null || enable == null || enable.getInt() != 30) {
            return;
        }
        adjSchID = (String)obj;
        CmpAdjustSchemeInfo cmpAdjustSchemeInfo = CmpAdjustSchemeFactory.getRemoteInstance().getCmpAdjustSchemeInfo("where id = '" + adjSchID + "'");
        if (cmpAdjustSchemeInfo != null && cmpAdjustSchemeInfo.isIsHistoryData()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource", (String)"ADJ_ZHUJI_NOTCALAU"));
            return;
        }
        if (this.isAlreadyInAdjustScheme(adjSchID)) {
            SysUtil.abort();
        }
        if (MsgBox.showConfirm2((String)(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"113_AdjustSchemeListUI") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"114_AdjustSchemeListUI") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"115_AdjustSchemeListUI") + EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"116_AdjustSchemeListUI"))) != 0) {
            return;
        }
        ICmpAdjustScheme adjSch = CmpAdjustSchemeFactory.getRemoteInstance();
        IRowSet rowSet = adjSch.checkIsCanUnAudit(adjSchID);
        if (rowSet != null && rowSet.size() > 0) {
            this.getUIContext().put("MsgData", rowSet);
            this.getUIContext().put("adjustScheme", strNumber);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(AdjustCheckUnAuditMsgUI.class.getName(), this.getUIContext());
            uiWindow.show();
        } else {
            adjSch.cancelAudit(adjSchID);
            this.actionRefresh_actionPerformed(e);
        }
    }

    private boolean isAlreadyInAdjustScheme(String strAdjSchemeID) throws EASBizException, BOSException {
        HashMap mapAlreadyInAdjustScheme = CmpAdjExecutorFactory.getRemoteInstance().getAlreadyInAdjustScheme(null, strAdjSchemeID);
        if (mapAlreadyInAdjustScheme == null || mapAlreadyInAdjustScheme.size() <= 0) {
            return false;
        }
        StringBuffer strAlreadyInAdjustScheme = new StringBuffer();
        Iterator it = mapAlreadyInAdjustScheme.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            if (!StringUtils.isEmpty((String)strAlreadyInAdjustScheme.toString())) {
                strAlreadyInAdjustScheme.append(",");
                strAlreadyInAdjustScheme.append(entry.getValue().toString());
                continue;
            }
            strAlreadyInAdjustScheme.append(entry.getValue().toString());
        }
        MsgBox.showInfo((String)HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"720_AdjustSchemeListUI", (String[])new String[]{strAlreadyInAdjustScheme.toString()}));
        return true;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2New((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource", (String)"ADJ_ZHUJI_1") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource", (String)"ADJ_ZHUJI_2") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource", (String)"ADJ_ZHUJI_3") + "\n" + EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchListUIResource", (String)"ADJ_ZHUJI_4"))) != 0) {
            return;
        }
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new CmpAdjustSchemeInfo().getBOSType(), null, (String)SysContext.getSysContext().getCurrentUserInfo().getName(), (String)"cmpadjSch_import");
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(this.getImportParam(), 0, true);
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.hr.compensation.adjustSchemeHistory";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.AdjSchEditUIResource.ADJUST_TITLE");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private void setF7Filter(FilterInfo cmpAdjustSchemeFilter) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        IUserPermission iup = UserPermissionFactory.getRemoteInstance();
        UserPermissionCollection collection = iup.getUserPermissionCollection(viewInfo);
        String filterString = null;
        if (collection != null && collection.size() > 0) {
            filterString = collection.get(0).getFilter();
        }
        if (filterString == null) {
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmpInfoQuery");
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        filter = new FilterInfo(filterString);
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        iQe.setObjectView(viewInfo);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adjEmp.id", (Object)iQe.getSQL(), CompareType.INNER));
        cmpAdjustSchemeFilter.mergeFilter(filter, "and");
    }

    private String makeErrorMessage(List invalidList, Map adjPerIndexMap) {
        String RESC = "com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.";
        StringBuffer errorMessage = new StringBuffer("");
        String[] adjPerIndex = null;
        int size = invalidList.size();
        for (int i = 0; i < size; ++i) {
            adjPerIndex = StringUtil.split((String)((String)adjPerIndexMap.get(invalidList.get(i))), (String)"&&");
            errorMessage.append(HRResourceUtils.getMessage((String)RESC, (String)"27_ADJ", (String[])new String[]{adjPerIndex[0], adjPerIndex[1], adjPerIndex[2]}) + "\n");
        }
        return errorMessage.toString();
    }
}

