/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.client.AbstractBIReportCmpFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BIReportCmpFilterUI
extends AbstractBIReportCmpFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BIReportCmpFilterUI.class);
    private String resClass = "com.kingdee.eas.hr.compensation.client.CmpReportResource.";
    private boolean isShowDepartment = true;
    private final String separator = "!";
    private Object tempScheme = null;

    public BIReportCmpFilterUI() throws Exception {
        this.init();
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this), new Component[]{this.listAllItems, this.listItemsSelected});
        RptParams params = rcm.toRptParams();
        if (this.rbDepartment.isSelected()) {
            params.setString("choosed", "adminOrgUnitCmp");
        }
        if (this.rbPositioin.isSelected()) {
            params.setString("choosed", "positionCmp");
        }
        if (this.rbGrade.isSelected()) {
            params.setString("choosed", "gradeCmp");
        }
        if (this.rbLevel.isSelected()) {
            params.setString("choosed", "levelCmp");
        }
        if (this.rbEmployeeClassify.isSelected()) {
            params.setString("choosed", "classifyCmp");
        }
        HashSet<String> selectedItems = new HashSet<String>();
        int size = this.listItemsSelected.getElementCount();
        for (int i = 0; i < size; ++i) {
            selectedItems.add(((CmpItemInfo)this.listItemsSelected.getElement(i)).getNumber());
        }
        params.setObject("selectedItems", selectedItems);
        return params;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        StringBuffer selectedItems = new StringBuffer();
        int size = this.listItemsSelected.getElementCount();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                selectedItems.append("!");
            }
            selectedItems.append(((CmpItemInfo)this.listItemsSelected.getElement(i)).getNumber());
        }
        if (!StringUtils.isEmpty((String)selectedItems.toString())) {
            cp.addCustomerParam("itemsInList", selectedItems.toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (!StringUtils.isEmpty((String)cp.getCustomerParam("itemsInList"))) {
            String[] items = StringUtils.split((String)cp.getCustomerParam("itemsInList"), (String)"!");
            CmpItemInfo itemInfo = null;
            block0: for (int i = 0; i < items.length; ++i) {
                for (int j = 0; j < this.listAllItems.getElementCount(); ++j) {
                    itemInfo = (CmpItemInfo)this.listAllItems.getElement(j);
                    if (!itemInfo.getNumber().equals(items[i])) continue;
                    this.listItemsSelected.addElement((Object)itemInfo);
                    this.listAllItems.removeElement((Object)itemInfo);
                    continue block0;
                }
            }
            if (this.listAllItems.getElementCount() > 0) {
                this.listAllItems.setSelectedIndex(0);
            }
            if (this.listItemsSelected.getElementCount() > 0) {
                this.listItemsSelected.setSelectedIndex(0);
            }
        }
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager m = new RptConditionManager(params);
        m.restoreAllStatus((Container)((Object)this));
        this.updateFilterUIShow();
    }

    public boolean verify() {
        CmpSchemeInfo cmpSchemeInfo = null;
        cmpSchemeInfo = (CmpSchemeInfo)this.prmtCmpScheme.getData();
        if (cmpSchemeInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "MESSAGE_NOT_SELECTCMPSCHEME")));
            return false;
        }
        CmpPeriodInfo cmpPeriodInfo = null;
        cmpPeriodInfo = (CmpPeriodInfo)this.prmtCmpPeriod.getData();
        if (cmpPeriodInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "MESSAGE_CMPPERIODNOTNULL")));
            return false;
        }
        if (this.listItemsSelected.getElementCount() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "MESSAGE_CMPITEMNOTNULL")));
            return false;
        }
        return true;
    }

    public void clear() {
        this.prmtCmpPeriod.setValue(null);
        this.prmtCmpScheme.setValue(null);
        this.prmtDepartment.setValue(null);
        this.rbDepartment.setSelected(true);
        this.tempScheme = null;
        this.updateFilterUIShow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnLeft.setEnabled(true);
        this.btnAllLeft.setEnabled(true);
        this.btnRight.setEnabled(true);
        this.btnAllRight.setEnabled(true);
        this.listAllItems.setSelectionMode(0);
        this.listItemsSelected.setSelectionMode(0);
        this.updateFilterUIShow();
    }

    private void init() {
        this.prmtCmpScheme = HRSchemeUtils.getDefaultCmpSchemeF7(this.prmtCmpScheme);
        this.prmtCmpPeriod = HRSchemeUtils.getDefaultCmpPeriodF7(this.prmtCmpPeriod);
        this.prmtDepartment = HRSchemeUtils.getDefaultDeptF7NoHR(this.prmtDepartment);
        this.bgDimension.add((AbstractButton)this.rbDepartment);
        this.bgDimension.add((AbstractButton)this.rbGrade);
        this.bgDimension.add((AbstractButton)this.rbLevel);
        this.bgDimension.add((AbstractButton)this.rbPositioin);
        this.bgDimension.add((AbstractButton)this.rbEmployeeClassify);
        this.listAllItems.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        BIReportCmpFilterUI.this.actionRight_actionPerformed(null);
                    }
                }
                catch (Exception exc) {
                    BIReportCmpFilterUI.this.handUIException(exc);
                }
            }
        });
        this.listItemsSelected.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        BIReportCmpFilterUI.this.actionLeft_actionPerformed(null);
                    }
                }
                catch (Exception exc) {
                    BIReportCmpFilterUI.this.handUIException(exc);
                }
            }
        });
        this.prmtCmpScheme.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Object obj = BIReportCmpFilterUI.this.prmtCmpScheme.getData();
                if (obj != null) {
                    if (BIReportCmpFilterUI.this.tempScheme != null && obj.equals(BIReportCmpFilterUI.this.tempScheme)) {
                        return;
                    }
                    BIReportCmpFilterUI.this.tempScheme = obj;
                    CmpSchemeInfo info = (CmpSchemeInfo)obj;
                    try {
                        BIReportCmpFilterUI.this.reloadCmpScheme(info);
                    }
                    catch (Exception e) {
                        BIReportCmpFilterUI.this.handUIException(e);
                    }
                } else {
                    BIReportCmpFilterUI.this.listAllItems.removeAllElements();
                    BIReportCmpFilterUI.this.listItemsSelected.removeAllElements();
                }
            }
        });
        this.rbDepartment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BIReportCmpFilterUI.this.updateFilterUIShow();
            }
        });
        this.rbPositioin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BIReportCmpFilterUI.this.updateFilterUIShow();
            }
        });
        this.rbGrade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BIReportCmpFilterUI.this.updateFilterUIShow();
            }
        });
        this.rbLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BIReportCmpFilterUI.this.updateFilterUIShow();
            }
        });
        this.rbEmployeeClassify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BIReportCmpFilterUI.this.updateFilterUIShow();
            }
        });
    }

    private void updateFilterUIShow() {
        boolean temp = this.isShowDepartment;
        this.setShowDepartment();
        if (temp != this.isShowDepartment) {
            int deY = this.pDepartment.getY();
            int deH = this.pDepartment.getHeight();
            int cmW = this.pCmpItem.getWidth();
            int cmY = this.pCmpItem.getY();
            int cmH = this.pCmpItem.getHeight();
            if (this.isShowDepartment) {
                this.pCmpItem.setSize(cmW, cmH - deH - (this.pDepartment.getY() - this.pDimension.getY() - this.pDimension.getHeight()));
                this.pCmpItem.setLocation(this.pCmpItem.getX(), cmY + deH + (this.pDepartment.getY() - this.pDimension.getY() - this.pDimension.getHeight()));
                this.pAllItems.setSize(this.pAllItems.getWidth(), this.pAllItems.getHeight() - deH - (this.pDepartment.getY() - this.pDimension.getY() - this.pDimension.getHeight()));
                this.pSelectedItems.setSize(this.pSelectedItems.getWidth(), this.pSelectedItems.getHeight() - deH - (this.pDepartment.getY() - this.pDimension.getY() - this.pDimension.getHeight()));
                this.pDepartment.setVisible(true);
            } else {
                this.pDepartment.setVisible(false);
                this.pCmpItem.setSize(cmW, cmH + cmY - deY);
                this.pCmpItem.setLocation(this.pCmpItem.getX(), deY);
                this.pAllItems.setSize(this.pAllItems.getWidth(), this.pAllItems.getHeight() + cmY - deY);
                this.pSelectedItems.setSize(this.pSelectedItems.getWidth(), this.pSelectedItems.getHeight() + cmY - deY);
            }
        }
    }

    private void setShowDepartment() {
        if (this.rbDepartment.isSelected()) {
            this.isShowDepartment = true;
        }
        if (this.rbPositioin.isSelected()) {
            this.isShowDepartment = true;
        }
        if (this.rbGrade.isSelected()) {
            this.isShowDepartment = false;
        }
        if (this.rbLevel.isSelected()) {
            this.isShowDepartment = false;
        }
        if (this.rbEmployeeClassify.isSelected()) {
            this.isShowDepartment = false;
        }
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        int count = this.listItemsSelected.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.listItemsSelected.getElement(0);
                this.listAllItems.addElement((Object)info);
                this.listItemsSelected.removeElement((Object)info);
            }
            this.listAllItems.setSelectedIndex(0);
        }
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        int count = this.listAllItems.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.listAllItems.getElement(0);
                this.listItemsSelected.addElement((Object)info);
                this.listAllItems.removeElement((Object)info);
            }
            this.listItemsSelected.setSelectedIndex(0);
        }
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        if (this.listItemsSelected.getElementCount() <= 0) {
            return;
        }
        int index = this.listItemsSelected.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.listItemsSelected.getElement(index);
            this.listItemsSelected.removeElement((Object)info);
            this.listAllItems.addElement((Object)info);
            this.listAllItems.setSelectedValue((Object)info, true);
            if (this.listItemsSelected.getElementCount() > 0) {
                this.listItemsSelected.setSelectedIndex(index - 1);
            }
        }
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        if (this.listAllItems.getElementCount() <= 0) {
            return;
        }
        int index = this.listAllItems.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.listAllItems.getElement(index);
            int indexSelect = this.listItemsSelected.getSelectedIndex() + 1;
            this.listItemsSelected.insertElement((Object)info, indexSelect);
            this.listAllItems.removeElement((Object)info);
            if (index - 1 > 0) {
                this.listAllItems.setSelectedIndex(index - 1);
            } else if (this.listAllItems.getElementCount() > 0) {
                this.listAllItems.setSelectedIndex(0);
            }
            this.listItemsSelected.setSelectedValue((Object)info, true);
        }
    }

    private void reloadCmpScheme(CmpSchemeInfo schemeInfo) throws BOSException {
        this.listAllItems.removeAllElements();
        this.listItemsSelected.removeAllElements();
        if (schemeInfo == null) {
            return;
        }
        StringBuffer oql = new StringBuffer(" select cmpitem.name,cmpitem.number,cmpitem.id where cmpitem.datatype=60 and cmpScheme.id ='");
        oql.append(schemeInfo.getId().toString());
        oql.append("' ");
        oql.append(" order by sortOrder asc");
        CmpSchemeItemCollection col = CmpSchemeItemFactory.getRemoteInstance().getCmpSchemeItemCollection(oql.toString());
        if (col != null && col.size() > 0) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                this.listAllItems.addElement((Object)col.get(i).getCmpItem());
            }
            this.listAllItems.setSelectedIndex(0);
        }
    }
}

