/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.IEmployeeType;
import com.kingdee.eas.hr.base.client.EmployeeTypePromptBox;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.client.AbstractCashPaymentIssueFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class CashPaymentIssueFilterUI
extends AbstractCashPaymentIssueFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CashPaymentIssueFilterUI.class);
    private String cmpSchemeF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpSchemeQuery";
    private HROrgUnitInfo hrOrgUnitInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        }
        return this.hrOrgUnitInfo;
    }

    private void initAllEditor() {
        this.prmtCmpScheme.setQueryInfo(this.cmpSchemeF7URL);
        this.prmtCmpScheme.setEditable(false);
        this.prmtCmpScheme.setEditFormat("$name$");
        this.prmtCmpScheme.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoCmpSch = new FilterInfo();
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
        filterInfoCmpSch.setMaskString("#0 and (#1 or #2) and #3");
        FilterInfo adminRangeFilter = HRSchemeUtils.getAdminRangeFilter(null, "adminUser.id");
        if (adminRangeFilter != null) {
            try {
                filterInfoCmpSch.mergeFilter(adminRangeFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        evi.setFilter(filterInfoCmpSch);
        this.prmtCmpScheme.setEntityViewInfo(evi);
        this.tblMain.setEnabled(false);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.kdbizEmpType.setSelector((KDPromptSelector)new EmployeeTypePromptBox());
        this.kdbizEmpType.setEditable(false);
        this.kdbizEmpType.setEnabledMultiSelection(true);
        this.kdbizEmpType.setDisplayFormat("$name$");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        AdminByCurrentHROF7WithOrgRangeFilter adminF7 = new AdminByCurrentHROF7WithOrgRangeFilter();
        adminF7.setMultiSelect(true);
        adminF7.show();
        Object obj = adminF7.getData();
        if (obj != null && obj instanceof Object[]) {
            Object[] units = (Object[])obj;
            int size = units.length;
            for (int i = 0; i < size; ++i) {
                AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)units[i];
                if (this.isExistInTable(unitInfo.getId().toString())) continue;
                IRow row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)unitInfo.getId().toString());
                row.getCell("number").setValue((Object)unitInfo.getNumber());
                row.getCell("name").setValue((Object)unitInfo.getName());
                row.getCell("level").setValue((Object)unitInfo.getLevel());
                row.getCell("longnumber").setValue((Object)unitInfo.getLongNumber());
            }
        }
    }

    public String getSchemeTableName() {
        CmpSchemeInfo cmpSchemeInfo = (CmpSchemeInfo)this.prmtCmpScheme.getData();
        return cmpSchemeInfo.getHorTableName();
    }

    public List getAdminList() {
        ArrayList<String> adminList = new ArrayList<String>();
        int size = this.tblMain.getRowCount();
        IRow iRow = null;
        for (int i = 0; i < size; ++i) {
            iRow = this.tblMain.getRow(i);
            String idString = iRow.getCell("id").getValue().toString();
            adminList.add(idString);
        }
        return adminList;
    }

    public List getEmpTypeList() {
        ArrayList<String> empTypeList = new ArrayList<String>();
        Object[] o = (Object[])this.kdbizEmpType.getData();
        if (o != null && o.length > 0) {
            for (int i = 0; i < o.length; ++i) {
                empTypeList.add(((EmployeeTypeInfo)o[i]).getId().toString());
            }
            if (empTypeList.size() > 0) {
                return empTypeList;
            }
        }
        return null;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CmpSchemeInfo cmpSchemeInfo = (CmpSchemeInfo)this.prmtCmpScheme.getData();
        cp.addCustomerParam("cmpSchemeId", cmpSchemeInfo.getId().toString());
        int size = this.tblMain.getRowCount();
        StringBuffer compUnitIds = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            compUnitIds.append(row.getCell("id").getValue().toString());
            if (i == size - 1) continue;
            compUnitIds.append("-");
        }
        cp.addCustomerParam("compUnitIds", compUnitIds.toString());
        if (this.kdbizEmpType.getData() != null) {
            Object[] o = (Object[])this.kdbizEmpType.getData();
            EmployeeTypeInfo empTypeInfo = null;
            StringBuffer empTypeId = new StringBuffer();
            String separator = "@";
            for (int i = 0; i < o.length; ++i) {
                empTypeInfo = (EmployeeTypeInfo)o[i];
                if (i < o.length - 1) {
                    empTypeId.append(empTypeInfo.getId().toString()).append("@");
                    continue;
                }
                empTypeId.append(empTypeInfo.getId().toString());
            }
            if (empTypeId.toString().trim().length() > 0) {
                cp.addCustomerParam("empTypeId", empTypeId.toString());
            }
        }
        return cp;
    }

    public void clear() {
        super.clear();
        if (this.prmtCmpScheme.getData() != null) {
            this.prmtCmpScheme.setData(null);
        }
        if (this.kdbizEmpType.getData() != null) {
            this.kdbizEmpType.setData(null);
        }
        this.tblMain.removeRows();
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.kdbizEmpType.setData(null);
        try {
            String cmpSchemeId = cp.getCustomerParam("cmpSchemeId").toString();
            CmpSchemeInfo cmpSchemeInfo = CmpSchemeFactory.getRemoteInstance().getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(cmpSchemeId));
            this.prmtCmpScheme.setData((Object)cmpSchemeInfo);
            String cmpUnitId = cp.getCustomerParam("compUnitIds");
            String[] cmpUnitIds = cmpUnitId.split("-");
            HashSet<String> keySet = new HashSet<String>();
            ArrayList<String> seqList = new ArrayList<String>();
            HashMap<String, AdminOrgUnitInfo> hashMap = new HashMap<String, AdminOrgUnitInfo>();
            int size = cmpUnitIds.length;
            for (int i = 0; i < size; ++i) {
                keySet.add(cmpUnitIds[i]);
                seqList.add(cmpUnitIds[i]);
            }
            EntityViewInfo entityViewInfoTmp = new EntityViewInfo();
            FilterInfo fitlerInfoTmp = new FilterInfo();
            fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
            entityViewInfoTmp.setFilter(fitlerInfoTmp);
            try {
                int i;
                AdminOrgUnitCollection adminOrgCol = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(entityViewInfoTmp);
                int catalogSize = adminOrgCol.size();
                for (i = 0; i < catalogSize; ++i) {
                    AdminOrgUnitInfo adminOrgUnitInfo = adminOrgCol.get(i);
                    hashMap.put(adminOrgUnitInfo.getId().toString(), adminOrgUnitInfo);
                }
                this.tblMain.removeRows();
                int sizeList = seqList.size();
                for (i = 0; i < sizeList; ++i) {
                    IRow iRow = this.tblMain.addRow();
                    AdminOrgUnitInfo adminOrgUnitInfoTmp = (AdminOrgUnitInfo)hashMap.get(seqList.get(i).toString());
                    this.tblMain.checkParsed();
                    iRow.getCell("id").setValue((Object)adminOrgUnitInfoTmp.getId().toString());
                    iRow.getCell("name").setValue((Object)adminOrgUnitInfoTmp.getName().toString());
                    iRow.getCell("number").setValue((Object)adminOrgUnitInfoTmp.getNumber());
                    iRow.getCell("level").setValue((Object)adminOrgUnitInfoTmp.getLevel());
                    iRow.getCell("longnumber").setValue((Object)adminOrgUnitInfoTmp.getLongNumber());
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            if (cp.getCustomerParam("empTypeId") != null) {
                String ids = cp.getCustomerParam("empTypeId");
                String[] empTypeIds = ids.split("@");
                String oql = null;
                IEmployeeType iEmployeeType = EmployeeTypeFactory.getRemoteInstance();
                EmployeeTypeInfo empTypeInfo = null;
                EmployeeTypeCollection c = new EmployeeTypeCollection();
                for (int i = 0; i < empTypeIds.length; ++i) {
                    oql = "select *  where id = '" + empTypeIds[i] + "'";
                    empTypeInfo = iEmployeeType.getEmployeeTypeInfo(oql);
                    c.add(empTypeInfo);
                }
                this.kdbizEmpType.setData((Object)c.toArray());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private boolean isExistInTable(String unitId) {
        boolean isExist = false;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            String strId = this.tblMain.getRow(i).getCell("id").getValue().toString();
            if (!strId.equals(unitId)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() != 0) {
            int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            int size = rowIndexs.length;
            for (int i = size - 1; i >= 0; --i) {
                this.tblMain.removeRow(rowIndexs[i]);
            }
        }
    }

    public boolean verify() {
        if (this.prmtCmpScheme.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"162_CashPaymentIssueFilterUI"));
            return false;
        }
        if (this.tblMain.getRowCount() > 500) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"163_CashPaymentIssueFilterUI"));
            return false;
        }
        if (this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"164_CashPaymentIssueFilterUI"));
            return false;
        }
        if (!this.verifyCmpItem()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"165_CashPaymentIssueFilterUI"));
            return false;
        }
        return true;
    }

    private boolean verifyCmpItem() {
        CmpSchemeInfo cmpSchemeInfo = (CmpSchemeInfo)this.prmtCmpScheme.getData();
        String oql = "SELECT * WHERE cmpItem.number='FFSAL230' AND cmpScheme.id='" + cmpSchemeInfo.getId().toString() + "'";
        try {
            CmpSchemeItemCollection cmpSchemeCol = CmpSchemeItemFactory.getRemoteInstance().getCmpSchemeItemCollection(oql);
            if (cmpSchemeCol.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return false;
    }
}

