/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeException;
import com.kingdee.eas.hr.compensation.client.AbstractCmpAdjustiveReportFilter;
import com.kingdee.eas.hr.compensation.client.CmpReportFilterBaseUI;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class CmpAdjustiveReportFilter
extends AbstractCmpAdjustiveReportFilter {
    private static final Logger logger = CoreUIObject.getLogger(CmpAdjustiveReportFilter.class);
    String resClass = "com.kingdee.eas.hr.compensation.client.FixedCmpSchemeResource.";
    private String cmpAdjustiveSchBasicURL = "com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.";
    private final String ALLLISTITEM_CP = "allListItem";
    private final String LSTSELECTITEM_CP = "lstSelectItem";
    private ArrayList hrOrgList;
    private ArrayList adminOrgList;
    private String fixcmpHrOrgId;
    private final String RADIOBTN = "radiobtn";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public String getFixedCmpItemNum() {
        List lstFixedCmpItem = this.getListSelectItem();
        CmpItemInfo info = null;
        String numbers = "";
        int n = lstFixedCmpItem.size();
        for (int i = 0; i < n; ++i) {
            info = (CmpItemInfo)lstFixedCmpItem.get(i);
            numbers = i == 0 ? info.getNumber() : numbers + "," + info.getNumber();
        }
        return numbers;
    }

    public void clear() {
        super.clear();
        this.btnCmpDate.setSelected(true);
        this.pkBeginDate.setValue((Object)new java.util.Date());
        this.pkEndDate.setValue((Object)new java.util.Date());
        this.prmtAdminF7.setData(null);
        this.chkShowSealUp.setSelected(false);
        this.radiobtn0.setSelected(true);
        if (this.adminOrgList != null) {
            this.adminOrgList.clear();
        }
        if (this.hrOrgList != null) {
            this.hrOrgList.clear();
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        CompUtils.initF7ForMutilSelectOrg(this.prmtAdminF7, false);
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    @Override
    protected void chkShowSealUp_itemStateChanged(ItemEvent e) throws Exception {
        CompUtils.initF7ForMutilSelectOrg(this.prmtAdminF7, this.chkShowSealUp.isSelected());
    }

    protected void initListener() {
        super.initListener();
        this.prmtAdminF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    CmpAdjustiveReportFilter.this.lstAllItem.removeAllElements();
                    CmpAdjustiveReportFilter.this.lstSelectItem.removeAllElements();
                    CmpAdjustiveReportFilter.this.adminOrgList = CmpAdjustiveReportFilter.this.getAdminOrgUnitList();
                    if (CmpAdjustiveReportFilter.this.adminOrgList != null && CmpAdjustiveReportFilter.this.adminOrgList.size() > 0) {
                        CmpAdjustiveReportFilter.this.hrOrgList = CmpAdjustiveReportFilter.this.getHrOrgUnitList(CmpAdjustiveReportFilter.this.adminOrgList);
                        CmpItemCollection itemCol = CmpAdjustiveReportFilter.this.getCmpItemCollection();
                        CmpAdjustiveReportFilter.this.fillCmpItem(itemCol);
                    }
                }
                catch (Exception exc) {
                    CmpAdjustiveReportFilter.this.handUIException(exc);
                }
            }
        });
    }

    private void fillCmpItem(CmpItemCollection itemCol) {
        Iterator itemIterator = itemCol.iterator();
        while (itemIterator.hasNext()) {
            CmpItemInfo fixItem = (CmpItemInfo)itemIterator.next();
            this.lstAllItem.addElement((Object)fixItem);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putDate("beginDate", (java.util.Date)this.pkBeginDate.getSqlDate());
        cp.putDate("endDate", (java.util.Date)this.pkEndDate.getSqlDate());
        cp.addCustomerParam("btnCmpDate", String.valueOf(this.btnCmpDate.isSelected()));
        cp.addCustomerParam("btnEnableDate", String.valueOf(this.btnEnableDate.isSelected()));
        if (this.prmtAdminF7.getData() != null) {
            ArrayList adminlist = this.getAdminOrgUnitList();
            String adminOrgStr = HRUtils.getOrgIdString(adminlist);
            cp.addCustomerParam("adminOrgUnit", adminOrgStr);
        }
        cp.addCustomerParam(this.ALLLISTITEM_CP, this.allListStr());
        cp.addCustomerParam(this.LSTSELECTITEM_CP, this.selectListStr());
        cp.addCustomerParam("displayAllName", String.valueOf(this.displayAllName.isSelected()));
        cp.addCustomerParam("emptyDisplayNull", String.valueOf(this.emptyDisplayNull.isSelected()));
        cp.addCustomerParam("isShowSealUp", String.valueOf(this.chkShowSealUp.isSelected()));
        if (this.radiobtn0.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn0");
        } else if (this.radiobtn2.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn2");
            cp.addCustomerParam("level", this.levelComboBox.getSelectedItem().toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("radiobtn") == null || cp.getCustomerParam("radiobtn").equals("radiobtn0")) {
            this.radiobtn0.setSelected(true);
        } else if (cp.getCustomerParam("radiobtn").equals("radiobtn2")) {
            this.radiobtn2.setSelected(true);
            String level = cp.getCustomerParam("level");
            this.levelComboBox.setSelectedIndex(Integer.parseInt(level) - 1);
        }
        if (cp.getCustomerParam("btnCmpDate") != null) {
            this.btnCmpDate.setSelected(Boolean.valueOf(cp.getCustomerParam("btnCmpDate")).booleanValue());
        }
        if (cp.getCustomerParam("btnEnableDate") != null) {
            this.btnEnableDate.setSelected(Boolean.valueOf(cp.getCustomerParam("btnEnableDate")).booleanValue());
        }
        if (cp.getCustomerParam("beginDate") != null) {
            this.pkBeginDate.setValue((Object)cp.getDate("beginDate"));
        }
        if (cp.getCustomerParam("endDate") != null) {
            this.pkEndDate.setValue((Object)cp.getDate("endDate"));
        }
        if (cp.getCustomerParam("displayAllName") != null) {
            this.displayAllName.setSelected(Boolean.valueOf(cp.getCustomerParam("displayAllName")).booleanValue());
        }
        if (cp.getCustomerParam("emptyDisplayNull") != null) {
            this.emptyDisplayNull.setSelected(Boolean.valueOf(cp.getCustomerParam("emptyDisplayNull")).booleanValue());
        }
        if (cp.getCustomerParam("isShowSealUp") != null) {
            this.chkShowSealUp.setSelected(Boolean.valueOf(cp.getCustomerParam("isShowSealUp")).booleanValue());
        }
        if (cp.getCustomerParam("adminOrgUnit") != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            String orgIds = cp.getCustomerParam("adminOrgUnit");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgIds, CompareType.INNER));
            entityViewInfo.setFilter(filterInfo);
            try {
                AdminOrgUnitCollection admOrgCollection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(entityViewInfo);
                this.prmtAdminF7.setData((Object)admOrgCollection.toArray());
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.adminOrgList = this.getAdminOrgUnitList();
        } else {
            this.prmtAdminF7.setData(null);
        }
        String allListStr = cp.getCustomerParam(this.ALLLISTITEM_CP);
        this.setAllItem(allListStr);
        String ids = cp.getCustomerParam(this.LSTSELECTITEM_CP);
        this.setLstSelectItem(ids);
    }

    public boolean verify() {
        boolean flagOfDate = false;
        boolean flagOfDateTemp = false;
        Date beginDate = this.pkBeginDate.getSqlDate();
        Date endDate = this.pkEndDate.getSqlDate();
        if (beginDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.cmpAdjustiveSchBasicURL + "NEED_DATE")));
            return false;
        }
        if (endDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.cmpAdjustiveSchBasicURL + "NEED_DATE")));
            return false;
        }
        flagOfDateTemp = DateTimeUtils.dayEquals((java.util.Date)endDate, (java.util.Date)beginDate);
        if (!flagOfDateTemp) {
            flagOfDate = DateTimeUtils.dayAfter((java.util.Date)endDate, (java.util.Date)beginDate);
            if (!flagOfDate) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.cmpAdjustiveSchBasicURL + "BEGINDATE_AFTER_ENDDATE")));
                this.pkEndDate.requestFocusInWindow();
            }
        } else {
            flagOfDate = true;
        }
        if (this.hrOrgList != null && this.hrOrgList.size() == 0 && this.adminOrgList != null && this.adminOrgList.size() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "MSG_ADMIN_ORG_NOTEXITS_HR_ORG")));
            this.prmtAdminF7.requestFocusInWindow();
            return false;
        }
        if (this.adminOrgList != null && this.adminOrgList.size() > 0 && this.lstSelectItem.getElementCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "MSG_CHOOSE_FIXED_CMPITEM")));
            this.lstAllItem.requestFocusInWindow();
            return false;
        }
        return flagOfDate;
    }

    public ArrayList getAdminOrgUnitList() {
        Object adminOrg = this.prmtAdminF7.getData();
        ArrayList<AdminOrgUnitInfo> orgUnitList = new ArrayList<AdminOrgUnitInfo>();
        if (adminOrg != null) {
            AdminOrgUnitInfo[] info = this.getAdminOrgUnitInfoArrayByObject((Object[])adminOrg);
            int size = info.length;
            for (int i = 0; i < size; ++i) {
                orgUnitList.add(info[i]);
            }
        }
        return orgUnitList;
    }

    private ArrayList getHrOrgUnitList(ArrayList adminOrgList) throws Exception {
        CmpReportFilterBaseUI baseUi = new CmpReportFilterBaseUI();
        ArrayList<HROrgUnitInfo> hrOrgList = baseUi.getSelectHROS(adminOrgList);
        if (hrOrgList == null) {
            hrOrgList = new ArrayList<HROrgUnitInfo>();
            HROrgUnitInfo hro = HRSchemeUtils.getClientHROrgUnitInfo();
            hrOrgList.add(hro);
        }
        return hrOrgList;
    }

    private AdminOrgUnitInfo[] getAdminOrgUnitInfoArrayByObject(Object[] objA) {
        AdminOrgUnitInfo[] info = new AdminOrgUnitInfo[objA.length];
        int size = objA.length;
        for (int i = 0; i < size; ++i) {
            info[i] = (AdminOrgUnitInfo)objA[i];
        }
        return info;
    }

    public List getListSelectItem() {
        ArrayList<CmpItemInfo> listSelectList = new ArrayList<CmpItemInfo>();
        int countListSelectItem = this.lstSelectItem.getElementCount();
        if (countListSelectItem > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < countListSelectItem; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(i);
                listSelectList.add(i, info);
            }
        }
        return listSelectList;
    }

    private CmpItemCollection getCmpItemCollection() throws Exception {
        CmpItemCollection cmpItemColl = new CmpItemCollection();
        if (this.hrOrgList.size() == 0) {
            return cmpItemColl;
        }
        CmpReportFilterBaseUI baseUi = new CmpReportFilterBaseUI();
        String fixcmpHrOrgId = baseUi.getRootHROID(this.hrOrgList);
        StringBuffer sql = new StringBuffer("SELECT DISTINCT T1.FNumber ");
        sql.append("FROM T_HR_CMPITEM T1 ");
        sql.append("INNER JOIN T_HR_FixedCmpSchemeItem T2 ON T1.FID = T2.FCmpItemID ");
        sql.append("INNER JOIN T_HR_FixedCmpScheme T3 ON T3.FID = T2.FFixedCmpSchemeID ");
        sql.append("WHERE T3.FHrOrgUnitID IN (");
        int size = this.hrOrgList.size() - 1;
        for (int i = 0; i < size; ++i) {
            sql.append("'");
            sql.append(((HROrgUnitInfo)this.hrOrgList.get(i)).getId());
            sql.append("',");
        }
        sql.append("'");
        sql.append(((HROrgUnitInfo)this.hrOrgList.get(this.hrOrgList.size() - 1)).getId());
        sql.append("')");
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)fixcmpHrOrgId));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)sql.toString(), CompareType.INNER));
        filterInfo.setMaskString("#0 and #1");
        env.setFilter(filterInfo);
        cmpItemColl = CmpItemFactory.getRemoteInstance().getCmpItemCollection(env);
        return cmpItemColl;
    }

    protected void allLeftToRightItem() {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.insertElement((Object)info, indexSelect);
                this.lstAllItem.removeElement((Object)info);
                ++indexSelect;
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    protected void leftToRight() {
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeft_actionPerformed(e);
        this.rightToLeft();
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllLeft_actionPerformed(e);
        this.allRightToLeftItem();
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionRight_actionPerformed(e);
        this.leftToRight();
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllRight_actionPerformed(e);
        this.allLeftToRightItem();
    }

    protected void allRightToLeftItem() {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                this.lstAllItem.addElement((Object)info);
                this.lstSelectItem.removeElement((Object)info);
            }
            if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
        }
    }

    protected void rightToLeft() {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElement((Object)info);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
            this.lstAllItem.addElement((Object)info);
            this.lstAllItem.setSelectedIndex(this.lstAllItem.getElementCount() - 1);
        }
    }

    public ArrayList getHrOrgList() throws FixedCmpSchemeException, Exception {
        if (this.hrOrgList == null) {
            this.hrOrgList = this.getHrOrgUnitList(this.adminOrgList);
        }
        if (this.hrOrgList != null && this.hrOrgList.size() <= 0) {
            String hrOrgId = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
            HROrgUnitInfo hrInfo = new HROrgUnitInfo();
            hrInfo.setId(BOSUuid.read((String)hrOrgId));
            this.hrOrgList.add(hrInfo);
        }
        return this.hrOrgList;
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.leftToRight();
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.rightToLeft();
        }
    }

    private String allListStr() {
        StringBuffer allListArray = new StringBuffer();
        int allListItemSize = this.lstAllItem.getElementCount();
        int controlInt = allListItemSize - 1;
        for (int i = 0; i < allListItemSize; ++i) {
            CmpItemInfo cmpItemInfo = (CmpItemInfo)this.lstAllItem.getElement(i);
            allListArray.append(cmpItemInfo.getId().toString());
            if (i == controlInt) continue;
            allListArray.append("~");
        }
        return allListArray.toString();
    }

    private String selectListStr() {
        ArrayList<Object> lstSelectItemData = new ArrayList<Object>();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        return HRCommonQueryUtils.getSelectedItemIDS(lstSelectItemData);
    }

    private void setAllItem(String allListStr) {
        this.lstAllItem.removeAllElements();
        if (allListStr != null) {
            String[] allListStrArray = allListStr.split("~");
            int arrayInt = allListStrArray.length;
            HashSet<String> keySet = new HashSet<String>();
            for (int i = 0; i < arrayInt; ++i) {
                keySet.add(allListStrArray[i]);
            }
            EntityViewInfo entityViewInfoTmp = new EntityViewInfo();
            FilterInfo fitlerInfoTmp = new FilterInfo();
            fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
            entityViewInfoTmp.setFilter(fitlerInfoTmp);
            try {
                CmpItemCollection cmpItemColl = CmpItemFactory.getRemoteInstance().getCmpItemCollection(entityViewInfoTmp);
                int catalogSize = cmpItemColl.size();
                for (int i = 0; i < catalogSize; ++i) {
                    CmpItemInfo cmpItemInfo = cmpItemColl.get(i);
                    this.lstAllItem.addElement((Object)cmpItemInfo);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void setLstSelectItem(String ids) {
        if (ids != null && !"".equals(ids)) {
            try {
                List lstSelectItemData = HRCommonQueryUtils.getSelectedItemList(ids, "~");
                HRCommonQueryUtils.fillSelectItemList(lstSelectItemData, this.lstSelectItem, this.lstAllItem);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }
}

