/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.easprogressbar.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.framework.client.wizard.Wizard;
import com.kingdee.eas.hr.compensation.client.CmpCheckRunnable;
import com.kingdee.eas.hr.compensation.client.CmpWizardPropertyChangeListener;
import com.kingdee.eas.hr.compensation.client.UpdateUIListener;
import com.kingdee.eas.hr.compensation.util.CmpCheckLog;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class CmpCheckWizard
extends Wizard {
    private KDPanel panelProgress = null;
    private KDProgressBar progressBar = null;
    private Vector updateUIListeners = new Vector();
    private CmpCheckRunnable currentRun = null;
    private KDPanel currentProgressContainer = null;
    private HashMap params = new HashMap();
    private Vector cmpWizardPropertyChangeListeners = new Vector();
    private volatile boolean isPerformFinish = true;

    private void initProgressBar() {
        if (this.panelProgress == null) {
            this.panelProgress = new KDPanel();
            this.panelProgress.setVisible(true);
        }
        if (this.progressBar == null) {
            this.progressBar = new KDProgressBar();
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(100);
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("");
            this.progressBar.setVisible(true);
        }
    }

    public void setCurrentRun(CmpCheckRunnable run) {
        this.currentRun = run;
    }

    public void addParameter(String key, Object value) {
        if (value == null || key == null) {
            return;
        }
        this.params.put(key, value);
    }

    public Object getParameter(String key) {
        return this.params.get(key);
    }

    public HashMap getConditionsSetted() {
        return this.params;
    }

    public void setProgressBarBounds(Rectangle rec, KDPanel pageContainer) {
        if (pageContainer == null || rec == null) {
            return;
        }
        if (this.panelProgress == null || this.progressBar == null) {
            this.initProgressBar();
        }
        if (this.currentProgressContainer != null) {
            this.panelProgress.remove((Component)this.progressBar);
            this.panelProgress.validate();
            this.currentProgressContainer.remove((Component)this.panelProgress);
            this.currentProgressContainer.validate();
        }
        this.panelProgress.setBounds(new Rectangle(rec.x, rec.y, rec.width, rec.height));
        this.panelProgress.setLayout(null);
        pageContainer.add((Component)this.panelProgress, null);
        this.progressBar.setBounds(new Rectangle(0, 0, rec.width, rec.height));
        this.panelProgress.add((Component)this.progressBar, null);
        this.currentProgressContainer = pageContainer;
        this.currentProgressContainer.validate();
    }

    public boolean performFinish() {
        return this.isPerformFinish;
    }

    public void setIsPerformFinish(boolean isPerformFinish) {
        this.isPerformFinish = isPerformFinish;
    }

    public synchronized void addUpdateUIListener(UpdateUIListener listener) {
        if (!this.updateUIListeners.contains(listener)) {
            this.updateUIListeners.add(listener);
        }
    }

    public synchronized void removeUpdateUIListener(UpdateUIListener listener) {
        this.updateUIListeners.remove(listener);
    }

    public synchronized void removeAllUpdateUIListeners() {
        this.updateUIListeners.clear();
    }

    public synchronized void addCmpWizardPropertyChangeListener(CmpWizardPropertyChangeListener listener) {
        if (!this.cmpWizardPropertyChangeListeners.contains(listener)) {
            this.cmpWizardPropertyChangeListeners.add(listener);
        }
    }

    public synchronized void removeCmpWizardPropertyChangeListener(CmpWizardPropertyChangeListener listener) {
        this.cmpWizardPropertyChangeListeners.remove(listener);
    }

    public synchronized void removeAllCmpWizardPropertyChangeListeners() {
        this.cmpWizardPropertyChangeListeners.clear();
    }

    public final void run() {
        if (this.currentRun == null || this.currentProgressContainer == null) {
            return;
        }
        this.onPreparedToRun();
        Thread taskThread = new Thread(){

            @Override
            public void run() {
                try {
                    CmpCheckWizard.this.currentRun.run();
                    CmpCheckLog taskLog = CmpCheckWizard.this.currentRun.getRunLog();
                    UpdateUIRunnable update = new UpdateUIRunnable();
                    update.setCmpCheckLog(taskLog);
                    SwingUtilities.invokeLater(update);
                }
                catch (Exception e) {
                    UpdateUIRunnable update = new UpdateUIRunnable();
                    update.setException(e);
                    SwingUtilities.invokeLater(update);
                    return;
                }
                finally {
                    if (CmpCheckWizard.this.progressBar.isIndeterminate()) {
                        CmpCheckWizard.this.progressBar.setIndeterminate(false);
                    }
                }
            }
        };
        taskThread.start();
    }

    private void onFinishedRunning() {
        if (this.updateUIListeners != null) {
            int size = this.updateUIListeners.size();
            for (int i = 0; i < size; ++i) {
                ((UpdateUIListener)this.updateUIListeners.get(i)).processAfterRun();
            }
        }
        this.progressBar.setIndeterminate(false);
    }

    private void onPreparedToRun() {
        if (this.updateUIListeners != null) {
            int size = this.updateUIListeners.size();
            for (int i = 0; i < size; ++i) {
                ((UpdateUIListener)this.updateUIListeners.get(i)).processBeforeRun();
            }
        }
        this.panelProgress.setVisible(true);
        this.progressBar.setIndeterminate(true);
    }

    protected void processCheckSuccess() {
        if (this.updateUIListeners != null) {
            Object listener = null;
            int size = this.updateUIListeners.size();
            for (int i = 0; i < size; ++i) {
                listener = this.updateUIListeners.get(i);
                ((UpdateUIListener)listener).processCheckSuccess();
            }
        }
    }

    protected void processCheckLog(CmpCheckLog log) {
        if (this.updateUIListeners != null) {
            Object listener = null;
            int size = this.updateUIListeners.size();
            for (int i = 0; i < size; ++i) {
                listener = this.updateUIListeners.get(i);
                ((UpdateUIListener)listener).processCheckLog(log);
            }
        }
    }

    protected void processCheckException(Exception e) {
        if (this.updateUIListeners != null) {
            Object listener = null;
            int size = this.updateUIListeners.size();
            for (int i = 0; i < size; ++i) {
                listener = this.updateUIListeners.get(i);
                ((UpdateUIListener)listener).processCheckException(e);
            }
        }
    }

    public final void firePropertyChangeListener(final Object param) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.firePropertyChange(param);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CmpCheckWizard.this.firePropertyChange(param);
                }
            });
        }
    }

    private void firePropertyChange(Object param) {
        if (this.cmpWizardPropertyChangeListeners != null) {
            Object listener = null;
            int size = this.cmpWizardPropertyChangeListeners.size();
            for (int i = 0; i < size; ++i) {
                listener = this.cmpWizardPropertyChangeListeners.get(i);
                ((CmpWizardPropertyChangeListener)listener).propertyChanged(param);
            }
        }
    }

    private class UpdateUIRunnable
    implements Runnable {
        private Exception _e = null;
        private CmpCheckLog _log = null;

        private UpdateUIRunnable() {
        }

        public void setException(Exception e) {
            this._e = e;
        }

        public void setCmpCheckLog(CmpCheckLog log) {
            this._log = log;
        }

        @Override
        public void run() {
            if (this._log == null && this._e == null) {
                CmpCheckWizard.this.processCheckSuccess();
                CmpCheckWizard.this.onFinishedRunning();
                return;
            }
            if (this._log != null) {
                CmpCheckWizard.this.processCheckLog(this._log);
                CmpCheckWizard.this.onFinishedRunning();
                return;
            }
            if (this._e != null) {
                CmpCheckWizard.this.processCheckException(this._e);
                CmpCheckWizard.this.onFinishedRunning();
                return;
            }
        }
    }
}

