/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.service.formula.builder.hr.IHRObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.hr.base.MetaInfo;
import com.kingdee.eas.hr.compensation.CmpCommonFacadeFactory;
import com.kingdee.eas.hr.compensation.FormulaCmpItemData;
import com.kingdee.eas.hr.compensation.FormulaFacadeFactory;
import com.kingdee.eas.hr.compensation.IFormulaFacade;
import com.kingdee.eas.hr.compensation.client.AbstractCmpDimensionFilterUI;
import com.kingdee.eas.hr.compensation.client.OrgChangeEnvent;
import com.kingdee.eas.hr.compensation.client.OrgChangeListener;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpDimensionFilterUI
extends AbstractCmpDimensionFilterUI
implements OrgChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(CmpDimensionFilterUI.class);
    private Map mapItemValue = new HashMap();
    private String resClass = "com.kingdee.eas.hr.compensation.client.CmpReportResource.";
    private List lstAllItemData = null;
    private List lstSelectItemData = null;
    private Object adminOrgs = null;
    private List lst = new ArrayList();
    private String hrOrgUnitID = null;

    public CmpDimensionFilterUI() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        int i;
        this.lst = this.getDimensions();
        this.cmbItem.removeAllItems();
        this.cmbItem.addItems(this.lst.toArray());
        ArrayList<String> lstCmpItemNumber = new ArrayList<String>();
        String itemNum = null;
        int size = this.lst.size();
        for (i = 0; i < size; ++i) {
            itemNum = ((MetaInfo)this.lst.get(i)).getName();
            if ("FPER004".equals(itemNum)) continue;
            lstCmpItemNumber.add(itemNum);
        }
        this.mapItemValue = this.getCmpItemData(lstCmpItemNumber);
        if (this.lstAllItemData != null && this.lstSelectItemData != null) {
            this.lstAllItem.removeAllElements();
            this.lstSelectItem.removeAllElements();
            size = this.lstAllItemData.size();
            for (i = 0; i < size; ++i) {
                this.lstAllItem.addElement(this.lstAllItemData.get(i));
            }
            size = this.lstSelectItemData.size();
            for (i = 0; i < size; ++i) {
                this.lstSelectItem.addElement(this.lstSelectItemData.get(i));
            }
        } else {
            this.reloadItemValue((MetaInfo)this.cmbItem.getSelectedItem());
        }
        this.lstAllItem.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        CmpDimensionFilterUI.this.actionRight_actionPerformed(null);
                    }
                }
                catch (Exception exc) {
                    CmpDimensionFilterUI.this.handUIException(exc);
                }
            }
        });
        this.lstSelectItem.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        CmpDimensionFilterUI.this.actionLeft_actionPerformed(null);
                    }
                }
                catch (Exception exc) {
                    CmpDimensionFilterUI.this.handUIException(exc);
                }
            }
        });
        this.cmbItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int state = ie.getStateChange();
                if (state == 1) {
                    MetaInfo info = (MetaInfo)CmpDimensionFilterUI.this.cmbItem.getSelectedItem();
                    try {
                        CmpDimensionFilterUI.this.reloadItemValue(info);
                    }
                    catch (Exception e) {
                        CmpDimensionFilterUI.this.handUIException(e);
                    }
                }
            }
        });
    }

    @Override
    public void orgChanged(OrgChangeEnvent e) throws Exception {
        if (e.getRootOrgID() != null && !e.getRootOrgID().equals(this.hrOrgUnitID)) {
            this.hrOrgUnitID = e.getRootOrgID();
            ArrayList<String> lstCmpItemNumber = new ArrayList<String>();
            String itemNum = null;
            int size = this.lst.size();
            for (int i = 0; i < size; ++i) {
                itemNum = ((MetaInfo)this.lst.get(i)).getName();
                if ("FPER004".equals(itemNum)) continue;
                lstCmpItemNumber.add(itemNum);
            }
            this.mapItemValue = this.getCmpItemData(lstCmpItemNumber);
            this.reloadItemValue((MetaInfo)this.cmbItem.getSelectedItem());
        }
    }

    public DataChangeListener getOrgChangeListener() {
        return new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CmpDimensionFilterUI.this.initOrgListener(eventObj);
            }
        };
    }

    private void reLoadAminOrg(Object data) {
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        if (data == null) {
            return;
        }
        if (data instanceof AdminOrgUnitInfo) {
            this.lstAllItem.addElement(data);
        } else if (data instanceof Object[]) {
            Object[] admins = (Object[])data;
            for (int i = 0; i < admins.length; ++i) {
                this.lstAllItem.addElement(admins[i]);
            }
        }
        if (this.lstAllItem.getElementCount() > 0) {
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    private void initOrgListener(DataChangeEvent eventObj) {
        Object[] data = eventObj.getNewValue();
        if (data != null && data.equals(eventObj.getOldValue())) {
            return;
        }
        if (data instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)data;
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("AdminOrgUnitInfo", unitInfo);
            paramsMap.put("ToLevel", 1);
            try {
                AdminOrgUnitCollection colDept = CmpCommonFacadeFactory.getRemoteInstance().getSubAdminOrgCollection(paramsMap);
                data = colDept.toArray();
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.adminOrgs = data;
        } else {
            this.adminOrgs = data instanceof Object[] ? (((Object[])data).length == 1 ? (((Object[])data)[0] instanceof Object[] ? ((Object[])data)[0] : data) : data) : data;
        }
        MetaInfo item = (MetaInfo)this.cmbItem.getSelectedItem();
        if (item != null && "FPER004".equals(item.getName())) {
            this.reLoadAminOrg(this.adminOrgs);
        }
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstSelectItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            Object info = this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElement(info);
            this.lstAllItem.addElement(info);
            this.lstAllItem.setSelectedValue(info, true);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
        }
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            Object info = null;
            for (int i = 0; i < count; ++i) {
                info = this.lstSelectItem.getElement(0);
                this.lstAllItem.addElement(info);
                this.lstSelectItem.removeElement(info);
            }
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            Object info = null;
            for (int i = 0; i < count; ++i) {
                info = this.lstAllItem.getElement(0);
                this.lstSelectItem.addElement(info);
                this.lstAllItem.removeElement(info);
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstAllItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            Object info = this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement(info, indexSelect);
            this.lstAllItem.removeElement(info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue(info, true);
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            Object info = this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement(info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            Object info = this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement(info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            Object info = this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement(info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            Object info = this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement(info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
    }

    private void reloadItemValue(MetaInfo info) throws Exception {
        if (info == null) {
            return;
        }
        String itemNum = info.getName();
        if ("FPER004".equals(itemNum)) {
            this.reLoadAminOrg(this.adminOrgs);
        } else {
            this.reloadNotAdminItem(itemNum);
        }
    }

    private void reloadNotAdminItem(String itemNum) {
        if (StringUtils.isEmpty((String)itemNum)) {
            return;
        }
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        FormulaCmpItemData data = (FormulaCmpItemData)this.mapItemValue.get(itemNum);
        if (data != null && data.getCmpItemInstList() != null && data.getCmpItemInstList().length > 0) {
            IHRObject[] obj = data.getCmpItemInstList();
            int size = obj.length;
            for (int i = 0; i < size; ++i) {
                this.lstAllItem.addElement((Object)obj[i]);
            }
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    private Map getCmpItemData(List cmpItemList) throws Exception {
        IFormulaFacade formula = FormulaFacadeFactory.getRemoteInstance();
        Map rst = formula.getAllCmpItemInstanceList(cmpItemList, this.hrOrgUnitID);
        return rst;
    }

    public void onLoad() throws Exception {
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        super.onLoad();
    }

    public boolean verify() {
        int i;
        if (this.lstSelectItem.getElementCount() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "MESSAGE_ANANLYNOTNULL")));
            return false;
        }
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        this.lstAllItemData = new ArrayList();
        size = this.lstAllItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstAllItemData.add(this.lstAllItem.getElement(i));
        }
        return true;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        MetaInfo item = (MetaInfo)this.cmbItem.getSelectedItem();
        if (item != null) {
            cp.addCustomerParam("cmbAnalysisCmpItem", item.getName());
            String itemNum = item.getName();
            if ("FPER004".equals(itemNum)) {
                cp.addCustomerParam("lstSelectItem", this.getSelectedItemIDS(this.lstSelectItemData));
            } else {
                cp.addCustomerParam("lstSelectItem", HRCommonQueryUtils.getSelectedItemIDS(this.lstSelectItemData));
            }
        }
        return cp;
    }

    private String getSelectedItemIDS(List lstSelectItemData) {
        StringBuffer ids = new StringBuffer("");
        if (lstSelectItemData.size() < 1) {
            return ids.toString();
        }
        int size = lstSelectItemData.size();
        for (int i = 0; i < size; ++i) {
            if (lstSelectItemData.get(i) instanceof AdminOrgUnitInfo) {
                ids.append(((AdminOrgUnitInfo)lstSelectItemData.get(i)).getId().toString());
            }
            ids.append("~");
        }
        if (ids.length() > 1) {
            ids.deleteCharAt(ids.length() - 1);
        }
        return ids.toString();
    }

    public void setCustomerParams(CustomerParams cp) {
        MetaInfo item;
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("cmbAnalysisCmpItem") != null && this.cmbItem.getItemCount() > 0) {
            String name = cp.getCustomerParam("cmbAnalysisCmpItem");
            MetaInfo temp = null;
            try {
                int size = this.cmbItem.getItemCount();
                for (int i = 0; i < size; ++i) {
                    temp = (MetaInfo)this.cmbItem.getItemAt(i);
                    if (!temp.getName().equals(name)) continue;
                    this.cmbItem.setSelectedItem((Object)temp);
                    this.reloadItemValue(temp);
                    break;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((item = (MetaInfo)this.cmbItem.getSelectedItem()) != null) {
            if ("FPER004".equals(item.getName())) {
                this.setOrgWeidu(cp);
            } else {
                this.setOtherWeidu(cp);
            }
        }
    }

    private void setOrgWeidu(CustomerParams cp) {
        String strOrgIdSet = cp.getCustomerParam("lstSelectItem");
        this.lstSelectItemData = this.getSelectedItemListOrg(strOrgIdSet);
        try {
            this.fillSelectItemListOrg(this.lstSelectItemData, this.lstSelectItem, this.lstAllItem);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private List getSelectedItemListOrg(String ids) {
        ArrayList<AdminOrgUnitInfo> lstItem = new ArrayList<AdminOrgUnitInfo>();
        if (StringUtils.isEmpty((String)ids)) {
            return lstItem;
        }
        String[] items = ids.split("~");
        AdminOrgUnitInfo org = null;
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            org = new AdminOrgUnitInfo();
            org.setId(BOSUuid.read((String)items[i]));
            lstItem.add(org);
        }
        return lstItem;
    }

    private void fillSelectItemListOrg(List lst, KDList lstSelectItem, KDList lstAllItem) throws Exception {
        int i;
        if (lst == null || lst.size() <= 0) {
            return;
        }
        AdminOrgUnitInfo infoTempSelect = null;
        AdminOrgUnitInfo infoTempAll = null;
        this.lstSelectItemData = new ArrayList();
        this.lstAllItemData = new ArrayList();
        int size = this.lstAllItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstAllItemData.add(lstAllItem.getElement(i));
        }
        size = lst.size();
        for (i = 0; i < size; ++i) {
            infoTempSelect = (AdminOrgUnitInfo)lst.get(i);
            int n = lstAllItem.getElementCount();
            for (int m = 0; m < n; ++m) {
                infoTempAll = (AdminOrgUnitInfo)lstAllItem.getElement(m);
                if (!infoTempAll.getId().toString().equals(infoTempSelect.getId().toString())) continue;
                this.lstSelectItemData.add(infoTempAll);
                this.lstAllItemData.remove(infoTempAll);
            }
        }
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        size = this.lstAllItemData.size();
        for (i = 0; i < size; ++i) {
            this.lstAllItem.addElement(this.lstAllItemData.get(i));
        }
        size = this.lstSelectItemData.size();
        for (i = 0; i < size; ++i) {
            this.lstSelectItem.addElement(this.lstSelectItemData.get(i));
        }
        lstAllItem.setSelectedIndex(0);
    }

    private void setOtherWeidu(CustomerParams cp) {
        if (cp.getCustomerParam("lstSelectItem") != null) {
            String ids = cp.getCustomerParam("lstSelectItem");
            try {
                this.lstSelectItemData = CmpDimensionFilterUI.getSelectedItemList(ids);
                this.fillSelectItemList(this.lstSelectItemData, this.lstSelectItem, this.lstAllItem);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public static List getSelectedItemList(String ids) throws Exception {
        ArrayList<FormulaCmpItemData> lstItem = new ArrayList<FormulaCmpItemData>();
        if (ids.length() < 1) {
            return lstItem;
        }
        String[] items = ids.split("~");
        FormulaCmpItemData temp = null;
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            temp = new FormulaCmpItemData();
            temp.setUuid(items[i]);
            lstItem.add(temp);
        }
        return lstItem;
    }

    private void fillSelectItemList(List lst, KDList lstSelectItem, KDList lstAllItem) throws Exception {
        int i;
        lstSelectItem.removeAllElements();
        if (lst == null || lst.size() <= 0) {
            return;
        }
        FormulaCmpItemData infoTempSelect = null;
        FormulaCmpItemData infoTempAll = null;
        this.lstSelectItemData = new ArrayList();
        this.lstAllItemData = new ArrayList();
        int size = this.lstAllItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstAllItemData.add(lstAllItem.getElement(i));
        }
        size = lst.size();
        for (i = 0; i < size; ++i) {
            infoTempSelect = (FormulaCmpItemData)lst.get(i);
            int n = lstAllItem.getElementCount();
            for (int m = 0; m < n; ++m) {
                infoTempAll = (FormulaCmpItemData)lstAllItem.getElement(m);
                if (!infoTempAll.getUuid().toString().equals(infoTempSelect.getUuid().toString())) continue;
                this.lstSelectItemData.add(infoTempAll);
                this.lstAllItemData.remove(infoTempAll);
            }
        }
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        size = this.lstAllItemData.size();
        for (i = 0; i < size; ++i) {
            this.lstAllItem.addElement(this.lstAllItemData.get(i));
        }
        size = this.lstSelectItemData.size();
        for (i = 0; i < size; ++i) {
            this.lstSelectItem.addElement(this.lstSelectItemData.get(i));
        }
        lstAllItem.setSelectedIndex(0);
    }

    public void clear() {
        super.clear();
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        this.lstSelectItemData = new ArrayList();
        this.cmbItem.setSelectedIndex(0);
        try {
            this.reloadItemValue((MetaInfo)this.cmbItem.getSelectedItem());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private List getDimensions() {
        ArrayList<MetaInfo> lstItem = new ArrayList<MetaInfo>();
        MetaInfo item = new MetaInfo();
        item.setName("FPER004");
        item.setValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"206_CmpDimensionFilterUI"));
        lstItem.add(item);
        item = new MetaInfo();
        item.setName("FPER006");
        item.setValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"207_CmpDimensionFilterUI"));
        lstItem.add(item);
        item = new MetaInfo();
        item.setName("FPER008");
        item.setValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"208_CmpDimensionFilterUI"));
        lstItem.add(item);
        item = new MetaInfo();
        item.setName("FPER007");
        item.setValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"209_CmpDimensionFilterUI"));
        lstItem.add(item);
        item = new MetaInfo();
        item.setName("FPER009");
        item.setValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"210_CmpDimensionFilterUI"));
        lstItem.add(item);
        item = new MetaInfo();
        item.setName("FPER010");
        item.setValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"211_CmpDimensionFilterUI"));
        lstItem.add(item);
        item = new MetaInfo();
        item.setName("FPER011");
        item.setValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"212_CmpDimensionFilterUI"));
        lstItem.add(item);
        item = new MetaInfo();
        item.setName("FPER012");
        item.setValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"213_CmpDimensionFilterUI"));
        lstItem.add(item);
        item = new MetaInfo();
        item.setName("FPER013");
        item.setValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"214_CmpDimensionFilterUI"));
        lstItem.add(item);
        item = new MetaInfo();
        item.setName("FPER021");
        item.setValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"215_CmpDimensionFilterUI"));
        lstItem.add(item);
        return lstItem;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        RptParams params = rcm.toRptParams();
        params.setObject("dimension", (Object)((MetaInfo)this.cmbItem.getSelectedItem()).getName());
        params.setObject("selectDmItem", (Object)this.lstSelectItemData);
        return params;
    }

    public void setCustomCondition(RptParams params) {
    }
}

