/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemException;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.ItemTypeEnum;
import com.kingdee.eas.hr.compensation.ItemUsedEnum;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractCmpItemEditUI;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CmpItemEditUI
extends AbstractCmpItemEditUI {
    private static Logger logger = Logger.getLogger(CmpItemEditUI.class);
    String resClass = "com.kingdee.eas.hr.compensation.client.CmpItemResource.";
    boolean isFullSize = false;
    boolean changeFlag = false;

    private void init() {
        this.initUITitle();
        this.txtNumber.setEnabled(false);
    }

    private void initPrecisionControl(ItemDataTypeEnum dataType, CmpItemInfo oldItemInfo) {
        if (dataType == null) {
            return;
        }
        SpinnerNumberModel modelLength = null;
        SpinnerNumberModel modelDec = null;
        if (dataType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
            this.spinDec.setEnabled(true);
            this.spinLength.setEnabled(false);
            this.comboPrecisionType.setEnabled(true);
            modelLength = new SpinnerNumberModel(13, 0, 13, 1);
            this.spinLength.setModel((SpinnerModel)modelLength);
            modelDec = new SpinnerNumberModel(2, 0, 4, 1);
            this.spinDec.setModel((SpinnerModel)modelDec);
            this.collectFlag.setEnabled(true);
        } else if (dataType.equals((Object)ItemDataTypeEnum.FLOAT)) {
            this.spinDec.setEnabled(true);
            this.spinLength.setEnabled(false);
            this.comboPrecisionType.setEnabled(true);
            modelLength = new SpinnerNumberModel(13, 0, 13, 1);
            this.spinLength.setModel((SpinnerModel)modelLength);
            modelDec = new SpinnerNumberModel(2, 0, 8, 1);
            this.spinDec.setModel((SpinnerModel)modelDec);
            this.collectFlag.setEnabled(true);
        } else if (dataType.equals((Object)ItemDataTypeEnum.INT)) {
            this.spinDec.setEnabled(false);
            this.spinLength.setEnabled(false);
            this.comboPrecisionType.setEnabled(false);
            modelLength = new SpinnerNumberModel(13, 0, 13, 1);
            this.spinLength.setModel((SpinnerModel)modelLength);
            this.spinDec.setValue((Object)0);
            this.collectFlag.setEnabled(true);
        } else if (dataType.equals((Object)ItemDataTypeEnum.STRING)) {
            this.spinDec.setEnabled(false);
            this.spinLength.setEnabled(false);
            this.comboPrecisionType.setEnabled(false);
            modelLength = new SpinnerNumberModel(255, 0, 255, 1);
            this.spinLength.setModel((SpinnerModel)modelLength);
            this.spinDec.setValue((Object)0);
            this.collectFlag.setEnabled(false);
            this.collectFlag.setSelected(false);
        } else {
            this.spinDec.setEnabled(false);
            this.spinLength.setEnabled(false);
            this.comboPrecisionType.setEnabled(false);
            this.spinLength.setValue((Object)0);
            this.spinDec.setValue((Object)0);
            this.collectFlag.setEnabled(false);
            this.collectFlag.setSelected(false);
        }
        if (oldItemInfo != null && oldItemInfo.getId() != null) {
            this.spinLength.setValue((Object)oldItemInfo.getLength());
            this.spinDec.setValue((Object)oldItemInfo.getDecDigital());
        }
    }

    private void initUITitle() {
        if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            this.setUITitle(EASResource.getString((String)(this.resClass + "ADD_TITLE")));
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
            this.setUITitle(EASResource.getString((String)(this.resClass + "EDIT_TITLE")));
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
            this.setUITitle(EASResource.getString((String)(this.resClass + "VIEW_TITLE")));
        }
    }

    protected void initListener() {
        super.initListener();
        this.comboDataType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int state = ie.getStateChange();
                if (state == 1) {
                    ItemDataTypeEnum selItem = (ItemDataTypeEnum)((Object)((KDComboBox)ie.getSource()).getSelectedItem());
                    CmpItemEditUI.this.initPrecisionControl(selItem, null);
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.txtName.setEnabled(true);
        this.comboDataType.setEnabled(true);
        this.comboType.setEnabled(false);
        this.comboType.setEditable(false);
        this.chkEnable.setEnabled(true);
        this.btnCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnRemove.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        CmpItemInfo itemInfo = this.editData;
        this.collectFlag.setSelected(itemInfo.isCollectFlag());
        this.initPrecisionControl(this.editData.getDataType(), this.editData);
        this.doSpecialCondition();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.updateCollectFlag();
    }

    protected IObjectValue createNewData() {
        CmpItemInfo info = new CmpItemInfo();
        info.setSubject(ItemSubjectEnum.NOTSYSINIT);
        info.setDataType(ItemDataTypeEnum.CURRENCY);
        info.setUsed(ItemUsedEnum.OTHER);
        info.setLength(13);
        info.setDecDigital(4);
        info.setEnable(StateEnum.UNENABLE);
        info.setDefaultOrder(9999);
        info.setCmpItemCatalog((CmpItemCatalogInfo)this.getUIContext().get("ParentNode"));
        info.setNumber(HRUtils.getCmpItemNumber(info.getCmpItemCatalog().getNumber()));
        if (info.getCmpItemCatalog().getNumber().equals("FPER")) {
            info.setType(ItemTypeEnum.FIX);
        } else {
            info.setType(ItemTypeEnum.CHANGEABLE);
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CmpItemFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        this.lblCtrItemValue.setVisible(false);
        this.txtItemValue.setEditable(false);
    }

    private void doSpecialCondition() {
        if (this.editData.getSubject() != null && this.editData.getSubject().getValue() == 10) {
            this.txtName.setEnabled(false);
            this.comboDataType.setEnabled(false);
            this.comboType.setEnabled(false);
            this.spinLength.setEnabled(false);
        }
        if (this.editData.getEnable() != null && this.editData.getEnable().getValue() != 0 && (this.getOprtState().equalsIgnoreCase(OprtState.EDIT) || this.getOprtState().equalsIgnoreCase(OprtState.VIEW))) {
            this.comboDataType.setEnabled(false);
            this.comboType.setEnabled(false);
            this.spinLength.setEnabled(false);
            if (this.editData.getEnable().getValue() == 1) {
                this.chkEnable.setEnabled(false);
                this.chkEnable.setSelected(true);
            } else {
                this.chkEnable.setEnabled(true);
                this.chkEnable.setSelected(false);
            }
        } else {
            this.chkEnable.setSelected(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        boolean flagOfDate;
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            throw new CmpItemException(CmpItemException.CMPITEM_NUMBER_NOT_BLANK);
        }
        if (this.editData.getNumber().charAt(0) < '\n') {
            throw new CmpItemException(CmpItemException.CMPITEM_NOTNUM);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            throw new CmpItemException(CmpItemException.CMPITEM_NAME_NOT_BLANK);
        }
        if (this.editData.getName().charAt(0) < ':' && this.editData.getName().charAt(0) > '/') {
            throw new CmpItemException(CmpItemException.CMPITEM_NAMENOTNUM);
        }
        if (this.editData.getDataType() != null && (this.editData.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY) || this.editData.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) && (this.editData.getPrecisionType() == null || this.editData.getPrecisionType().getValue() == 10)) {
            throw new CmpItemException(CmpItemException.CMPITEM_PRECISION_NOT_NULL);
        }
        String strNameCharacter = null;
        int size = this.editData.getName().length();
        for (int i = 0; i < size; ++i) {
            strNameCharacter = this.editData.getName().substring(i, i + 1);
            if (strNameCharacter.equals("%")) {
                throw new CmpItemException(CmpItemException.CMPITEM_NAMENOTBFH);
            }
            if (!strNameCharacter.equals(" ")) continue;
            throw new CmpItemException(CmpItemException.CMPITEM_NOEMPTYCHAR);
        }
        if (this.chkEnable.isSelected()) {
            this.editData.setEnable(StateEnum.ENABLE);
        }
        this.editData.setCollectFlag(this.collectFlag.isSelected());
        if (StringUtils.isEmpty((String)this.editData.getItemValue())) {
            // empty if block
        }
        if (this.spinLength.getIntegerVlaue() < this.spinDec.getIntegerVlaue()) {
            throw new CmpItemException(CmpItemException.CMPITEM_DECGRATELENTH);
        }
        Date pkEnableDate = (Date)this.pkEnableDate.getValue();
        Date pkDisableDate = (Date)this.pkDisableDate.getValue();
        if (pkEnableDate != null && pkDisableDate != null && !(flagOfDate = DateTimeUtils.dayAfter((Date)pkDisableDate, (Date)pkEnableDate))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource.BEGINDATE_AFTER_ENDDATE"));
            SysUtil.abort();
        }
        this.editData.setEnableDate(pkEnableDate);
        this.editData.setDisableDate(pkDisableDate);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ICmpItem iCmpItem;
        CmpItemInfo infoOldCmpItem;
        if (this.editData != null && this.editData.getId() != null && !(infoOldCmpItem = (iCmpItem = (ICmpItem)this.getBizInterface()).getCmpItemInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()))).getName().trim().equals(this.txtName.getSelectedItemData().toString().trim()) && iCmpItem.isReferencedByFormula(this.editData.getNumber()) && MsgBox.showConfirm2((String)EASResource.getString((String)(this.resClass + "REFEFENCED_BYFORMULA"))) == 2) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnHigh.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnEdit.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuView.setVisible(false);
        this.menuEdit.setVisible(false);
    }

    @Override
    public void actionHigh_actionPerformed(ActionEvent e) throws Exception {
        super.actionHigh_actionPerformed(e);
        this.resetUISize();
    }

    private void resetUISize() {
        int changed = 344;
        if (this.isFullSize) {
            changed += 0;
            this.isFullSize = false;
        } else {
            changed += 25;
            this.isFullSize = true;
        }
        if (this.getUIWindow() instanceof Frame) {
            Frame uiWindow = (Frame)this.getUIWindow();
            uiWindow.setSize(278, changed);
            uiWindow.repaint();
        } else if (this.getUIWindow() instanceof JDialog) {
            JDialog uiWindow = (JDialog)this.getUIWindow();
            uiWindow.setSize(270, changed);
            uiWindow.repaint();
        }
        this.lblCtrItemValue.setVisible(this.isFullSize);
    }

    @Override
    protected void collectFlag_stateChanged(ChangeEvent e) throws Exception {
        this.changeFlag = true;
    }

    private void updateCollectFlag() {
        BOSUuid Id;
        boolean isCollect;
        if (this.changeFlag && !(isCollect = this.collectFlag.isSelected()) && (Id = this.editData.getId()) != null) {
            try {
                ICmpSchemeItem schemeItem = CmpSchemeItemFactory.getRemoteInstance();
                schemeItem.updateCollectFlag(this.editData);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }
}

