/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.AccountTypeEnum;
import com.kingdee.eas.hr.compensation.CmpItemAccountDeptEntryCollection;
import com.kingdee.eas.hr.compensation.CmpItemAccountDeptException;
import com.kingdee.eas.hr.compensation.CmpItemAccountEmpCollection;
import com.kingdee.eas.hr.compensation.CmpItemAccountEmpEntryCollection;
import com.kingdee.eas.hr.compensation.CmpItemAccountEmpEntryInfo;
import com.kingdee.eas.hr.compensation.CmpItemAccountEmpFactory;
import com.kingdee.eas.hr.compensation.CmpItemAccountEmpInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.GrantTypeEnum;
import com.kingdee.eas.hr.compensation.ICmpItemAccountEmp;
import com.kingdee.eas.hr.compensation.client.AbstractCmpOpenOutEmployeeUI;
import com.kingdee.eas.hr.compensation.client.CmpItemAccountEntryPrmtBox;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpOpenOutEmployeeUI
extends AbstractCmpOpenOutEmployeeUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpOpenOutEmployeeUI.class);
    private AdminOrgUnitInfo adminOrgInfo = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private boolean hasSub = false;
    private CmpItemInfo cmpItem = null;
    private String empTypeID = null;
    private String empTypeName = null;
    private String empStatusID = null;
    private String empStatusName = null;
    private String empClassifyID = null;
    private String empClassifyName = null;
    private String cmpAccountDeptID = null;
    private Map accountMap = null;
    private Set changeValueSet = new HashSet();
    private Set deleteSet = new HashSet();
    private boolean isChanged = false;
    private boolean isDisplayDetail = false;
    protected KDBizPromptBox bizDebitPromptBox = null;
    protected KDBizPromptBox bizCreditPromptBox = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app", "CmpEmployeeQuery");
        this.initParams();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.setAccountF7("AccountDebit");
        this.setAccountF7("AccountCredit");
        this.setTableNotEditable();
        this.setEditable(false);
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Copy");
    }

    private void initParams() {
        this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("cmpCompany");
        this.adminOrgInfo = (AdminOrgUnitInfo)this.getUIContext().get("cmpAdminOrgUnit");
        this.cmpItem = (CmpItemInfo)this.getUIContext().get("cmpCmpItem");
        this.empTypeID = (String)this.getUIContext().get("cmpEmployeeTypeID");
        this.empTypeName = (String)this.getUIContext().get("cmpEmployeeTypeName");
        this.empClassifyID = (String)this.getUIContext().get("cmpEmployeeClassifyID");
        this.empClassifyName = (String)this.getUIContext().get("cmpEmployeeClassifyName");
        this.empStatusID = (String)this.getUIContext().get("cmpEmployeeStatusID");
        this.empStatusName = (String)this.getUIContext().get("cmpEmployeeStatusName");
        this.hasSub = (Boolean)this.getUIContext().get("isHasSub");
        this.cmpAccountDeptID = (String)this.getUIContext().get("cmpAccountDeptID");
        this.isDisplayDetail = (Boolean)this.getUIContext().get("isDisplayDetail");
        this.accountMap = (Map)this.getUIContext().get("accountMap");
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.showChange();
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setEditable(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectIDs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        StringBuffer sb = new StringBuffer();
        String id = null;
        IRow iRow = null;
        for (int i = 0; i < selectIDs.length; ++i) {
            iRow = this.tblMain.getRow(selectIDs[i]);
            if (iRow.getCell("deptAccountID").getValue() != null) continue;
            id = (String)this.tblMain.getRow(selectIDs[i]).getCell("id").getValue();
            if (id != null) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(id).append("'");
                iRow.getCell("id").setValue(null);
            }
            iRow.getCell("AccountDebit").setValue(null);
            iRow.getCell("AccountCredit").setValue(null);
            iRow.getCell("assActDebit").setValue(null);
            iRow.getCell("assActCredit").setValue(null);
            iRow.getCell("DebitHesuan").setValue(null);
            iRow.getCell("CreditHesuan").setValue(null);
        }
        if (sb.length() > 0) {
            ICmpItemAccountEmp iCIAEmp = CmpItemAccountEmpFactory.getRemoteInstance();
            iCIAEmp.delete("where id in (" + sb.toString() + ")");
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.showChange()) {
            return;
        }
        this.fillQueryData();
        this.setEditable(false);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.fillQueryData();
        this.setEditable(false);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getSelectManager().setSelectMode(15);
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            sb = this.tblMain.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblMain.getColumn(column);
            if (row == -1) {
                return;
            }
            int[] selectIDs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            if (this.tblMain.getCell(row, column) == null) {
                return;
            }
            Object value = this.tblMain.getCell(row, column).getValue();
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            if (!this.checkAccountView(selectIDs, iColumn.getKey())) {
                return;
            }
            IRow iRow = null;
            int count = selectIDs.length;
            for (int i = 0; i < count; ++i) {
                String objStr;
                iRow = this.tblMain.getRow(selectIDs[i]);
                CmpItemAccountEmpInfo accountEmpInfo = new CmpItemAccountEmpInfo();
                if (iRow.getCell("id").getValue() != null) {
                    accountEmpInfo.setId(BOSUuid.read((String)iRow.getCell("id").getValue().toString()));
                }
                if (selectIDs[i] == row || this.tblMain.getCell(selectIDs[i], column).getStyleAttributes().isLocked()) continue;
                if (column == this.tblMain.getColumnIndex("AccountDebit")) {
                    this.tblMain.getCell(selectIDs[i], "AccountDebit").setValue(value);
                    this.tblMain.getCell(selectIDs[i], "assActDebit").setValue(null);
                    this.tblMain.getCell(selectIDs[i], "DebitHesuan").setValue(null);
                } else if (column == this.tblMain.getColumnIndex("AccountCredit")) {
                    this.tblMain.getCell(selectIDs[i], "AccountCredit").setValue(value);
                    this.tblMain.getCell(selectIDs[i], "assActCredit").setValue(null);
                    this.tblMain.getCell(selectIDs[i], "CreditHesuan").setValue(null);
                } else if (column == this.tblMain.getColumnIndex("CreditHesuan")) {
                    value = this.tblMain.getCell(row, "assActCredit").getValue();
                    this.copyAssActEntryColl(value, selectIDs[i], "assActCredit");
                    if (value != null) {
                        objStr = this.toString((CmpItemAccountEmpEntryCollection)((Object)value));
                        this.tblMain.getCell(selectIDs[i], "CreditHesuan").setValue((Object)objStr);
                    } else {
                        this.tblMain.getCell(selectIDs[i], "CreditHesuan").setValue(null);
                    }
                } else if (column == this.tblMain.getColumnIndex("DebitHesuan")) {
                    value = this.tblMain.getCell(row, "assActDebit").getValue();
                    this.copyAssActEntryColl(value, selectIDs[i], "assActDebit");
                    if (value != null) {
                        objStr = this.toString((CmpItemAccountEmpEntryCollection)((Object)value));
                        this.tblMain.getCell(selectIDs[i], "DebitHesuan").setValue((Object)objStr);
                    } else {
                        this.tblMain.getCell(selectIDs[i], "DebitHesuan").setValue(null);
                    }
                }
                if (this.tblMain.getRow(selectIDs[i]).getCell("id").getValue() != null) {
                    this.changeValueSet.add(selectIDs[i]);
                }
                this.isChanged = true;
            }
        }
    }

    @Override
    public void actionEvaluate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectIDs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        AccountViewInfo accountDebit = (AccountViewInfo)this.accountMap.get("cmpAccountDebit");
        AccountViewInfo accountCredit = (AccountViewInfo)this.accountMap.get("cmpAccountCredit");
        IRow iRow = null;
        for (int i = 0; i < selectIDs.length; ++i) {
            String objStr;
            iRow = this.tblMain.getRow(selectIDs[i]);
            iRow.getCell("AccountDebit").setValue((Object)accountDebit);
            iRow.getCell("AccountCredit").setValue((Object)accountCredit);
            iRow.getCell("assActDebit").setValue((Object)this.copyEmpFromDeptEntryData(selectIDs[i], "assActDebit"));
            iRow.getCell("assActCredit").setValue((Object)this.copyEmpFromDeptEntryData(selectIDs[i], "assActCredit"));
            if (iRow.getCell("assActCredit").getValue() != null) {
                objStr = this.toString((CmpItemAccountEmpEntryCollection)((Object)iRow.getCell("assActCredit").getValue()));
                iRow.getCell("CreditHesuan").setValue((Object)objStr);
            }
            if (iRow.getCell("assActDebit").getValue() != null) {
                objStr = this.toString((CmpItemAccountEmpEntryCollection)((Object)iRow.getCell("assActDebit").getValue()));
                iRow.getCell("DebitHesuan").setValue((Object)objStr);
            }
            CmpItemAccountEmpInfo accountEmpInfo = new CmpItemAccountEmpInfo();
            if (iRow.getCell("id").getValue() != null) {
                accountEmpInfo.setId(BOSUuid.read((String)iRow.getCell("id").getValue().toString()));
            }
            if (iRow.getCell("id").getValue() == null) continue;
            this.changeValueSet.add(selectIDs[i]);
        }
        this.isChanged = true;
    }

    private CmpItemAccountEmpEntryCollection copyEmpFromDeptEntryData(int rowIndex, String columnKey) {
        CmpItemAccountDeptEntryCollection deptEntry = (CmpItemAccountDeptEntryCollection)((Object)this.accountMap.get(columnKey));
        if (deptEntry == null || deptEntry.size() == 0) {
            return null;
        }
        CmpItemAccountEmpInfo empAccountInfo = null;
        String empAccountID = (String)this.tblMain.getRow(rowIndex).getCell("id").getValue();
        if (empAccountID != null) {
            empAccountInfo = new CmpItemAccountEmpInfo();
            empAccountInfo.setId(BOSUuid.read((String)empAccountID));
        }
        CmpItemAccountEmpEntryCollection accountEntry = new CmpItemAccountEmpEntryCollection();
        CmpItemAccountEmpEntryInfo entryInfo = null;
        for (int i = 0; i < deptEntry.size(); ++i) {
            entryInfo = new CmpItemAccountEmpEntryInfo();
            entryInfo.setCmpItemAccount(empAccountInfo);
            entryInfo.setAccountType(deptEntry.get(i).getAccountType());
            entryInfo.setAssActName(deptEntry.get(i).getAssActName());
            entryInfo.setAssActNumber(deptEntry.get(i).getAssActNumber());
            entryInfo.setValue(deptEntry.get(i).getValue());
            entryInfo.setAssActType(deptEntry.get(i).getAssActType());
            accountEntry.add(entryInfo);
        }
        return accountEntry;
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getSelectManager().setSelectMode(2);
        super.actionLocate_actionPerformed(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkCreditAndDebitAccount();
        CmpItemAccountEmpCollection addValueColl = new CmpItemAccountEmpCollection();
        CmpItemAccountEmpCollection updateValueColl = new CmpItemAccountEmpCollection();
        IRow iRow = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            CmpItemAccountEmpInfo accountInfo;
            iRow = this.tblMain.getRow(i);
            if (iRow.getCell("id").getValue() != null || (accountInfo = this.getCmpItemAccountEmpInfo(iRow)) == null) continue;
            addValueColl.add(accountInfo);
        }
        Iterator iter = this.changeValueSet.iterator();
        while (iter.hasNext()) {
            int rowIndex = (Integer)iter.next();
            iRow = this.tblMain.getRow(rowIndex);
            updateValueColl.add(this.getCmpItemAccountEmpInfo(iRow));
        }
        HashMap<String, Object> changeMap = new HashMap<String, Object>();
        changeMap.put("add_Value", (Object)addValueColl);
        changeMap.put("change_Value", (Object)updateValueColl);
        changeMap.put("delete_Value", this.deleteSet);
        CmpItemAccountEmpFactory.getRemoteInstance().saveData(changeMap);
        this.changeValueSet.clear();
        this.deleteSet.clear();
        this.isChanged = false;
        if (addValueColl.size() != 0 || updateValueColl.size() != 0 || this.deleteSet.size() != 0) {
            String res = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"Msg_Save_OK");
            this.setMessageText(res);
            this.showMessage();
            this.actionRefresh_actionPerformed(e);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void setDefaultEntityViewInfo(EntityViewInfo entryViewInfo) {
        super.setDefaultEntityViewInfo(entryViewInfo);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer maskStr = new StringBuffer();
        int i = 0;
        if (this.hasSub) {
            GrantTypeEnum grantType = GrantTypeEnum.BYHRORG;
            try {
                grantType = HRUtils.getGrantHRParamterValue(null);
            }
            catch (Exception e) {
                grantType = GrantTypeEnum.BYHRORG;
            }
            if (grantType.getValue() == 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
                filterInfo.getFilterItems().add(new FilterItemInfo("adminToUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000010FE9F8B5"));
                filterInfo.getFilterItems().add(new FilterItemInfo("adminToUnit.id", (Object)this.companyInfo.getId().toString()));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)(this.adminOrgInfo.getLongNumber() + "%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
            maskStr.append(" #").append(i++).append(" and #").append(i++).append(" and #").append(i++).append(" and #").append(i++);
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("admin.id", (Object)this.adminOrgInfo.getId().toString()));
            maskStr.append(" #").append(i++);
        }
        if (this.empTypeID != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("empType.id", (Object)this.empTypeID));
            maskStr.append(" and #").append(i++);
        }
        if (this.empClassifyID != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("empClassify.id", (Object)this.empClassifyID));
            maskStr.append(" and #").append(i++);
        }
        if (this.empStatusID != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("employeeType.id", (Object)this.empStatusID));
            maskStr.append(" and #").append(i++);
        }
        filterInfo.setMaskString(maskStr.toString());
        return filterInfo;
    }

    private void setAccountF7(String columnName) {
        IColumn iColumn = this.tblMain.getColumn(columnName);
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        AccountPromptBox accountPromptBox = new AccountPromptBox((IUIObject)this, this.companyInfo, null, false, true);
        bizPromptBox.setSelector((KDPromptSelector)accountPromptBox);
        bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        bizPromptBox.setSelector((KDPromptSelector)accountPromptBox);
        bizPromptBox.setEditable(false);
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptBox));
    }

    private void fillQueryData() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.getDefaultFilterForQuery());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("cmpAccountDeptID", this.cmpAccountDeptID);
        paramMap.put("cmpItem", this.cmpItem);
        paramMap.put("cmpCompany", this.companyInfo);
        CmpItemAccountEmpCollection accountEmpColl = CmpItemAccountEmpFactory.getRemoteInstance().getCmpItemAccountEmpColl(viewInfo, this.PersonQueryPK, paramMap);
        this.tblMain.removeRows();
        this.deleteSet.clear();
        this.changeValueSet.clear();
        this.isChanged = false;
        if (accountEmpColl == null || accountEmpColl.size() == 0) {
            return;
        }
        CmpItemAccountEmpInfo accountEmpInfo = null;
        for (int i = 0; i < accountEmpColl.size(); ++i) {
            accountEmpInfo = accountEmpColl.get(i);
            this.fillOneRowData(accountEmpInfo);
        }
    }

    private void fillOneRowData(CmpItemAccountEmpInfo accountEmpInfo) {
        IRow iRow = this.tblMain.addRow();
        if (accountEmpInfo.getId() != null) {
            iRow.getCell("id").setValue((Object)accountEmpInfo.getId().toString());
        }
        iRow.getCell("personid").setValue((Object)accountEmpInfo.getPerson().getId().toString());
        iRow.getCell("empName").setValue((Object)accountEmpInfo.getPerson().getName());
        iRow.getCell("empNumber").setValue((Object)accountEmpInfo.getPerson().getNumber());
        iRow.getCell("admin").setValue((Object)accountEmpInfo.getAdminOrg());
        iRow.getCell("deptAccountID").setValue((Object)accountEmpInfo.getValueOfDept());
        iRow.getCell("empTypeID").setValue(accountEmpInfo.get("empTypeID"));
        if (this.empTypeName == null) {
            iRow.getCell("empTypeName").setValue(accountEmpInfo.get("empTypeName"));
        } else {
            iRow.getCell("empTypeName").setValue((Object)this.empTypeName);
        }
        iRow.getCell("empStatusID").setValue(accountEmpInfo.get("empStatusID"));
        if (this.empStatusName == null) {
            iRow.getCell("empStatusName").setValue(accountEmpInfo.get("empStatusName"));
        } else {
            iRow.getCell("empStatusName").setValue((Object)this.empStatusName);
        }
        iRow.getCell("empClassifyID").setValue(accountEmpInfo.get("empClassifyID"));
        if (this.empClassifyName == null) {
            iRow.getCell("empClassifyName").setValue(accountEmpInfo.get("empClassifyName"));
        } else {
            iRow.getCell("empClassifyName").setValue((Object)this.empClassifyName);
        }
        iRow.getCell("cmpItem").setValue((Object)this.cmpItem);
        iRow.getCell("AccountDebit").setValue((Object)accountEmpInfo.getAccountDebit());
        iRow.getCell("AccountCredit").setValue((Object)accountEmpInfo.getAccountCredit());
        CmpItemAccountEmpEntryCollection[] entryColls = this.getDebitOrCrebitEntryColl(accountEmpInfo);
        iRow.getCell("assActDebit").setValue((Object)entryColls[0]);
        iRow.getCell("assActCredit").setValue((Object)entryColls[1]);
        if (entryColls[0] != null) {
            iRow.getCell("DebitHesuan").setValue((Object)this.toString(entryColls[0]));
        }
        if (iRow.getCell("AccountDebit").getValue() != null) {
            // empty if block
        }
        if (entryColls[1] != null) {
            iRow.getCell("CreditHesuan").setValue((Object)this.toString(entryColls[1]));
        }
        if (iRow.getCell("AccountCredit").getValue() != null) {
            // empty if block
        }
    }

    private void addRowByPer(Object[] obj) throws BOSException, Exception {
        int i;
        PersonInfo person = null;
        HashSet<String> personSet = new HashSet<String>();
        int size = obj.length;
        for (int i2 = 0; i2 < size; ++i2) {
            person = (PersonInfo)obj[i2];
            personSet.add(person.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CmpItem.id", (Object)this.cmpItem.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("person.id", personSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        CmpItemAccountEmpCollection accountEmpColl = CmpItemAccountEmpFactory.getRemoteInstance().getCmpItemAccountEmpCollection(viewInfo);
        if (accountEmpColl != null && accountEmpColl.size() > 0) {
            StringBuffer empNames = new StringBuffer();
            String empName = null;
            for (int i3 = 0; i3 < accountEmpColl.size(); ++i3) {
                empName = accountEmpColl.get(i3).getPerson().getName();
                personSet.remove(accountEmpColl.get(i3).getPerson().getId().toString());
                if (empNames.length() > 0) {
                    empNames.append("\uff0c");
                }
                empNames.append(empName);
            }
            StringBuffer str = new StringBuffer();
            str.append(HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"723_CmpOpenOutEmployeeUI", (String[])new String[]{empNames.toString(), this.cmpItem.toString()}));
            MsgBox.showInfo((String)str.toString());
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("employeeType.name"));
        selector.add(new SelectorItemInfo("employeeType.employeeFenLei.name"));
        PersonInfo newPersonInfo = null;
        ArrayList<String> personIds = new ArrayList<String>();
        int size2 = obj.length;
        for (int i4 = 0; i4 < size2; ++i4) {
            person = (PersonInfo)obj[i4];
            if (!personSet.contains(person.getId().toString()) || this.isSamePersonInPersonTable(person)) continue;
            personIds.add(person.getId().toString());
        }
        if (personIds.size() == 0) {
            return;
        }
        PersonCollection coll = PersonFactory.getRemoteInstance().getPersonCollection("select id,employeeType.name,employeeType.employeeFenLei.name where id in " + CompUtils.getStrFromList(personIds) + "");
        HashMap<String, PersonInfo> personInfos = new HashMap<String, PersonInfo>();
        int size3 = coll.size();
        for (i = 0; i < size3; ++i) {
            personInfos.put(coll.get(i).getId().toString(), coll.get(i));
        }
        size3 = obj.length;
        for (i = 0; i < size3; ++i) {
            person = (PersonInfo)obj[i];
            if (!personSet.contains(person.getId().toString()) || this.isSamePersonInPersonTable(person)) continue;
            IRow iRow = this.tblMain.addRow();
            iRow.getCell("personid").setValue((Object)person.getId().toString());
            iRow.getCell("empName").setValue((Object)person.getName());
            iRow.getCell("empNumber").setValue((Object)person.getNumber());
            iRow.getCell("admin").setValue((Object)((AdminOrgUnitInfo)person.get("primaryAdminOrg")));
            iRow.getCell("empClassifyName").setValue(person.get("employeeClassify"));
            newPersonInfo = (PersonInfo)personInfos.get(person.getId().toString());
            if (newPersonInfo.getEmployeeType() != null && newPersonInfo.getEmployeeType().getEmployeeFenLei() != null) {
                iRow.getCell("empTypeName").setValue((Object)newPersonInfo.getEmployeeType().getEmployeeFenLei().getName());
            }
            if (newPersonInfo.getEmployeeType() != null) {
                iRow.getCell("empStatusName").setValue((Object)newPersonInfo.getEmployeeType().getName());
            }
            iRow.getCell("deptAccountID").setValue((Object)this.cmpAccountDeptID);
            iRow.getCell("cmpItem").setValue((Object)this.cmpItem);
        }
    }

    private boolean isSamePersonInPersonTable(PersonInfo info) {
        if (info == null) {
            return false;
        }
        boolean isSame = false;
        int count = this.tblMain.getRowCount();
        if (count <= 0) {
            return isSame;
        }
        IRow iRow = null;
        ICell iCell = null;
        for (int i = 0; i < count; ++i) {
            iRow = this.tblMain.getRow(i);
            iCell = iRow.getCell("personid");
            if (iCell.getValue() == null) continue;
            String temp = iCell.getValue().toString();
            String id = info.getId().toString();
            if (!id.equals(temp)) continue;
            return true;
        }
        return isSame;
    }

    protected void initListener() {
        super.initListener();
        IColumn iColumnCredit = this.tblMain.getColumn("CreditHesuan");
        this.bizCreditPromptBox = new KDBizPromptBox();
        this.bizCreditPromptBox.setEditable(false);
        this.bizCreditPromptBox.setDefaultF7UIName("com.kingdee.eas.hr.compensation.client.CmpItemAccountEntryPrmtBox");
        CmpItemAccountEntryPrmtBox accountPromtBox = new CmpItemAccountEntryPrmtBox();
        accountPromtBox.setCompanyInfo(this.companyInfo.getId().toString());
        this.bizCreditPromptBox.setSelector((KDPromptSelector)accountPromtBox);
        this.bizCreditPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                CmpItemAccountEntryPrmtBox accountPromtBox = (CmpItemAccountEntryPrmtBox)CmpOpenOutEmployeeUI.this.bizCreditPromptBox.getSelector();
                int rowIndex = CmpOpenOutEmployeeUI.this.tblMain.getSelectManager().getActiveRowIndex();
                if (rowIndex < 0) {
                    return;
                }
                String cmpAccountEmpInfoID = null;
                ICell iCell = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell("id");
                if (iCell != null && iCell.getValue() != null) {
                    cmpAccountEmpInfoID = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
                }
                String hideColKey = "assActCredit";
                AccountViewInfo accountViewInfo = (AccountViewInfo)CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell("AccountCredit").getValue();
                ICell hideCell = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell(hideColKey);
                accountPromtBox.putParameter("cmpAccountDeptOrEmpInfoID", cmpAccountEmpInfoID);
                accountPromtBox.putParameter((Object)"cmpAccountViewInfo", accountViewInfo);
                accountPromtBox.putParameter((Object)"cmpAccounTypeEnunm", (Object)AccountTypeEnum.CreditAccount);
                accountPromtBox.putParameter("cmpAccountItemDeptOrEmp", "cmpAccountItemEmp");
                accountPromtBox.putParameter((Object)"cmpAccountDeptEntryColl", (Object)((CmpItemAccountEmpEntryCollection)((Object)hideCell.getValue())));
            }
        });
        this.bizCreditPromptBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                int rowIndex = CmpOpenOutEmployeeUI.this.tblMain.getSelectManager().getActiveRowIndex();
                String hideColKey = "assActCredit";
                ICell hideCell = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell(hideColKey);
                if (e.getData() != null && e.getData() instanceof Object[]) {
                    Object[] obj = (Object[])e.getData();
                    hideCell.setValue(obj[0]);
                } else {
                    hideCell.setValue(e.getData());
                }
            }
        });
        iColumnCredit.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.bizCreditPromptBox));
        IColumn iColumnDebit = this.tblMain.getColumn("DebitHesuan");
        this.bizDebitPromptBox = new KDBizPromptBox();
        this.bizDebitPromptBox.setEditable(false);
        this.bizDebitPromptBox.setDefaultF7UIName("com.kingdee.eas.hr.compensation.client.CmpItemAccountEntryPrmtBox");
        CmpItemAccountEntryPrmtBox accountDebitPromtBox = new CmpItemAccountEntryPrmtBox();
        accountPromtBox.setCompanyInfo(this.companyInfo.getId().toString());
        this.bizDebitPromptBox.setSelector((KDPromptSelector)accountDebitPromtBox);
        this.bizDebitPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                CmpItemAccountEntryPrmtBox accountPromtBox = (CmpItemAccountEntryPrmtBox)CmpOpenOutEmployeeUI.this.bizDebitPromptBox.getSelector();
                int rowIndex = CmpOpenOutEmployeeUI.this.tblMain.getSelectManager().getActiveRowIndex();
                if (rowIndex < 0) {
                    return;
                }
                String cmpAccountEmpInfoID = null;
                ICell iCell = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell("id");
                if (iCell != null && iCell.getValue() != null) {
                    cmpAccountEmpInfoID = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
                }
                String hideColKey = "assActDebit";
                AccountViewInfo accountViewInfo = (AccountViewInfo)CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell("AccountDebit").getValue();
                ICell hideCell = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell(hideColKey);
                accountPromtBox.putParameter("cmpAccountDeptOrEmpInfoID", cmpAccountEmpInfoID);
                accountPromtBox.putParameter((Object)"cmpAccountViewInfo", accountViewInfo);
                accountPromtBox.putParameter((Object)"cmpAccounTypeEnunm", (Object)AccountTypeEnum.DebitAccount);
                accountPromtBox.putParameter("cmpAccountItemDeptOrEmp", "cmpAccountItemEmp");
                accountPromtBox.putParameter((Object)"cmpAccountDeptEntryColl", (Object)((CmpItemAccountEmpEntryCollection)((Object)hideCell.getValue())));
            }
        });
        this.bizDebitPromptBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                int rowIndex = CmpOpenOutEmployeeUI.this.tblMain.getSelectManager().getActiveRowIndex();
                String hideColKey = "assActDebit";
                ICell hideCell = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell(hideColKey);
                if (e.getData() != null && e.getData() instanceof Object[]) {
                    Object[] obj = (Object[])e.getData();
                    hideCell.setValue(obj[0]);
                } else {
                    hideCell.setValue(e.getData());
                }
            }
        });
        iColumnDebit.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.bizDebitPromptBox));
    }

    private void initHesuanF7(final KDBizPromptBox bizPromptBox, IColumn iColumn, final AccountTypeEnum accountType) {
        bizPromptBox.setEditable(false);
        bizPromptBox.setDefaultF7UIName("com.kingdee.eas.hr.compensation.client.CmpItemAccountEntryPrmtBox");
        CmpItemAccountEntryPrmtBox accountPromtBox = new CmpItemAccountEntryPrmtBox();
        accountPromtBox.setCompanyInfo(this.companyInfo.getId().toString());
        bizPromptBox.setSelector((KDPromptSelector)accountPromtBox);
        bizPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                CmpItemAccountEntryPrmtBox accountPromtBox = (CmpItemAccountEntryPrmtBox)bizPromptBox.getSelector();
                int rowIndex = CmpOpenOutEmployeeUI.this.tblMain.getSelectManager().getActiveRowIndex();
                if (rowIndex < 0) {
                    return;
                }
                String cmpAccountEmpInfoID = null;
                ICell iCell = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell("id");
                if (iCell != null && iCell.getValue() != null) {
                    cmpAccountEmpInfoID = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
                }
                String hideColKey = "assActDebit";
                AccountViewInfo accountViewInfo = null;
                if (1 == accountType.getValue()) {
                    hideColKey = "assActCredit";
                    accountViewInfo = (AccountViewInfo)CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell("AccountCredit").getValue();
                } else {
                    accountViewInfo = (AccountViewInfo)CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell("AccountDebit").getValue();
                }
                ICell hideCell = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell(hideColKey);
                accountPromtBox.putParameter("cmpAccountDeptOrEmpInfoID", cmpAccountEmpInfoID);
                accountPromtBox.putParameter((Object)"cmpAccountViewInfo", accountViewInfo);
                accountPromtBox.putParameter((Object)"cmpAccounTypeEnunm", (Object)accountType);
                accountPromtBox.putParameter("cmpAccountItemDeptOrEmp", "cmpAccountItemEmp");
                if (hideCell.getValue() != null) {
                    accountPromtBox.putParameter((Object)"cmpAccountDeptEntryColl", (Object)((CmpItemAccountEmpEntryCollection)((Object)hideCell.getValue())));
                }
            }
        });
        bizPromptBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                int colIndex = CmpOpenOutEmployeeUI.this.tblMain.getSelectManager().getActiveColumnIndex();
                int rowIndex = CmpOpenOutEmployeeUI.this.tblMain.getSelectManager().getActiveRowIndex();
                String columnKey = CmpOpenOutEmployeeUI.this.tblMain.getColumnKey(colIndex);
                String hideColKey = "assActDebit";
                if (columnKey.equals("CreditHesuan")) {
                    hideColKey = "assActCredit";
                }
                ICell hideCell = CmpOpenOutEmployeeUI.this.tblMain.getRow(rowIndex).getCell(hideColKey);
                if (e.getData() != null && e.getData() instanceof Object[]) {
                    Object[] obj = (Object[])e.getData();
                    hideCell.setValue(obj[0]);
                } else {
                    hideCell.setValue(e.getData());
                }
            }
        });
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptBox));
    }

    private CmpItemAccountEmpEntryCollection[] getDebitOrCrebitEntryColl(CmpItemAccountEmpInfo accountInfo) {
        if (accountInfo == null || accountInfo.getCmpAssActEntries() == null) {
            return null;
        }
        CmpItemAccountEmpEntryCollection entryColl = accountInfo.getCmpAssActEntries();
        CmpItemAccountEmpEntryCollection[] debitORCreditColl = new CmpItemAccountEmpEntryCollection[]{new CmpItemAccountEmpEntryCollection(), new CmpItemAccountEmpEntryCollection()};
        CmpItemAccountEmpEntryInfo entryInfo = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo.getAccountType().getValue() == 0) {
                debitORCreditColl[0].add(entryInfo);
                continue;
            }
            debitORCreditColl[1].add(entryInfo);
        }
        if (debitORCreditColl[0].size() == 0) {
            debitORCreditColl[0] = null;
        }
        if (debitORCreditColl[1].size() == 0) {
            debitORCreditColl[1] = null;
        }
        return debitORCreditColl;
    }

    @Override
    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox personNoPositionPromptBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        personNoPositionPromptBox.showNoPositionPerson(true);
        personNoPositionPromptBox.setIsSingleSelect(false);
        personNoPositionPromptBox.setUserOrgRangeFilter(true);
        personNoPositionPromptBox.show();
        if (!personNoPositionPromptBox.isCanceled() && personNoPositionPromptBox.getData() instanceof Object[]) {
            Object[] obj = (Object[])personNoPositionPromptBox.getData();
            this.addRowByPer(obj);
        }
    }

    @Override
    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int selectRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        IRow iRow = this.tblMain.getRow(selectRow);
        if (iRow.getCell("deptAccountID").getValue() != null) {
            if (iRow.getCell("id").getValue() != null) {
                this.deleteSet.add((String)iRow.getCell("id").getValue());
            }
            this.tblMain.removeRow(selectRow);
            this.isChanged = true;
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (this.tblMain.getColumnKey(colIndex).equals("AccountDebit")) {
            this.editAccountItem(e, "DebitHesuan", "assActDebit");
        } else if (this.tblMain.getColumnKey(colIndex).equals("AccountCredit")) {
            this.editAccountItem(e, "CreditHesuan", "assActCredit");
        } else if (this.tblMain.getColumnKey(colIndex).equals("DebitHesuan")) {
            this.editAssAct(e, "DebitHesuan");
        } else if (this.tblMain.getColumnKey(colIndex).equals("CreditHesuan")) {
            this.editAssAct(e, "CreditHesuan");
        }
    }

    @Override
    protected void tblMain_editStopping(KDTEditEvent e) throws Exception {
        super.tblMain_editStopping(e);
    }

    private void editAssAct(KDTEditEvent e, String columnKey) {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IRow iRow = this.tblMain.getRow(rowIndex);
        if (e.getValue() == null || !e.getValue().equals(e.getOldValue())) {
            if (iRow.getCell(columnKey).getValue() != null) {
                String objStr = this.toString((CmpItemAccountEmpEntryCollection)((Object)iRow.getCell(columnKey).getValue()));
                iRow.getCell(colIndex).setValue((Object)objStr);
                this.isChanged = true;
                if (iRow.getCell("id").getValue() != null) {
                    this.changeValueSet.add(rowIndex);
                }
            } else if (e.getOldValue() != null) {
                if (iRow.getCell("id").getValue() != null) {
                    this.changeValueSet.add(rowIndex);
                }
                this.isChanged = true;
            }
        }
    }

    private void editAccountItem(KDTEditEvent e, String columnKey, String hideColumeKey) {
        int rowIndex = e.getRowIndex();
        IRow iRow = this.tblMain.getRow(rowIndex);
        if (e.getValue() == null) {
            iRow.getCell(columnKey).setEditor(null);
            iRow.getCell(columnKey).setValue(null);
            iRow.getCell(hideColumeKey).setValue(null);
            if (e.getOldValue() != null && iRow.getCell("id").getValue() != null) {
                this.changeValueSet.add(rowIndex);
            }
            return;
        }
        if (e.getValue().equals(e.getOldValue())) {
            return;
        }
        CmpItemAccountEmpInfo accountEmpInfo = new CmpItemAccountEmpInfo();
        if (iRow.getCell("id").getValue() != null) {
            accountEmpInfo.setId(BOSUuid.read((String)this.tblMain.getRow(rowIndex).getCell("id").getValue().toString()));
        }
        iRow.getCell(hideColumeKey).setValue(null);
        iRow.getCell(columnKey).setValue(null);
        if (iRow.getCell("id").getValue() != null) {
            this.changeValueSet.add(rowIndex);
        }
        this.isChanged = true;
    }

    private boolean checkAccountView(int[] selectIDs, String columnKey) {
        String colkey = null;
        if ("DebitHesuan".equals(columnKey)) {
            colkey = "AccountDebit";
        } else if ("CreditHesuan".equals(columnKey)) {
            colkey = "AccountCredit";
        } else {
            return true;
        }
        AccountViewInfo firstAccountView = (AccountViewInfo)this.tblMain.getCell(selectIDs[0], colkey).getValue();
        if (firstAccountView != null) {
            AccountViewInfo otherAccountView = null;
            for (int i = 1; i < selectIDs.length; ++i) {
                otherAccountView = (AccountViewInfo)this.tblMain.getCell(selectIDs[i], colkey).getValue();
                if (otherAccountView != null && firstAccountView.getId().equals((Object)otherAccountView.getId())) continue;
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"220_CmpItemAccountDeptUI"));
                SysUtil.abort();
            }
            return true;
        }
        return false;
    }

    private void copyAssActEntryColl(Object value, int rowIndex, String columnKey) {
        if (value == null) {
            this.tblMain.getCell(rowIndex, columnKey).setValue(null);
        }
        String id = (String)this.tblMain.getRow(rowIndex).getCell("id").getValue();
        CmpItemAccountEmpInfo accountEmpInfo = null;
        if (id != null) {
            accountEmpInfo = new CmpItemAccountEmpInfo();
            accountEmpInfo.setId(BOSUuid.read((String)id));
        }
        CmpItemAccountEmpEntryCollection entryColl = (CmpItemAccountEmpEntryCollection)((Object)value);
        CmpItemAccountEmpEntryCollection newColl = null;
        if (entryColl != null) {
            newColl = new CmpItemAccountEmpEntryCollection();
            CmpItemAccountEmpEntryInfo entryInfo = null;
            for (int i = 0; i < entryColl.size(); ++i) {
                entryInfo = new CmpItemAccountEmpEntryInfo();
                entryInfo.setCmpItemAccount(accountEmpInfo);
                entryInfo.setAccountType(entryColl.get(i).getAccountType());
                entryInfo.setAssActType(entryColl.get(i).getAssActType());
                entryInfo.setValue(entryColl.get(i).getValue());
                entryInfo.setAssActName(entryColl.get(i).getAssActName());
                entryInfo.setAssActNumber(entryColl.get(i).getAssActNumber());
                newColl.add(entryInfo);
            }
        }
        this.tblMain.getCell(rowIndex, columnKey).setValue((Object)newColl);
    }

    private CmpItemAccountEmpInfo getCmpItemAccountEmpInfo(IRow iRow) {
        if (iRow.getCell("AccountCredit").getValue() == null && iRow.getCell("AccountDebit").getValue() == null && iRow.getCell("id").getValue() == null) {
            return null;
        }
        CmpItemAccountEmpInfo accountInfo = new CmpItemAccountEmpInfo();
        if (iRow.getCell("id").getValue() != null) {
            accountInfo.setId(BOSUuid.read((String)iRow.getCell("id").getValue().toString()));
        }
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)iRow.getCell("admin").getValue();
        accountInfo.setAdminOrg(adminInfo);
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)iRow.getCell("personid").getValue().toString()));
        person.setName((String)iRow.getCell("empName").getValue());
        person.setNumber((String)iRow.getCell("empNumber").getValue());
        accountInfo.setPerson(person);
        accountInfo.setHrOrgUnit(HRSchemeUtils.getClientHROrgUnitInfo());
        accountInfo.setCompany(this.companyInfo);
        accountInfo.setValueOfDept((String)iRow.getCell("deptAccountID").getValue());
        accountInfo.setCmpItem((CmpItemInfo)iRow.getCell("cmpItem").getValue());
        accountInfo.setAccountCredit((AccountViewInfo)iRow.getCell("AccountCredit").getValue());
        accountInfo.setAccountDebit((AccountViewInfo)iRow.getCell("AccountDebit").getValue());
        CmpItemAccountEmpEntryCollection debitColl = (CmpItemAccountEmpEntryCollection)((Object)iRow.getCell("assActDebit").getValue());
        CmpItemAccountEmpEntryCollection creditColl = (CmpItemAccountEmpEntryCollection)((Object)iRow.getCell("assActCredit").getValue());
        CmpItemAccountEmpEntryCollection total = null;
        total = debitColl;
        if (total == null) {
            total = new CmpItemAccountEmpEntryCollection();
        }
        total.addCollection(creditColl);
        accountInfo.setCmpAssActEntries(total);
        return accountInfo;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.tblMain.getSelectManager().setSelectMode(15);
        int rowIndex = e.getRowIndex();
        IRow iRow = this.tblMain.getRow(rowIndex);
        if (iRow == null) {
            return;
        }
        if (iRow.getCell("deptAccountID").getValue() == null) {
            this.actionDelPerson.setEnabled(false);
            this.actionRemove.setEnabled(true);
        } else {
            this.actionDelPerson.setEnabled(true);
            this.actionRemove.setEnabled(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnDelPerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
    }

    private void setTableNotEditable() {
        this.tblMain.getColumn("admin").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("empTypeName").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("empName").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("empNumber").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("cmpItem").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("empStatusName").getStyleAttributes().setLocked(true);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"empNumber", "empName"};
        return locateNames;
    }

    private void setEditable(boolean flag) {
        this.actionEdit.setEnabled(!flag);
        this.actionSave.setEnabled(flag);
        this.actionAddPerson.setEnabled(flag);
        this.actionDelPerson.setEnabled(flag);
        this.actionEvaluate.setEnabled(flag);
        this.actionCopy.setEnabled(flag);
        this.tblMain.getColumn("DebitHesuan").getStyleAttributes().setLocked(!flag);
        this.tblMain.getColumn("CreditHesuan").getStyleAttributes().setLocked(!flag);
        this.tblMain.getColumn("AccountDebit").getStyleAttributes().setLocked(!flag);
        this.tblMain.getColumn("AccountCredit").getStyleAttributes().setLocked(!flag);
    }

    private void checkCreditAndDebitAccount() throws CmpItemAccountDeptException {
        int rowIndex = this.tblMain.getRowCount();
        Object credit = null;
        for (int i = 0; i < rowIndex; ++i) {
            Object debit = this.tblMain.getRow(i).getCell("AccountDebit").getValue();
            credit = this.tblMain.getRow(i).getCell("AccountCredit").getValue();
            if ((debit == null || credit != null) && (debit != null || credit == null)) continue;
            throw new CmpItemAccountDeptException(CmpItemAccountDeptException.ITEM_ACCOUNT_NULL);
        }
    }

    private boolean showChange() {
        if (this.isChanged) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"232_CmpOpenOutEmployeeUI"));
            if (result == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    this.handUIException(e);
                }
                return true;
            }
            if (result == 1) {
                return false;
            }
            SysUtil.abort();
        }
        return false;
    }

    protected boolean checkBeforeWindowClosing() {
        this.showChange();
        return true;
    }

    private String toString(CmpItemAccountEmpEntryCollection empEntryColl) {
        if (empEntryColl == null || empEntryColl.size() == 0) {
            return null;
        }
        if (!this.isDisplayDetail) {
            return EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"227_CmpItemAccountDeptUI");
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < empEntryColl.size(); ++i) {
            if (i != 0) {
                str.append("\uff1b");
            }
            if (StringUtils.isEmpty((String)empEntryColl.get(i).getAssActName())) continue;
            str.append(empEntryColl.get(i).getAssActType()).append("\uff1a").append(empEntryColl.get(i).getAssActName());
        }
        return str.toString();
    }
}

