/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.hr.compensation.CmpCommonFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpItemCatalogCollection;
import com.kingdee.eas.hr.compensation.CmpItemCatalogFactory;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportException;
import com.kingdee.eas.hr.compensation.CmpReportFilterF7Info;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CombinCmpItemInfo;
import com.kingdee.eas.hr.compensation.ICmpCommonFacade;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.client.AbstractCmpReportFilterBaseUI;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterUI;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterUtil;
import com.kingdee.eas.hr.compensation.client.HRF7CmpSchemePromptBox;
import com.kingdee.eas.hr.compensation.client.OrgChangeEnvent;
import com.kingdee.eas.hr.compensation.client.OrgChangeListener;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpReportFilterBaseUI
extends AbstractCmpReportFilterBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpReportFilterBaseUI.class);
    protected String empSumResource = "com.kingdee.eas.hr.compensation.client.EmpSumReportResource.";
    protected String cmpPeriodF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery";
    private CmpItemCollection colNecessaryCmpItem = new CmpItemCollection();
    protected CmpItemCollection colCmpItem = new CmpItemCollection();
    private ICmpSchemeItem iCmpSchemeItemIts = null;
    private HROrgUnitInfo hrOrgUnitInfo = null;
    protected List lstAllSelectItemData = null;
    protected List lstSelectItemData = new ArrayList();
    protected List lstSelectItemNotSortData = new ArrayList();
    protected boolean dataTypeFilter = false;
    protected boolean perItemFilter = false;
    protected int displaySAL000 = 0;
    protected static String SORT_ORDER = "sort_order";
    protected static final String COLLECT_STATE = "collect_State";
    protected CmpItemFilterUI cmpItemFilterUI = null;
    protected List adminOrgChangeListener = null;
    protected List orgChangeListener = null;
    protected String rootHroId = null;
    protected ArrayList hroList = null;
    protected HashSet deletedItemSet = new HashSet();
    protected CmpReportFilterF7Info f7Info = null;
    protected AdminOrgUnitInfo adminInfo = null;

    public CmpReportFilterBaseUI() throws Exception {
        this.init();
    }

    public CmpReportFilterBaseUI(int displaySAL000) throws Exception {
        this.displaySAL000 = displaySAL000;
        this.init();
    }

    public CmpReportFilterBaseUI(boolean dataTypeFilter, boolean perItemFilter) throws Exception {
        this.dataTypeFilter = dataTypeFilter;
        this.perItemFilter = perItemFilter;
        this.init();
    }

    public CmpItemFilterUI getCmpItemFilterUI() {
        return this.cmpItemFilterUI;
    }

    public void setCmpItemFilterUI(CmpItemFilterUI cmpItemFilterUI) {
        this.cmpItemFilterUI = cmpItemFilterUI;
    }

    public HashMap getCustomFilterMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CmpSchemeInfos", this.getCmpSchemeColl());
        map.put("CmpPeriodInfo", (CmpPeriodInfo)this.prmtCmpPeriod.getData());
        map.put("isShowLongName", this.chkShowLongName.isSelected());
        map.put("isShowSealUp", this.chkShowSealUp.isSelected());
        map.put("zeroItemDisplayNull", this.chkZeroItemDisplayNull.isSelected());
        map.put("AdminOrgUnitColl", this.getDeptCol(this.chkShowSealUp.isSelected()));
        map.put("AllSelectItem", this.getAllSelectItem());
        map.put("AllPublicItem", this.lstSelectItemData);
        map.put("AllPrivateItem", this.lstSelectItemNotSortData);
        map.put("RootHROrgID", this.rootHroId);
        map.put("chkIncDelItem", this.chkIncDelItem.isSelected());
        return map;
    }

    public boolean verify() {
        int i;
        if (this.prmtAdminUnitOrg.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_ADMIN")));
            this.prmtAdminUnitOrg.requestFocusInWindow();
            return false;
        }
        if (this.prmtCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            this.prmtCmpPeriod.requestFocusInWindow();
            return false;
        }
        if (this.prmtCmpScheme.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPSCH")));
            this.prmtCmpScheme.requestFocusInWindow();
            return false;
        }
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        this.lstSelectItemNotSortData = new ArrayList();
        size = this.lstSelectItemNotSort.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstSelectItemNotSortData.add(this.lstSelectItemNotSort.getElement(i));
        }
        if (this.lstSelectItemData.size() <= 0 && this.lstSelectItemNotSortData.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"126_BICmpStructReportFilterUI"));
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.f7Info = null;
        if (this.prmtCmpPeriod.getData() != null) {
            this.prmtCmpPeriod.setData(null);
        }
        if (this.prmtCmpScheme.getData() != null) {
            this.prmtCmpScheme.setData(null);
        }
        this.cmbItemCatalog.removeAllItems();
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        this.prmtAdminUnitOrg.setData(null);
        this.chkShowLongName.setSelected(false);
        this.chkShowSealUp.setSelected(false);
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        this.lstSelectItemNotSort.removeAllElements();
        this.chkZeroItemDisplayNull.setSelected(false);
        this.lstSelectItemNotSortData = new ArrayList();
        this.lstSelectItemData = new ArrayList();
        this.lstAllSelectItemData = new ArrayList();
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.lstSelectItem);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        this.initBtnIconLayout();
        this.lstAllItem.setSelectionMode(0);
        this.lstSelectItem.setSelectionMode(0);
        this.lstSelectItemNotSort.setSelectionMode(0);
    }

    public void addOrgChangeListener(OrgChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.orgChangeListener == null) {
            this.orgChangeListener = new ArrayList();
        }
        this.orgChangeListener.add(listener);
    }

    public void addAdminOrgDataChangeListener(DataChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.adminOrgChangeListener == null) {
            this.adminOrgChangeListener = new ArrayList();
        }
        this.adminOrgChangeListener.add(listener);
        this.prmtAdminUnitOrg.addDataChangeListener(listener);
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        logger.info((Object)"CmpReportFilterBaseUI.setCustomerParams");
        if (cp == null) {
            return;
        }
        try {
            String filterStr;
            Map paramF7Map = this.getF7ParamMap(cp);
            this.f7Info = this.getF7Info(paramF7Map);
            AdminOrgUnitCollection col = this.f7Info.getAdminColl();
            if (col != null && col.size() > 0) {
                this.prmtAdminUnitOrg.setValue((Object)col.toArray());
                this.chkShowLongName.setSelected(cp.getBoolean("isShowLongName"));
            }
            this.chkShowSealUp.setSelected(cp.getBoolean("isShowSealUp"));
            CmpPeriodInfo periodInfo = this.f7Info.getPeriodInfo();
            if (periodInfo != null) {
                this.prmtCmpPeriod.setData((Object)periodInfo);
            }
            this.chkZeroItemDisplayNull.setSelected(cp.getBoolean("zeroItemDisplayNull"));
            this.chkShowDelete.setSelected(cp.getBoolean("chkShowDelete"));
            this.chkIncDelItem.setSelected(cp.getBoolean("chkIncDelItem"));
            CmpSchemeCollection cmpSchemeColl = this.f7Info.getCmpSchemeColl();
            Set cmpSchemeIdSet = this.formatSetCmpSchemeId(cp.getCustomerParam("prmtCmpScheme"));
            logger.info((Object)"CmpReportFilterBaseUI.cmpSchemeColl");
            if (cmpSchemeColl == null || cmpSchemeColl.size() != cmpSchemeIdSet.size()) {
                SysUtil.abort();
            } else {
                this.loadCmpScheme(cmpSchemeColl);
            }
            this.setCustomerParamForSelectItem(cp);
            CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, false, true, this.lstSelectItem);
            if (this.cmpItemFilterUI != null && !StringUtils.isEmpty((String)(filterStr = cp.getCustomerParam("CmpItemFilter")))) {
                this.cmpItemFilterUI.loadFilterInfo(new FilterInfo(filterStr));
            }
        }
        catch (AbortException e) {
            ExceptionHandler.handle((Throwable)e);
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"236_CmpReportFilterBaseUI"));
            SysUtil.abort();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        FilterInfo filter;
        Object[] ogs;
        Object value;
        int i;
        CustomerParams cp = new CustomerParams();
        if (this.prmtCmpPeriod.getData() != null) {
            cp.addCustomerParam("prmtCmpPeriod", ((CmpPeriodInfo)this.prmtCmpPeriod.getData()).getId().toString());
        }
        if (this.prmtCmpScheme.getData() != null) {
            CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
            CmpSchemeInfo infoTem = null;
            StringBuffer cmpSchemeStr = new StringBuffer();
            int size = info.length;
            for (int i2 = 0; i2 < size; ++i2) {
                infoTem = info[i2];
                if (i2 == 0) {
                    cmpSchemeStr.append(infoTem.getId().toString());
                    continue;
                }
                cmpSchemeStr.append("~" + infoTem.getId().toString());
            }
            cp.addCustomerParam("prmtCmpScheme", cmpSchemeStr.toString());
        }
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        cp.addCustomerParam("selectListItem", HRCommonQueryUtils.getSelectedItemIDS(this.lstSelectItemData));
        this.lstSelectItemNotSortData = new ArrayList();
        size = this.lstSelectItemNotSort.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstSelectItemNotSortData.add(this.lstSelectItemNotSort.getElement(i));
        }
        String selelctItemIds = HRCommonQueryUtils.getSelectedItemIDS(this.lstSelectItemNotSortData);
        if (!StringUtils.isEmpty((String)selelctItemIds)) {
            cp.addCustomerParam("lstSelectItemNotSort", selelctItemIds);
        }
        if ((value = this.prmtAdminUnitOrg.getValue()) != null && value instanceof Object[] && (ogs = (Object[])value).length > 0 && ogs[0] != null) {
            int i3;
            StringBuffer orgUnits = new StringBuffer();
            for (i3 = 0; i3 < ogs.length - 1; ++i3) {
                orgUnits.append(((AdminOrgUnitInfo)ogs[i3]).getId().toString());
                orgUnits.append("\u2014\u2014");
            }
            orgUnits.append(((AdminOrgUnitInfo)ogs[i3]).getId().toString());
            cp.addCustomerParam("prmtAdminUnitOrg", orgUnits.toString());
        }
        cp.putBoolean("isShowLongName", this.chkShowLongName.isSelected());
        cp.putBoolean("isShowSealUp", this.chkShowSealUp.isSelected());
        cp.addCustomerParam("zeroItemDisplayNull", String.valueOf(this.chkZeroItemDisplayNull.isSelected()));
        cp.putBoolean("chkShowDelete", this.chkShowDelete.isSelected());
        cp.putBoolean("chkIncDelItem", this.chkIncDelItem.isSelected());
        if (this.cmpItemFilterUI != null && (filter = this.cmpItemFilterUI.getCondition()) != null) {
            cp.addCustomerParam("CmpItemFilter", filter.toString());
        }
        return cp;
    }

    protected void setCustomerParamForSelectItem(CustomerParams cp) {
        if (cp.getCustomerParam("selectListItem") == null) {
            return;
        }
        try {
            this.lstSelectItem.removeAllElements();
            String selectListStr = cp.getCustomerParam("selectListItem").toString();
            ArrayList<CmpItemInfo> selectNotSortList = null;
            if (!StringUtils.isEmpty((String)selectListStr)) {
                int i;
                int i2;
                String[] idArray = selectListStr.split("~");
                if (idArray.length <= 1) {
                    idArray = selectListStr.split("-");
                }
                List<String> seqList = Arrays.asList(idArray);
                CmpItemCollection cmpItemColl = this.f7Info.getPubCmpItemColl();
                ArrayList<CmpItemInfo> selectSortList = new ArrayList<CmpItemInfo>();
                int size = cmpItemColl.size();
                for (i2 = 0; i2 < size; ++i2) {
                    selectSortList.add(null);
                }
                size = seqList.size();
                block3: for (i2 = 0; i2 < size; ++i2) {
                    String cmpItemId = seqList.get(i2);
                    int catalogSize = cmpItemColl.size();
                    for (int j = 0; j < catalogSize; ++j) {
                        CmpItemInfo cmpItemInfo = cmpItemColl.get(j);
                        if (!cmpItemInfo.getId().toString().equals(cmpItemId)) continue;
                        selectSortList.set(i2, cmpItemInfo);
                        continue block3;
                    }
                }
                this.lstSelectItemData = new ArrayList();
                ArrayList<CmpItemInfo> notCollectToCollectList = new ArrayList<CmpItemInfo>();
                ArrayList<CmpItemInfo> collectToNotCollectList = new ArrayList<CmpItemInfo>();
                int seqSize = selectSortList.size();
                block5: for (int i3 = 0; i3 < seqSize; ++i3) {
                    CmpItemInfo curItemInfo = (CmpItemInfo)selectSortList.get(i3);
                    int size2 = this.colCmpItem.size();
                    for (int j = 0; j < size2; ++j) {
                        CmpItemInfo itemInfo = this.colCmpItem.get(j);
                        String collectState = (String)itemInfo.get(COLLECT_STATE);
                        if (!curItemInfo.getNumber().equals(itemInfo.getNumber()) || StringUtils.isEmpty((String)collectState)) continue;
                        if (collectState.indexOf("1") != -1) continue block5;
                        collectToNotCollectList.add(curItemInfo);
                        continue block5;
                    }
                }
                String ids = cp.getCustomerParam("lstSelectItemNotSort");
                selectNotSortList = new ArrayList();
                if (!StringUtils.isEmpty((String)ids)) {
                    String[] items = ids.split("~");
                    CmpItemCollection cmpItemNotSortColl = this.f7Info.getPrivateCmpItemColl();
                    if (cmpItemNotSortColl != null && cmpItemNotSortColl.size() > 0) {
                        int length = items.length;
                        for (int j = 0; j < length; ++j) {
                            int size3 = cmpItemNotSortColl.size();
                            for (int i4 = 0; i4 < size3; ++i4) {
                                if (!cmpItemNotSortColl.get(i4).getId().toString().equals(items[j])) continue;
                                selectNotSortList.add(cmpItemNotSortColl.get(i4));
                            }
                        }
                    }
                }
                int seqSize2 = selectNotSortList.size();
                block9: for (i = 0; i < seqSize2; ++i) {
                    CmpItemInfo curItemInfo = (CmpItemInfo)selectNotSortList.get(i);
                    int size4 = this.colCmpItem.size();
                    for (int j = 0; j < size4; ++j) {
                        CmpItemInfo itemInfo = this.colCmpItem.get(j);
                        String collectState = (String)itemInfo.get(COLLECT_STATE);
                        if (!curItemInfo.getNumber().equals(itemInfo.getNumber()) || StringUtils.isEmpty((String)collectState)) continue;
                        if (collectState.indexOf("0") != -1) continue block9;
                        notCollectToCollectList.add(curItemInfo);
                        continue block9;
                    }
                }
                selectSortList.removeAll(collectToNotCollectList);
                int size5 = notCollectToCollectList.size();
                for (i = 0; i < size5; ++i) {
                    CmpItemInfo itemInfo = (CmpItemInfo)notCollectToCollectList.get(i);
                    if (selectSortList.contains(itemInfo)) continue;
                    selectSortList.add(itemInfo);
                }
                selectNotSortList.removeAll(notCollectToCollectList);
                size5 = collectToNotCollectList.size();
                for (i = 0; i < size5; ++i) {
                    CmpItemInfo itemInfo = (CmpItemInfo)collectToNotCollectList.get(i);
                    if (selectNotSortList.contains(itemInfo)) continue;
                    selectNotSortList.add(itemInfo);
                }
                this.lstSelectItemData = selectSortList;
                HRCommonQueryUtils.fillSelectItemNumberList(this.lstSelectItemData, this.lstSelectItem, this.lstAllItem);
            } else {
                String ids = cp.getCustomerParam("lstSelectItemNotSort");
                selectNotSortList = new ArrayList<CmpItemInfo>();
                if (!StringUtils.isEmpty((String)ids)) {
                    String[] items = ids.split("~");
                    CmpItemCollection cmpItemNotSortColl = this.f7Info.getPrivateCmpItemColl();
                    if (cmpItemNotSortColl != null && cmpItemNotSortColl.size() > 0) {
                        int length = items.length;
                        for (int j = 0; j < length; ++j) {
                            int size = cmpItemNotSortColl.size();
                            for (int i = 0; i < size; ++i) {
                                if (!cmpItemNotSortColl.get(i).getId().toString().equals(items[j])) continue;
                                selectNotSortList.add(cmpItemNotSortColl.get(i));
                            }
                        }
                    }
                }
            }
            if (cp.getCustomerParam("lstSelectItemNotSort") != null) {
                this.lstSelectItemNotSort.removeAllElements();
                this.lstSelectItemNotSortData = selectNotSortList;
                HRCommonQueryUtils.fillSelectItemNumberList(this.lstSelectItemNotSortData, this.lstSelectItemNotSort, this.lstAllItem);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            ExceptionHandler.handle((Throwable)e);
        }
        this.changeTheCollectProValue();
    }

    protected ICmpSchemeItem getSchemeItemBizInteface() throws BOSException {
        if (this.iCmpSchemeItemIts == null) {
            return CmpSchemeItemFactory.getRemoteInstance();
        }
        return this.iCmpSchemeItemIts;
    }

    protected void initBtnIconLayout() {
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    protected void initAllEditor() throws Exception {
        HRF7CmpSchemePromptBox f7PromptBox = new HRF7CmpSchemePromptBox((IUIObject)this);
        f7PromptBox.setIsSingleSelect(false);
        this.prmtCmpScheme.setDefaultF7UIName(HRF7CmpSchemePromptBox.class.getName());
        this.prmtCmpScheme.setEditable(false);
        this.prmtCmpScheme.setEditFormat("$name$");
        this.prmtCmpScheme.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoCmpSch = new FilterInfo();
        this.prmtCmpScheme.setSelector((KDPromptSelector)f7PromptBox);
        this.prmtCmpScheme.setHasCUDefaultFilter(false);
        this.prmtCmpScheme.setEnabledMultiSelection(true);
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnitIDByUserPermssion()));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
        filterInfoCmpSch.setMaskString("#0 and (#1 or #2) and #3");
        evi.setFilter(filterInfoCmpSch);
        this.prmtCmpScheme.setEntityViewInfo(evi);
        this.prmtCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtCmpPeriod.setEditable(false);
        this.prmtCmpPeriod.setEditFormat("$name$");
        this.prmtCmpPeriod.setDisplayFormat("$name$");
        this.prmtCmpPeriod.setHasCUDefaultFilter(false);
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnitIDByUserPermssion()));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        CompUtils.initF7ForMutilSelectOrg(this.prmtAdminUnitOrg, false);
        this.prmtAdminUnitOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    CmpReportFilterBaseUI.this.setCurrentHRO();
                }
                catch (Exception e) {
                    CmpReportFilterBaseUI.this.handUIException(e);
                }
            }
        });
    }

    @Override
    protected void chkShowSealUp_itemStateChanged(ItemEvent e) throws Exception {
        CompUtils.initF7ForMutilSelectOrg(this.prmtAdminUnitOrg, this.chkShowSealUp.isSelected());
        if (this.prmtAdminUnitOrg.getData() != null) {
            Object[] objs = (Object[])this.prmtAdminUnitOrg.getData();
            Object[] newObjs = null;
            int size = objs.length;
            for (int i = 0; i < size; ++i) {
                if (objs[i] instanceof Object[]) {
                    newObjs = (Object[])objs[i];
                    this.prmtAdminUnitOrg.setValue((Object)newObjs);
                    return;
                }
                if (objs[i] != null) continue;
                this.prmtAdminUnitOrg.setValue(null);
                return;
            }
        }
    }

    protected void setCurrentHRO() throws Exception {
        String newRootHroId = "";
        ArrayList newHroList = null;
        if (this.prmtAdminUnitOrg.getData() == null) {
            return;
        }
        if (!this.isLoaded()) {
            return;
        }
        Object[] objs = (Object[])this.prmtAdminUnitOrg.getData();
        ArrayList<Object> adminList = new ArrayList<Object>();
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            if (!(objs[i] instanceof AdminOrgUnitInfo)) continue;
            adminList.add(objs[i]);
        }
        newHroList = this.getSelectHROS(adminList);
        newRootHroId = this.getRootHROID(newHroList);
        this.setPeriodAndSchemeF7(newRootHroId, newHroList);
        OrgChangeEnvent event = new OrgChangeEnvent();
        event.setRootOrgID(newRootHroId);
        event.setOrgs(newHroList);
        if (this.orgChangeListener != null) {
            int size2 = this.orgChangeListener.size();
            for (int i = 0; i < size2; ++i) {
                ((OrgChangeListener)this.orgChangeListener.get(i)).orgChanged(event);
            }
        }
    }

    protected void setPeriodAndSchemeF7(String newRootHroId, ArrayList newHroList) throws Exception {
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)newRootHroId));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        if (this.rootHroId != null && !this.rootHroId.equals(newRootHroId)) {
            this.prmtCmpPeriod.setValue(null);
        }
        HRF7CmpSchemePromptBox f7PromptBox = new HRF7CmpSchemePromptBox((IUIObject)this);
        f7PromptBox.setIsSingleSelect(false);
        f7PromptBox.setIsShowDelete(this.chkShowDelete.isSelected());
        f7PromptBox.setHROFilter(newHroList);
        this.prmtCmpScheme.setDefaultF7UIName(HRF7CmpSchemePromptBox.class.getName());
        this.prmtCmpScheme.setSelector((KDPromptSelector)f7PromptBox);
        this.rootHroId = newRootHroId;
        this.hroList = newHroList;
        if (this.prmtCmpScheme.getData() == null) {
            return;
        }
        Object[] objs = (Object[])this.prmtCmpScheme.getData();
        boolean flag = true;
        CmpSchemeInfo csInfo = null;
        HROrgUnitInfo hroInfo = null;
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            if (!(objs[i] instanceof CmpSchemeInfo)) continue;
            csInfo = (CmpSchemeInfo)objs[i];
            flag = true;
            for (int t = 0; t < this.hroList.size(); ++t) {
                hroInfo = (HROrgUnitInfo)this.hroList.get(t);
                if (!csInfo.getHrOrgUnit().getId().toString().equals(hroInfo.getId().toString())) continue;
                flag = false;
            }
            if (flag) break;
        }
        if (flag) {
            this.prmtCmpScheme.setValue(null);
            this.lstSelectItem.removeAllElements();
            this.lstSelectItemNotSort.removeAllElements();
            this.lstAllItem.removeAllElements();
        }
    }

    protected ArrayList getSelectHROS(ArrayList adminList) throws Exception {
        if (adminList == null || adminList.size() == 0) {
            return null;
        }
        StringBuffer inStr = new StringBuffer();
        AdminOrgUnitInfo adminInfo = null;
        int size = adminList.size() - 1;
        for (int i = 0; i < size; ++i) {
            adminInfo = (AdminOrgUnitInfo)adminList.get(i);
            inStr.append("'");
            inStr.append(adminInfo.getId());
            inStr.append("',");
        }
        adminInfo = (AdminOrgUnitInfo)adminList.get(adminList.size() - 1);
        inStr.append("'");
        inStr.append(adminInfo.getId());
        inStr.append("'");
        ArrayList<HROrgUnitInfo> hros = new ArrayList<HROrgUnitInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT T_ORG_HRO.FID,T_ORG_HRO.FLongNumber ");
        sql.append("FROM T_ORG_HRO ");
        sql.append("LEFT OUTER JOIN T_ORG_UnitRelation ");
        sql.append("ON T_ORG_UnitRelation.FToUnitID = T_ORG_HRO.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Admin ");
        sql.append("ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID ");
        sql.append("WHERE (T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        sql.append("AND T_ORG_Admin.FID IN (");
        sql.append(inStr);
        sql.append(")) ORDER BY T_ORG_HRO.FLongNumber");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        HROrgUnitInfo hroInfo = null;
        while (rows.next()) {
            hroInfo = new HROrgUnitInfo();
            hroInfo.setId(BOSUuid.read((String)rows.getString(1)));
            hroInfo.setLongNumber(rows.getString(2));
            hros.add(hroInfo);
        }
        return hros;
    }

    protected String getRootHROID(ArrayList hroList) throws Exception {
        if (hroList == null || hroList.size() == 0) {
            return null;
        }
        HROrgUnitInfo hroInfo = (HROrgUnitInfo)hroList.get(0);
        if (hroList.size() == 1) {
            return hroInfo.getId().toString();
        }
        String longNumber = hroInfo.getLongNumber();
        int size = hroList.size();
        for (int i = 1; i < size; ++i) {
            hroInfo = (HROrgUnitInfo)hroList.get(i);
            if (hroInfo.getLongNumber().indexOf(longNumber) != -1) continue;
            longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
        }
        StringBuffer sql = new StringBuffer("SELECT FID FROM T_ORG_HRO WHERE FLongNumber = '");
        sql.append(longNumber);
        sql.append("'");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        if (rows.next()) {
            return rows.getString("FID");
        }
        return null;
    }

    protected void init() throws Exception {
        this.cmbItemCatalog.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int state = ie.getStateChange();
                if (state == 1) {
                    CmpReportFilterBaseUI.this.reloadAllListByItemCatalog();
                }
            }
        });
        this.prmtCmpScheme.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    Object[] objs = (Object[])e.getData();
                    CmpReportFilterBaseUI.this.lstSelectItem.removeAllElements();
                    CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(CmpReportFilterBaseUI.this.cmpItemFilterUI, true, true, new CmpItemInfo[0]);
                    CmpReportFilterBaseUI.this.lstSelectItemNotSort.removeAllElements();
                    CmpReportFilterBaseUI.this.lstAllItem.removeAllElements();
                    CmpReportFilterBaseUI.this.lstSelectItemNotSortData = new ArrayList();
                    CmpReportFilterBaseUI.this.lstSelectItemData = new ArrayList();
                    CmpReportFilterBaseUI.this.lstAllSelectItemData = null;
                    if (objs != null && objs.length != 0) {
                        CmpSchemeInfo[] schemeInfos = CmpReportFilterBaseUI.this.getCmpSchemeInfoArrayByObject(objs);
                        CmpReportFilterBaseUI.this.getCmpItemCollection(schemeInfos, false);
                        CmpReportFilterBaseUI.this.fillCmpItemCatalogData(false);
                        return;
                    }
                }
                catch (Exception exc) {
                    CmpReportFilterBaseUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void fillCmpItemCatalogData(boolean isFromQuerySolution) throws Exception {
        CmpItemCatalogCollection colCmpItemCatalog = null;
        if (isFromQuerySolution && this.f7Info != null) {
            colCmpItemCatalog = this.f7Info.getColCmpItemCatalog();
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
            if (this.perItemFilter) {
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FPER", CompareType.NOTEQUALS));
                filterInfo.setMaskString(" #0 and #1");
            }
            SorterItemCollection sort = new SorterItemCollection();
            sort.add(new SorterItemInfo("longnumber"));
            evi.setSorter(sort);
            evi.setFilter(filterInfo);
            colCmpItemCatalog = CmpItemCatalogFactory.getRemoteInstance().getCmpItemCatalogCollection(evi);
        }
        if (colCmpItemCatalog == null || colCmpItemCatalog.size() <= 0) {
            return;
        }
        Iterator itr = colCmpItemCatalog.iterator();
        CmpItemCatalogInfo cmpItemCatalogInfo = null;
        this.cmbItemCatalog.removeAllItems();
        while (itr.hasNext()) {
            cmpItemCatalogInfo = (CmpItemCatalogInfo)itr.next();
            this.cmbItemCatalog.addItem((Object)cmpItemCatalogInfo);
        }
    }

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        }
        return this.hrOrgUnitInfo;
    }

    protected CmpItemCollection getCmpItemCollection(CmpSchemeInfo[] schemeInfos, boolean isFromQuerySolution) throws Exception {
        this.lstAllItem.removeAllElements();
        if (schemeInfos == null || schemeInfos.length == 0) {
            return null;
        }
        ArrayList<String> schemeIDs = new ArrayList<String>();
        for (int i = 0; i < schemeInfos.length; ++i) {
            schemeIDs.add(schemeInfos[i].getId().toString());
        }
        List cmpItemList = null;
        if (isFromQuerySolution && this.f7Info != null) {
            this.colCmpItem = this.f7Info.getPersonItemColl();
            cmpItemList = this.f7Info.getCmpItemList();
            this.deletedItemSet = this.f7Info.getDeletedItemSet();
        } else {
            this.colCmpItem = HRCommonQueryUtils.getPersonItems();
            cmpItemList = this.getSchemeItemBizInteface().getAllItemsByScheme(schemeIDs, this.getEntityViewInfo(schemeIDs));
            this.deletedItemSet = this.getSchemeItemBizInteface().getDeletedCmpItem(schemeIDs);
        }
        if (cmpItemList == null || cmpItemList.size() == 0) {
            return this.colCmpItem;
        }
        CombinCmpItemInfo combinItemInfo = null;
        for (int i = 0; i < cmpItemList.size(); ++i) {
            combinItemInfo = (CombinCmpItemInfo)cmpItemList.get(i);
            combinItemInfo.getCmpItemInfo().put(COLLECT_STATE, combinItemInfo.getCollectState());
            this.colCmpItem.add(combinItemInfo.getCmpItemInfo());
        }
        this.getColNecessaryCmpItem();
        return this.colCmpItem;
    }

    public void getColNecessaryCmpItem() {
        if (this.colCmpItem == null) {
            return;
        }
        this.colNecessaryCmpItem = new CmpItemCollection();
        if (this.perItemFilter) {
            return;
        }
        Iterator itr = this.colCmpItem.iterator();
        CmpItemInfo info = null;
        while (itr.hasNext()) {
            info = (CmpItemInfo)itr.next();
            if (!this.isNecessaryCmpItem(info)) continue;
            this.colNecessaryCmpItem.add(info);
        }
        this.initLstSelectItem();
    }

    protected EntityViewInfo getEntityViewInfo(List schemeIDs) {
        return HRCommonQueryUtils.getEntityViewInfo(schemeIDs, this.dataTypeFilter, this.displaySAL000);
    }

    protected void reloadAllListByItemCatalog() {
        try {
            this.lstAllSelectItemData = this.getAllSelectItem();
            this.onLoadAllList();
            this.setUnenabledItem();
            this.lstAllItem.requestFocus();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public List getAllSelectItem() {
        int i;
        ArrayList<CmpItemInfo> allSelectItems = new ArrayList<CmpItemInfo>();
        CmpItemInfo priItem = null;
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        this.lstSelectItemNotSortData = new ArrayList();
        size = this.lstSelectItemNotSort.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstSelectItemNotSortData.add(this.lstSelectItemNotSort.getElement(i));
        }
        if (this.lstSelectItemData != null) {
            allSelectItems.addAll(this.lstSelectItemData);
        }
        if (this.lstSelectItemNotSortData != null) {
            if (allSelectItems.size() == 0) {
                allSelectItems.addAll(this.lstSelectItemNotSortData);
                return allSelectItems;
            }
            for (i = 0; i < this.lstSelectItemNotSortData.size(); ++i) {
                priItem = (CmpItemInfo)this.lstSelectItemNotSortData.get(i);
                CmpItemInfo selectItem = null;
                boolean contains = false;
                for (int j = 0; j < allSelectItems.size(); ++j) {
                    selectItem = (CmpItemInfo)allSelectItems.get(j);
                    if (!selectItem.getNumber().equals(priItem.getNumber())) continue;
                    contains = true;
                }
                if (contains) continue;
                allSelectItems.add(priItem);
            }
        }
        return allSelectItems;
    }

    private void onLoadAllList() throws BOSException {
        CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
        if (infoCmpItemCatalog == null || this.colCmpItem == null) {
            return;
        }
        this.lstAllSelectItemData = this.getAllSelectItem();
        this.lstAllItem.removeAllElements();
        Iterator itrCmpItem = this.colCmpItem.iterator();
        CmpItemInfo infoCmpItem = null;
        CmpItemCatalogInfo infoTemp = null;
        while (itrCmpItem.hasNext()) {
            infoCmpItem = (CmpItemInfo)itrCmpItem.next();
            infoTemp = infoCmpItem.getCmpItemCatalog();
            if (infoTemp == null || !infoTemp.getNumber().equals(infoCmpItemCatalog.getNumber())) continue;
            boolean isSame = false;
            CmpItemInfo infoTempCmpItem = null;
            int count = this.lstAllSelectItemData.size();
            for (int i = 0; i < count; ++i) {
                infoTempCmpItem = (CmpItemInfo)this.lstAllSelectItemData.get(i);
                if (infoTempCmpItem == null || infoTempCmpItem.getId() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"237_CmpReportFilterBaseUI"));
                    return;
                }
                if (!infoTempCmpItem.getNumber().equals(infoCmpItem.getNumber())) continue;
                isSame = true;
            }
            if (isSame) continue;
            this.lstAllItem.addElement((Object)infoCmpItem);
        }
        if (this.lstAllItem.getElementCount() > 0) {
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    protected CmpSchemeInfo[] getCmpSchemeInfoArrayByObject(Object[] objA) {
        if (objA == null || objA.length == 0) {
            return null;
        }
        CmpSchemeInfo[] info = new CmpSchemeInfo[objA.length];
        int size = objA.length;
        for (int i = 0; i < size; ++i) {
            info[i] = (CmpSchemeInfo)objA[i];
        }
        return info;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstAllItem_mouseClicked(e);
        super.lstAllItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.leftToRight();
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstSelectItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.rightToLeft();
        }
    }

    @Override
    protected void lstSelectItemNotSort_mouseClicked(MouseEvent e) throws Exception {
        super.lstSelectItemNotSort_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.rightToLeft();
        }
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllLeft_actionPerformed(e);
        this.allRightToLeftItem();
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeft_actionPerformed(e);
        this.rightToLeft();
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionRight_actionPerformed(e);
        this.leftToRight();
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllRight_actionPerformed(e);
        this.allLeftToRightItem();
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
            this.lstSelectItemNotSort.setSelectedIndex(-1);
        }
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionMovePre_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveNext_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
    }

    protected void leftToRight() {
        if (this.lstAllItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            for (int i = 0; i < this.colCmpItem.size(); ++i) {
                CmpItemInfo cur = this.colCmpItem.get(i);
                if (!cur.getNumber().equals(info.getNumber())) continue;
                info = cur;
                break;
            }
            boolean isAddToSelect = false;
            int indexSelect = 0;
            if (info.getNumber().startsWith("FPER")) {
                indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
                this.lstSelectItem.insertElement((Object)info, indexSelect);
                this.lstSelectItem.setSelectedValue((Object)info, true);
                isAddToSelect = true;
            } else if (info.get(COLLECT_STATE) != null) {
                if (((String)info.get(COLLECT_STATE)).indexOf("1") > -1 && !this.isContainTheSame(info, this.lstSelectItem)) {
                    indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
                    this.lstSelectItem.insertElement((Object)info, indexSelect);
                    this.lstSelectItem.setSelectedValue((Object)info, true);
                    isAddToSelect = true;
                }
                if (((String)info.get(COLLECT_STATE)).indexOf("0") > -1 && !this.isContainTheSame(info, this.lstSelectItemNotSort)) {
                    indexSelect = this.lstSelectItemNotSort.getSelectedIndex() + 1;
                    this.lstSelectItemNotSort.insertElement((Object)info, indexSelect);
                    this.lstSelectItemNotSort.setSelectedValue((Object)info, true);
                    this.lstAllItem.removeElement((Object)info);
                }
            }
            if (isAddToSelect) {
                CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, false, false, new CmpItemInfo[]{info});
            }
            if (isAddToSelect) {
                this.lstAllItem.removeElement((Object)info);
                if (index - 1 > 0) {
                    this.lstAllItem.setSelectedIndex(index - 1);
                } else if (this.lstAllItem.getElementCount() > 0) {
                    this.lstAllItem.setSelectedIndex(0);
                }
            }
        }
    }

    protected void allLeftToRightItem() {
        int count = this.lstAllItem.getElementCount();
        boolean isAddToSelect = false;
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                if (info.getNumber().startsWith("FPER")) {
                    this.lstSelectItem.addElement((Object)info);
                } else if (info.get(COLLECT_STATE) != null) {
                    if (((String)info.get(COLLECT_STATE)).indexOf("0") > -1 && !this.isContainTheSame(info, this.lstSelectItemNotSort)) {
                        this.lstSelectItemNotSort.addElement((Object)info);
                    }
                    if (((String)info.get(COLLECT_STATE)).indexOf("1") > -1 && !this.isContainTheSame(info, this.lstSelectItem)) {
                        isAddToSelect = true;
                        this.lstSelectItem.addElement((Object)info);
                    }
                }
                this.lstAllItem.removeElement((Object)info);
            }
            if (isAddToSelect) {
                CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.lstSelectItem);
            }
        }
    }

    protected void rightToLeft() {
        int index = this.lstSelectItem.getSelectedIndex();
        CmpItemInfo info = null;
        CmpItemCatalogInfo infoCmpItemCatalog = null;
        CmpItemCatalogInfo infoTemp = null;
        if (index >= 0 && !this.isNecessaryCmpItem(info = (CmpItemInfo)this.lstSelectItem.getElement(index))) {
            this.lstSelectItem.removeElement((Object)info);
            CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.lstSelectItem);
            infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
            infoTemp = info.getCmpItemCatalog();
            if (infoCmpItemCatalog != null && !this.isContainTheSame(info, this.lstAllItem) && infoTemp.getNumber().equals(infoCmpItemCatalog.getNumber())) {
                this.lstAllItem.addElement((Object)info);
            }
        }
        if ((index = this.lstSelectItemNotSort.getSelectedIndex()) > -1 && !this.isNecessaryCmpItem(info = (CmpItemInfo)this.lstSelectItemNotSort.getElement(index))) {
            this.lstSelectItemNotSort.removeElement((Object)info);
            if (info != null) {
                infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
                infoTemp = info.getCmpItemCatalog();
                if (infoCmpItemCatalog != null && !this.isContainTheSame(info, this.lstAllItem) && infoTemp.getNumber().equals(infoCmpItemCatalog.getNumber())) {
                    this.lstAllItem.addElement((Object)info);
                }
            }
        }
    }

    protected void allRightToLeftItem() {
        CmpItemCatalogInfo infoTemp;
        CmpItemCatalogInfo infoCmpItemCatalog;
        int i;
        int count = this.lstSelectItem.getElementCount();
        CmpItemInfo info = null;
        if (count > 0) {
            for (i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                if (!this.isNecessaryCmpItem(info)) {
                    infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
                    infoTemp = info.getCmpItemCatalog();
                    if (infoCmpItemCatalog != null && !this.isContainTheSame(info, this.lstAllItem) && infoTemp.getNumber().equals(infoCmpItemCatalog.getNumber())) {
                        this.lstAllItem.addElement((Object)info);
                    }
                }
                this.lstSelectItem.removeElement((Object)info);
            }
            CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.lstSelectItem);
        }
        if ((count = this.lstSelectItemNotSort.getElementCount()) > 0) {
            for (i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItemNotSort.getElement(0);
                if (!this.isNecessaryCmpItem(info)) {
                    infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
                    infoTemp = info.getCmpItemCatalog();
                    if (infoCmpItemCatalog != null && !this.isContainTheSame(info, this.lstAllItem) && infoTemp.getNumber().equals(infoCmpItemCatalog.getNumber())) {
                        this.lstAllItem.addElement((Object)info);
                    }
                }
                this.lstSelectItemNotSort.removeElement((Object)info);
            }
        }
        this.initLstSelectItem();
    }

    private boolean isContainTheSame(CmpItemInfo itemInfo, KDList kDList) {
        if (itemInfo == null) {
            return true;
        }
        int count = kDList.getElementCount();
        if (count <= 0) {
            return false;
        }
        CmpItemInfo info = null;
        for (int i = 0; i < count; ++i) {
            info = (CmpItemInfo)kDList.getElement(i);
            if (!info.getNumber().equals(itemInfo.getNumber())) continue;
            return true;
        }
        return false;
    }

    protected boolean isNecessaryCmpItem(CmpItemInfo info) {
        return false;
    }

    private void initLstSelectItem() {
        Iterator itr = this.colNecessaryCmpItem.iterator();
        CmpItemInfo infoCmpItem = null;
        while (itr.hasNext()) {
            infoCmpItem = (CmpItemInfo)itr.next();
            this.insertToSelectItem(infoCmpItem);
        }
    }

    private void insertToSelectItem(CmpItemInfo info) {
        if (info == null) {
            this.lstAllItem.removeElement(null);
            return;
        }
        if (info.getNumber().startsWith("FPER")) {
            this.lstSelectItem.addElement((Object)info);
            this.lstSelectItemData.add(info);
            CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, false, false, new CmpItemInfo[]{info});
        } else if ((String)info.get(COLLECT_STATE) != null) {
            if (((String)info.get(COLLECT_STATE)).indexOf("0") > -1) {
                this.lstSelectItemNotSort.addElement((Object)info);
                this.lstSelectItemNotSortData.add(info);
            }
            if (((String)info.get(COLLECT_STATE)).indexOf("1") > -1) {
                this.lstSelectItem.addElement((Object)info);
                this.lstSelectItemData.add(info);
                CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, false, false, new CmpItemInfo[]{info});
            }
        } else {
            this.lstSelectItemNotSort.addElement((Object)info);
            this.lstSelectItemNotSortData.add(info);
        }
        this.lstAllItem.removeElement((Object)info);
    }

    protected String getHROrgUnitIDByUserPermssion() throws Exception {
        if (StringUtils.isEmpty((String)this.rootHroId)) {
            this.rootHroId = CmpCommonFacadeFactory.getRemoteInstance().getHROrgUnitIDByUserPermssion();
        }
        return this.rootHroId;
    }

    private Set formatSetCmpSchemeId(String cmpSchemeStr) {
        if (StringUtils.isEmpty((String)cmpSchemeStr)) {
            return new HashSet();
        }
        String[] idArr = cmpSchemeStr.split("~");
        HashSet<String> set = new HashSet<String>();
        int size = idArr.length;
        for (int i = 0; i < size; ++i) {
            set.add(idArr[i]);
        }
        return set;
    }

    private void loadCmpScheme(CmpSchemeCollection cmpSchemeColl) throws CmpReportException {
        logger.info((Object)"CmpReportFilterBaseUI.loadCmpScheme");
        CmpSchemeCollection cmpColl = this.sortScheme(cmpSchemeColl);
        if (cmpColl == null) {
            return;
        }
        CmpSchemeInfo[] cmpSchemeArr = new CmpSchemeInfo[cmpColl.size()];
        int size = cmpColl.size();
        for (int i = 0; i < size; ++i) {
            cmpSchemeArr[i] = cmpColl.get(i);
        }
        this.prmtCmpScheme.setData((Object)cmpSchemeArr);
        try {
            this.getCmpItemCollection(cmpSchemeArr, true);
            this.fillCmpItemCatalogData(true);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private CmpSchemeCollection sortScheme(CmpSchemeCollection schemeColl) {
        if (schemeColl == null || schemeColl.size() <= 0) {
            return null;
        }
        ArrayList<CmpSchemeInfo> cmpSchemeList = new ArrayList<CmpSchemeInfo>();
        int size = schemeColl.size();
        for (int i = 0; i < size; ++i) {
            cmpSchemeList.add(schemeColl.get(i));
        }
        Comparator orderName = new Comparator(){

            public int compare(Object o1, Object o2) {
                CmpSchemeInfo scheme1 = (CmpSchemeInfo)o1;
                CmpSchemeInfo scheme2 = (CmpSchemeInfo)o2;
                return scheme1.getName().compareTo(scheme2.getName());
            }
        };
        Collections.sort(cmpSchemeList, orderName);
        CmpSchemeCollection schemeCollection = new CmpSchemeCollection();
        int size2 = cmpSchemeList.size();
        for (int i = 0; i < size2; ++i) {
            schemeCollection.add((CmpSchemeInfo)cmpSchemeList.get(i));
        }
        return schemeCollection;
    }

    protected void changeTheCollectProValue() {
        block5: {
            block4: {
                if (this.lstSelectItemData == null || this.lstSelectItemData.size() <= 0) break block4;
                CmpItemInfo combinItem = null;
                for (int i = 0; i < this.lstSelectItemData.size(); ++i) {
                    combinItem = (CmpItemInfo)this.lstSelectItemData.get(i);
                    if (combinItem == null) continue;
                    combinItem.put(COLLECT_STATE, "1");
                    if (this.lstSelectItemNotSortData == null) continue;
                    CmpItemInfo privateItem = null;
                    for (int j = 0; j < this.lstSelectItemNotSortData.size(); ++j) {
                        privateItem = (CmpItemInfo)this.lstSelectItemNotSortData.get(j);
                        if (privateItem.getNumber().equals(combinItem.getNumber())) {
                            combinItem.put(COLLECT_STATE, "10");
                            privateItem.put(COLLECT_STATE, "10");
                        }
                        if (privateItem.get(COLLECT_STATE) != null) continue;
                        privateItem.put(COLLECT_STATE, "0");
                    }
                }
                break block5;
            }
            if (this.lstSelectItemNotSortData == null || this.lstSelectItemNotSortData.size() <= 0) break block5;
            CmpItemInfo privateItem = null;
            for (int j = 0; j < this.lstSelectItemNotSortData.size(); ++j) {
                privateItem = (CmpItemInfo)this.lstSelectItemNotSortData.get(j);
                privateItem.put(COLLECT_STATE, "0");
            }
        }
    }

    public List getInfoCmpSchemeList() {
        CmpSchemeInfo[] info = this.getCmpSchemeColl();
        ArrayList<CmpSchemeInfo> alCmpScheme = new ArrayList<CmpSchemeInfo>();
        if (info == null) {
            return alCmpScheme;
        }
        int size = info.length;
        for (int i = 0; i < size; ++i) {
            alCmpScheme.add(info[i]);
        }
        return alCmpScheme;
    }

    public CmpSchemeInfo[] getCmpSchemeColl() {
        CmpSchemeInfo[] infos = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
        return infos;
    }

    public AdminOrgUnitCollection getDeptCol() {
        AdminOrgUnitCollection colDept = new AdminOrgUnitCollection();
        Object[] value = (Object[])this.prmtAdminUnitOrg.getData();
        if (value != null && value.length > 0) {
            for (int i = 0; i < value.length; ++i) {
                colDept.add((AdminOrgUnitInfo)value[i]);
            }
        }
        return colDept;
    }

    public AdminOrgUnitCollection getDeptCol(boolean isShowSealUp) {
        AdminOrgUnitCollection colDept = new AdminOrgUnitCollection();
        Object[] value = (Object[])this.prmtAdminUnitOrg.getData();
        HashSet<String> set = new HashSet<String>();
        if (value != null && value.length > 0) {
            for (int i = 0; i < value.length; ++i) {
                if (isShowSealUp) {
                    colDept.add((AdminOrgUnitInfo)value[i]);
                    continue;
                }
                set.add(((AdminOrgUnitInfo)value[i]).getId().toString());
            }
        }
        if (!isShowSealUp && set.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            try {
                IAdminOrgUnit iadmin = AdminOrgUnitFactory.getRemoteInstance();
                AdminOrgUnitCollection adminColl = iadmin.getAdminOrgUnitCollection(viewInfo);
                AdminOrgUnitInfo adminInfo = null;
                int size = adminColl.size();
                for (int i = 0; i < size; ++i) {
                    adminInfo = adminColl.get(i);
                    if (adminInfo.isIsSealUp()) continue;
                    colDept.add(adminInfo);
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return colDept;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        RptParams params = rcm.toRptParams();
        params.setObject("customFilterMap", (Object)this.getCustomFilterMap());
        return params;
    }

    public void setCustomCondition(RptParams params) {
    }

    @Override
    protected void chkShowDelete_itemStateChanged(ItemEvent e) throws Exception {
        super.chkShowDelete_itemStateChanged(e);
        HRF7CmpSchemePromptBox f7PromptBox = (HRF7CmpSchemePromptBox)this.prmtCmpScheme.getSelector();
        if (f7PromptBox != null) {
            f7PromptBox.setIsShowDelete(this.chkShowDelete.isSelected());
        }
    }

    public String getRootHROrgUnitID() {
        return this.rootHroId;
    }

    @Override
    protected void chkIncDelItem_itemStateChanged(ItemEvent e) throws Exception {
        this.reloadAllListByItemCatalog();
    }

    public void setUnenabledItem() {
        if (this.chkIncDelItem.isSelected()) {
            int i;
            int size;
            CmpItemInfo infoCmpItem = null;
            String cmpItemID = null;
            String itemCatalog = null;
            if (this.lstAllSelectItemData != null) {
                size = this.lstAllSelectItemData.size();
                for (i = 0; i < size; ++i) {
                    infoCmpItem = (CmpItemInfo)this.lstAllSelectItemData.get(i);
                    itemCatalog = infoCmpItem.getCmpItemCatalog().getNumber();
                    cmpItemID = infoCmpItem.getNumber();
                    if (this.deletedItemSet.contains(cmpItemID) || itemCatalog.startsWith("FPER")) continue;
                    this.lstAllSelectItemData.remove(i);
                    --size;
                }
            }
            if (this.lstSelectItemData != null) {
                size = this.lstSelectItemData.size();
                for (i = 0; i < size; ++i) {
                    infoCmpItem = (CmpItemInfo)this.lstSelectItemData.get(i);
                    itemCatalog = infoCmpItem.getCmpItemCatalog().getNumber();
                    cmpItemID = infoCmpItem.getNumber();
                    if (this.deletedItemSet.contains(cmpItemID) || itemCatalog.startsWith("FPER")) continue;
                    this.lstSelectItemData.remove(i);
                    --size;
                }
            }
            if (this.lstSelectItemNotSortData != null) {
                size = this.lstSelectItemNotSortData.size();
                for (i = 0; i < size; ++i) {
                    infoCmpItem = (CmpItemInfo)this.lstSelectItemNotSortData.get(i);
                    itemCatalog = infoCmpItem.getCmpItemCatalog().getNumber();
                    cmpItemID = infoCmpItem.getNumber();
                    if (this.deletedItemSet.contains(cmpItemID) || itemCatalog.startsWith("FPER")) continue;
                    this.lstSelectItemNotSortData.remove(i);
                    --size;
                }
            }
            if (this.lstAllItem != null) {
                size = this.lstAllItem.getElementCount();
                for (i = 0; i < size; ++i) {
                    infoCmpItem = (CmpItemInfo)this.lstAllItem.getElement(i);
                    itemCatalog = infoCmpItem.getCmpItemCatalog().getNumber();
                    cmpItemID = infoCmpItem.getNumber();
                    if (this.deletedItemSet.contains(cmpItemID) || itemCatalog.startsWith("FPER")) continue;
                    this.lstAllItem.removeElementAt(i);
                    --i;
                    --size;
                }
            }
            if (this.lstSelectItem != null) {
                size = this.lstSelectItem.getElementCount();
                for (i = 0; i < size; ++i) {
                    infoCmpItem = (CmpItemInfo)this.lstSelectItem.getElement(i);
                    itemCatalog = infoCmpItem.getCmpItemCatalog().getNumber();
                    cmpItemID = infoCmpItem.getNumber();
                    if (this.deletedItemSet.contains(cmpItemID) || itemCatalog.startsWith("FPER")) continue;
                    this.lstSelectItem.removeElementAt(i);
                    --i;
                    --size;
                }
            }
            if (this.lstSelectItemNotSort != null) {
                size = this.lstSelectItemNotSort.getElementCount();
                for (i = 0; i < size; ++i) {
                    infoCmpItem = (CmpItemInfo)this.lstSelectItemNotSort.getElement(i);
                    itemCatalog = infoCmpItem.getCmpItemCatalog().getNumber();
                    cmpItemID = infoCmpItem.getNumber();
                    if (this.deletedItemSet.contains(cmpItemID) || itemCatalog.startsWith("FPER")) continue;
                    this.lstSelectItemNotSort.removeElementAt(i);
                    --i;
                    --size;
                }
            }
            CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.lstSelectItem);
        }
    }

    protected Map getF7ParamMap(CustomerParams cp) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("cmpreport_isNeed_cmpItem", Boolean.TRUE);
        paramMap.put("cmpreport_perItemFilter", this.perItemFilter);
        paramMap.put("cmpreport_dataTypeFilter", this.dataTypeFilter);
        paramMap.put("cmpreport_display_FSAL000", this.displaySAL000);
        String value = cp.getCustomerParam("prmtAdminUnitOrg");
        String[] idArrays = null;
        if (!StringUtils.isEmpty((String)value)) {
            idArrays = StringUtils.split((String)value, (String)"\u2014\u2014");
            paramMap.put("cmpreport_admin_mul", idArrays);
        }
        if (!StringUtils.isEmpty((String)(value = cp.getCustomerParam("prmtCmpPeriod")))) {
            paramMap.put("cmpreport_period_start", value);
        }
        if (!StringUtils.isEmpty((String)(value = cp.getCustomerParam("prmtCmpScheme")))) {
            idArrays = value.split("~");
            paramMap.put("cmpreport_scheme_mul", idArrays);
        }
        if (!StringUtils.isEmpty((String)(value = cp.getCustomerParam("selectListItem")))) {
            idArrays = value.split("~");
            if (idArrays.length <= 1) {
                idArrays = value.split("-");
            }
            paramMap.put("cmpreport_item_public", idArrays);
        }
        if (!StringUtils.isEmpty((String)(value = cp.getCustomerParam("lstSelectItemNotSort")))) {
            idArrays = value.split("~");
            paramMap.put("cmpreport_item_private", idArrays);
        }
        return paramMap;
    }

    protected CmpReportFilterF7Info getF7Info(Map paramMap) throws EASBizException, BOSException {
        ICmpCommonFacade cmpCommonFacade = CmpCommonFacadeFactory.getRemoteInstance();
        CmpReportFilterF7Info f7Info = cmpCommonFacade.getF7InfoFromFilterUI(paramMap);
        return f7Info;
    }

    protected CmpPeriodCollection getCmpPeriodCollFromF7Info() {
        if (this.f7Info != null) {
            return this.f7Info.getPeriodColl();
        }
        return null;
    }

    protected Map getHaveDataInPeriods() {
        if (this.f7Info != null) {
            return this.f7Info.getHasDataSchemeMap();
        }
        return null;
    }

    protected boolean isLoaded() {
        return true;
    }

    protected AdminOrgUnitInfo getAdminOrgUnitInfo() {
        return this.adminInfo;
    }
}

