/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemePerFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemePersonCollection;
import com.kingdee.eas.hr.compensation.CmpSchemePersonInfo;
import com.kingdee.eas.hr.compensation.ICmpSchemePerFacade;
import com.kingdee.eas.hr.compensation.TaxSchemeFactory;
import com.kingdee.eas.hr.compensation.client.AbstractCmpSchemePersonListUI;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class CmpSchemePersonListUI
extends AbstractCmpSchemePersonListUI {
    private static final String CMPID = "cmpScheme.id";
    private static final String ID = "id";
    private static final String CMPNUM = "cmpScheme.number";
    private static final String CMPNAME = "cmpScheme.name";
    private ArrayList list = new ArrayList();
    HashMap mapCmpScheme = new HashMap();
    private IIDList iIDListPersons = null;
    CmpSchemeCollection colCmpScheme = new CmpSchemeCollection();
    private static final Logger logger = CoreUIObject.getLogger(CmpSchemePersonListUI.class);

    public void onLoad() throws Exception {
        this.iIDListPersons = (IIDList)this.getUIContext().get("perIdList");
        this.loadDataForTblMain();
        this.initUI();
        this.changeDefaultProps();
        this.initWorkButton();
    }

    protected void initListener() {
        super.initListener();
        CompUtils.setEditorForCell(this.tblMain, null, "com.kingdee.eas.hr.compensation.app.F7CmpSchemeQuery", CMPNAME);
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox = HRSchemeUtils.getCmpSchemeF7(bizPromptBox);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("audit", (Object)10));
        filter.getFilterItems().add(new FilterItemInfo("audit", (Object)30));
        filter.setMaskString("#0 or #1");
        try {
            bizPromptBox.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        bizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent evi) {
                if (evi.getNewValue() != null && evi.getNewValue() instanceof CmpSchemeInfo) {
                    CmpSchemeInfo infoCmpScheme = (CmpSchemeInfo)evi.getNewValue();
                    ICell iCell = null;
                    Object iRow = null;
                    int size = CmpSchemePersonListUI.this.tblMain.getRowCount();
                    for (int i = 0; i < size && (iCell = CmpSchemePersonListUI.this.tblMain.getRow(i).getCell(CmpSchemePersonListUI.CMPID)) != null && iCell.getValue() != null; ++i) {
                        String id = iCell.getValue().toString();
                        if (id == null || !id.endsWith(infoCmpScheme.getId().toString())) continue;
                        CmpSchemePersonListUI.this.tblMain.getRow(CmpSchemePersonListUI.this.tblMain.getSelectManager().getActiveRowIndex()).getCell(CmpSchemePersonListUI.CMPNAME).setValue((Object)"");
                        return;
                    }
                    CmpSchemePersonListUI.this.tblMain.getRow(CmpSchemePersonListUI.this.tblMain.getSelectManager().getActiveRowIndex()).getCell(CmpSchemePersonListUI.CMPID).setValue((Object)infoCmpScheme.getId().toString());
                    CmpSchemePersonListUI.this.tblMain.getRow(CmpSchemePersonListUI.this.tblMain.getSelectManager().getActiveRowIndex()).getCell(CmpSchemePersonListUI.CMPNUM).setValue((Object)infoCmpScheme.getNumber());
                }
            }
        });
        this.tblMain.getColumn(CMPNAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptBox));
    }

    private void fillCmpSchemeTableRow(CmpSchemeInfo info, boolean addRow) {
        if (info == null) {
            return;
        }
        ICell iCell = null;
        IRow iRow = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            iCell = this.tblMain.getRow(i).getCell(CMPID);
            if (iCell == null || iCell.getValue() == null) {
                return;
            }
            String id = iCell.getValue().toString();
            if (id == null || !id.endsWith(info.getId().toString())) continue;
            return;
        }
        iRow = addRow ? this.tblMain.addRow() : this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        iCell = iRow.getCell(CMPID);
        if (iCell != null) {
            iCell.setValue((Object)info.getId().toString());
        }
        if ((iCell = iRow.getCell(CMPNUM)) != null) {
            iCell.setValue((Object)info.getNumber());
        }
        if ((iCell = iRow.getCell(CMPNAME)) != null) {
            iCell.setValue((Object)info.getName());
        }
    }

    private void loadDataForTblMain() throws BOSException, SQLException {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.colCmpScheme = new CmpSchemeCollection();
        HashSet<String> set = new HashSet<String>();
        int size = this.iIDListPersons.size();
        for (int i = 0; i < size; ++i) {
            set.add(this.iIDListPersons.getID(i));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", set, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.isDelete", (Object)Boolean.FALSE));
        view.setFilter(filterInfo);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        exec.setObjectView(view);
        IRowSet rows = exec.executeQuery();
        this.mapCmpScheme = new HashMap();
        String CMPSCHEMEID = null;
        String PERSONID = null;
        CmpSchemeInfo infoCmpScheme = null;
        while (rows.next()) {
            CMPSCHEMEID = rows.getString("CMPSCHEME.ID");
            PERSONID = rows.getString("PERSON.ID");
            infoCmpScheme = (CmpSchemeInfo)this.mapCmpScheme.get(CMPSCHEMEID);
            if (infoCmpScheme == null) {
                infoCmpScheme = new CmpSchemeInfo();
                infoCmpScheme.setId(BOSUuid.read((String)CMPSCHEMEID));
                infoCmpScheme.setName(rows.getString("CMPSCHEME.NAME"));
                infoCmpScheme.setNumber(rows.getString("CMPSCHEME.NUMBER"));
                CmpSchemePersonCollection colTemp = new CmpSchemePersonCollection();
                infoCmpScheme.setPersons(colTemp);
            }
            CmpSchemePersonInfo infoTemp = new CmpSchemePersonInfo();
            PersonInfo infoPerson = new PersonInfo();
            infoPerson.setId(BOSUuid.read((String)PERSONID));
            infoTemp.setPerson(infoPerson);
            infoCmpScheme.getPersons().add(infoTemp);
            this.mapCmpScheme.put(CMPSCHEMEID, infoCmpScheme);
        }
        if (!this.mapCmpScheme.isEmpty()) {
            for (CmpSchemeInfo infoTemp : this.mapCmpScheme.values()) {
                if (infoTemp.getPersons().size() != this.iIDListPersons.size()) continue;
                this.fillCmpSchemeTableRow(infoTemp, true);
                this.colCmpScheme.add(infoTemp);
            }
        }
        this.tblMain.getColumn(CMPNAME).getStyleAttributes().setLocked(false);
    }

    private void changeDefaultProps() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(CMPNUM).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(CMPNAME).getStyleAttributes().setLocked(false);
    }

    private void initUI() {
        this.txtNumber.setText(this.getUIContext().get("perNum").toString());
        this.txtName.setText(this.getUIContext().get("perName").toString());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kDContainer1.addButton((JButton)this.btnAddRow);
        this.kDContainer1.addButton((JButton)this.btnDelRow);
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnSave);
        this.btnSave.setEnabled(true);
        this.btnEdit.setVisible(false);
        this.btnAttachment.setVisible(false);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    private void executeQuery() {
    }

    @Override
    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    protected void btnDelRow_actionPerformed(ActionEvent e) throws Exception {
        int activeIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeIndex >= 0) {
            this.tblMain.removeRow(activeIndex);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        boolean isSame;
        String id;
        ArrayList<String> lstPersonIDs = new ArrayList<String>();
        int size = this.iIDListPersons.size();
        for (int i = 0; i < size; ++i) {
            lstPersonIDs.add(this.iIDListPersons.getID(i));
        }
        CmpSchemeCollection colTemp = new CmpSchemeCollection();
        int size2 = this.tblMain.getRowCount();
        for (int i = 0; i < size2 && (id = (String)this.tblMain.getRow(i).getCell(CMPID).getValue()) != null; ++i) {
            isSame = false;
            int n = this.colCmpScheme.size();
            for (int m = 0; m < n; ++m) {
                CmpSchemeInfo infoTemp = this.colCmpScheme.get(m);
                if (!infoTemp.getId().toString().equals(id)) continue;
                isSame = true;
                break;
            }
            if (isSame) continue;
            CmpSchemeInfo infoTemp = new CmpSchemeInfo();
            infoTemp.setId(BOSUuid.read((String)id));
            infoTemp.put("State", "ADD");
            colTemp.add(infoTemp);
        }
        int n = this.colCmpScheme.size();
        for (int m = 0; m < n; ++m) {
            CmpSchemeInfo infoTemp = this.colCmpScheme.get(m);
            isSame = false;
            int size3 = this.tblMain.getRowCount();
            for (int i = 0; i < size3; ++i) {
                String id2 = (String)this.tblMain.getRow(i).getCell(CMPID).getValue();
                if (id2 == null || !infoTemp.getId().toString().equals(id2)) continue;
                isSame = true;
                break;
            }
            if (isSame) continue;
            infoTemp.put("State", "DELETE");
            colTemp.add(infoTemp);
        }
        ICmpSchemePerFacade iCmpSchemePerFacade = CmpSchemePerFacadeFactory.getRemoteInstance();
        iCmpSchemePerFacade.submitCmpScheme((Object)colTemp, lstPersonIDs);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.PersonCmpResource.PERCMP_SAVE_SUCC"));
        this.loadDataForTblMain();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.loadDataForTblMain();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxSchemeFactory.getRemoteInstance();
    }
}

