/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ColCmpSchemeEntryCollection;
import com.kingdee.eas.hr.compensation.ColCmpSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.ColCmpSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.ColCmpSchemeException;
import com.kingdee.eas.hr.compensation.ColCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.ColCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ColCmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.ColCmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.ColCmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.IColCmpSchemeEntry;
import com.kingdee.eas.hr.compensation.IColCmpSchemeItem;
import com.kingdee.eas.hr.compensation.client.AbstractColCmpSchemeEditUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class ColCmpSchemeEditUI
extends AbstractColCmpSchemeEditUI {
    private String colCmpSchemeID = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        ColCmpSchemeInfo info = new ColCmpSchemeInfo();
        SysContext ctx = SysContext.getSysContext();
        UserInfo curUser = (UserInfo)ctx.getProperty((Object)"UserInfo");
        info.setCreator(curUser);
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        info.setCreateTime(new Timestamp(d.getTime().getTime()));
        this.colCmpSchemeID = null;
        this.tblItem.removeRows();
        this.tblScheme.removeRows();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ColCmpSchemeFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnEdit.setVisible(false);
    }

    protected void initListener() {
        super.initListener();
        this.tblScheme.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){
            IRow iRow = null;
            ICell iCell = null;
            boolean isException = false;

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 4) {
                    this.iRow = ColCmpSchemeEditUI.this.tblScheme.getRow(e.getRowIndex());
                    this.iCell = this.iRow.getCell(e.getColIndex());
                    Boolean temp = (Boolean)this.iCell.getValue();
                    try {
                        if (temp.booleanValue()) {
                            this.iCell.setValue((Object)Boolean.FALSE);
                        } else {
                            this.iCell.setValue((Object)Boolean.TRUE);
                        }
                        ColCmpSchemeEditUI.this.doSelectScheme();
                    }
                    catch (Exception e1) {
                        this.editCanceled(null);
                        this.isException = true;
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }

            public void editStopped(KDTEditEvent e) {
                if (this.isException) {
                    this.iCell.setValue((Object)Boolean.FALSE);
                    this.isException = false;
                }
            }

            public void editCanceled(KDTEditEvent e) {
                if (this.isException) {
                    this.iCell.setValue((Object)Boolean.FALSE);
                    this.isException = false;
                }
            }
        });
    }

    private void doSelectScheme() throws Exception {
        if (this.tblScheme.getRowCount() <= 0) {
            return;
        }
        IRow iRow = null;
        ArrayList<String> lstIDs = new ArrayList<String>();
        int size = this.tblScheme.getRowCount();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblScheme.getRow(i);
            if (!((Boolean)iRow.getCell("unite").getValue()).booleanValue()) continue;
            lstIDs.add(iRow.getCell("id").getValue().toString());
        }
        IColCmpSchemeItem iColCmpSchemeItem = ColCmpSchemeItemFactory.getRemoteInstance();
        ObjectUuidPK pk = null;
        if (this.colCmpSchemeID != null) {
            pk = new ObjectUuidPK(this.colCmpSchemeID);
        }
        ColCmpSchemeItemCollection colItem = iColCmpSchemeItem.getColCollection(lstIDs, (IObjectPK)pk);
        this.loadItemTable(colItem);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblItem.checkParsed();
        if (this.getUIContext().get("ID") != null) {
            this.colCmpSchemeID = this.getUIContext().get("ID").toString();
        }
        this.loadSchemeTable();
        this.doSelectScheme();
        this.bizPromptCreator.setDisplayFormat("$name$");
    }

    private void loadSchemeTable() throws Exception {
        this.tblScheme.checkParsed();
        this.tblScheme.removeRows();
        ColCmpSchemeEntryCollection col = this.getColCmpSchemeCollection();
        if (col == null || col.size() <= 0) {
            return;
        }
        ColCmpSchemeEntryInfo info = null;
        ColCmpSchemeInfo infoColCmpScheme = null;
        CmpSchemeInfo infoCmpScheme = null;
        IRow iRow = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            infoColCmpScheme = info.getColCmpScheme();
            infoCmpScheme = info.getCmpScheme();
            iRow = this.tblScheme.addRow();
            iRow.setUserObject((Object)info);
            if (infoCmpScheme != null) {
                iRow.getCell("id").setValue((Object)infoCmpScheme.getId());
                iRow.getCell("name").setValue((Object)infoCmpScheme.getName());
            }
            if (info.isUnit()) {
                iRow.getCell("unite").setValue((Object)Boolean.TRUE);
                continue;
            }
            iRow.getCell("unite").setValue((Object)Boolean.FALSE);
        }
    }

    private void loadItemTable(ColCmpSchemeItemCollection col) throws Exception {
        this.tblItem.removeRows();
        if (col == null || col.size() <= 0) {
            return;
        }
        Iterator itr = col.iterator();
        ColCmpSchemeItemInfo info = null;
        CmpItemInfo infoCmpItem = null;
        IRow iRow = null;
        while (itr.hasNext()) {
            info = (ColCmpSchemeItemInfo)itr.next();
            infoCmpItem = info.getCmpItem();
            iRow = this.tblItem.addRow();
            iRow.setUserObject((Object)info);
            if (infoCmpItem != null) {
                iRow.getCell("id").setValue((Object)infoCmpItem.getId());
                iRow.getCell("number").setValue((Object)infoCmpItem.getNumber());
                iRow.getCell("name").setValue((Object)infoCmpItem.getName());
            }
            if (info.getColCmpScheme() != null) {
                iRow.getCell("unite").setValue((Object)Boolean.TRUE);
                continue;
            }
            iRow.getCell("unite").setValue((Object)Boolean.FALSE);
        }
    }

    private ColCmpSchemeEntryCollection getColCmpSchemeCollection() throws Exception {
        IColCmpSchemeEntry iColCmpSchemeEntry;
        ColCmpSchemeEntryCollection colColCmpSchemeEntry;
        ColCmpSchemeEntryCollection col = new ColCmpSchemeEntryCollection();
        ICmpScheme iCmpScheme = CmpSchemeFactory.getRemoteInstance();
        CmpSchemeCollection colCmpScheme = iCmpScheme.getCmpSchemeCollection("select * where enable=1 and isDelete=0 and hrOrgUnit.id='" + HRSchemeUtils.getClientHROrgUnitInfo().getId().toString() + "'");
        Hashtable<String, CmpSchemeInfo> hst = new Hashtable<String, CmpSchemeInfo>();
        if (this.colCmpSchemeID != null && (colColCmpSchemeEntry = (iColCmpSchemeEntry = ColCmpSchemeEntryFactory.getRemoteInstance()).getColCmpSchemeEntryCollection("select cmpScheme.* where colCmpScheme.id='" + this.colCmpSchemeID + "'")) != null && colColCmpSchemeEntry.size() > 0) {
            int size = colColCmpSchemeEntry.size();
            for (int i = 0; i < size; ++i) {
                CmpSchemeInfo info = colColCmpSchemeEntry.get(i).getCmpScheme();
                hst.put(info.getId().toString(), info);
            }
        }
        ColCmpSchemeEntryInfo info = null;
        Object infoColCmpScheme = null;
        CmpSchemeInfo infoCmpScheme = null;
        Object infoCurrency = null;
        int size = colCmpScheme.size();
        for (int i = 0; i < size; ++i) {
            info = new ColCmpSchemeEntryInfo();
            infoCmpScheme = colCmpScheme.get(i);
            if (hst.get(infoCmpScheme.getId().toString()) != null) {
                info.setUnit(true);
            }
            info.setCmpScheme(infoCmpScheme);
            col.add(info);
        }
        return col;
    }

    private ColCmpSchemeEntryCollection getEntries() throws Exception {
        ColCmpSchemeEntryCollection col = new ColCmpSchemeEntryCollection();
        int indexUnite = this.tblScheme.getColumnIndex("unite");
        int indexID = this.tblScheme.getColumnIndex("id");
        String id = null;
        ColCmpSchemeEntryInfo info = null;
        CmpSchemeInfo infoCmpScheme = null;
        int size = this.tblScheme.getRowCount();
        for (int i = 0; i < size; ++i) {
            Boolean isSelect = (Boolean)this.tblScheme.getCell(i, indexUnite).getValue();
            if (!isSelect.booleanValue()) continue;
            id = this.tblScheme.getCell(i, indexID).getValue().toString();
            info = new ColCmpSchemeEntryInfo();
            infoCmpScheme = new CmpSchemeInfo();
            infoCmpScheme.setId(BOSUuid.read((String)id));
            info.setCmpScheme(infoCmpScheme);
            col.add(info);
        }
        return col;
    }

    private ColCmpSchemeItemCollection getItems() throws Exception {
        ColCmpSchemeItemCollection col = new ColCmpSchemeItemCollection();
        int indexUnite = this.tblItem.getColumnIndex("unite");
        int indexID = this.tblItem.getColumnIndex("id");
        String id = null;
        ColCmpSchemeItemInfo info = null;
        CmpItemInfo infoCmpItem = null;
        int size = this.tblItem.getRowCount();
        for (int i = 0; i < size; ++i) {
            Boolean isSelect = (Boolean)this.tblItem.getCell(i, indexUnite).getValue();
            if (!isSelect.booleanValue()) continue;
            id = this.tblItem.getCell(i, indexID).getValue().toString();
            info = new ColCmpSchemeItemInfo();
            infoCmpItem = new CmpItemInfo();
            infoCmpItem.setId(BOSUuid.read((String)id));
            info.setCmpItem(infoCmpItem);
            col.add(info);
        }
        return col;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.editData.setColCmpSchemeEntry(this.getEntries());
        this.editData.setColCmpSchemeItem(this.getItems());
        super.actionSubmit_actionPerformed(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.loadSchemeTable();
            this.doSelectScheme();
        }
    }

    protected void verifyInput(ActionEvent arg0) throws Exception {
        String number = this.txtNumber.getText();
        if (number == null || number.trim().equals("")) {
            this.txtNumber.requestFocus(true);
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        String name = this.editData.getName();
        if (name == null || name.trim().equals("")) {
            this.txtName.requestFocus(true);
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
        if (this.tblScheme.getRowCount() < 1) {
            throw new ColCmpSchemeException(ColCmpSchemeException.SCHEME_NOTNULL);
        }
        boolean isHas = false;
        int indexUnite = this.tblScheme.getColumnIndex("unite");
        int size = this.tblScheme.getRowCount();
        for (int i = 0; i < size; ++i) {
            Boolean isSelect = (Boolean)this.tblScheme.getCell(i, indexUnite).getValue();
            if (!isSelect.booleanValue()) continue;
            isHas = true;
        }
        if (!isHas) {
            throw new ColCmpSchemeException(ColCmpSchemeException.SCHEME_NOTNULL);
        }
        super.verifyInput(arg0);
    }
}

