/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.client.f7.NewAdminByHROF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.CmpSystemConfigInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.client.AbstractCompensatedPayFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class CompensatedPayFilterUI
extends AbstractCompensatedPayFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CompensatedPayFilterUI.class);
    private String cmpPeriodF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery";
    private String empSumResource = "com.kingdee.eas.hr.compensation.client.EmpSumReportResource.";
    private String hAresourceBasicURL = "com.kingdee.eas.hr.compensation.client.HolidayAttendanceResource.";
    private String CMPSYSTEMCONFIG_TABLE_NAME = "T_HR_CMPSYSTEMCONFIG";
    private String sysConResourceBasicURL = "com.kingdee.eas.hr.base.client.SystemConfigResource.";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        if (this.prmBeginPeriod.getData() != null) {
            this.prmBeginPeriod.setData(null);
        }
        this.prmtAdmin.setValue(null);
        this.chkDisplayAllName.setSelected(false);
    }

    public CmpSystemConfigInfo getSystemCoinfg() throws EASBizException, BOSException {
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add(this.CMPSYSTEMCONFIG_TABLE_NAME);
        boolean fisrtEnterFlag = HRUtils.hasSystemConfig();
        if (!fisrtEnterFlag) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.sysConResourceBasicURL + "FIRSTENTERINFO")));
            SysUtil.abort();
        }
        CmpSystemConfigInfo cmpSysConfigInfo = HRUtils.getSysConfigInfo();
        return cmpSysConfigInfo;
    }

    public boolean verify() {
        if (this.prmBeginPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            this.prmBeginPeriod.requestFocusInWindow();
            return false;
        }
        if (this.prmtAdmin.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"218_CmpItemAccountDeptFilterUI"));
            this.prmtAdmin.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private void msgBoxInfo(String msgStr) {
        MsgBox.showInfo((String)EASResource.getString((String)msgStr));
        SysUtil.abort();
    }

    public CustomerParams getCustomerParams() {
        Object[] ogs;
        Object value;
        CustomerParams cp = new CustomerParams();
        if (this.prmBeginPeriod.getData() != null) {
            cp.addCustomerParam("prmBeginPeriod", ((CmpPeriodInfo)this.prmBeginPeriod.getData()).getId().toString());
        }
        if ((value = this.prmtAdmin.getValue()) != null && value instanceof Object[] && (ogs = (Object[])value).length > 0 && ogs[0] != null) {
            int i;
            StringBuffer orgUnits = new StringBuffer();
            for (i = 0; i < ogs.length - 1; ++i) {
                orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
                orgUnits.append("\u2014\u2014");
            }
            orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
            cp.addCustomerParam("adminOrgUnit", orgUnits.toString());
        }
        cp.putBoolean("displayAllName", this.chkDisplayAllName.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        ObjectUuidPK pkTemp = null;
        try {
            if (cp.getCustomerParam("prmBeginPeriod") != null) {
                pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmBeginPeriod")));
                this.prmBeginPeriod.setData((Object)((CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
            }
            String value = cp.getCustomerParam("adminOrgUnit");
            EntityViewInfo evi = new EntityViewInfo();
            if (!CompensatedPayFilterUI.objectIsNull(value)) {
                String[] adminOrg = StringUtils.split((String)value, (String)"\u2014\u2014");
                IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(adminOrg)), CompareType.INCLUDE));
                evi.setFilter(fi);
                AdminOrgUnitCollection col = adminOrgUnit.getAdminOrgUnitCollection(evi);
                this.prmtAdmin.setValue((Object)col.toArray());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.chkDisplayAllName.setSelected(cp.getBoolean("displayAllName"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        this.prmBeginPeriod.setEditable(false);
    }

    private void initAllEditor() throws Exception {
        this.prmBeginPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("enableState", (Object)"0"));
        filterInfo.setMaskString("#0 and #1");
        evi.setFilter(filterInfo);
        this.prmBeginPeriod.setEntityViewInfo(evi);
        this.initAdminOrg();
        this.chkDisplayAllName.setSelected(false);
    }

    private void initAdminOrg() {
        NewAdminByHROF7 adminF7 = new NewAdminByHROF7();
        adminF7.setMultiSelect(true);
        this.prmtAdmin.setSelector((KDPromptSelector)adminF7);
        this.prmtAdmin.setEditable(false);
        this.prmtAdmin.setDisplayFormat("$name$");
    }

    protected Date getPeriodDate(boolean flag) {
        CmpPeriodInfo cmpPeriodTemp = null;
        if (flag) {
            cmpPeriodTemp = (CmpPeriodInfo)this.prmBeginPeriod.getData();
            return (Date)cmpPeriodTemp.getBeginDate();
        }
        cmpPeriodTemp = (CmpPeriodInfo)this.prmBeginPeriod.getData();
        return (Date)cmpPeriodTemp.getEndDate();
    }

    public AdminOrgUnitCollection getAdminOrgColl() {
        AdminOrgUnitCollection adminColl = new AdminOrgUnitCollection();
        Object[] value = (Object[])this.prmtAdmin.getValue();
        if (value != null && value.length > 0) {
            for (int i = 0; i < value.length; ++i) {
                adminColl.add((AdminOrgUnitInfo)value[i]);
            }
        }
        return adminColl;
    }

    public Set getAdminIDSet() {
        HashSet<String> set = null;
        Object[] value = (Object[])this.prmtAdmin.getValue();
        if (value != null && value.length > 0) {
            set = new HashSet<String>();
            for (int i = 0; i < value.length; ++i) {
                set.add(((AdminOrgUnitInfo)value[i]).getId().toString());
            }
        }
        return set;
    }

    public boolean isDisplayAllName() {
        return this.chkDisplayAllName.isSelected();
    }

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)((String)obj));
        }
        if (obj instanceof DataToken) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }
}

