/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportException;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ISchemeFacade;
import com.kingdee.eas.hr.compensation.SchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.client.AbstractDelHistoryDataUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;

public class DelHistoryDataUI
extends AbstractDelHistoryDataUI {
    String resClass = "com.kingdee.eas.hr.compensation.client.EmpCmpSchmResource.";
    private Date beginDate = null;
    private Date endDate = null;
    private IObjectPK pk = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizPromptCmpScheme = HRSchemeUtils.getDefaultCmpSchemeF7(this.bizPromptCmpScheme);
        this.bizPromptCmpScheme.setEditable(false);
        this.bizPromptBeginDate = HRSchemeUtils.getDefaultCmpPeriodF7(this.bizPromptBeginDate);
        this.bizPromptBeginDate.setEditable(false);
        this.bizPromptEndDate = HRSchemeUtils.getDefaultCmpPeriodF7(this.bizPromptEndDate);
        this.bizPromptEndDate.setEditable(false);
    }

    public DelHistoryDataUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (!this.confirmDelete()) {
            return;
        }
        IObjectPK logPK = null;
        logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new CmpSchemeInfo().getBOSType(), null, (String)(this.bizPromptCmpScheme.getText() + "[" + this.beginDate + "," + this.endDate + "]"), (String)"cmphisdata_delete");
        ISchemeFacade iSchemeFacade = SchemeFacadeFactory.getRemoteInstance();
        iSchemeFacade.delHistoryData(this.pk, this.beginDate, this.endDate);
        LogUtil.afterLog(null, (IObjectPK)logPK);
        MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "DELHISTORYDATA_SUCCESS")));
        this.disposeUIWindow();
    }

    public CmpSchemeInfo getCmpSchemeInfo() {
        return (CmpSchemeInfo)this.bizPromptCmpScheme.getData();
    }

    public CmpPeriodCollection getCmpPeriodCollection() throws Exception {
        CmpPeriodCollection col = null;
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        col = iCmpPeriod.getCmpPeriodCollection(evi);
        return col;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.bizPromptCmpScheme.getData() == null) {
            throw new CmpReportException(CmpReportException.CMPSCHEME_NOT_NULL);
        }
        if (this.bizPromptBeginDate.getData() == null) {
            throw new CmpReportException(CmpReportException.CMPPERIOD_BEGINDATE_NOT_NULL);
        }
        if (this.bizPromptEndDate.getData() == null) {
            throw new CmpReportException(CmpReportException.CMPPERIOD_ENDDATE_NOTNULL);
        }
        this.beginDate = ((CmpPeriodInfo)this.bizPromptBeginDate.getData()).getBeginDate();
        this.endDate = ((CmpPeriodInfo)this.bizPromptEndDate.getData()).getEndDate();
        if (!this.beginDate.before(this.endDate)) {
            throw new CmpReportException(CmpReportException.ENDDATE_NOTLESS_BEGINDATE);
        }
        CmpSchemeInfo infoCmpScheme = (CmpSchemeInfo)this.bizPromptCmpScheme.getData();
        this.pk = new ObjectUuidPK(infoCmpScheme.getId());
    }

    protected boolean confirmDelete() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"297_DelHistoryDataUI")));
    }
}

