/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.IDeptSchemeEntry;
import com.kingdee.eas.hr.compensation.InputTypeEnum;
import com.kingdee.eas.hr.compensation.SchemeAuditedEnum;
import com.kingdee.eas.hr.compensation.SchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.client.AbstractDepPersonBalanceToEndInputUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DepPersonBalanceToEndInputUI
extends AbstractDepPersonBalanceToEndInputUI {
    private static final Logger logger = CoreUIObject.getLogger(DepPersonBalanceToEndInputUI.class);
    private String depInnerResURL = "com.kingdee.eas.hr.compensation.client.DeptInnerSchemeResource.";
    public static final String ENTITYVIEWINFO_CTX = "EntityViewInfo";
    public static final String LOG_CTX = "logInfo";
    private boolean personCheckState = false;
    private boolean periodCheckState = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initListenerCtrl();
        this.kDLabel1.setText("<html><p><font color=red size=3 >" + this.kDLabel1.getText() + "</font></p></html>");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtCmpItem.setEnabled(false);
        this.lblPersonCheck.setText("");
        this.lblPeriodCheck.setText("");
        this.txtDetail.setText("");
        this.txtDetail.setEditable(false);
        this.btnPeriodCheck.setEnabled(true);
        this.btnPersonCheck.setEnabled(true);
    }

    private void initListenerCtrl() {
        this.prmtCmpScheme = HRSchemeUtils.getEnableCmpSchemeF7(this.prmtCmpScheme);
        SelectorItemCollection sic = this.prmtCmpScheme.getSelectorCollection();
        sic.add(new SelectorItemInfo("cmpPeriod.id"));
        sic.add(new SelectorItemInfo("cmpPeriod.beginDate"));
        sic.add(new SelectorItemInfo("audit"));
        this.prmtCmpScheme.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CmpSchemeInfo cmpScheme = (CmpSchemeInfo)eventObj.getNewValue();
                DepPersonBalanceToEndInputUI.this.initPrmtCmpItem(cmpScheme);
                DepPersonBalanceToEndInputUI.this.initCheckCtrlOfPerson();
            }
        });
        this.prmtCmpPeriod = HRSchemeUtils.getDefaultCmpPeriodF7(this.prmtCmpPeriod, false);
        this.prmtCmpPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                DepPersonBalanceToEndInputUI.this.initCheckCtrlOfPeriod();
            }
        });
    }

    private void initCheckCtrlOfPerson() {
        this.lblPersonCheck.setText("");
        this.lblPeriodCheck.setText("");
        this.txtDetail.setText("");
        this.personCheckState = false;
        this.periodCheckState = false;
    }

    private void initCheckCtrlOfPeriod() {
        this.lblPeriodCheck.setText("");
        this.txtDetail.setText("");
        this.periodCheckState = false;
    }

    private void initPrmtCmpItem(CmpSchemeInfo cmpScheme) {
        if (cmpScheme != null) {
            this.setCmpItemPrmt(cmpScheme);
            this.prmtCmpItem.setEnabled(true);
        } else {
            this.prmtCmpItem.setEnabled(false);
        }
    }

    public void setCmpItemPrmt(CmpSchemeInfo cmpScheme) {
        this.prmtCmpItem.setData(null);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("cmpItemCatalog.number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("decDigital"));
        sic.add(new SelectorItemInfo("precisionType"));
        sic.add(new SelectorItemInfo("id"));
        String sqlCmpScheme = " select FCmpItemID from T_HR_CMPSCHEMEITEM  where FCmpSchemeID='" + cmpScheme.getId().toString() + "'";
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sqlCmpScheme, CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)20));
        filterInfo.getFilterItems().add(new FilterItemInfo("dataType", (Object)60));
        filterInfo.setMaskString("#0 and #1 and #2 and #3 ");
        evi.setFilter(filterInfo);
        this.prmtCmpItem.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpItemQuery");
        this.prmtCmpItem.setEditable(true);
        this.prmtCmpItem.setEditFormat("$number$");
        this.prmtCmpItem.setDisplayFormat("$name$");
        this.prmtCmpItem.setCommitFormat("$number$");
        this.prmtCmpItem.setEntityViewInfo(evi);
        this.prmtCmpItem.setSelectorCollection(sic);
        this.prmtCmpItem.setHasCUDefaultFilter(false);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        if (this.lblPersonCheck.getText() == null || "".equals(this.lblPersonCheck.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_NOT_PERSONCHECK")));
            return;
        }
        if (!this.personCheckState) {
            MsgBox.showWarning((String)EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_PERSONCHECK_NOTPASS")));
            return;
        }
        if (this.lblPeriodCheck.getText() == null || "".equals(this.lblPeriodCheck.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_NOT_PERIODCHECK")));
            return;
        }
        if (!this.periodCheckState) {
            MsgBox.showWarning((String)EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_PERIODCHECK_NOTPASS")));
            return;
        }
        if (this.prmtCmpItem.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_CMPITEM_NOTNULL")));
            return;
        }
        if (this.confirm(EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_ISCONVERT")))) {
            CmpSchemeInfo cmpScheme = (CmpSchemeInfo)this.prmtCmpScheme.getData();
            CmpPeriodInfo cmpPeriod = (CmpPeriodInfo)this.prmtCmpPeriod.getData();
            CmpItemInfo cmpItem = (CmpItemInfo)this.prmtCmpItem.getData();
            InputTypeEnum inputTypeEnum = (InputTypeEnum)((Object)this.combInputType.getSelectedItem());
            int time = 1;
            if (this.txtTime.getIntegerValue() != null) {
                time = this.txtTime.getIntegerValue();
            }
            String logStr = "";
            logStr = this.getLogStr(cmpScheme, cmpPeriod, time, cmpItem, inputTypeEnum);
            IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new DeptInnerSchemeInfo().getBOSType(), null, (String)logStr, (String)"depPersonBalance_dataToEndInput");
            boolean bo = DeptSchemeEntryFactory.getRemoteInstance().convertBalanceToEndInput(cmpScheme, cmpPeriod, time, cmpItem, inputTypeEnum, (IObjectValue)this.getPersonEntityViewInfo(), null);
            LogUtil.afterLog(null, (IObjectPK)logPK);
            if (bo) {
                MsgBox.showWarning((String)EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_DATACONVERT_OK")));
                this.destroyWindow();
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_DATACONVERT_ERROR")));
            }
        }
    }

    private String getLogStr(CmpSchemeInfo cmpScheme, CmpPeriodInfo cmpPeriod, int time, CmpItemInfo cmpItem, InputTypeEnum inputTypeEnum) {
        StringBuffer sb = new StringBuffer((String)this.getUIContext().get(LOG_CTX));
        sb.append(HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.client.DeptInnerSchemeResource", (String)"49_PERSON_BALANCE", (String[])new String[]{cmpScheme.getName(), cmpScheme.getNumber(), cmpPeriod.getName(), cmpPeriod.getNumber(), String.valueOf(time), cmpItem.getName(), cmpItem.getNumber(), inputTypeEnum.getAlias()}));
        return sb.toString();
    }

    private boolean confirm(String resourceName) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)resourceName));
    }

    @Override
    public void actionPeriodCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionPeriodCheck_actionPerformed(e);
        CmpSchemeInfo cmpScheme = (CmpSchemeInfo)this.prmtCmpScheme.getData();
        CmpPeriodInfo cmpPeriodInfo = (CmpPeriodInfo)this.prmtCmpPeriod.getData();
        if (cmpScheme == null) {
            MsgBox.showWarning((String)EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_SELECT_SCHEME")));
            return;
        }
        if (cmpPeriodInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_SELECT_PERIOD")));
            return;
        }
        int time = -1;
        if (this.txtTime.getIntegerValue() != null) {
            time = this.txtTime.getIntegerValue();
        }
        if (time < 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.PeriodEndInputResource.CMP_TIME_CON"));
            return;
        }
        this.isInpuHasClose(cmpScheme, cmpPeriodInfo);
    }

    @Override
    public void actionPersonCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonCheck_actionPerformed(e);
        CmpSchemeInfo cmpScheme = (CmpSchemeInfo)this.prmtCmpScheme.getData();
        if (cmpScheme == null) {
            MsgBox.showWarning((String)EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_SELECT_SCHEME")));
            return;
        }
        IRowSet personRow = DeptSchemeEntryFactory.getRemoteInstance().getDepCmpPersonalBalanceNotExitScheme((IObjectValue)this.getPersonEntityViewInfo(), cmpScheme);
        if (personRow.size() == 0) {
            this.lblPersonCheck.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_INPUT_CHECK_OK")));
            this.txtDetail.setText("");
            this.personCheckState = true;
        } else {
            String personListStr = this.showNotExitSchemePerson(personRow);
            this.lblPersonCheck.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_INPUT_CHECK_ERROR")));
            this.txtDetail.setText(HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.client.DeptInnerSchemeResource", (String)"50_SCHEME_NOTEXIT_PERSON", (String[])new String[]{personListStr}));
            this.personCheckState = false;
        }
    }

    public String showNotExitSchemePerson(IRowSet personRow) throws SQLException {
        StringBuffer str = new StringBuffer();
        while (personRow.next()) {
            str.append(personRow.getString("Person.name"));
            str.append("  ");
            str.append(personRow.getString("Person.number"));
            str.append("\n");
        }
        return str.toString();
    }

    private EntityViewInfo getPersonEntityViewInfo() throws BOSException {
        EntityViewInfo evi = (EntityViewInfo)this.getUIContext().get(ENTITYVIEWINFO_CTX);
        return evi;
    }

    private void isInpuHasClose(CmpSchemeInfo cmpScheme, CmpPeriodInfo cmpPeriodInfo) throws BOSException, EASBizException {
        if (cmpScheme == null || cmpPeriodInfo == null) {
            return;
        }
        Integer timeInt = this.txtTime.getIntegerValue();
        if (timeInt == null) {
            timeInt = 1;
        }
        IDeptSchemeEntry deptSchemeEntry = DeptSchemeEntryFactory.getRemoteInstance();
        if (this.beforeCurPeriod(cmpScheme, cmpPeriodInfo)) {
            this.txtDetail.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_PERIOD_TIME_CLOSE_CHECK")));
            this.lblPeriodCheck.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_INPUT_CHECK_ERROR")));
            this.periodCheckState = false;
            SysUtil.abort();
        }
        boolean isHisPeriod = this.isHisPeriod(cmpScheme, cmpPeriodInfo);
        HashMap<String, EntityViewInfo> paramMap = new HashMap<String, EntityViewInfo>();
        paramMap.put("filterInfo", this.getPersonEntityViewInfo());
        Map sumMap = deptSchemeEntry.getPersonInSchemeInDept(paramMap);
        ArrayList empIdList = new ArrayList(sumMap.keySet());
        if (HRSchemeUtils.chekcPeriodEndInputAuditedNoException(null, cmpScheme.getId().toString(), cmpPeriodInfo.getId().toString(), timeInt, empIdList) || isHisPeriod) {
            this.txtDetail.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_SCH_CLOSE")));
            this.lblPeriodCheck.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_INPUT_CHECK_ERROR")));
            this.periodCheckState = false;
        } else {
            this.lblPeriodCheck.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_INPUT_CHECK_OK")));
            this.txtDetail.setText("");
            this.periodCheckState = true;
        }
    }

    private boolean isHisPeriod(CmpSchemeInfo cmpScheme, CmpPeriodInfo cmpPeriodInfo) throws BOSException, EASBizException {
        boolean isNotCanPassData = false;
        int time = this.txtTime.getIntegerValue();
        CmpSchemeInfo schemeInfo = CmpSchemeFactory.getRemoteInstance().getCmpSchemeInfo("select * ,cmpPeriod.* where id = '" + cmpScheme.getId().toString() + "'");
        int SchemeAuditState = SchemeFacadeFactory.getRemoteInstance().getAuditStateForFuture(cmpScheme.getId().toString(), cmpPeriodInfo.getId().toString(), time);
        if (SchemeAuditState == 40 || SchemeAuditState == 20 || SchemeAuditState == 50) {
            this.txtDetail.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_SCH_CLOSE_CHECK")));
            this.lblPeriodCheck.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_INPUT_CHECK_ERROR")));
            this.periodCheckState = false;
            SysUtil.abort();
        }
        if (!schemeInfo.getAudit().equals((Object)SchemeAuditedEnum.NOTAUDITED) && !schemeInfo.getAudit().equals((Object)SchemeAuditedEnum.AUDITEDNOTPASS)) {
            if (cmpPeriodInfo.getBeginDate().after(schemeInfo.getCmpPeriod().getBeginDate())) {
                isNotCanPassData = false;
            } else if (cmpPeriodInfo.getId().equals((Object)cmpScheme.getCmpPeriod().getId()) && schemeInfo.getTime() < time) {
                isNotCanPassData = false;
            } else {
                this.txtDetail.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_BALANCE_SCH_CLOSE_CHECK")));
                this.lblPeriodCheck.setText(EASResource.getString((String)(this.depInnerResURL + "PERSON_INPUT_CHECK_ERROR")));
                this.periodCheckState = false;
                SysUtil.abort();
            }
        }
        return isNotCanPassData;
    }

    private boolean beforeCurPeriod(CmpSchemeInfo cmpScheme, CmpPeriodInfo cmpPeriodInfo) {
        if (cmpPeriodInfo.getBeginDate().before(cmpScheme.getCmpPeriod().getBeginDate())) {
            return true;
        }
        if (cmpPeriodInfo.getId().equals((Object)cmpScheme.getCmpPeriod().getId())) {
            Integer timeInt = this.txtTime.getIntegerValue();
            if (timeInt == null) {
                timeInt = 1;
            }
            return timeInt < cmpScheme.getTime();
        }
        return false;
    }
}

