/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.hr.compensation.AssignTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeCollection;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryCollection;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeInfo;
import com.kingdee.eas.hr.compensation.ITeamGroup;
import com.kingdee.eas.hr.compensation.TeamGroupCollection;
import com.kingdee.eas.hr.compensation.TeamGroupFactory;
import com.kingdee.eas.hr.compensation.TeamGroupInfo;
import com.kingdee.eas.hr.compensation.client.AbstractDeptSchemeEntryFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DeptSchemeEntryFilterUI
extends AbstractDeptSchemeEntryFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DeptSchemeEntryFilterUI.class);
    private String resClass = "com.kingdee.eas.hr.compensation.client.DeptSchemeResource.";
    private final String DeptSchme_CP = "DeptSchme_CP";
    private final String StartPeriod_CP = "StartPeriod_CP";
    private final String EndPeriod_CP = "EndPeriod_CP";

    public DeptSchemeEntryFilterUI() throws Exception {
        this.initCtrl();
    }

    @Override
    public void actionAdminSelect_actionPerformed(ActionEvent e) throws Exception {
        this.prmtAdminOrg.setEnabled(true);
        this.prmtTeamgroup.setEnabled(false);
    }

    @Override
    public void actionTeamGroupSelect_actionPerformed(ActionEvent e) throws Exception {
        this.prmtAdminOrg.setEnabled(false);
        this.prmtTeamgroup.setEnabled(true);
    }

    private void initCtrl() {
        this.btnAdmin.setEnabled(false);
        this.btnTeamgroup.setEnabled(false);
        this.prmtTeamgroup.setEnabled(false);
        this.prmtAdminOrg.setEnabled(false);
        this.prmtStartPeriod = HRSchemeUtils.getDefaultCmpPeriodF7(this.prmtStartPeriod, false);
        this.prmtEndPeriod = HRSchemeUtils.getDefaultCmpPeriodF7(this.prmtEndPeriod, false);
        this.initPrmtDepScheme();
    }

    private void initPrmtDepScheme() {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("enable"));
        sic.add(new SelectorItemInfo("entries.teamGroup.id"));
        sic.add(new SelectorItemInfo("assignType"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.setMaskString("#0 and #1");
        evi.setFilter(filterInfo);
        this.prmtDeptScheme.setEntityViewInfo(evi);
        this.prmtDeptScheme.setSelectorCollection(sic);
        this.prmtDeptScheme.setEditable(false);
    }

    private void initPrmtTeamGroup(Set idSet) {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)2));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        if (idSet != null && idSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet(idSet), CompareType.INCLUDE));
        } else {
            String deptSchemeID = ((DeptSchemeInfo)this.prmtDeptScheme.getData()).getId().toString();
            StringBuffer sb = new StringBuffer();
            sb.append(" select distinct team.fid ").append(" from t_hr_teamgroup as team ").append("   inner join T_HR_DeptSchemeEntry as entry on team.fid = entry.FteamGroupID ").append(" where entry.FDeptSchemeID = '").append(deptSchemeID).append("'");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        }
        filterInfo.setMaskString("#0 and #1 and #2 ");
        evi.setFilter(filterInfo);
        this.prmtTeamgroup.setEntityViewInfo(evi);
        this.prmtTeamgroup.setSelectorCollection(sic);
        this.prmtTeamgroup.setEditable(false);
    }

    private void initPrmtAdminOrg(Map adminMap) {
        this.prmtAdminOrg.setQueryInfo("com.kingdee.eas.hr.compensation.app.DeptSchemeAdminOrgQuery");
        this.prmtAdminOrg.setEnabledMultiSelection(true);
        this.prmtAdminOrg.setDisplayFormat("$name$");
        if (adminMap != null && !adminMap.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            Iterator keySet = adminMap.keySet().iterator();
            FilterInfo filterInfo = new FilterInfo();
            if (keySet.hasNext()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("deptScheme.id", (Object)adminMap.get("deptScheme.id").toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("deptAdmin.isMulSentFlag", (Object)false));
                filterInfo.getFilterItems().add(new FilterItemInfo("deptAdmin.isMulSentFlag", (Object)true));
                filterInfo.getFilterItems().add(new FilterItemInfo("deptAdmin.isParentNode", (Object)true));
                filterInfo.setMaskString("#0 AND (#1 OR (#2 AND #3))");
            }
            evi.setFilter(filterInfo);
            this.prmtAdminOrg.setEntityViewInfo(evi);
        }
        this.prmtAdminOrg.setEditable(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean verify() {
        DeptSchemeInfo deptSchemeInfo = (DeptSchemeInfo)this.prmtDeptScheme.getData();
        CmpPeriodInfo cmpPeriodInfoStart = (CmpPeriodInfo)this.prmtStartPeriod.getData();
        CmpPeriodInfo cmpPeriodInfoEnd = (CmpPeriodInfo)this.prmtEndPeriod.getData();
        if (deptSchemeInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "DeptScheme_NotNull")));
            return false;
        }
        if (cmpPeriodInfoStart != null && cmpPeriodInfoEnd != null && cmpPeriodInfoStart.getBeginDate().after(cmpPeriodInfoEnd.getBeginDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "DeptScheme_PeriodError")));
            return false;
        }
        return true;
    }

    public CustomerParams getCustomerParams() {
        int i;
        StringBuffer orgUnits;
        Object[] ogs;
        Object value;
        CustomerParams cp = new CustomerParams();
        DeptSchemeInfo deptSchemeInfo = (DeptSchemeInfo)this.prmtDeptScheme.getData();
        CmpPeriodInfo cmpPeriodInfoStart = (CmpPeriodInfo)this.prmtStartPeriod.getData();
        CmpPeriodInfo cmpPeriodInfoEnd = (CmpPeriodInfo)this.prmtEndPeriod.getData();
        if (deptSchemeInfo != null) {
            cp.addCustomerParam(this.DeptSchme_CP, deptSchemeInfo.getId().toString());
        }
        if (cmpPeriodInfoStart != null) {
            cp.addCustomerParam(this.StartPeriod_CP, cmpPeriodInfoStart.getId().toString());
        }
        if (cmpPeriodInfoEnd != null) {
            cp.addCustomerParam(this.EndPeriod_CP, cmpPeriodInfoEnd.getId().toString());
        }
        if ((value = this.prmtAdminOrg.getValue()) != null && value instanceof Object[] && (ogs = (Object[])value).length > 0 && ogs[0] != null) {
            orgUnits = new StringBuffer();
            for (i = 0; i < ogs.length - 1; ++i) {
                orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
                orgUnits.append("\u2014\u2014");
            }
            orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
            cp.addCustomerParam("adminOrgUnit", orgUnits.toString());
        }
        if ((value = this.prmtTeamgroup.getValue()) != null && value instanceof Object[] && (ogs = (Object[])value).length > 0 && ogs[0] != null) {
            orgUnits = new StringBuffer();
            for (i = 0; i < ogs.length - 1; ++i) {
                orgUnits.append(((TeamGroupInfo)ogs[i]).getId().toString());
                orgUnits.append("\u2014\u2014");
            }
            orgUnits.append(((TeamGroupInfo)ogs[i]).getId().toString());
            cp.addCustomerParam("teamGroup", orgUnits.toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        Object col;
        FilterInfo fi;
        EntityViewInfo evi;
        String value;
        String idStartPeirod;
        if (cp == null) {
            this.clear();
            return;
        }
        String idDeptSchme = cp.getCustomerParam(this.DeptSchme_CP);
        if (idDeptSchme != null && !"".equals(idDeptSchme)) {
            try {
                DeptSchemeInfo deptSchemeInfo = null;
                if (DeptSchemeFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(idDeptSchme))) {
                    deptSchemeInfo = DeptSchemeFactory.getRemoteInstance().getDeptSchemeInfo((IObjectPK)new ObjectUuidPK(idDeptSchme));
                } else {
                    DeptSchemeCollection coll = DeptSchemeFactory.getRemoteInstance().getDeptSchemeCollection("select top 1");
                    if (coll != null && coll.size() > 0) {
                        deptSchemeInfo = coll.get(0);
                    }
                }
                if (deptSchemeInfo == null) {
                    deptSchemeInfo = new DeptSchemeInfo();
                    deptSchemeInfo.setId(BOSUuid.read((String)idDeptSchme));
                }
                this.prmtDeptScheme.setData((Object)deptSchemeInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((idStartPeirod = cp.getCustomerParam(this.StartPeriod_CP)) != null && !"".equals(idStartPeirod)) {
            try {
                this.prmtStartPeriod.setData((Object)CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(idStartPeirod)));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.prmtStartPeriod.setData(null);
        }
        String idEndPeriod = cp.getCustomerParam(this.EndPeriod_CP);
        if (idEndPeriod != null && !"".equals(idEndPeriod)) {
            try {
                this.prmtEndPeriod.setData((Object)CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(idEndPeriod)));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.prmtEndPeriod.setData(null);
        }
        try {
            value = cp.getCustomerParam("adminOrgUnit");
            evi = new EntityViewInfo();
            if (!DeptSchemeEntryFilterUI.objectIsNull(value)) {
                String[] adminOrg = StringUtils.split((String)value, (String)"\u2014\u2014");
                IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(adminOrg)), CompareType.INCLUDE));
                evi.setFilter(fi);
                col = adminOrgUnit.getAdminOrgUnitCollection(evi);
                this.prmtAdminOrg.setValue((Object)col.toArray());
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        try {
            value = cp.getCustomerParam("teamGroup");
            evi = new EntityViewInfo();
            if (!DeptSchemeEntryFilterUI.objectIsNull(value)) {
                String[] teamGroupIDs = StringUtils.split((String)value, (String)"\u2014\u2014");
                ITeamGroup teamGroup = TeamGroupFactory.getRemoteInstance();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(teamGroupIDs)), CompareType.INCLUDE));
                evi.setFilter(fi);
                col = teamGroup.getTeamGroupCollection(evi);
                this.prmtTeamgroup.setValue((Object)col.toArray());
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public void clear() {
        this.prmtAdminOrg.setData(null);
        this.prmtTeamgroup.setData(null);
        this.prmtDeptScheme.setData(null);
        this.prmtStartPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
    }

    public DeptSchemeInfo getDeptScheme() {
        return (DeptSchemeInfo)this.prmtDeptScheme.getData();
    }

    public CmpPeriodInfo getCmpPeriodStart() {
        return (CmpPeriodInfo)this.prmtStartPeriod.getData();
    }

    public CmpPeriodInfo getCmpPeriodEnd() {
        return (CmpPeriodInfo)this.prmtEndPeriod.getData();
    }

    public TeamGroupCollection getTeamGroupColl() {
        TeamGroupCollection teamColl = new TeamGroupCollection();
        Object[] value = (Object[])this.prmtTeamgroup.getValue();
        if (value != null && value.length > 0) {
            for (int i = 0; i < value.length; ++i) {
                teamColl.add((TeamGroupInfo)value[i]);
            }
        }
        return teamColl;
    }

    public AdminOrgUnitCollection getAdminOrgColl() {
        AdminOrgUnitCollection adminColl = new AdminOrgUnitCollection();
        Object[] value = (Object[])this.prmtAdminOrg.getValue();
        if (value != null && value.length > 0) {
            for (int i = 0; i < value.length; ++i) {
                adminColl.add((AdminOrgUnitInfo)value[i]);
            }
        }
        return adminColl;
    }

    private void setButtonState(boolean flag) {
        if (flag) {
            this.prmtTeamgroup.setEnabled(true);
            this.prmtAdminOrg.setData(null);
            this.prmtAdminOrg.setEnabled(false);
            this.btnAdmin.setSelected(false);
            this.btnAdmin.setEnabled(false);
            this.btnTeamgroup.setEnabled(true);
            this.btnTeamgroup.setSelected(true);
        } else {
            this.prmtAdminOrg.setEnabled(true);
            this.prmtTeamgroup.setData(null);
            this.prmtTeamgroup.setEnabled(false);
            this.btnTeamgroup.setSelected(false);
            this.btnTeamgroup.setEnabled(false);
            this.btnAdmin.setEnabled(true);
            this.btnAdmin.setSelected(true);
        }
    }

    @Override
    protected void prmtDeptScheme_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtDeptScheme.getData() == null) {
            this.btnAdmin.setEnabled(false);
            this.btnTeamgroup.setEnabled(false);
            this.prmtTeamgroup.setEnabled(false);
            this.prmtAdminOrg.setEnabled(false);
            return;
        }
        DeptSchemeInfo deptSchemeInfo = (DeptSchemeInfo)this.prmtDeptScheme.getData();
        if (deptSchemeInfo.getAssignType() != null && deptSchemeInfo.getAssignType().equals((Object)AssignTypeEnum.TEAMGROUP)) {
            Set idSet = null;
            if (deptSchemeInfo.get("entries") != null) {
                idSet = this.getTeamGroupIDSet((DeptSchemeEntryCollection)((Object)deptSchemeInfo.get("entries")));
            }
            this.initPrmtTeamGroup(idSet);
            this.setButtonState(true);
        } else {
            HashMap<String, String> adminMap = new HashMap<String, String>();
            adminMap.put("deptScheme.id", deptSchemeInfo.getId().toString());
            this.initPrmtAdminOrg(adminMap);
            this.setButtonState(false);
        }
        this.prmtAdminOrg.setData(null);
        this.prmtTeamgroup.setData(null);
    }

    private Set getTeamGroupIDSet(DeptSchemeEntryCollection entryColl) {
        if (entryColl == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        DeptSchemeEntryInfo entryInfo = null;
        TeamGroupInfo groupInfo = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            groupInfo = (TeamGroupInfo)entryInfo.get("teamgroup");
            if (groupInfo == null) continue;
            set.add(groupInfo.getId().toString());
        }
        return set;
    }

    private Map getAdminIDsColl(DeptSchemeEntryCollection entryColl) {
        if (entryColl == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        Map adminMap = new HashMap();
        DeptSchemeEntryInfo entryInfo = null;
        AdminOrgUnitInfo adminInfo = null;
        boolean hasSubDept = false;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            adminInfo = (AdminOrgUnitInfo)entryInfo.get("adminOrgUnit");
            if (set.contains(adminInfo.getId().toString())) continue;
            set.add(adminInfo.getId().toString());
            hasSubDept = entryInfo.getBoolean("hasSubDept");
            adminMap = this.getAdminTakeoutRepeat(adminMap, adminInfo, hasSubDept);
        }
        return adminMap;
    }

    private Map getAdminTakeoutRepeat(Map adminMap, AdminOrgUnitInfo adminInfo, boolean hasSubDept) {
        if (hasSubDept) {
            String longNumber = adminInfo.getLongNumber();
            Iterator keySet = adminMap.keySet().iterator();
            AdminOrgUnitInfo hasContainsDept = null;
            HashMap<AdminOrgUnitInfo, Boolean> newMap = new HashMap<AdminOrgUnitInfo, Boolean>();
            while (keySet.hasNext()) {
                hasContainsDept = (AdminOrgUnitInfo)keySet.next();
                if (longNumber.startsWith(hasContainsDept.getLongNumber() + "!")) continue;
                newMap.put(adminInfo, hasSubDept);
            }
            adminMap.putAll(newMap);
        } else {
            adminMap.put(adminInfo, hasSubDept);
        }
        return adminMap;
    }

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)((String)obj));
        }
        if (obj instanceof DataToken) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }
}

