/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.AssignTypeEnum;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeInfo;
import com.kingdee.eas.hr.compensation.IDeptScheme;
import com.kingdee.eas.hr.compensation.TeamGroupCollection;
import com.kingdee.eas.hr.compensation.TeamGroupInfo;
import com.kingdee.eas.hr.compensation.TeamGroupStateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractDeptSchemeListUI;
import com.kingdee.eas.hr.compensation.client.DeptSchemeEditUI;
import com.kingdee.eas.hr.compensation.util.DeptInnerSchemePersonHisUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeptSchemeListUI
extends AbstractDeptSchemeListUI {
    private static final Logger logger = CoreUIObject.getLogger(DeptSchemeListUI.class);

    public DeptSchemeListUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.tblMain.getSelectManager().getActiveRowIndex() >= 0) {
            DeptSchemeInfo deptInfo = this.getDeptSchemeInfo();
            this.checkDisableTeamGroup(deptInfo);
            this.checkPersonExistScheme(deptInfo);
            if (deptInfo != null) {
                ObjectUuidPK pk = new ObjectUuidPK(deptInfo.getId());
                ((IDeptScheme)this.getBizInterface()).enableDeptScheme((IObjectPK)pk);
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.DeptSchemeResource.DEPTSCHEME_ENABLE_SUCCESS"));
                this.showMessage();
                this.refresh(e);
            }
        }
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        Object id;
        this.checkSelected();
        if (this.tblMain.getSelectManager().getActiveRowIndex() >= 0 && (id = HRTableTools.getTableSelectCellValue(this.tblMain, "id")) != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id.toString()));
            ((IDeptScheme)this.getBizInterface()).disableDeptScheme((IObjectPK)pk);
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.DeptSchemeResource.DEPTSCHEME_DISABLE_SUCCESS"));
            this.showMessage();
            this.refresh(e);
        }
    }

    protected String getEditUIName() {
        return DeptSchemeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DeptSchemeFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        return filter;
    }

    protected boolean initDefaultFilter() {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo("enable");
        sorterOrderItem1.setSortType(SortType.ASCEND);
        this.mainQuery.getSorter().add(sorterOrderItem1);
        return false;
    }

    protected void initWorkButton() {
        this.menuItemEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuItemDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        super.initWorkButton();
        this.tblMain.setColumnMoveable(true);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    int indexRow = e.getSelectBlock().getTop();
                    DeptSchemeListUI.this.doButtonState(indexRow);
                }
                catch (Exception exc) {
                    DeptSchemeListUI.this.handUIException(exc);
                }
            }
        });
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
            this.doButtonState(0);
        }
    }

    private void doButtonState(int indexRow) {
        Object enable = HRTableTools.getTableSelectCellValue(this.tblMain, "enable");
        if (enable != null && !((Boolean)enable).booleanValue()) {
            this.actionEnable.setEnabled(true);
            this.btnEnable.setEnabled(true);
            this.actionDisable.setEnabled(false);
            this.btnDisable.setEnabled(false);
            this.actionRemove.setEnabled(true);
            this.btnRemove.setEnabled(true);
        } else {
            this.actionEnable.setEnabled(false);
            this.btnEnable.setEnabled(false);
            this.actionDisable.setEnabled(true);
            this.btnDisable.setEnabled(true);
            this.actionRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    private DeptSchemeInfo getDeptSchemeInfo() throws Exception {
        Object id = HRTableTools.getTableSelectCellValue(this.tblMain, "id");
        if (id == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id.toString()));
        DeptSchemeInfo deptInfo = (DeptSchemeInfo)((IDeptScheme)this.getBizInterface()).getDeptSchemeInfo(false, (IObjectPK)pk);
        return deptInfo;
    }

    private void checkDisableTeamGroup(DeptSchemeInfo deptInfo) {
        TeamGroupCollection tgColl = deptInfo.getTeamGroupCollection();
        if (tgColl == null) {
            return;
        }
        StringBuffer teamName = new StringBuffer();
        int flag = 0;
        for (int i = 0; i < tgColl.size(); ++i) {
            TeamGroupInfo teamGroupInfo = tgColl.get(i);
            if (teamGroupInfo.getState() == null || !TeamGroupStateEnum.DISABLE.equals((Object)teamGroupInfo.getState())) continue;
            if (flag != 0) {
                teamName.append("\uff0c");
            }
            teamName.append(teamGroupInfo.getName());
            ++flag;
        }
        if (teamName.length() > 0) {
            MsgBox.showInfo((String)HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"736_DeptSchemeListUI", (String[])new String[]{teamName.toString()}));
            SysUtil.abort();
        }
    }

    private void checkPersonExistScheme(DeptSchemeInfo deptSchemeInfo) throws Exception {
        IRowSet iRowSet;
        if (deptSchemeInfo.isPersonRange()) {
            return;
        }
        String sql = DeptInnerSchemePersonHisUtils.getPersonNotInSchemeInDept(deptSchemeInfo);
        if (AssignTypeEnum.ADMIN.equals((Object)deptSchemeInfo.getAssignType())) {
            String replaceStr = this.getAllAdminIDSqlByDeptScheme(deptSchemeInfo);
            if (StringUtils.isEmpty((String)replaceStr)) {
                return;
            }
            sql = sql.replaceFirst("adminDdORadminLongNumber", replaceStr);
        }
        if ((iRowSet = DeptSchemeEntryFactory.getRemoteInstance().getPersonNotInSchemeInDept(sql, null)) != null && iRowSet.size() > 0) {
            ArrayList allPerson = new ArrayList();
            HashMap<String, String> personMap = null;
            while (iRowSet.next()) {
                personMap = new HashMap<String, String>();
                personMap.put("FPER002", iRowSet.getString("personNumber"));
                personMap.put("FPER001", iRowSet.getString("personName"));
                allPerson.add(personMap);
            }
            if (this.confirm(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"338_DeptSchemeEntryEditUI"))) {
                this.showNotInCmpSchPersonList(allPerson);
            }
            SysUtil.abort();
        }
    }

    private boolean confirm(String resourceName) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)resourceName));
    }

    private void showNotInCmpSchPersonList(List alPersonList) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"alPersonList", (Object)alPersonList);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.compensation.client.DepCmpInnerAssignPersonNotInCmpSchListUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private String getAllAdminIDSqlByDeptScheme(DeptSchemeInfo deptInfo) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct adminOrg.fid as fid ,adminOrg.FlongNumber as longNumber,entries.FhasSubDept as hasSubDept");
        sb.append(" from T_ORG_Admin as adminOrg ");
        sb.append(" inner join T_HR_DeptSchemeEntry AS entries ON adminOrg.FID = entries.FAdminOrgUnitID ");
        sb.append(" where entries.FDeptSchemeID =?");
        sb.append("  and (entries.fisMulSentFlag = 0 or(entries.fisMulSentFlag = 1 and entries.fisParentNode=1)) ");
        Object[] params = new Object[]{deptInfo.getId().toString()};
        IRowSet iRow = DeptSchemeEntryFactory.getRemoteInstance().getPersonNotInSchemeInDept(sb.toString(), params);
        StringBuffer ids = new StringBuffer();
        if (iRow.size() > 0) {
            String adminID = null;
            String longNumber = null;
            boolean hasSubDept = false;
            ArrayList<String> longNumberList = new ArrayList<String>();
            int i = 0;
            ids.append("adminOrg.Fid in (");
            while (iRow.next()) {
                adminID = iRow.getString("fid");
                longNumber = iRow.getString("longNumber");
                hasSubDept = iRow.getBoolean("hasSubDept");
                ids.append("'").append(adminID).append("'");
                if (i != iRow.size() - 1) {
                    ids.append(",");
                }
                if (hasSubDept && this.isContains(longNumberList, longNumber)) {
                    longNumberList.add(longNumber);
                }
                ++i;
            }
            ids.append(")");
            if (longNumberList.size() > 0) {
                ids.append(" or (adminOrg.Fid in(").append(this.getCurrentUserRangStr()).append(") and (");
                for (int j = 0; j < longNumberList.size(); ++j) {
                    ids.append(" (adminOrg.FLongNumber like '").append(longNumberList.get(j).toString()).append("!%'").append(")");
                    if (j == longNumberList.size() - 1) continue;
                    ids.append(" or ");
                }
                ids.append(") )");
            }
        }
        return ids.toString();
    }

    private boolean isContains(List longNumberList, String longNumber) {
        if (longNumberList.size() <= 0) {
            return true;
        }
        for (int i = 0; i < longNumberList.size(); ++i) {
            String hasNumber = (String)longNumberList.get(i);
            if (!longNumber.startsWith(hasNumber + "!")) continue;
            return false;
        }
        return true;
    }

    private String getCurrentUserRangStr() {
        StringBuffer sql = new StringBuffer();
        sql.append("select T1.FID from t_org_admin T1 ").append(" inner join t_pm_orgrange T2 on T1.FID = T2.FORGID").append(" inner join t_org_unitrelation T3 on t1.fid = T3.Ffromunitid").append(" where T2.Ftype = 20 and T3.Ftyperelationid = '00000000-0000-0000-0000-0000000000100FE9F8B5'").append("and T2.fuserid= '").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'").append(" and T3.Ftounitid='").append(SysContext.getSysContext().getCurrentHRUnit().getId().toString()).append("'");
        return sql.toString();
    }
}

