/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.client.AbstractDsalaryReportFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DsalaryReportFilterUI
extends AbstractDsalaryReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DsalaryReportFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdbEndPeriod.setVisible(false);
        this.kdlEndPeriod.setVisible(false);
        this.initAllEditor();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnAdd.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.tblCompanyUnits.checkParsed();
        this.kdbBeginPeriod.setRequired(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initAllEditor() {
        this.kdbBeginPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        this.kdbEndPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.kdbBeginPeriod.setEntityViewInfo(eviCmpPeriod);
        this.kdbBeginPeriod.setDisplayFormat("$name$");
        this.kdbBeginPeriod.setEditFormat("$name$");
        this.kdbBeginPeriod.setEntityViewInfo(eviCmpPeriod);
        this.kdbEndPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        this.kdbEndPeriod.setDisplayFormat("$name$");
        this.kdbEndPeriod.setEditFormat("$name$");
        this.kdbEndPeriod.setEntityViewInfo(eviCmpPeriod);
    }

    public void clear() {
        super.clear();
        if (this.kdbBeginPeriod.getData() != null) {
            this.kdbBeginPeriod.setData(null);
        }
        if (this.kdbEndPeriod.getData() != null) {
            this.kdbEndPeriod.setData(null);
        }
        this.tblCompanyUnits.removeRows();
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }

    public CustomerParams getCustomerParams() {
        this.verify();
        CustomerParams customerParams = new CustomerParams();
        if (this.kdbBeginPeriod.getData() != null) {
            customerParams.addCustomerParam("beginPeriod.id", ((CmpPeriodInfo)this.kdbBeginPeriod.getData()).getId().toString());
        }
        if (this.kdbEndPeriod.getData() != null) {
            customerParams.addCustomerParam("endPeriod.id", ((CmpPeriodInfo)this.kdbEndPeriod.getData()).getId().toString());
        }
        int size = this.tblCompanyUnits.getRowCount();
        StringBuffer compUnitIds = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblCompanyUnits.getRow(i);
            if (i == size - 1) {
                compUnitIds.append(row.getCell("id").getValue().toString());
                continue;
            }
            compUnitIds.append(row.getCell("id").getValue().toString()).append(":");
        }
        if (compUnitIds != null && compUnitIds.length() > 0) {
            customerParams.addCustomerParam("compUnitIds", compUnitIds.toString());
        }
        return customerParams;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        CmpPeriodInfo beginPeriodInfo = null;
        CmpPeriodInfo endPeriodInfo = null;
        try {
            if (cp.getKeys().contains("beginPeriod.id")) {
                beginPeriodInfo = CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectStringPK(cp.getCustomerParam("beginPeriod.id")));
            }
            if (cp.getKeys().contains("endPeriod.id")) {
                endPeriodInfo = CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectStringPK(cp.getCustomerParam("endPeriod.id")));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        try {
            if (cp.getKeys().contains("compUnitIds")) {
                this.tblCompanyUnits.removeRows();
                IAdminOrgUnit iUnit = AdminOrgUnitFactory.getRemoteInstance();
                String compUnitIds = cp.getCustomerParam("compUnitIds");
                String[] compUnitIdArgs = compUnitIds.split(":");
                int size = compUnitIdArgs.length;
                for (int i = 0; i < size; ++i) {
                    AdminOrgUnitInfo compUnitInfo = iUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(compUnitIdArgs[i]));
                    IRow row = this.tblCompanyUnits.addRow();
                    row.getCell("id").setValue((Object)compUnitInfo.getId().toString());
                    row.getCell("number").setValue((Object)compUnitInfo.getNumber());
                    row.getCell("name").setValue((Object)compUnitInfo.getName());
                    row.getCell("level").setValue((Object)compUnitInfo.getLevel());
                    row.getCell("longnumber").setValue((Object)compUnitInfo.getLongNumber());
                }
            } else {
                this.tblCompanyUnits.removeRows();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        if (beginPeriodInfo != null) {
            this.kdbBeginPeriod.setData((Object)beginPeriodInfo);
        }
        if (endPeriodInfo != null) {
            this.kdbEndPeriod.setData((Object)endPeriodInfo);
        }
    }

    public boolean verify() {
        super.verify();
        if (this.kdbBeginPeriod.getData() == null) {
            return false;
        }
        if (this.kdbBeginPeriod.getData() != null && !(this.kdbBeginPeriod.getData() instanceof CmpPeriodInfo)) {
            return false;
        }
        return this.kdbEndPeriod.getData() == null || this.kdbEndPeriod.getData() instanceof CmpPeriodInfo;
    }

    @Override
    public void orgBtnAdd_actionPerformed(ActionEvent e) throws Exception {
        AdminByCurrentHROF7WithOrgRangeFilter adminF7 = new AdminByCurrentHROF7WithOrgRangeFilter();
        adminF7.setMultiSelect(true);
        Vector<String> vt = new Vector<String>();
        for (int i = 0; i < this.tblCompanyUnits.getRowCount(); ++i) {
            vt.add(this.tblCompanyUnits.getRow(i).getCell("id").getValue().toString());
        }
        adminF7.show();
        Object obj = adminF7.getData();
        if (obj != null && obj instanceof Object[]) {
            Object[] units = (Object[])obj;
            int size = units.length;
            for (int i = 0; i < size; ++i) {
                AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)units[i];
                if (vt.contains(unitInfo.getId().toString())) continue;
                IRow row = this.tblCompanyUnits.addRow();
                row.getCell("id").setValue((Object)unitInfo.getId().toString());
                row.getCell("number").setValue((Object)unitInfo.getNumber());
                row.getCell("name").setValue((Object)unitInfo.getName());
                row.getCell("longnumber").setValue((Object)unitInfo.getLongNumber());
            }
        }
    }

    @Override
    public void orgBtnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblCompanyUnits.getSelectManager().size() != 0) {
            int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblCompanyUnits);
            int size = rowIndexs.length;
            for (int i = size - 1; i >= 0; --i) {
                this.tblCompanyUnits.removeRow(rowIndexs[i]);
            }
        }
    }
}

