/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.DsalaryCmpSchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.IDsalaryCmpSchemeFacade;
import com.kingdee.eas.hr.compensation.client.AbstractDsalaryReportUI;
import com.kingdee.eas.hr.compensation.client.DsalaryReportFilterUI;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DsalaryReportUI
extends AbstractDsalaryReportUI {
    private static final Logger logger = CoreUIObject.getLogger(DsalaryReportUI.class);
    private IDsalaryCmpSchemeFacade idSalaryFacade = null;
    private boolean isFirstDefaultQuery = true;
    private CmpPeriodInfo beginCmpPeriod = null;
    private CmpPeriodInfo endCmpPeriod = null;
    private AdminOrgUnitCollection orgCollection = new AdminOrgUnitCollection();
    private String resURLStr = "com.kingdee.eas.hr.compensation.Comp_ReportResource.";
    private Vector vt = new Vector();
    private CommonQueryDialog commonQueryDialog = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setVisible(true);
        this.initWorkButton();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setEditable(false);
        this.initTableForPrint();
        HRUtils.removeLintMenu(this.tblMain, this.getMenuManager(this.tblMain));
        this.performCommonQuery();
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    @Override
    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    protected void performCommonQuery() throws Exception {
        DsalaryReportFilterUI dsalaryReportFilterUI = new DsalaryReportFilterUI();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = DsalaryReportUI.getQueryInfo(this.queryBankOrgPersonQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (solution.getQueryPanelInfo().size() <= 0 || solution.getQueryPanelInfo().get(0).getCustomerParams() == null) {
                this.showFilterDialog(dsalaryReportFilterUI);
            } else if (solution.getQueryPanelInfo().size() > 0 && solution.getQueryPanelInfo().get(0).getCustomerParams() != null) {
                this.getFilterData(null, CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams()));
                IRowSet iRowSet = this.getBizfacadeInterface().getDsalaryResult(this.beginCmpPeriod, this.endCmpPeriod, false, this.orgCollection, "003", true);
                IRowSet totalRowSet = this.getBizfacadeInterface().getTotalDsalaryResult(this.beginCmpPeriod, this.endCmpPeriod, false, this.orgCollection, "003", true);
                this.fillData(iRowSet, totalRowSet);
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.getFilterData(dsalaryReportFilterUI, null);
            this.showFilterDialog(dsalaryReportFilterUI);
        }
    }

    private void showFilterDialog(DsalaryReportFilterUI dsalaryReportFilterUI) throws Exception {
        int dialogHight = 330;
        int dialogWidth = 380;
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(dialogHight);
            this.commonQueryDialog.setWidth(dialogWidth);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.queryBankOrgPersonQueryPK);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.addUserPanel((KDPanel)dsalaryReportFilterUI);
            this.commonQueryDialog.setTitle(EASResource.getString((String)(this.resURLStr + "DSALARY_CONQUERY")));
            this.commonQueryDialog.setMaxReturnCountVisible(false);
        }
        if (this.commonQueryDialog.show()) {
            this.getFilterData((DsalaryReportFilterUI)this.commonQueryDialog.getUserPanel(0), null);
            IRowSet iRowSet = this.getBizfacadeInterface().getDsalaryResult(this.beginCmpPeriod, this.endCmpPeriod, false, this.orgCollection, "003", true);
            IRowSet totalRowSet = this.getBizfacadeInterface().getTotalDsalaryResult(this.beginCmpPeriod, this.endCmpPeriod, false, this.orgCollection, "003", true);
            this.fillData(iRowSet, totalRowSet);
        } else {
            SysUtil.abort();
        }
    }

    private void getFilterData(DsalaryReportFilterUI dsalaryReportFilterUI, CustomerParams customerParams) throws EASBizException, BOSException {
        CustomerParams cp = null;
        cp = customerParams != null ? customerParams : dsalaryReportFilterUI.getCustomerParams();
        this.vt.clear();
        try {
            this.beginCmpPeriod = cp.getKeys().contains("beginPeriod.id") ? CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectStringPK(cp.getCustomerParam("beginPeriod.id"))) : null;
            this.endCmpPeriod = cp.getKeys().contains("endPeriod.id") ? CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectStringPK(cp.getCustomerParam("endPeriod.id"))) : null;
            if (cp.getKeys().contains("compUnitIds")) {
                String compUnitIds = cp.getCustomerParam("compUnitIds");
                String[] compUnitIdArgs = compUnitIds.split(":");
                AdminOrgUnitInfo orgInfo = null;
                ObjectStringPK PK = null;
                for (int i = 0; i < compUnitIdArgs.length; ++i) {
                    PK = new ObjectStringPK(compUnitIdArgs[i]);
                    orgInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)PK);
                    this.orgCollection.add(orgInfo);
                    this.vt.add(PK.toString());
                }
            } else {
                this.orgCollection.clear();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    @Override
    protected void initTableForPrint() {
        super.initTableForPrint();
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    @Override
    protected void doQueryResult() throws Exception {
        super.doQueryResult();
    }

    private void fillData(IRowSet iRowSet, IRowSet totalRowSet) throws Exception {
        this.tblMain.removeRows();
        for (int i = 0; i < this.orgCollection.size(); ++i) {
            IRow row = this.tblMain.addRow();
            row.getCell("number").setValue((Object)this.orgCollection.get(i).getLongNumber());
            row.getCell("adminName").setValue((Object)this.orgCollection.get(i).getName());
            this.fillRowData(this.orgCollection.get(i).getLongNumber(), iRowSet, row);
        }
        this.fillTotalData(totalRowSet);
    }

    private void fillRowData(String longNumber, IRowSet iRowSet, IRow row) throws SQLException {
        int personSum = 0;
        double FSAL004Sum = 0.0;
        double FFSAL223Sum = 0.0;
        double FSAL006Sum = 0.0;
        double FFSAL263Sum = 0.0;
        double FFSAL231Sum = 0.0;
        if (iRowSet != null) {
            iRowSet.beforeFirst();
            while (iRowSet.next()) {
                if (iRowSet.getString("number").indexOf(longNumber) == -1) continue;
                personSum += Integer.parseInt(iRowSet.getString("personCount") == null ? "0" : iRowSet.getString("personCount"));
                FSAL004Sum += Double.parseDouble(iRowSet.getString("FSAL004") == null ? "0.00d" : iRowSet.getString("FSAL004"));
                FFSAL223Sum += Double.parseDouble(iRowSet.getString("FFSAL223") == null ? "0.00d" : iRowSet.getString("FFSAL223"));
                FSAL006Sum += Double.parseDouble(iRowSet.getString("FSAL006") == null ? "0.00d" : iRowSet.getString("FSAL006"));
                FFSAL263Sum += Double.parseDouble(iRowSet.getString("FFSAL263") == null ? "0.00d" : iRowSet.getString("FFSAL263"));
                FFSAL231Sum += Double.parseDouble(iRowSet.getString("FFSAL231") == null ? "0.00d" : iRowSet.getString("FFSAL231"));
            }
        }
        row.getCell("personCount").setValue((Object)personSum);
        row.getCell("FSAL004").setValue((Object)new BigDecimal(FSAL004Sum).setScale(2, 4).toString());
        row.getCell("FFSAL223").setValue((Object)new BigDecimal(FFSAL223Sum).setScale(2, 4).toString());
        row.getCell("FSAL006").setValue((Object)new BigDecimal(FSAL006Sum).setScale(2, 4).toString());
        row.getCell("FFSAL263").setValue((Object)new BigDecimal(FFSAL263Sum).setScale(2, 4).toString());
        row.getCell("FFSAL231").setValue((Object)new BigDecimal(FFSAL231Sum).setScale(2, 4).toString());
    }

    private void fillTotalData(IRowSet totalRowSet) throws SQLException {
        IRow row = this.tblMain.addRow();
        if (totalRowSet != null) {
            totalRowSet.beforeFirst();
            if (totalRowSet.next()) {
                row.getStyleAttributes().setBackground(new Color(246, 246, 191));
                row.getCell("adminName").setValue((Object)EASResource.getString((String)(this.resURLStr + "DSALARY_ITEM_TOTAL")));
                row.getCell("personCount").setValue((Object)Integer.valueOf(totalRowSet.getString("personCount") == null ? "0" : totalRowSet.getString("personCount")));
                row.getCell("FSAL004").setValue((Object)new BigDecimal(totalRowSet.getString("FSAL004") == null ? "0.00" : totalRowSet.getString("FSAL004")).setScale(2, 4).toString());
                row.getCell("FFSAL223").setValue((Object)new BigDecimal(totalRowSet.getString("FFSAL223") == null ? "0.00" : totalRowSet.getString("FFSAL223")).setScale(2, 4).toString());
                row.getCell("FSAL006").setValue((Object)new BigDecimal(totalRowSet.getString("FSAL006") == null ? "0.00" : totalRowSet.getString("FSAL006")).setScale(2, 4).toString());
                row.getCell("FFSAL263").setValue((Object)new BigDecimal(totalRowSet.getString("FFSAL263") == null ? "0.00" : totalRowSet.getString("FFSAL263")).setScale(2, 4).toString());
                row.getCell("FFSAL231").setValue((Object)new BigDecimal(totalRowSet.getString("FFSAL231") == null ? "0.00" : totalRowSet.getString("FFSAL231")).setScale(2, 4).toString());
            }
        } else {
            row.getStyleAttributes().setBackground(new Color(246, 246, 191));
            row.getCell("adminName").setValue((Object)EASResource.getString((String)(this.resURLStr + "DSALARY_ITEM_TOTAL")));
            row.getCell("personCount").setValue((Object)0);
            row.getCell("FSAL004").setValue((Object)new BigDecimal(0.0).setScale(2, 4).toString());
            row.getCell("FFSAL223").setValue((Object)new BigDecimal(0.0).setScale(2, 4).toString());
            row.getCell("FSAL006").setValue((Object)new BigDecimal(0.0).setScale(2, 4).toString());
            row.getCell("FFSAL263").setValue((Object)new BigDecimal(0.0).setScale(2, 4).toString());
            row.getCell("FFSAL231").setValue((Object)new BigDecimal(0.0).setScale(2, 4).toString());
        }
    }

    private IDsalaryCmpSchemeFacade getBizfacadeInterface() throws BOSException {
        if (this.idSalaryFacade == null) {
            this.idSalaryFacade = DsalaryCmpSchemeFacadeFactory.getRemoteInstance();
        }
        return this.idSalaryFacade;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblMain.removeRows();
        this.onLoad();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.performCommonQuery();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }
}

