/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.ColCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.ColCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ColCmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.ColCmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.client.AbstractEmpCmpDiffQueryPanel;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EmpCmpDiffQueryPanel
extends AbstractEmpCmpDiffQueryPanel {
    private List lstCmpItem = null;
    private CmpPeriodInfo infoBeginCmpPeriod = null;
    private CmpPeriodInfo infoEndCmpPeriod = null;
    private boolean ratio_CmpScheme = true;
    private boolean ratio_ColCmpScheme = false;
    private Map itemCmpSchemeMap = new HashMap();
    private final String PublicItem = "PublicItem";
    private CmpPeriodCollection colCmpPeriod = null;
    private CmpSchemeInfo[] infoCmpScheme = null;
    private ColCmpSchemeInfo infoColCmpScheme = null;
    String resClass2 = "com.kingdee.eas.hr.compensation.client.CmpReportResource.";
    String resClass = "com.kingdee.eas.hr.compensation.client.ColCmpSchemeResource.";
    private PersonInfo infoPerson = null;
    private static final Logger logger = CoreUIObject.getLogger(EmpCmpDiffQueryPanel.class);

    public PersonInfo getInfoPerson() {
        return this.infoPerson;
    }

    public CmpPeriodCollection getColCmpPeriod() {
        return this.colCmpPeriod;
    }

    public List getInfoCmpScheme() {
        ArrayList<CmpSchemeInfo> alCmpScheme = new ArrayList<CmpSchemeInfo>();
        int size = this.infoCmpScheme.length;
        for (int i = 0; i < size; ++i) {
            alCmpScheme.add(this.infoCmpScheme[i]);
        }
        return alCmpScheme;
    }

    public ColCmpSchemeInfo getInfoColCmpScheme() {
        return this.infoColCmpScheme;
    }

    public List getLstCmpItem() {
        return this.lstCmpItem;
    }

    protected void initListener() {
        super.initListener();
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox();
        pmt.setModal(true);
        pmt.showOnlyPayPerson(true);
        pmt.setIsSingleSelect(true);
        pmt.showNoPositionPerson(true);
        HashSet<String> hroSet = new HashSet<String>();
        hroSet.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
        pmt.setHROFilter(hroSet);
        this.bizPromptPerson.setSelector((KDPromptSelector)pmt);
        this.bizPromptPerson.setEditable(false);
        this.bizPromptPerson.setEditFormat("$name$");
        this.bizPromptPerson.setDisplayFormat("$name$");
        this.bizPromptCmpScheme = HRSchemeUtils.getDefaultCmpSchemeF7(this.bizPromptCmpScheme);
        this.bizPromptCmpScheme.setEnabledMultiSelection(true);
        this.bizPromptCmpScheme.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Object[] obj = (Object[])EmpCmpDiffQueryPanel.this.bizPromptCmpScheme.getData();
                if (obj != null) {
                    CmpSchemeInfo[] info = EmpCmpDiffQueryPanel.this.getCmpSchemeInfoArrayByObject(obj);
                    try {
                        EmpCmpDiffQueryPanel.this.reloadCmpSchemeItem(info);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
                    }
                }
            }
        });
        this.bizPromptCmpScheme.setEditable(false);
        this.bizPromptColCmpScheme = HRSchemeUtils.getDefaultColCmpSchemeF7(this.bizPromptColCmpScheme);
        this.bizPromptColCmpScheme.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Object obj = EmpCmpDiffQueryPanel.this.bizPromptColCmpScheme.getData();
                if (obj != null) {
                    ColCmpSchemeInfo info = (ColCmpSchemeInfo)obj;
                    try {
                        EmpCmpDiffQueryPanel.this.reloadColCmpScheme(info);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
                    }
                }
            }
        });
        this.bizPromptBeginCmpPeriod = HRSchemeUtils.getDefaultCmpPeriodF7(this.bizPromptBeginCmpPeriod);
        this.bizPromptEndCmpPeriod = HRSchemeUtils.getDefaultCmpPeriodF7(this.bizPromptEndCmpPeriod);
    }

    private CmpSchemeInfo[] getCmpSchemeInfoArrayByObject(Object[] objA) {
        CmpSchemeInfo[] info = new CmpSchemeInfo[objA.length];
        int size = objA.length;
        for (int i = 0; i < size; ++i) {
            info[i] = (CmpSchemeInfo)objA[i];
        }
        return info;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void rbtnCmpScheme_actionPerformed(ActionEvent e) throws Exception {
        this.bizPromptCmpScheme.setEnabled(true);
        this.bizPromptColCmpScheme.setEnabled(false);
        Object obj = this.bizPromptCmpScheme.getData();
        CmpSchemeInfo[] info = (CmpSchemeInfo[])obj;
        this.reloadCmpSchemeItem(info);
    }

    @Override
    protected void rbtnColCmpScheme_actionPerformed(ActionEvent e) throws Exception {
        this.bizPromptColCmpScheme.setEnabled(true);
        this.bizPromptCmpScheme.setEnabled(false);
        Object obj = this.bizPromptColCmpScheme.getData();
        ColCmpSchemeInfo info = (ColCmpSchemeInfo)obj;
        this.reloadColCmpScheme(info);
    }

    private void reloadCmpSchemeItem(CmpSchemeInfo[] info) throws Exception {
        this.lstCmpItem = new ArrayList();
        this.lstItem.removeAllElements();
        this.itemCmpSchemeMap.clear();
        if (info == null) {
            return;
        }
        StringBuffer oql = new StringBuffer(" select cmpitem.name,cmpitem.number,cmpitem.id,cmpitem.dataType,cmpitem.decDigital,cmpitem.precisionType,cmpScheme.id,cmpScheme.number,cmpScheme.name where cmpitem.datatype=60 ");
        oql.append(" and " + this.getCmpSchemeIdFilter(" cmpScheme.id", info));
        oql.append(" order by sortOrder ");
        CmpSchemeItemCollection col = CmpSchemeItemFactory.getRemoteInstance().getCmpSchemeItemCollection(oql.toString());
        if (col != null && col.size() > 0) {
            CmpItemInfo cmpItem = null;
            CmpSchemeInfo cmpScheme = null;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                cmpItem = col.get(i).getCmpItem();
                cmpScheme = col.get(i).getCmpScheme();
                if (this.checkIsExitCmpItemList(cmpItem)) {
                    this.setPublicItemMap(cmpItem, info);
                    continue;
                }
                this.setPraivateItemMap(cmpItem, cmpScheme);
                this.lstItem.addElement((Object)cmpItem);
                this.lstCmpItem.add(cmpItem);
            }
        }
    }

    private boolean checkIsExitCmpItemList(CmpItemInfo cmpItem) {
        CmpItemInfo cmpItemTem = null;
        int size = this.lstCmpItem.size();
        for (int i = 0; i < size; ++i) {
            cmpItemTem = (CmpItemInfo)this.lstCmpItem.get(i);
            if (!cmpItem.getNumber().equals(cmpItemTem.getNumber())) continue;
            return true;
        }
        return false;
    }

    private String getCmpSchemeIdFilter(String filedName, CmpSchemeInfo[] infoArr) {
        if (filedName == null || infoArr.length < 1) {
            return "";
        }
        CmpSchemeInfo cmpScheme = null;
        StringBuffer filter = new StringBuffer();
        filter.append(filedName);
        filter.append(" in ( ");
        int size = infoArr.length;
        for (int i = 0; i < size; ++i) {
            cmpScheme = infoArr[i];
            if (i == 0) {
                filter.append("'" + cmpScheme.getId().toString() + "'");
                continue;
            }
            filter.append(",'" + cmpScheme.getId().toString() + "'");
        }
        filter.append(" )");
        return filter.toString();
    }

    private void setPraivateItemMap(CmpItemInfo cmpItem, CmpSchemeInfo cmpScheme) {
        if (cmpItem == null | cmpScheme == null) {
            return;
        }
        Map<String, CmpItemInfo> cmpItemMap = null;
        cmpItemMap = this.itemCmpSchemeMap.get(cmpScheme.getNumber()) == null ? new HashMap<String, CmpItemInfo>() : (Map)this.itemCmpSchemeMap.get(cmpScheme.getNumber());
        cmpItemMap.put(cmpItem.getNumber(), cmpItem);
        this.itemCmpSchemeMap.put(cmpScheme.getNumber(), cmpItemMap);
    }

    private void setPublicItemMap(CmpItemInfo cmpItem, CmpSchemeInfo[] info) {
        if (cmpItem == null | info == null) {
            return;
        }
        Map<String, CmpItemInfo> cmpItemMap = null;
        cmpItemMap = this.itemCmpSchemeMap.get(this.PublicItem) == null ? new HashMap<String, CmpItemInfo>() : (Map)this.itemCmpSchemeMap.get(this.PublicItem);
        cmpItemMap.put(cmpItem.getNumber(), cmpItem);
        this.itemCmpSchemeMap.put(this.PublicItem, cmpItemMap);
        CmpSchemeInfo cmpSchemeTem2 = null;
        for (CmpSchemeInfo cmpSchemeTem2 : info) {
            Map privateMap = (Map)this.itemCmpSchemeMap.get(cmpSchemeTem2.getNumber());
            if (privateMap == null) continue;
            privateMap.remove(cmpItem.getNumber());
        }
    }

    public Map getItemeCmpSchemeMap() {
        return this.itemCmpSchemeMap;
    }

    private void reloadColCmpScheme(ColCmpSchemeInfo info) throws Exception {
        this.lstCmpItem = new ArrayList();
        this.lstItem.removeAllElements();
        if (info == null) {
            return;
        }
        StringBuffer oql = new StringBuffer(" select cmpitem.name,cmpitem.number,cmpitem.id where colCmpScheme.id ='");
        oql.append(info.getId().toString());
        oql.append("' order by order");
        ColCmpSchemeItemCollection col = ColCmpSchemeItemFactory.getRemoteInstance().getColCmpSchemeItemCollection(oql.toString());
        if (col != null && col.size() > 0) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                this.lstItem.addElement((Object)col.get(i).getCmpItem());
                this.lstCmpItem.add(col.get(i).getCmpItem());
            }
        }
    }

    public boolean verify() {
        if (this.bizPromptPerson.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.MESSAGE_PERSONNOTNULL"));
            return false;
        }
        if (this.rbtnCmpScheme.isSelected() && this.bizPromptCmpScheme.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.MESSAGE_NOT_SELECTCMPSCHEME"));
            return false;
        }
        this.infoCmpScheme = this.getCmpSchemeInfoArrayByObject((Object[])this.bizPromptCmpScheme.getData());
        if (this.rbtnColCmpScheme.isSelected() && this.bizPromptColCmpScheme.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.MESSAGE_NOT_SELECTCOLCMPSCHEME"));
            return false;
        }
        this.infoColCmpScheme = (ColCmpSchemeInfo)this.bizPromptColCmpScheme.getData();
        if (this.bizPromptBeginCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.MESSAGE_BEGINCMPPERIODNOTNULL"));
            return false;
        }
        if (this.bizPromptEndCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.MESSAGE_ENDCMPPERIODNOTNULL"));
            return false;
        }
        this.infoBeginCmpPeriod = (CmpPeriodInfo)this.bizPromptBeginCmpPeriod.getData();
        this.infoEndCmpPeriod = (CmpPeriodInfo)this.bizPromptEndCmpPeriod.getData();
        if (this.infoEndCmpPeriod.getBeginDate().before(this.infoBeginCmpPeriod.getEndDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.SHOUDGRATEENDGINCMPPERIOD"));
            return false;
        }
        try {
            this.colCmpPeriod = HRSchemeUtils.getCmpPeriodCollection(this.infoBeginCmpPeriod, this.infoEndCmpPeriod);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return false;
        }
        this.infoPerson = (PersonInfo)this.bizPromptPerson.getData();
        this.lstCmpItem = new ArrayList();
        int size = this.lstItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            this.lstCmpItem.add(this.lstItem.getElement(i));
        }
        return super.verify();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDButtonGroup1.add((AbstractButton)this.rbtnCmpScheme);
        this.kDButtonGroup1.add((AbstractButton)this.rbtnColCmpScheme);
        if (!this.rbtnColCmpScheme.isSelected()) {
            this.rbtnCmpScheme.setSelected(true);
            this.bizPromptCmpScheme.setEnabled(true);
            this.rbtnColCmpScheme.setSelected(false);
            this.bizPromptColCmpScheme.setEnabled(false);
        }
        this.lstItem.setEnabled(false);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.bizPromptPerson.getData() != null) {
            cp.addCustomerParam("person", ((PersonInfo)this.bizPromptPerson.getData()).getId().toString());
        }
        if (this.bizPromptBeginCmpPeriod.getData() != null) {
            cp.addCustomerParam("beginCmpPeriod", ((CmpPeriodInfo)this.bizPromptBeginCmpPeriod.getData()).getId().toString());
        }
        if (this.bizPromptEndCmpPeriod.getData() != null) {
            cp.addCustomerParam("endCmpPeriod", ((CmpPeriodInfo)this.bizPromptEndCmpPeriod.getData()).getId().toString());
        }
        if (this.bizPromptCmpScheme.getData() != null) {
            CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.bizPromptCmpScheme.getData());
            CmpSchemeInfo infoTem = null;
            StringBuffer cmpSchemeStr = new StringBuffer();
            int size = info.length;
            for (int i = 0; i < size; ++i) {
                infoTem = info[i];
                if (i == 0) {
                    cmpSchemeStr.append(infoTem.getId().toString());
                    continue;
                }
                cmpSchemeStr.append("~" + infoTem.getId().toString());
            }
            cp.addCustomerParam("CmpScheme", cmpSchemeStr.toString());
        }
        if (this.bizPromptColCmpScheme.getData() != null) {
            cp.addCustomerParam("ColCmpScheme", ((ColCmpSchemeInfo)this.bizPromptColCmpScheme.getData()).getId().toString());
        }
        cp.addCustomerParam("ratio_CmpScheme", String.valueOf(this.rbtnCmpScheme.isSelected()));
        cp.addCustomerParam("ratio_ColCmpScheme", String.valueOf(this.rbtnColCmpScheme.isSelected()));
        return cp;
    }

    private String formatCmpSchemeId(String cmpSchemeStr) {
        StringBuffer str = new StringBuffer();
        String[] idArr = cmpSchemeStr.split("~");
        int size = idArr.length;
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                str.append("'" + idArr[i] + "'");
                continue;
            }
            str.append(",'" + idArr[i] + "'");
        }
        return str.toString();
    }

    private void loadCmpScheme(String cmpSchemeIdStr) {
        try {
            CmpSchemeCollection cmpColl = CmpSchemeFactory.getRemoteInstance().getCmpSchemeCollection("select id,name,number,cmpPeriod.id,cmpPeriod.begindate,cmpPeriod.enddate  where id in (" + cmpSchemeIdStr + ")");
            CmpSchemeInfo[] cmpSchemeArr = new CmpSchemeInfo[cmpColl.size()];
            int size = cmpColl.size();
            for (int i = 0; i < size; ++i) {
                cmpSchemeArr[i] = cmpColl.get(i);
            }
            this.bizPromptCmpScheme.setData((Object)cmpSchemeArr);
            this.infoCmpScheme = this.getCmpSchemeInfoArrayByObject((Object[])this.bizPromptCmpScheme.getData());
            this.reloadCmpSchemeItem(cmpSchemeArr);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("ratio_CmpScheme") != null) {
            this.ratio_CmpScheme = Boolean.valueOf(cp.getCustomerParam("ratio_CmpScheme"));
        }
        if (cp.getCustomerParam("ratio_ColCmpScheme") != null) {
            this.ratio_ColCmpScheme = Boolean.valueOf(cp.getCustomerParam("ratio_ColCmpScheme"));
        }
        ObjectUuidPK pk = null;
        if (cp.getCustomerParam("person") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("person")));
            try {
                this.infoPerson = (PersonInfo)PersonFactory.getRemoteInstance().getValue((IObjectPK)pk);
                this.bizPromptPerson.setData((Object)this.infoPerson);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("beginCmpPeriod") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("beginCmpPeriod")));
            try {
                this.infoBeginCmpPeriod = (CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pk);
                this.bizPromptBeginCmpPeriod.setData((Object)this.infoBeginCmpPeriod);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("endCmpPeriod") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("endCmpPeriod")));
            try {
                this.infoEndCmpPeriod = (CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pk);
                this.bizPromptEndCmpPeriod.setData((Object)this.infoEndCmpPeriod);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (this.ratio_CmpScheme) {
            this.rbtnCmpScheme.setSelected(true);
            this.rbtnColCmpScheme.setSelected(false);
            this.bizPromptColCmpScheme.setEnabled(false);
            this.bizPromptCmpScheme.setEnabled(true);
            if (cp.getCustomerParam("CmpScheme") != null) {
                String cmpSchemeIdStr = this.formatCmpSchemeId(cp.getCustomerParam("CmpScheme"));
                this.loadCmpScheme(cmpSchemeIdStr);
            }
        }
        if (this.ratio_ColCmpScheme) {
            this.rbtnColCmpScheme.setSelected(true);
            this.rbtnCmpScheme.setSelected(false);
            this.bizPromptCmpScheme.setEnabled(false);
            this.bizPromptColCmpScheme.setEnabled(true);
            if (cp.getCustomerParam("ColCmpScheme") != null) {
                pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("ColCmpScheme")));
                try {
                    this.infoColCmpScheme = ColCmpSchemeFactory.getRemoteInstance().getColCmpSchemeInfo((IObjectPK)pk);
                    this.bizPromptColCmpScheme.setData((Object)this.infoColCmpScheme);
                    this.reloadColCmpScheme(this.infoColCmpScheme);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        try {
            this.colCmpPeriod = HRSchemeUtils.getCmpPeriodCollection((CmpPeriodInfo)this.bizPromptBeginCmpPeriod.getData(), (CmpPeriodInfo)this.bizPromptEndCmpPeriod.getData());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        super.setCustomerParams(cp);
    }

    public void clear() {
        super.clear();
        this.bizPromptPerson.setData(null);
        this.bizPromptBeginCmpPeriod.setData(null);
        this.bizPromptEndCmpPeriod.setData(null);
        this.bizPromptCmpScheme.setData(null);
        this.bizPromptColCmpScheme.setData(null);
        this.lstItem.removeAllElements();
        this.rbtnCmpScheme.setSelected(true);
        this.rbtnColCmpScheme.setSelected(false);
        this.bizPromptColCmpScheme.setEnabled(false);
        this.bizPromptCmpScheme.setEnabled(true);
    }
}

