/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.BillBoSTypeEnum;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemePersonInfo;
import com.kingdee.eas.hr.compensation.client.AbstractEnterForPersonUI;
import com.kingdee.eas.hr.compensation.client.CmpSchemeEditUI;
import com.kingdee.eas.hr.compensation.client.CmpSchemePersonSetUI;
import com.kingdee.eas.hr.compensation.client.CmpSchemeSelectPersonEditUI;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class EnterForPersonUI
extends AbstractEnterForPersonUI {
    private static final Logger logger = CoreUIObject.getLogger(EnterForPersonUI.class);
    private Set hashSet = new HashSet();

    public void onLoad() throws Exception {
        this.getUIContext().put("RequestModel", 0);
        this.setIsNeedDefaultFilter(false);
        super.onLoad();
        this.toolBar.removeAll();
        this.menuBar.removeAll();
        this.add.setEnabled(true);
        this.remove.setEnabled(true);
        this.addAll.setEnabled(true);
        this.removeAll.setEnabled(true);
        this.sure.setEnabled(true);
        this.kDTable1.setEnabled(false);
        this.fillTable();
        KDTSortManager sm = new KDTSortManager(this.tblMain);
        int count = this.tblMain.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        sm.setClickCount(1);
        sm.setSortAuto(true);
    }

    protected void initWorkButton() {
        this.kDContainer1.addButton((JButton)this.add);
        this.kDContainer1.addButton((JButton)this.remove);
        this.kDContainer1.addButton((JButton)this.addAll);
        this.kDContainer1.addButton((JButton)this.removeAll);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    public void actionAddPosition_actionPerformed(ActionEvent e) throws Exception {
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        this.addDataToSelectTable(rowID);
    }

    @Override
    public void actionRemovePosition_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.kDTable1);
        for (i = 0; i < rowID.length; ++i) {
            if (this.kDTable1.getCell(rowID[i], "person.id") == null) continue;
            this.hashSet.remove(this.kDTable1.getCell(rowID[i], "person.id").getValue());
        }
        for (i = 0; i < rowID.length; ++i) {
            if (i > 0 && rowID[i] > 0) {
                int n = i;
                rowID[n] = rowID[n] - 1;
            }
            this.kDTable1.removeRow(rowID[i]);
        }
    }

    @Override
    public void actionSure_actionPerformed(ActionEvent e) throws Exception {
        LinkedList<CmpSchemePersonInfo> personValList = new LinkedList<CmpSchemePersonInfo>();
        CmpSchemePersonInfo info = null;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            info = new CmpSchemePersonInfo();
            if (this.kDTable1.getCell(i, "person.id").getValue() != null && !StringUtil.isEmpty((String)this.kDTable1.getCell(i, "person.id").getValue().toString())) {
                info.setPerson(this.kDTable1.getCell(i, "person.name").getValue() == null ? null : (PersonInfo)this.kDTable1.getCell(i, "person.name").getValue());
            }
            info.setPosition(this.kDTable1.getCell(i, "Position.name").getValue() == null ? null : (PositionInfo)this.kDTable1.getCell(i, "Position.name").getValue());
            if (this.kDTable1.getCell(i, "Dept.id").getValue() != null && !StringUtil.isEmpty((String)this.kDTable1.getCell(i, "Dept.id").getValue().toString())) {
                adminOrgUnitInfo = new AdminOrgUnitInfo();
                adminOrgUnitInfo.setId(BOSUuid.read((String)this.kDTable1.getCell(i, "Dept.id").getValue().toString()));
                adminOrgUnitInfo.setSimpleName(this.kDTable1.getCell(i, "Dept.name").getValue() == null ? null : this.kDTable1.getCell(i, "Dept.name").getValue().toString());
                adminOrgUnitInfo.setDisplayName(this.kDTable1.getCell(i, "Dept.displayName").getValue() == null ? null : this.kDTable1.getCell(i, "Dept.displayName").getValue().toString());
                info.setAdminOrgUnit(adminOrgUnitInfo);
            }
            info.setIsSyncOperate(true);
            personValList.add(info);
        }
        if (this.getUIContext().get("Owner") instanceof CmpSchemeEditUI) {
            ((CmpSchemeEditUI)((Object)this.getUIContext().get("Owner"))).setPersonIdsVal("EnterForPerson", personValList);
        } else if (this.getUIContext().get("Owner") instanceof CmpSchemePersonSetUI) {
            ((CmpSchemePersonSetUI)((Object)this.getUIContext().get("Owner"))).setPersonIdsVal("EnterForPerson", personValList);
        }
        if (personValList.size() > 0) {
            ((CmpSchemeSelectPersonEditUI)((Object)this.getUIContext().get("UI"))).showMessage("ADD_OK");
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent arg0) throws Exception {
        if (this.getUIContext().get("UI") != null) {
            ((CmpSchemeSelectPersonEditUI)((Object)this.getUIContext().get("UI"))).getUIWindow().close();
        }
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable1.removeRows();
        this.hashSet.clear();
        int[] rowID = new int[this.tblMain.getRowCount()];
        for (int i = 0; i < rowID.length; ++i) {
            rowID[i] = i;
        }
        this.addDataToSelectTable(rowID);
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable1.removeRows();
        this.hashSet.clear();
    }

    private void addDataToSelectTable(int[] rowID) throws Exception {
        String pId = null;
        for (int i = 0; i < rowID.length; ++i) {
            if (this.tblMain.getRow(rowID[i]) == null || !this.hashSet.add(pId = this.tblMain.getRow(rowID[i]).getCell("person.id").getValue().toString())) continue;
            this.hashSet.add(pId);
            IRow curRow = this.kDTable1.addRow();
            curRow.getCell("person.id").setValue((Object)pId);
            curRow.getCell("person.number").setValue(this.tblMain.getRow(rowID[i]).getCell("person.number").getValue());
            curRow.getCell("person.name").setValue(this.tblMain.getRow(rowID[i]).getCell("person.name").getValue());
            curRow.getCell("Position.name").setValue(this.tblMain.getRow(rowID[i]).getCell("newPosition.name").getValue());
            curRow.getCell("Dept.name").setValue(this.tblMain.getRow(rowID[i]).getCell("newDept.name").getValue());
            curRow.getCell("Dept.displayName").setValue(this.tblMain.getRow(rowID[i]).getCell("newDept.displayName").getValue());
            curRow.getCell("Dept.id").setValue(this.tblMain.getRow(rowID[i]).getCell("newDept.id").getValue());
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() != 0) {
            int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            this.addDataToSelectTable(rowID);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            String str = null;
            while (rowSet.next()) {
                if (rowSet.getString("billBOSType") == null || BillBoSTypeEnum.getEnum(rowSet.getString("billBOSType")) == null) continue;
                str = BillBoSTypeEnum.getEnum(rowSet.getString("billBOSType")).toString();
                rowSet.updateString("billBOSType", str);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("ctrlBeginDate", ((CmpSchemeSelectPersonEditUI)((Object)this.getUIContext().get((Object)"UI"))).dateBegin.getValue());
        this.getUIContext().put("ctrlEndDate", ((CmpSchemeSelectPersonEditUI)((Object)this.getUIContext().get((Object)"UI"))).dateEnd.getValue());
        this.tblMain.removeRows();
        this.fillTable();
    }

    private void fillTable() {
        String cmpSchemeId = null;
        Date startDate = new Date();
        Date endDate = new Date();
        if (this.getUIContext().get("cmpSchemeId") != null) {
            cmpSchemeId = this.getUIContext().get("cmpSchemeId").toString();
        }
        if (this.getUIContext().get("ctrlBeginDate") != null) {
            startDate = (Date)this.getUIContext().get("ctrlBeginDate");
        }
        if (this.getUIContext().get("ctrlEndDate") != null) {
            endDate = (Date)this.getUIContext().get("ctrlEndDate");
        }
        try {
            PersonPositionCollection ppColl = CmpSchemeFactory.getRemoteInstance().getPersonPositionCollection(startDate, endDate, cmpSchemeId);
            IRow iRow = null;
            PersonPositionInfo ppInfo = null;
            if (ppColl != null && ppColl.size() > 0) {
                int size = ppColl.size();
                for (int i = 0; i < size; ++i) {
                    ppInfo = ppColl.get(i);
                    iRow = this.tblMain.addRow();
                    if (ppInfo.getPerson() != null) {
                        iRow.getCell("person.id").setValue((Object)ppInfo.getPerson().getId().toString());
                        iRow.getCell("person.number").setValue((Object)ppInfo.getPerson().getNumber());
                        iRow.getCell("person.name").setValue((Object)ppInfo.getPerson());
                    }
                    if (ppInfo.getPerson() != null) {
                        iRow.getCell("affairType").setValue((Object)ppInfo.getPerson().getEmployeeType());
                    }
                    if (ppInfo.getPersonDep() != null) {
                        iRow.getCell("newDept.id").setValue((Object)ppInfo.getPersonDep().getId().toString());
                        iRow.getCell("newDept.name").setValue((Object)ppInfo.getPersonDep());
                        iRow.getCell("newDept.displayName").setValue((Object)ppInfo.getPersonDep().getDisplayName());
                    }
                    if (ppInfo.getPrimaryPosition() != null) {
                        iRow.getCell("newPosition.id").setValue((Object)ppInfo.getPrimaryPosition().getId().toString());
                        iRow.getCell("newPosition.name").setValue((Object)ppInfo.getPrimaryPosition());
                    }
                    iRow.getCell("affairDate").setValue((Object)ppInfo.getEnterDate());
                }
            }
        }
        catch (BOSException e) {
            this.abort(e);
        }
    }
}

