/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.client.FillDeductFillPayQueryUI;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FillFillDetailReportQueryUI
extends FillDeductFillPayQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(FillFillDetailReportQueryUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtCompeScheme.setEnabledMultiSelection(true);
    }

    private Set getCmpSchemeInfoSet() {
        Object o = this.prmtCompeScheme.getData();
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        if (o instanceof Object[]) {
            Object[] objs = (Object[])o;
            for (int i = 0; i < objs.length; ++i) {
                set.add(((CmpSchemeInfo)objs[i]).getId());
            }
        } else if (o instanceof CmpSchemeInfo) {
            set.add(((CmpSchemeInfo)o).getId());
        }
        return set;
    }

    private String getCmpSchemeInfos() {
        Object o = this.prmtCompeScheme.getData();
        StringBuffer ids = new StringBuffer();
        if (o instanceof Object[]) {
            Object[] objs = (Object[])o;
            for (int i = 0; i < objs.length; ++i) {
                ids.append("'").append(((CmpSchemeInfo)objs[i]).getId().toString()).append("',");
            }
            ids.deleteCharAt(ids.length() - 1);
        } else if (o instanceof CmpSchemeInfo) {
            ids.append("'").append(((CmpSchemeInfo)o).getId().toString()).append("'");
        }
        return ids.toString();
    }

    @Override
    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        AdminOrgUnitInfo org = (AdminOrgUnitInfo)this.prmtOrg.getData();
        PersonInfo person = (PersonInfo)this.prmtEmp.getData();
        String cmpschemes = this.getCmpSchemeInfos();
        CmpPeriodInfo payPeriodInfo = (CmpPeriodInfo)this.prmtPayCmpPeriod.getData();
        Integer level = new Integer(0);
        try {
            if (org != null) {
                level = new Integer(org.getLevel());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        if (this.prmtOrg.getData() != null && this.chkConSubOrg.isSelected()) {
            Integer nowlevel = new Integer(0);
            nowlevel = this.comboSubLevel.getSelectedItem() != null ? new Integer((Integer)this.comboSubLevel.getSelectedItem() + level) : level;
            filter.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)org.getLongNumber(), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("admin.level", (Object)level, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("admin.level", (Object)nowlevel, CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpschemes, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)payPeriodInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("time", (Object)this.txtTime.getIntegerValue()));
            if (person != null) {
                filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person.getId().toString(), CompareType.EQUALS));
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6");
            } else {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5");
            }
        } else if (this.prmtOrg.getData() != null) {
            filter.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)org.getLongNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpschemes, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)payPeriodInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("time", (Object)this.txtTime.getIntegerValue()));
            if (person != null) {
                filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person.getId().toString(), CompareType.EQUALS));
                filter.setMaskString("#0 and #1 and #2 and #3 and #4");
            } else {
                filter.setMaskString("#0 and #1 and #2 and #3");
            }
        } else if (person != null) {
            filter.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpschemes, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)payPeriodInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("time", (Object)this.txtTime.getIntegerValue()));
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person.getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpschemes, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)payPeriodInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("time", (Object)this.txtTime.getIntegerValue()));
            filter.setMaskString("#0 and #1 and #2");
        }
        return filter;
    }

    @Override
    protected void restoreCmpScheme(CustomerParams cp) {
        this.prmtCompeScheme.setData(this.stringToCmpScheme(cp.getCustomerParam("cmpScheme")));
    }

    @Override
    protected void saveCmpScheme(CustomerParams cp) {
        if (this.prmtCompeScheme.getData() != null) {
            String cmpSchemeStr = this.cmpSchemeToString(this.prmtCompeScheme.getData());
            cp.addCustomerParam("cmpScheme", cmpSchemeStr);
        }
    }

    private String cmpSchemeToString(Object data) {
        if (data == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (data instanceof Object[]) {
            Object[] objs = (Object[])data;
            for (int i = 0; i < objs.length; ++i) {
                sb.append('\'').append(((CmpSchemeInfo)objs[i]).getId().toString()).append('\'');
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    private Object stringToCmpScheme(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        try {
            CoreBaseCollection coll = CmpSchemeFactory.getRemoteInstance().getCollection("select * from where id in (" + str + ")");
            CmpSchemeInfo[] cmpSchemes = new CmpSchemeInfo[coll.size()];
            for (int i = 0; i < cmpSchemes.length; ++i) {
                cmpSchemes[i] = (CmpSchemeInfo)coll.get(i);
            }
            return cmpSchemes;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.hr.compensation.client", "FillFillDetailReportQueryUI");
    }
}

