/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractFixSchemeInitUI;
import com.kingdee.eas.hr.compensation.client.FixedCmpSchemeListUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FixSchemeInitUI
extends AbstractFixSchemeInitUI {
    private static final Logger logger = CoreUIObject.getLogger(FixSchemeInitUI.class);
    private boolean isFromSalSchm = false;
    private SalariatSchemeInfo ssinfo = null;
    private boolean stateChange = false;

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnUnenable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("SalSchmInfoID") != null) {
            this.isFromSalSchm = true;
            String salID = (String)this.getUIContext().get("SalSchmInfoID");
            this.ssinfo = SalariatSchemeFactory.getRemoteInstance().getSalariatSchemeInfo((IObjectPK)new ObjectUuidPK(salID));
        }
        super.onLoad();
        if (!this.oprtState.equalsIgnoreCase("ADDNEW")) {
            // empty if block
        }
        this.MenuService.setVisible(false);
        this.initAllListener();
        if (this.editData != null) {
            if ("EDIT".equals(this.getOprtState())) {
                this.pkEnableDate.setEnabled(true);
                this.pkDisableDate.setEnabled(true);
            } else {
                this.pkEnableDate.setEnabled(false);
                this.pkDisableDate.setEnabled(false);
            }
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.prmtSalariatScheme.setEnabled(true);
            this.pkEnableDate.setEnabled(true);
            this.pkDisableDate.setEnabled(true);
        }
        this.btnUnenable.setVisible(false);
        this.btnEnable.setVisible(false);
        this.btnEnableFixScheme.setVisible(false);
        this.btnUnenable.setEnabled(false);
        this.btnEnable.setEnabled(false);
        this.btnEnableFixScheme.setEnabled(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        view.setFilter(filter);
        this.prmtSalariatScheme.setEntityViewInfo(view);
        this.prmtSalariatScheme.setQueryInfo("com.kingdee.eas.hr.compensation.app.SalariatSchemeQuery");
        this.txtName.setMaxLength(255);
        this.txtNumber.setMaxLength(80);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int result;
        if (this.stateChange && this.btnEnable.isSelected() && (result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"389_FixedSchemeListUI"))) != 0) {
            return;
        }
        String newNumber = this.txtNumber.getText();
        if (newNumber == null || newNumber.trim().length() == 0) {
            this.txtNumber.requestFocus();
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        if (!newNumber.equals(this.editData.getNumber())) {
            String oql = "where number ='" + newNumber + "'";
            if (FixedCmpSchemeFactory.getRemoteInstance().exists(oql)) {
                this.txtNumber.requestFocus();
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{newNumber});
            }
        }
        super.actionSubmit_actionPerformed(e);
        if (this.isFromSalSchm) {
            this.destroyWindow();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        FixedCmpSchemeInfo fixedInfo = new FixedCmpSchemeInfo();
        if (this.isFromSalSchm) {
            fixedInfo.setSalariatScheme(this.ssinfo);
        }
        fixedInfo.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        fixedInfo.setEnable(StateEnum.UNENABLE);
        return fixedInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FixedCmpSchemeFactory.getRemoteInstance();
    }

    @Override
    public void actionStartupFixScheme_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"392_FixSchemeInitUI"));
            return;
        }
        FixedCmpSchemeInfo info = FixedCmpSchemeFactory.getRemoteInstance().getFixedCmpSchemeInfo("where id ='" + this.editData.getId() + "'");
        if (StateEnum.UNENABLE.equals((Object)info.getEnable())) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"640_FixedSchemeListUI"));
            SysUtil.abort();
        }
        if (info.getSalariatScheme() != null) {
            StateEnum state = info.getSalariatScheme().getState();
            String schemeName = info.getSalariatScheme().getName();
            if (state != null && StateEnum.DISABLE.equals((Object)state)) {
                String msgBoxForbid1 = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FixedCmpSchemeResource", (String)"MsgBoxForbid1");
                String msgBoxForbid2 = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FixedCmpSchemeResource", (String)"MsgBoxForbid2");
                int choose = MsgBox.showConfirm3((String)(msgBoxForbid1 + schemeName + msgBoxForbid2));
                if (choose != 0) {
                    SysUtil.abort();
                }
            }
        }
        String id = info.getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id.toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(FixedCmpSchemeListUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected void btnEnable_itemStateChanged(ItemEvent e) throws Exception {
    }

    protected String getEditUIModal() {
        String openModel = UIConfigUtility.getOpenModel();
        if (openModel != null) {
            return openModel;
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected void initAllListener() {
        this.btnEnable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FixSchemeInitUI.this.stateChange = true;
                FixedCmpSchemeInfo info = null;
                if (FixSchemeInitUI.this.editData != null && FixSchemeInitUI.this.editData.getId() != null) {
                    try {
                        info = FixedCmpSchemeFactory.getRemoteInstance().getFixedCmpSchemeInfo("select id,name,enable where id = '" + FixSchemeInitUI.this.editData.getId().toString() + "'");
                    }
                    catch (EASBizException e1) {
                        FixSchemeInitUI.this.handUIException(e1);
                    }
                    catch (BOSException e1) {
                        FixSchemeInitUI.this.handUIException(e1);
                    }
                }
                if (FixSchemeInitUI.this.btnEnable.isSelected()) {
                    // empty if block
                }
            }
        });
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FixedCmpSchemeCollection fiexdshcemes;
        if (this.pkEnableDate.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"395_FixSchemeInitUI"));
            SysUtil.abort();
        } else if (this.pkDisableDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.pkEnableDate.getValue()), (Date)((Date)this.pkDisableDate.getValue()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"396_FixSchemeInitUI"));
            SysUtil.abort();
        }
        StateEnum state = this.editData.getEnable();
        if (this.editData.getSalariatScheme() != null && "ADDNEW".equals(this.getOprtState()) && (fiexdshcemes = FixedCmpSchemeFactory.getRemoteInstance().getFixedCmpSchemeCollection("select id where salariatScheme = '" + this.editData.getSalariatScheme().getId().toString() + "' ")) != null && fiexdshcemes.size() > 0 && !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"678_FixSchemeInitUI")))) {
            SysUtil.abort();
        }
        if (StateEnum.DISABLE.equals((Object)state) && this.pkDisableDate.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"393_FixSchemeInitUI"));
            SysUtil.abort();
        }
        if (StateEnum.ENABLE.equals((Object)state) && this.pkEnableDate.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"394_FixSchemeInitUI"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnEnable_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"398_FixSchemeInitUI")))) {
                FixedCmpSchemeFactory.getRemoteInstance().updateEnableState(this.editData.getId().toString(), StateEnum.ENABLE);
                this.onLoad();
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"397_FixSchemeInitUI"));
        }
    }

    @Override
    protected void btnUnenable_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            FixedCmpSchemeFactory.getRemoteInstance().updateEnableState(this.editData.getId().toString(), StateEnum.DISABLE);
            this.onLoad();
        }
    }
}

