/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.client.AbstractFixedCmpSchemeFilterListUI;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBoxMutiSelect;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class FixedCmpSchemeFilterListUI
extends AbstractFixedCmpSchemeFilterListUI {
    private final String resClass = "com.kingdee.eas.hr.compensation.client.FixedCmpSchemeResource.";
    protected List lstAllItemData = null;
    protected List lstSelectItemData = null;
    protected List lstOldSelectItem = new ArrayList();
    private CmpItemCollection colCmpItemAll = null;
    private Hashtable hstSelectItem = new Hashtable();
    private String fixedCmpSchemeID = null;
    private String salSchemeID = null;

    public FixedCmpSchemeFilterListUI() throws Exception {
    }

    public FixedCmpSchemeFilterListUI(String fixedCmpSchemeID) throws Exception {
        this.fixedCmpSchemeID = fixedCmpSchemeID;
    }

    public FixedCmpSchemeFilterListUI(String fixedCmpSchemeID, String salSchemeID) throws Exception {
        this.fixedCmpSchemeID = fixedCmpSchemeID;
        this.salSchemeID = salSchemeID;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getCmpItemCollection();
        this.initF7();
        this.lstAllItem.setSelectionMode(0);
        this.lstSelectItem.setSelectionMode(0);
        this.initWorkButton();
    }

    protected void initWorkButton() {
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnLeft.setEnabled(true);
        this.btnAllLeft.setEnabled(true);
        this.btnRight.setEnabled(true);
        this.btnAllRight.setEnabled(true);
        this.btnMoveBottom.setEnabled(true);
        this.btnMoveNext.setEnabled(true);
        this.btnMovePre.setEnabled(true);
        this.btnMoveTop.setEnabled(true);
    }

    private void getCmpItemCollection() throws Exception {
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)10));
        filterInfo.getFilterItems().add(new FilterItemInfo("dataType", (Object)60));
        if (!StringUtils.isEmpty((String)this.salSchemeID)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL000"));
            filterInfo.setMaskString("#0 and #1 and ((#2 and #3) or #4)");
        }
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItemCatalog.*"));
        this.colCmpItemAll = iCmpItem.getCmpItemCollection(evi);
        String number = null;
        int size = this.colCmpItemAll.size();
        for (int i = 0; i < size; ++i) {
            number = this.colCmpItemAll.get(i).getNumber();
            if (!HRCmpItemUtils.isExcludeFixedCmpItem(number) && this.hstSelectItem.get(number) == null && this.colCmpItemAll.get(i).getCmpItemCatalog().getNumber().indexOf("FPER") <= -1) continue;
            this.colCmpItemAll.removeObject(i);
            --size;
            --i;
        }
    }

    private void onLoadAllList() {
        if (this.colCmpItemAll == null || this.colCmpItemAll.size() <= 0) {
            return;
        }
        this.lstAllItem.removeAllElements();
        Iterator itrCmpItem = this.colCmpItemAll.iterator();
        CmpItemInfo infoCmpItem = null;
        while (itrCmpItem.hasNext()) {
            infoCmpItem = (CmpItemInfo)itrCmpItem.next();
            this.lstAllItem.addElement((Object)infoCmpItem);
        }
        if (this.lstAllItem.getElementCount() > 0) {
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        return filterInfo;
    }

    public List getSelectedCmpItem() throws Exception {
        if (this.lstSelectItemData == null) {
            return new ArrayList();
        }
        return this.lstSelectItemData;
    }

    @Override
    protected void chkInclude_actionPerformed(ActionEvent e) throws Exception {
        super.chkInclude_actionPerformed(e);
        if (this.chkInclude.isSelected()) {
            this.cboLevel.setEnabled(true);
        } else {
            this.cboLevel.setEnabled(false);
        }
    }

    public boolean verify() {
        if (this.lstSelectItem.getElementCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FixedCmpSchemeResource.MSG_CHOOSE_FIXED_CMPITEM"));
            return false;
        }
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        return true;
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                this.lstAllItem.addElement((Object)info);
                this.lstSelectItem.removeElement((Object)info);
            }
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.addElement((Object)info);
                this.lstAllItem.removeElement((Object)info);
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            int indexSelect = this.lstAllItem.getSelectedIndex() + 1;
            this.lstAllItem.insertElement((Object)info, indexSelect);
            this.lstSelectItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            } else if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(0);
            }
            this.lstAllItem.setSelectedValue((Object)info, true);
        }
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    public void clear() {
        super.clear();
        this.bizAdminOrg.setData(null);
        this.chkDisplayFullName.setSelected(false);
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        this.onLoadAllList();
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionRight_actionPerformed(null);
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionLeft_actionPerformed(null);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        Object pk = null;
        if (cp.getCustomerParam("SelectOrg") != null) {
            String value = cp.getCustomerParam("SelectOrg");
            EntityViewInfo evi = new EntityViewInfo();
            String[] adminOrg = StringUtils.split((String)value, (String)"~");
            try {
                IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(adminOrg)), CompareType.INCLUDE));
                evi.setFilter(fi);
                AdminOrgUnitCollection col = adminOrgUnit.getAdminOrgUnitCollection(evi);
                this.bizAdminOrg.setData((Object)col.toArray());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.bizAdminOrg.setValue(null);
        }
        this.onLoadAllList();
        this.lstOldSelectItem = null;
        if (cp.getCustomerParam("lstSelectItem") != null) {
            String ids = cp.getCustomerParam("lstSelectItem");
            try {
                boolean isDisplaySalPoint = false;
                if (!StringUtils.isEmpty((String)this.salSchemeID)) {
                    isDisplaySalPoint = true;
                }
                this.lstSelectItemData = HRCommonQueryUtils.getSelectedItemList(ids, isDisplaySalPoint);
                this.lstOldSelectItem = new ArrayList();
                this.lstOldSelectItem.addAll(this.lstSelectItemData);
                HRCommonQueryUtils.fillSelectItemList(this.lstSelectItemData, this.lstSelectItem, this.lstAllItem);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else if (this.fixedCmpSchemeID != null) {
            try {
                this.lstSelectItemData = this.getDefaultCmpItem();
                HRCommonQueryUtils.fillSelectItemList(this.lstSelectItemData, this.lstSelectItem, this.lstAllItem);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("DisplayFullName") != null) {
            this.chkDisplayFullName.setSelected(Boolean.valueOf(cp.getCustomerParam("DisplayFullName")).booleanValue());
        }
        super.setCustomerParams(cp);
    }

    public CustomerParams getCustomerParams() {
        Object[] ogs;
        CustomerParams cp = new CustomerParams();
        Object value = this.bizAdminOrg.getValue();
        if (value != null && value instanceof Object[] && (ogs = (Object[])value).length > 0 && ogs[0] != null) {
            int i;
            StringBuffer orgUnits = new StringBuffer();
            for (i = 0; i < ogs.length - 1; ++i) {
                orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
                orgUnits.append("~");
            }
            orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
            cp.addCustomerParam("SelectOrg", orgUnits.toString());
        }
        cp.addCustomerParam("DisplayFullName", String.valueOf(this.chkDisplayFullName.isSelected()));
        cp.addCustomerParam("lstSelectItem", HRCommonQueryUtils.getSelectedItemIDS(this.lstSelectItemData));
        return cp;
    }

    private void initF7() throws Exception {
        AdminByOrgRangePromptBoxMutiSelect prmtUnit = new AdminByOrgRangePromptBoxMutiSelect();
        HashSet<String> hrSet = new HashSet<String>();
        hrSet.add(HRSchemeUtils.getClientHROrgUnitInfo().getId().toString());
        prmtUnit.setEnabledMultiSelection(true);
        prmtUnit.setHROFilter(hrSet);
        this.bizAdminOrg.setSelector((KDPromptSelector)prmtUnit);
        this.bizAdminOrg.setEditable(false);
        this.bizAdminOrg.setEditFormat("$name$");
        this.bizAdminOrg.setDisplayFormat("$name$");
        this.bizAdminOrg.setHasCUDefaultFilter(false);
        this.bizAdminOrg.setEnabledMultiSelection(true);
        if (this.getUIContext().get("SelectOrg") != null) {
            // empty if block
        }
        this.bizAdminOrg.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
            }
        });
    }

    private void initComboBox(PreChangeEvent e) throws Exception {
        this.cboLevel.removeAllItems();
        if (e.getData() == null) {
            return;
        }
        int level = HRCommonQueryUtils.getAdminOrgLevelCount((AdminOrgUnitInfo)e.getData());
        this.cboLevel.setEnabled(false);
        if (level == 0) {
            this.chkInclude.setSelected(false);
            this.chkInclude.setEnabled(false);
        } else {
            this.chkInclude.setEnabled(true);
        }
        HRCommonQueryUtils.initComBox(this.cboLevel, level);
        if (!this.chkInclude.isSelected()) {
            this.cboLevel.setEnabled(false);
        } else {
            this.cboLevel.setEnabled(true);
        }
    }

    private List getDefaultCmpItem() throws BOSException {
        ArrayList<CmpItemInfo> defaultCmpItemList = new ArrayList<CmpItemInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("visible", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("fixedCmpScheme", (Object)this.fixedCmpSchemeID));
        filterInfo.setMaskString("#0 and #1");
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("sortOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItem.*"));
        FixedCmpSchemeItemCollection col = FixedCmpSchemeItemFactory.getRemoteInstance().getFixedCmpSchemeItemCollection(evi);
        CmpItemInfo infoCmpItem = null;
        if (col != null && col.size() > 0) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                infoCmpItem = col.get(i).getCmpItem();
                defaultCmpItemList.add(infoCmpItem);
            }
        }
        return defaultCmpItemList;
    }
}

