/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.compensation.HRCmpDataAuditFacadeFactory;
import com.kingdee.eas.hr.compensation.IHRCmpDataAuditFacade;
import com.kingdee.eas.hr.compensation.client.AbstractHRCmpDataAuditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class HRCmpDataAuditUI
extends AbstractHRCmpDataAuditUI {
    private static final Logger logger = CoreUIObject.getLogger(HRCmpDataAuditUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setEnabled(true);
        this.btnFix.setEnabled(false);
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnFix.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.contDetail.addButton((JButton)this.btnPreserve);
        this.btnPreserve.setIcon(EASResource.getIcon((String)"imgTbtn_approvebatch"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblAuditResult.getStyleAttributes().setLocked(true);
        this.tblAuditResult.getSelectManager().setSelectMode(2);
        this.tblMain.getSelectManager().setSelectMode(15);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        String[] tableTypes = new String[]{"schemePerson", "periodEndInput", "allSchemeHorTable", "allSchemeHisTable", "fixedSchemePerson", "allFixedSchemeHorTable"};
        HashMap mapAuditResult = HRCmpDataAuditFacadeFactory.getRemoteInstance().auditCmpData(tableTypes);
        if (mapAuditResult != null && mapAuditResult.size() > 0) {
            this.showAuditResult(mapAuditResult);
            this.btnFix.setEnabled(true);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"425_HRCmpDataAuditUI"));
            this.tblAuditResult.removeRows();
            this.tblMain.removeColumns();
            this.btnFix.setEnabled(false);
        }
    }

    @Override
    public void actionFix_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.tblAuditResult.getSelectManager().getActiveRowIndex();
        IHRCmpDataAuditFacade iDataAudit = HRCmpDataAuditFacadeFactory.getRemoteInstance();
        if (rowIndex >= 0) {
            String strMsg;
            String strTableType = (String)this.tblAuditResult.getRow(rowIndex).getCell("auditType").getValue();
            HashMap newErrorData = null;
            if (strTableType.equals("schemePerson") || strTableType.equals("periodEndInput") || strTableType.equals("fixedSchemePerson")) {
                iDataAudit.fixCmpData(strTableType, null);
                newErrorData = iDataAudit.auditCmpData(new String[]{strTableType});
            } else if (strTableType.indexOf("T_HR_SCHM_") >= 0) {
                String strMsg2 = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"426_HRCmpDataAuditUI");
                if (MsgBox.showConfirm2((String)strMsg2) == 0) {
                    iDataAudit.fixCmpData(strTableType, null);
                    newErrorData = iDataAudit.auditCmpData(new String[]{strTableType});
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"427_HRCmpDataAuditUI"));
                }
            } else if (strTableType.indexOf("T_HR_SCHMHIS_") >= 0) {
                String strMsg3 = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"428_HRCmpDataAuditUI");
                if (MsgBox.showConfirm2((String)strMsg3) == 0) {
                    iDataAudit.fixCmpData(strTableType, null);
                    newErrorData = iDataAudit.auditCmpData(new String[]{strTableType});
                }
            } else if (strTableType.indexOf("T_HR_FCS_") >= 0 && MsgBox.showConfirm2((String)(strMsg = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"429_HRCmpDataAuditUI"))) == 0) {
                iDataAudit.fixCmpData(strTableType, null);
                newErrorData = iDataAudit.auditCmpData(new String[]{strTableType});
            }
            if (newErrorData == null) {
                return;
            }
            if (newErrorData.size() <= 0) {
                this.tblMain.removeColumns();
                this.tblAuditResult.removeRow(rowIndex);
                this.tblAuditResult_tableSelectChanged(null);
            } else {
                this.showErrorData((IRowSet)((HashMap)newErrorData.get(strTableType)).get("errorData"));
            }
        }
        if (this.tblAuditResult.getRowCount() > 0) {
            this.btnFix.setEnabled(true);
        } else {
            this.btnFix.setEnabled(false);
        }
    }

    private void showAuditResult(HashMap map) {
        this.tblAuditResult.removeRows();
        Iterator it = map.entrySet().iterator();
        String key = null;
        HashMap mapEntry = null;
        IRow row = null;
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            key = (String)entry.getKey();
            mapEntry = (HashMap)entry.getValue();
            row = this.tblAuditResult.addRow();
            row.getCell("auditType").setValue((Object)key);
            row.getCell("auditType").setUserObject(mapEntry.get("errorData"));
            row.getCell("auditMsg").setValue(mapEntry.get("errorMsg"));
        }
    }

    private void showErrorData(IRowSet rs) throws SQLException {
        this.tblMain.removeColumns();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        IRow headRow = this.tblMain.addHeadRow();
        for (int i = 0; i < columnCount; ++i) {
            IColumn column = this.tblMain.addColumn();
            column.setKey(meta.getColumnName(i + 1));
            headRow.getCell(i).setValue((Object)meta.getColumnName(i + 1));
        }
        rs.beforeFirst();
        while (rs.next()) {
            IRow row = this.tblMain.addRow();
            for (int j = 0; j < columnCount; ++j) {
                row.getCell(j).setValue(rs.getObject(j + 1));
            }
        }
    }

    @Override
    protected void tblAuditResult_tableSelectChanged(KDTSelectEvent e) throws Exception {
        IRowSet rs;
        int rowIndex = this.tblAuditResult.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (rs = (IRowSet)this.tblAuditResult.getRow(rowIndex).getCell("auditType").getUserObject()) != null) {
            this.showErrorData(rs);
        }
    }

    @Override
    protected void btnPreserve_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRowIndexs.length <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"430_HRCmpDataAuditUI"));
            return;
        }
        int index = this.tblAuditResult.getSelectManager().getActiveRowIndex();
        if (index < 0) {
            return;
        }
        String strTableType = (String)this.tblAuditResult.getRow(index).getCell("auditType").getValue();
        if (strTableType.indexOf("T_HR_SCHM_") >= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"431_HRCmpDataAuditUI"));
            return;
        }
        if (strTableType.indexOf("T_HR_SCHMHIS_") >= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"432_HRCmpDataAuditUI"));
            return;
        }
        if (strTableType.indexOf("T_HR_FCS_") >= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"433_HRCmpDataAuditUI"));
            return;
        }
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"434_HRCmpDataAuditUI")) != 0) {
            return;
        }
        if (strTableType.equals("schemePerson") || strTableType.equals("periodEndInput") || strTableType.equals("fixedSchemePerson")) {
            String strRowKey = null;
            StringBuffer strCondition = new StringBuffer();
            int size = selectRowIndexs.length;
            for (int i = 0; i < size; ++i) {
                strRowKey = (String)this.tblMain.getRow(selectRowIndexs[i]).getCell("FID").getValue();
                if (i > 0) {
                    strCondition.append(",");
                }
                strCondition.append("'").append(strRowKey).append("'");
            }
            String condition = "fid in (" + strCondition.toString() + ")";
            HRCmpDataAuditFacadeFactory.getRemoteInstance().preserveCmpData(strTableType, condition);
            HashMap newErrorData = HRCmpDataAuditFacadeFactory.getRemoteInstance().auditCmpData(new String[]{strTableType});
            if (newErrorData == null || newErrorData.size() <= 0) {
                this.tblMain.removeColumns();
                this.tblAuditResult.removeRow(index);
                this.tblAuditResult_tableSelectChanged(null);
            } else {
                IRowSet rsNew = (IRowSet)((HashMap)newErrorData.get(strTableType)).get("errorData");
                this.tblAuditResult.getRow(index).getCell("auditType").setUserObject((Object)rsNew);
                this.tblAuditResult.getSelectManager().select(index, 1, 2);
                this.showErrorData(rsNew);
            }
        }
    }
}

