/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CommonPermissionFacadeFactory;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.JointAssessmentCollection;
import com.kingdee.eas.hr.compensation.JointAssessmentFactory;
import com.kingdee.eas.hr.compensation.client.AbstractHRF7CmpSchemeUI;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class HRF7CmpSchemeUI
extends AbstractHRF7CmpSchemeUI {
    private static final Logger logger = CoreUIObject.getLogger(HRF7CmpSchemeUI.class);
    private String resClass = "com.kingdee.eas.hr.compensation.client.CmpItemResource.";
    protected boolean isCanceled = true;
    protected boolean isShowDelete = false;
    protected boolean isShowForJointAss = false;
    protected boolean isSingleSelect = false;
    protected CmpSchemeInfo cmpSchemeInfo = null;
    protected CmpSchemeCollection schemeColl = null;
    public static final String IS_SINGLE_SELECT = "IS_SINGLE_SELECT";
    public static final String IS_DELETE_SHOW = "IS_DELETE_SHOW";
    public static final String IS_how_ForJointAss = "IS_how_ForJointAss";
    public static final String HRO_LIST = "HRO_LIST";
    private ArrayList hroList = null;

    public void onLoad() throws Exception {
        this.chkLike.setSelected(true);
        HashMap map = (HashMap)this.getUIContext();
        if (map.get(HRO_LIST) != null) {
            this.hroList = (ArrayList)map.get(HRO_LIST);
        }
        this.isSingleSelect = (Boolean)map.get(IS_SINGLE_SELECT);
        this.isShowDelete = (Boolean)map.get(IS_DELETE_SHOW);
        this.isShowForJointAss = (Boolean)map.get(IS_how_ForJointAss);
        super.onLoad();
        if (this.isSingleSelect) {
            this.tblMain.getSelectManager().setSelectMode(2);
        } else {
            this.tblMain.getSelectManager().setSelectMode(10);
        }
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() < 1 || this.tblMain.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        ICmpScheme iCmpScheme = (ICmpScheme)this.getBizInterface();
        CmpSchemeCollection schemeTemp = null;
        if (this.isSingleSelect) {
            String strID = this.tblMain.getRow(rowID[0]).getCell("id").getValue().toString();
            this.cmpSchemeInfo = ((ICmpScheme)this.getBizInterface()).getSchemeNoDataPermission(strID, false);
        } else {
            HashSet<String> selectSet = new HashSet<String>();
            for (int i = 0; i < rowID.length; ++i) {
                selectSet.add(this.tblMain.getRow(rowID[i]).getCell("id").getValue().toString());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", selectSet, CompareType.INCLUDE));
            viewInfo.setFilter(fi);
            schemeTemp = iCmpScheme.getSchemeCollNoDataPermission(viewInfo);
        }
        this.schemeColl = this.sortScheme(schemeTemp);
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    private CmpSchemeCollection sortScheme(CmpSchemeCollection schemeColl) {
        if (schemeColl == null) {
            return null;
        }
        ArrayList<CmpSchemeInfo> cmpSchemeList = new ArrayList<CmpSchemeInfo>();
        int size = schemeColl.size();
        for (int i = 0; i < size; ++i) {
            cmpSchemeList.add(schemeColl.get(i));
        }
        Comparator orderName = new Comparator(){

            public int compare(Object o1, Object o2) {
                CmpSchemeInfo scheme1 = (CmpSchemeInfo)o1;
                CmpSchemeInfo scheme2 = (CmpSchemeInfo)o2;
                return scheme1.getName().compareTo(scheme2.getName());
            }
        };
        Collections.sort(cmpSchemeList, orderName);
        CmpSchemeCollection schemeCollection = new CmpSchemeCollection();
        int size2 = cmpSchemeList.size();
        for (int i = 0; i < size2; ++i) {
            schemeCollection.add((CmpSchemeInfo)cmpSchemeList.get(i));
        }
        return schemeCollection;
    }

    @Override
    protected void btnFastQuery_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        String queryValue = "";
        String queryFiled = "cmp.number";
        if (this.cboKey.getSelectedIndex() == 1) {
            queryFiled = "name";
        }
        if (!StringUtils.isEmpty((String)this.kdVlaue.getText())) {
            queryValue = this.kdVlaue.getText().trim();
        }
        if (this.chkLike.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo(queryFiled, (Object)("%" + queryValue + "%"), CompareType.LIKE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo(queryFiled, (Object)queryValue));
        }
        filterInfo.mergeFilter(this.getDefaultFilterForQuery(), "and");
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        this.mainQuery.setFilter(filterInfo);
        this.tblMain.removeRows();
        this.tblMain.requestFocusInWindow();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (!this.isShowForJointAss) {
            String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userID));
            filter.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
            if (this.isShowDelete) {
                filter.setMaskString("#0 and (#1 or #2)");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
                filter.setMaskString("#0 and (#1 or #2) and #3");
            }
            try {
                HashSet<String> hroSet = CompUtils.getHROrgUnitIds(null, "cmpScheme_view");
                EntityViewInfo view = CommonPermissionFacadeFactory.getRemoteInstance().getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpScheme_view");
                if (view.getFilter() != null && view.getFilter().size() > 0) {
                    filter.mergeFilter(view.getFilter(), "and");
                }
                if (this.hroList != null) {
                    hroSet = new HashSet<String>();
                    int size = this.hroList.size();
                    for (int i = 0; i < size; ++i) {
                        hroSet.add(((HROrgUnitInfo)this.hroList.get(i)).getId().toString());
                    }
                    if (this.hroList.size() == 0) {
                        hroSet.add("nodata");
                    }
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", hroSet, CompareType.INCLUDE));
                    filter.mergeFilter(filterInfo, "and");
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            FilterInfo adminRangeFilter = HRSchemeUtils.getAdminRangeFilter(null, "adminOrg.id");
            if (adminRangeFilter != null) {
                try {
                    filter.mergeFilter(adminRangeFilter, "and");
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        } else {
            try {
                JointAssessmentCollection jointassconsColl = JointAssessmentFactory.getRemoteInstance().getJointAssessmentCollection("select id,cmpScheme.id,cmpScheme.name where hrOrgUnit.id = '" + HRSchemeUtils.getClientHROrgUnitInfo().getId().toString() + "'");
                HashSet<String> set = new HashSet<String>();
                if (jointassconsColl.size() > 0) {
                    int size = jointassconsColl.size();
                    for (int i = 0; i < size; ++i) {
                        set.add(jointassconsColl.get(i).getCmpScheme().getId().toString());
                    }
                }
                filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)Boolean.FALSE));
                filter.getFilterItems().add(new FilterItemInfo("enable", (Object)"1"));
                if (set.size() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.NOTINCLUDE));
                }
            }
            catch (BOSException e) {
                super.handleException((Exception)((Object)e));
            }
        }
        return filter;
    }

    @Override
    protected void kDCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.btnConfirm_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected JButton getDefaultButton() {
        return this.btnConfirm;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CmpSchemeFactory.getRemoteInstance();
    }

    public Object getData() {
        if (this.isSingleSelect) {
            return new Object[]{this.cmpSchemeInfo};
        }
        return this.schemeColl.toArray();
    }
}

